/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.event.test;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.event.EventSource;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EventManagerTest
extends AbstractEJB3Test {
    EventManagerLocal eventManager;
    EntityManager em;

    @BeforeMethod
    public void init() {
        try {
            this.eventManager = LookupUtil.getEventManager();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventsSimple() throws Exception {
        try {
            this.getTransactionManager().begin();
            this.em = EventManagerTest.getEntityManager();
            Resource resource = this.setUpResource(this.em);
            EventDefinition eDef = new EventDefinition(resource.getResourceType(), "My definition is this ..");
            this.em.persist((Object)eDef);
            long now = System.currentTimeMillis();
            EventSource evSrc = new EventSource("ESource", eDef, resource);
            Event ev = new Event("EType", "ESource", now, EventSeverity.INFO, "This is a test", evSrc);
            this.em.persist((Object)evSrc);
            this.em.persist((Object)ev);
            this.em.flush();
            int resourceId = resource.getId();
            Query queryByTime = this.em.createNamedQuery("Event.FIND_EVENTS_FOR_RESOURCE_ID_AND_TIME");
            long t1 = now - 1000L;
            long t2 = now + 1000L;
            queryByTime.setParameter("resourceId", (Object)resourceId);
            queryByTime.setParameter("start", (Object)t1);
            queryByTime.setParameter("end", (Object)t2);
            List resultsByTime = queryByTime.getResultList();
            assert (resultsByTime.size() == 1) : "Expected 1 Event, got " + resultsByTime.size();
            Query queryBySeverity = this.em.createNamedQuery("Event.FIND_EVENTS_FOR_RESOURCE_ID_AND_TIME_Severity");
            queryBySeverity.setParameter("severity", (Object)EventSeverity.INFO);
            queryBySeverity.setParameter("resourceId", (Object)resourceId);
            queryBySeverity.setParameter("start", (Object)t1);
            queryBySeverity.setParameter("end", (Object)t2);
            List resultsBySeverity = queryBySeverity.getResultList();
            assert (resultsBySeverity.size() == 1) : "Expected 1 Event, got " + resultsBySeverity.size();
        }
        finally {
            this.getTransactionManager().rollback();
            this.em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventManager() throws Exception {
        try {
            boolean bucketCounts;
            this.getTransactionManager().begin();
            this.em = EventManagerTest.getEntityManager();
            Resource resource = this.setUpResource(this.em);
            EventDefinition eDef = new EventDefinition(resource.getResourceType(), "My definition is this ..");
            this.em.persist((Object)eDef);
            this.em.flush();
            long now = System.currentTimeMillis();
            EventSource evSrc = new EventSource("ESource", eDef, resource);
            Event ev = new Event("EType", "ESource", now, EventSeverity.INFO, "This is a 2nd test", evSrc);
            HashSet<Event> eventSet = new HashSet<Event>();
            eventSet.add(ev);
            HashMap<EventSource, HashSet<Event>> events = new HashMap<EventSource, HashSet<Event>>();
            events.put(evSrc, eventSet);
            this.eventManager.addEventData(events);
            int resourceId = resource.getId();
            long t1 = now - 1000L;
            long t2 = now + 1000L;
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            int[] buckets = this.eventManager.getEventCounts(overlord, resourceId, t1, t2, 3);
            assert (buckets != null) : "Buckets should not be null, but were null";
            assert (buckets.length == 3) : "Expected 3 buckets, but got " + buckets.length;
            boolean bl = bucketCounts = buckets[0] == 0 && buckets[1] == 1 && buckets[2] == 0;
            assert (bucketCounts) : "Expected bucket counts were [0 1 0] Received [" + buckets[0] + " " + buckets[1] + " " + buckets[2] + "]";
            PageControl pc = PageControl.getUnlimitedInstance();
            EntityContext context = EntityContext.forResource((int)resourceId);
            PageList res = this.eventManager.findEventComposites(overlord, context, t1, t2, null, null, null, pc);
            assert (res.size() == 1) : "Expected 1 Event, got " + res.size();
            res = this.eventManager.findEventComposites(overlord, context, t1, t2, new EventSeverity[]{EventSeverity.INFO}, null, null, pc);
            assert (res.size() == 1) : "Expected 1 Event, got " + res.size();
            res = this.eventManager.findEventComposites(overlord, context, t1, t2, new EventSeverity[]{EventSeverity.WARN}, null, null, pc);
            assert (res.size() == 0) : "Expected 0 Events, got " + res.size();
        }
        finally {
            this.getTransactionManager().rollback();
            this.em.close();
        }
    }

    private Resource setUpResource(EntityManager em) {
        ResourceType resourceType = new ResourceType("fake platform", "fake plugin", ResourceCategory.PLATFORM, null);
        em.persist((Object)resourceType);
        Resource platform = new Resource("org.jboss.on.TestPlatform", "Fake Platform", resourceType);
        platform.setUuid("" + new Random().nextInt());
        em.persist((Object)platform);
        em.flush();
        return platform;
    }
}

