/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.inventory;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlProducer;
import org.dbunit.ext.oracle.Oracle10DataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;
import org.dbunit.operation.DatabaseOperation;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.inventory.InventoryManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.xml.sax.InputSource;

public class InventoryManagerBeanTest
extends AbstractEJB3Test {
    private static List<Integer> deletedTypeIds = Arrays.asList(1, 2, 3, 4, 5);

    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.initDB();
        this.getTransactionManager().begin();
        InventoryManagerLocal inventoryMgr = LookupUtil.getInventoryManager();
        inventoryMgr.markTypesDeleted(deletedTypeIds);
        this.getTransactionManager().commit();
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws Exception {
        this.cleanDB();
    }

    @Test
    public void markTypesAndTheirChildTypesForDeletion() {
        List resourceTypes = InventoryManagerBeanTest.getEntityManager().createQuery("from ResourceType t where t.id in (:resourceTypeIds)").setParameter("resourceTypeIds", deletedTypeIds).getResultList();
        InventoryManagerBeanTest.assertEquals((String)"Failed to retrieve all resource types", (int)5, (int)resourceTypes.size());
        ArrayList<Integer> typesNotDeleted = new ArrayList<Integer>();
        for (ResourceType type : resourceTypes) {
            if (type.isDeleted()) continue;
            typesNotDeleted.add(type.getId());
        }
        InventoryManagerBeanTest.assertEquals((String)("Failed to mark for deletion resource types with the following ids: " + typesNotDeleted + "."), (int)0, (int)typesNotDeleted.size());
    }

    @Test
    public void uninventoryResourcesOfTypesMarkedForDeletion() {
        List resources = InventoryManagerBeanTest.getEntityManager().createQuery("from Resource r where r.id in (:resourceIds)").setParameter("resourceIds", Arrays.asList(1, 2)).getResultList();
        InventoryManagerBeanTest.assertEquals((String)"Failed to retrieve all resources", (int)2, (int)resources.size());
        ArrayList<Integer> resourcesNotDeleted = new ArrayList<Integer>();
        for (Resource resource : resources) {
            if (resource.getInventoryStatus() == InventoryStatus.UNINVENTORIED) continue;
            resourcesNotDeleted.add(resource.getId());
        }
        InventoryManagerBeanTest.assertEquals((String)("Resources of types marked for deletion should be uninventoried. Resources with the following ids should have been uninventoried: " + resourcesNotDeleted + "."), (int)0, (int)resourcesNotDeleted.size());
    }

    @Test
    public void getDeletedTypes() {
        InventoryManagerLocal inventoryMgr = LookupUtil.getInventoryManager();
        List deletedTypes = inventoryMgr.getDeletedTypes();
        int resultSize = deletedTypes.size();
        InventoryManagerBeanTest.assertTrue((String)"Expected at least five deleted types", (resultSize >= 5 ? 1 : 0) != 0);
        ArrayList<Integer> resultIds = new ArrayList<Integer>(resultSize);
        for (ResourceType rt : deletedTypes) {
            resultIds.add(rt.getId());
        }
        for (Integer id : deletedTypeIds) {
            assert (resultIds.contains(id));
        }
    }

    @Test
    public void deletedTypeIsReadyForRemovalWhenThereResourcesOfThatType() {
        InventoryManagerLocal inventoryMgr = LookupUtil.getInventoryManager();
        ResourceType deletedType = (ResourceType)InventoryManagerBeanTest.getEntityManager().find(ResourceType.class, (Object)4);
        InventoryManagerBeanTest.assertTrue((String)(deletedType + " should be ready for removal"), (boolean)inventoryMgr.isReadyForPermanentRemoval(deletedType));
    }

    @Test
    public void typeThatIsNotDeletedIsNotReadyForRemoval() {
        InventoryManagerLocal inventoryMgr = LookupUtil.getInventoryManager();
        ResourceType resourceType = (ResourceType)InventoryManagerBeanTest.getEntityManager().find(ResourceType.class, (Object)6);
        InventoryManagerBeanTest.assertFalse((String)(resourceType + " is not ready for removal because it is not deleted."), (boolean)inventoryMgr.isReadyForPermanentRemoval(resourceType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDB() throws Exception {
        Connection connection = null;
        try {
            connection = InventoryManagerBeanTest.getConnection();
            DatabaseConnection conn = new DatabaseConnection(connection);
            this.setDbType((IDatabaseConnection)conn);
            DatabaseOperation.REFRESH.execute((IDatabaseConnection)conn, this.getDataSet());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanDB() throws Exception {
        Connection connection = null;
        try {
            connection = InventoryManagerBeanTest.getConnection();
            DatabaseConnection conn = new DatabaseConnection(connection);
            this.setDbType((IDatabaseConnection)conn);
            DatabaseOperation.DELETE.execute((IDatabaseConnection)conn, this.getDataSet());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    void setDbType(IDatabaseConnection connection) throws Exception {
        DatabaseConfig dbConfig = connection.getConfig();
        String name = connection.getConnection().getMetaData().getDatabaseProductName().toLowerCase();
        int major = connection.getConnection().getMetaData().getDatabaseMajorVersion();
        Object type = null;
        if (name.contains("postgres")) {
            type = new PostgresqlDataTypeFactory();
        } else if (name.contains("oracle")) {
            type = major >= 10 ? new Oracle10DataTypeFactory() : new OracleDataTypeFactory();
        }
        if (type != null) {
            dbConfig.setProperty("http://www.dbunit.org/properties/datatypeFactory", type);
        }
    }

    IDataSet getDataSet() throws Exception {
        FlatXmlProducer xmlProducer = new FlatXmlProducer(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream(this.getDataSetFile())));
        xmlProducer.setColumnSensing(true);
        return new FlatXmlDataSet(xmlProducer);
    }

    String getDataSetFile() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ".xml";
    }
}

