/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.inventory;

import java.util.List;
import java.util.Random;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionTemplate;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test
public class UninventoryTest
extends AbstractEJB3Test {
    private Resource newResource;

    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws Exception {
        if (this.newResource != null) {
            this.deleteNewResource(this.newResource);
            this.newResource = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDriftDefRemoval() throws Exception {
        Query qDef;
        Query qTemplate;
        ResourceTypeCreator rtCreator = new ResourceTypeCreator(){

            @Override
            public void modifyResourceTypeToPersist(ResourceType resourceType, EntityManager em) {
                DriftDefinitionTemplate template = new DriftDefinitionTemplate();
                template.setName("drift1");
                template.setDescription("drift def template");
                Configuration config = new Configuration();
                DriftDefinition driftDef = new DriftDefinition(config);
                driftDef.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/"));
                driftDef.setName("drift1");
                template.setTemplateDefinition(driftDef);
                resourceType.addDriftDefinitionTemplate(template);
            }
        };
        ResourceCreator rCreator = new ResourceCreator(){

            @Override
            public void modifyResourceToPersist(Resource resource, EntityManager em) {
                Configuration config = new Configuration();
                DriftDefinition driftDef = new DriftDefinition(config);
                driftDef.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/boo"));
                driftDef.setName("drift-def-name");
                resource.addDriftDefinition(driftDef);
            }
        };
        Resource resource = this.createNewResource(rtCreator, rCreator);
        int templateId = ((DriftDefinitionTemplate)resource.getResourceType().getDriftDefinitionTemplates().iterator().next()).getId();
        int driftDefId = ((DriftDefinition)resource.getDriftDefinitions().iterator().next()).getId();
        String qTemplateString = "select t from DriftDefinitionTemplate t where t.id = :id";
        String qDefString = "select dc from DriftDefinition dc where dc.id = :id";
        this.getTransactionManager().begin();
        try {
            qTemplate = UninventoryTest.getEntityManager().createQuery(qTemplateString).setParameter("id", (Object)templateId);
            qDef = UninventoryTest.getEntityManager().createQuery(qDefString).setParameter("id", (Object)driftDefId);
            UninventoryTest.assertEquals((String)"drift template didn't get added", (int)1, (int)qTemplate.getResultList().size());
            UninventoryTest.assertEquals((String)"drift template def didn't get added", (int)1, (int)qDef.getResultList().size());
        }
        finally {
            this.getTransactionManager().commit();
        }
        this.deleteNewResource(resource);
        this.getTransactionManager().begin();
        try {
            qTemplate = UninventoryTest.getEntityManager().createQuery(qTemplateString).setParameter("id", (Object)templateId);
            qDef = UninventoryTest.getEntityManager().createQuery(qDefString).setParameter("id", (Object)driftDefId);
            UninventoryTest.assertEquals((String)"drift template didn't get purged", (int)0, (int)qTemplate.getResultList().size());
            UninventoryTest.assertEquals((String)"drift template def didn't get purged", (int)0, (int)qDef.getResultList().size());
        }
        finally {
            this.getTransactionManager().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource createNewResource(ResourceTypeCreator rtCreator, ResourceCreator rCreator) throws Exception {
        Resource resource;
        this.getTransactionManager().begin();
        EntityManager em = UninventoryTest.getEntityManager();
        try {
            try {
                ResourceType resourceType = new ResourceType("plat" + System.currentTimeMillis(), "test", ResourceCategory.PLATFORM, null);
                if (rtCreator != null) {
                    rtCreator.modifyResourceTypeToPersist(resourceType, em);
                }
                em.persist((Object)resourceType);
                Agent agent = new Agent("testagent", "testaddress", 1, "", "testtoken");
                em.persist((Object)agent);
                em.flush();
                resource = new Resource("reskey" + System.currentTimeMillis(), "resname", resourceType);
                resource.setUuid("" + new Random().nextInt());
                resource.setAgent(agent);
                resource.setInventoryStatus(InventoryStatus.COMMITTED);
                if (rCreator != null) {
                    rCreator.modifyResourceToPersist(resource, em);
                }
                em.persist((Object)resource);
            }
            catch (Exception e) {
                System.out.println("CANNOT PREPARE TEST: " + e);
                this.getTransactionManager().rollback();
                throw e;
            }
            em.flush();
            this.getTransactionManager().commit();
            this.newResource = resource;
        }
        finally {
            em.close();
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNewResource(Resource resource) throws Exception {
        if (null != resource) {
            EntityManager em = null;
            try {
                ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
                Subject overlord = LookupUtil.getSubjectManager().getOverlord();
                List deletedIds = resourceManager.uninventoryResource(overlord, resource.getId());
                for (Integer deletedResourceId : deletedIds) {
                    resourceManager.uninventoryResourceAsyncWork(overlord, deletedResourceId.intValue());
                }
                this.getTransactionManager().begin();
                em = UninventoryTest.getEntityManager();
                ResourceType type = (ResourceType)em.find(ResourceType.class, (Object)resource.getResourceType().getId());
                Agent agent = (Agent)em.find(Agent.class, (Object)resource.getAgent().getId());
                if (null != agent) {
                    em.remove((Object)agent);
                }
                if (null != type) {
                    em.remove((Object)type);
                }
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                try {
                    System.out.println("CANNOT CLEAN UP TEST (" + ((Object)((Object)this)).getClass().getSimpleName() + ") Cause: " + e);
                    this.getTransactionManager().rollback();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            finally {
                if (null != em) {
                    em.close();
                }
            }
        }
    }

    private static interface ResourceCreator {
        public void modifyResourceToPersist(Resource var1, EntityManager var2);
    }

    private static interface ResourceTypeCreator {
        public void modifyResourceTypeToPersist(ResourceType var1, EntityManager var2);
    }
}

