/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.test;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.TransactionManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.ResourceAvailability;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityPoint;
import org.rhq.enterprise.server.resource.ResourceAvailabilityManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerPluginService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AvailabilityManagerTest
extends AbstractEJB3Test {
    private static final boolean ENABLE_TESTS = false;
    private static final AvailabilityType UP = AvailabilityType.UP;
    private static final AvailabilityType DOWN = AvailabilityType.DOWN;
    private AvailabilityManagerLocal availabilityManager;
    private ResourceAvailabilityManagerLocal resourceAvailabilityManager;
    private ResourceManagerLocal resourceManager;
    private Subject overlord;
    private Agent theAgent;
    private Resource theResource;
    private ResourceType theResourceType;
    private List<Resource> additionalResources;
    private Availability availability1;
    private Availability availability2;
    private Availability availability3;
    private TestServerPluginService testServerPluginService;

    @BeforeMethod
    public void beforeMethod() {
        try {
            this.prepareScheduler();
            this.availabilityManager = LookupUtil.getAvailabilityManager();
            this.resourceAvailabilityManager = LookupUtil.getResourceAvailabilityManager();
            this.resourceManager = LookupUtil.getResourceManager();
            this.overlord = LookupUtil.getSubjectManager().getOverlord();
            this.additionalResources = new ArrayList<Resource>();
            this.testServerPluginService = new TestServerPluginService();
            this.prepareCustomServerPluginService(this.testServerPluginService);
            this.testServerPluginService.masterConfig.getPluginDirectory().mkdirs();
            this.testServerPluginService.startMasterPluginContainer();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    @AfterMethod
    public void afterMethod() throws Exception {
        try {
            EntityManager em;
            if (this.theResource != null) {
                this.resourceManager.uninventoryResource(this.overlord, this.theResource.getId());
                this.resourceManager.uninventoryResourceAsyncWork(this.overlord, this.theResource.getId());
                this.theResource = null;
            }
            if (this.additionalResources != null) {
                this.getTransactionManager().begin();
                em = AvailabilityManagerTest.getEntityManager();
                for (Resource res : this.additionalResources) {
                    Resource res2 = (Resource)em.find(Resource.class, (Object)res.getId());
                    this.resourceManager.uninventoryResource(this.overlord, res2.getId());
                    this.resourceManager.uninventoryResourceAsyncWork(this.overlord, res2.getId());
                }
                this.getTransactionManager().commit();
            }
            if (this.theResourceType != null) {
                this.getTransactionManager().begin();
                em = AvailabilityManagerTest.getEntityManager();
                em.remove(em.find(ResourceType.class, (Object)this.theResourceType.getId()));
                this.theResourceType = null;
                this.getTransactionManager().commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.unprepareScheduler();
            this.unprepareServerPluginService();
            this.testServerPluginService.stopMasterPluginContainer();
        }
    }

    @Test(enabled=true)
    public void testInsertPastAvailabilities() throws Exception {
        Date now = new Date();
        Date middle = new Date(now.getTime() - 30000L);
        Date then = new Date(now.getTime() - 60000L);
        EntityManager em = this.beginTx();
        try {
            this.setupResource(em);
            this.commitAndClose(em);
            Availability aThen = new Availability(this.theResource, then, AvailabilityType.UP);
            aThen.setEndTime(middle);
            Availability aMiddle = new Availability(this.theResource, middle, AvailabilityType.DOWN);
            aMiddle.setEndTime(now);
            Availability aNow = new Availability(this.theResource, now, AvailabilityType.UP);
            this.persistAvailability(aThen);
            this.persistAvailability(aNow);
            this.persistAvailability(aMiddle);
            em = this.beginTx();
            Query q = em.createNamedQuery("Availability.findByResource");
            q.setParameter("resourceId", (Object)this.theResource.getId());
            List avails = q.getResultList();
            assert (avails.size() == 2) : "Did not get 2 availabilities but " + avails.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (em != null) {
                this.getTransactionManager().rollback();
                em.close();
            }
        }
    }

    @Test(enabled=true)
    public void testPurgeAvailabilities() throws Exception {
        Date now = new Date();
        Date middle = new Date(now.getTime() - 30000L);
        Date then = new Date(now.getTime() - 60000L);
        EntityManager em = this.beginTx();
        try {
            this.setupResource(em);
            this.commitAndClose(em);
            Availability aThen = new Availability(this.theResource, then, AvailabilityType.UP);
            aThen.setEndTime(middle);
            Availability aMiddle = new Availability(this.theResource, middle, AvailabilityType.DOWN);
            aMiddle.setEndTime(now);
            Availability aNow = new Availability(this.theResource, now, AvailabilityType.UP);
            this.persistAvailability(aThen);
            this.persistAvailability(aMiddle);
            this.persistAvailability(aNow);
            em = this.beginTx();
            int purged = this.availabilityManager.purgeAvailabilities(new Long(now.getTime() - 29999L).longValue());
            assert (purged == 1) : "Didn't purge 1 --> " + purged;
            Query q = em.createNamedQuery("Availability.findByResource");
            q.setParameter("resourceId", (Object)this.theResource.getId());
            List avails = q.getResultList();
            assert (avails.size() == 2);
            assert (((Availability)avails.get(0)).getAvailabilityType() == AvailabilityType.DOWN);
            assert (((Availability)avails.get(0)).getStartTime().equals(middle));
            assert (((Availability)avails.get(0)).getEndTime().equals(now));
            assert (((Availability)avails.get(1)).getAvailabilityType() == AvailabilityType.UP);
            assert (((Availability)avails.get(1)).getStartTime().equals(now));
            assert (((Availability)avails.get(1)).getEndTime() == null);
            purged = this.availabilityManager.purgeAvailabilities(new Long(now.getTime() + 12345L).longValue());
            assert (purged == 1) : "Didn't purge 1 --> " + purged;
            purged = this.availabilityManager.purgeAvailabilities(new Long(now.getTime() + 12345L).longValue());
            assert (purged == 0) : "Didn't purge 0 --> " + purged;
            q = em.createNamedQuery("Availability.findByResource");
            q.setParameter("resourceId", (Object)this.theResource.getId());
            avails = q.getResultList();
            assert (avails.size() == 1);
            assert (((Availability)avails.get(0)).getAvailabilityType() == AvailabilityType.UP);
            assert (((Availability)avails.get(0)).getStartTime().equals(now));
            assert (((Availability)avails.get(0)).getEndTime() == null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (em != null) {
                this.getTransactionManager().rollback();
                em.close();
            }
        }
    }

    @Test(enabled=true)
    public void testGetAvailabilities() throws Exception {
        EntityManager em = this.beginTx();
        try {
            this.setupResource(em);
            this.commitAndClose(em);
            em = null;
            AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
            List availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), 1L, System.currentTimeMillis(), 3, false);
            assert (availPoints.size() == 3) : "There is no avail data, but should still get 3 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getValue() == DOWN.ordinal());
            assert (((AvailabilityPoint)availPoints.get(1)).getValue() == DOWN.ordinal());
            assert (((AvailabilityPoint)availPoints.get(2)).getValue() == DOWN.ordinal());
            long startMillis = 60000L;
            Date startDate = new Date(startMillis);
            Availability avail = new Availability(this.theResource, startDate, UP);
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis, startMillis + 10000L, 3, false);
            assert (availPoints.size() == 3) : "There is 1 avail data, but should still get 3 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getValue() == UP.ordinal());
            assert (((AvailabilityPoint)availPoints.get(1)).getValue() == UP.ordinal());
            assert (((AvailabilityPoint)availPoints.get(2)).getValue() == UP.ordinal());
            availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis - 3L, startMillis, 3, false);
            assert (availPoints.size() == 3) : "There is 1 avail data, but should still get 3 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getValue() == DOWN.ordinal());
            assert (!((AvailabilityPoint)availPoints.get(0)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(1)).getValue() == DOWN.ordinal());
            assert (!((AvailabilityPoint)availPoints.get(1)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(2)).getValue() == DOWN.ordinal());
            assert (!((AvailabilityPoint)availPoints.get(2)).isKnown()) : availPoints;
            availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis - 20000L, startMillis + 10000L, 3, false);
            assert (availPoints.size() == 3) : "There is 1 avail data, but should still get 3 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getValue() == DOWN.ordinal());
            assert (!((AvailabilityPoint)availPoints.get(0)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(1)).getValue() == DOWN.ordinal());
            assert (!((AvailabilityPoint)availPoints.get(1)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(2)).getValue() == UP.ordinal());
            availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis - 10000L, startMillis + 20000L, 3, false);
            assert (availPoints.size() == 3) : "There is 1 avail data, but should still get 3 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getValue() == DOWN.ordinal());
            assert (!((AvailabilityPoint)availPoints.get(0)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(1)).getValue() == UP.ordinal());
            assert (((AvailabilityPoint)availPoints.get(1)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(2)).getValue() == UP.ordinal());
            availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis - 20000L, startMillis + 20000L, 10, false);
            assert (availPoints.size() == 10) : "There is 1 avail data, but should still get 10 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getValue() == DOWN.ordinal()) : availPoints;
            assert (!((AvailabilityPoint)availPoints.get(0)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(1)).getValue() == DOWN.ordinal()) : availPoints;
            assert (!((AvailabilityPoint)availPoints.get(1)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(2)).getValue() == DOWN.ordinal()) : availPoints;
            assert (!((AvailabilityPoint)availPoints.get(2)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(3)).getValue() == DOWN.ordinal()) : availPoints;
            assert (!((AvailabilityPoint)availPoints.get(3)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(4)).getValue() == DOWN.ordinal()) : availPoints;
            assert (!((AvailabilityPoint)availPoints.get(4)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(5)).getValue() == UP.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(5)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(6)).getValue() == UP.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(7)).getValue() == UP.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(8)).getValue() == UP.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(9)).getValue() == UP.ordinal()) : availPoints;
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(new Availability(this.theResource, new Date(startDate.getTime() + 10000L), DOWN));
            this.availabilityManager.mergeAvailabilityReport(report);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(new Availability(this.theResource, new Date(startDate.getTime() + 20000L), UP));
            this.availabilityManager.mergeAvailabilityReport(report);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(new Availability(this.theResource, new Date(startDate.getTime() + 30000L), DOWN));
            this.availabilityManager.mergeAvailabilityReport(report);
            availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis - 15000L, startMillis + 35000L, 5, false);
            assert (availPoints.size() == 5) : "There is 1 avail data, but should still get 5 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getValue() == DOWN.ordinal()) : availPoints;
            assert (!((AvailabilityPoint)availPoints.get(0)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(1)).getValue() == UP.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(1)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(2)).getValue() == DOWN.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(3)).getValue() == DOWN.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(4)).getValue() == DOWN.ordinal()) : availPoints;
            availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis - 30000L, startMillis + 30000L, 10, false);
            assert (availPoints.size() == 10) : "There is 1 avail data, but should still get 10 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getValue() == DOWN.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(1)).getValue() == DOWN.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(2)).getValue() == DOWN.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(3)).getValue() == DOWN.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(4)).getValue() == DOWN.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(5)).getValue() == UP.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(6)).getValue() == DOWN.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(7)).getValue() == DOWN.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(8)).getValue() == DOWN.ordinal()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(9)).getValue() == UP.ordinal()) : availPoints;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (em != null) {
                this.getTransactionManager().rollback();
                em.close();
            }
        }
    }

    @Test(enabled=true)
    public void testSetAllAgentResourceAvailabilities() throws Exception {
        EntityManager em = this.beginTx();
        try {
            this.setupResource(em);
            this.commitAndClose(em);
            em = null;
            Availability avail = new Availability(this.theResource, new Date(), null);
            this.persistAvailability(avail);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == null);
            this.availabilityManager.setAllAgentResourceAvailabilities(this.theAgent.getId(), UP);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == UP);
            this.availabilityManager.setAllAgentResourceAvailabilities(this.theAgent.getId(), DOWN);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
            this.availabilityManager.setAllAgentResourceAvailabilities(this.theAgent.getId(), DOWN);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (em != null) {
                this.getTransactionManager().rollback();
                em.close();
            }
        }
    }

    @Test(enabled=true)
    public void testAgentBackfillNewResource() throws Exception {
        EntityManager em = this.beginTx();
        try {
            this.setupResource(em);
            this.commitAndClose(em);
            em = null;
            LookupUtil.getAgentManager().checkForSuspectAgents();
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == null);
            em = this.beginTx();
            Resource resource = (Resource)em.find(Resource.class, (Object)this.theResource.getId());
            List avails = resource.getAvailability();
            assert (avails != null);
            assert (avails.size() == 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (em != null) {
                this.getTransactionManager().rollback();
                em.close();
            }
        }
    }

    @Test(enabled=true)
    public void testAgentBackfill() throws Exception {
        EntityManager em = this.beginTx();
        try {
            this.prepareForTestAgents();
            this.setupResource(em);
            this.commitAndClose(em);
            em = null;
            Availability avail = new Availability(this.theResource, new Date(System.currentTimeMillis() - 12000000L), UP);
            AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == UP);
            em = this.beginTx();
            Agent agent = (Agent)em.find(Agent.class, (Object)this.theAgent.getId());
            agent.setLastAvailabilityReport(Long.valueOf(System.currentTimeMillis() - 1080000L));
            this.commitAndClose(em);
            em = null;
            LookupUtil.getAgentManager().checkForSuspectAgents();
            AvailabilityType curAvail = this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId());
            assert (curAvail == AvailabilityType.DOWN) : curAvail;
            em = this.beginTx();
            Resource resource = (Resource)em.find(Resource.class, (Object)this.theResource.getId());
            List allAvails = resource.getAvailability();
            assert (allAvails.size() == 2);
            this.commitAndClose(em);
            em = null;
            Availability first = (Availability)allAvails.get(0);
            Availability second = (Availability)allAvails.get(1);
            assert (first.getAvailabilityType() == AvailabilityType.UP);
            assert (second.getAvailabilityType() == AvailabilityType.DOWN) : second.getAvailabilityType();
            assert (first.getEndTime() != null);
            assert (second.getEndTime() == null);
            assert (first.getEndTime().getTime() > first.getStartTime().getTime());
            assert (second.getStartTime().getTime() == first.getEndTime().getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.unprepareForTestAgents();
            if (em != null) {
                this.getTransactionManager().rollback();
                em.close();
            }
        }
    }

    @Test(enabled=true)
    public void testAgentBackfillPerformance() throws Exception {
        EntityManager em = this.beginTx();
        ArrayList<Resource> allResources = new ArrayList<Resource>();
        try {
            this.prepareForTestAgents();
            this.setupResource(em);
            allResources.add(this.theResource);
            for (int i = 0; i < 100; ++i) {
                allResources.add(this.setupAnotherResource(em, i, this.theResource));
            }
            em.flush();
            this.commitAndClose(em);
            em = null;
            for (Resource res : allResources) {
                int resId = res.getId();
                Availability currentAvailability = this.availabilityManager.getCurrentAvailabilityForResource(this.overlord, resId);
                assert (currentAvailability != null) : "Current Availability was null for " + resId;
                assert (currentAvailability.getAvailabilityType() == null) : "Current AvailabilityType should have been null for " + resId;
                List allData = this.availabilityManager.findAvailabilityWithinInterval(resId, new Date(0L), new Date(Long.MAX_VALUE));
                assert (allData != null) : "All availabilities was null for " + resId;
                assert (allData.size() == 0) : "All availabilities size was " + allData.size() + " for " + resId;
                ResourceAvailability currentResAvail = this.resourceAvailabilityManager.getLatestAvailability(resId);
                assert (currentResAvail != null) : "Current ResourceAvailability was null for " + resId;
                assert (currentResAvail.getAvailabilityType() == null) : "Current ResourceAvailabilityType should have been null for " + resId;
            }
            em = this.beginTx();
            Agent agent = (Agent)em.find(Agent.class, (Object)this.theAgent.getId());
            agent.setLastAvailabilityReport(Long.valueOf(System.currentTimeMillis() - 1080000L));
            this.commitAndClose(em);
            em = null;
            long start = System.currentTimeMillis();
            LookupUtil.getAgentManager().checkForSuspectAgents();
            System.out.println("testAgentBackfillPerformance: checkForSuspectAgents run 1 took " + (System.currentTimeMillis() - start) + "ms");
            Thread.sleep(500L);
            AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
            for (Resource resource : allResources) {
                Availability avail = new Availability(resource, new Date(), UP);
                report.addAvailability(avail);
            }
            start = System.currentTimeMillis();
            this.availabilityManager.mergeAvailabilityReport(report);
            System.out.println("testAgentBackfillPerformance: mergeAvailabilityReport run took " + (System.currentTimeMillis() - start) + "ms");
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == UP);
            em = this.beginTx();
            agent = (Agent)em.find(Agent.class, (Object)this.theAgent.getId());
            agent.setLastAvailabilityReport(Long.valueOf(System.currentTimeMillis() - 1080000L));
            this.commitAndClose(em);
            em = null;
            start = System.currentTimeMillis();
            LookupUtil.getAgentManager().checkForSuspectAgents();
            System.out.println("testAgentBackfillPerformance: checkForSuspectAgents run 2 took " + (System.currentTimeMillis() - start) + "ms");
            start = System.currentTimeMillis();
            for (Resource resource : allResources) {
                AvailabilityType curAvail = this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, resource.getId());
                assert (curAvail == AvailabilityType.DOWN) : curAvail;
                em = this.beginTx();
                resource = (Resource)em.find(Resource.class, (Object)resource.getId());
                List allAvails = resource.getAvailability();
                assert (allAvails.size() == 2) : allAvails;
                this.commitAndClose(em);
                em = null;
                Availability a0 = (Availability)allAvails.get(0);
                Availability a1 = (Availability)allAvails.get(1);
                assert (a0.getAvailabilityType() == AvailabilityType.UP) : allAvails;
                assert (a1.getAvailabilityType() == AvailabilityType.DOWN) : allAvails;
                assert (a0.getEndTime() != null) : allAvails;
                assert (a1.getEndTime() == null) : allAvails;
                assert (a0.getEndTime().getTime() > a0.getStartTime().getTime()) : allAvails;
                assert (a0.getEndTime().getTime() == a1.getStartTime().getTime()) : allAvails;
            }
            System.out.println("testAgentBackfillPerformance: checking validity of data took " + (System.currentTimeMillis() - start) + "ms");
            em = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.unprepareForTestAgents();
            if (em != null) {
                this.getTransactionManager().rollback();
                em.close();
            }
        }
    }

    @Test(enabled=true)
    public void testAgentOldReport() throws Exception {
        EntityManager em = this.beginTx();
        try {
            this.setupResource(em);
            this.commitAndClose(em);
            em = null;
            long now = System.currentTimeMillis();
            Availability avail = new Availability(this.theResource, new Date(now), DOWN);
            AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            avail = new Availability(this.theResource, new Date(now - 600000L), UP);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            assert (this.getPointInTime(new Date(avail.getStartTime().getTime() - 1L)) == DOWN);
            assert (this.getPointInTime(avail.getStartTime()) == UP);
            assert (this.getPointInTime(new Date(avail.getStartTime().getTime() + 1L)) == UP);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
            avail = new Availability(this.theResource, new Date(now - 300000L), UP);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            assert (this.getPointInTime(new Date(avail.getStartTime().getTime() - 1L)) == UP);
            assert (this.getPointInTime(avail.getStartTime()) == UP);
            assert (this.getPointInTime(new Date(avail.getStartTime().getTime() + 1L)) == UP);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
            avail = new Availability(this.theResource, new Date(now - 100000L), DOWN);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            assert (this.getPointInTime(new Date(avail.getStartTime().getTime() - 1L)) == UP);
            assert (this.getPointInTime(avail.getStartTime()) == DOWN);
            assert (this.getPointInTime(new Date(avail.getStartTime().getTime() + 1L)) == DOWN);
            avail = new Availability(this.theResource, new Date(now - 450000L), DOWN);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            assert (this.getPointInTime(new Date(avail.getStartTime().getTime() - 1L)) == UP);
            assert (this.getPointInTime(avail.getStartTime()) == DOWN);
            assert (this.getPointInTime(new Date(avail.getStartTime().getTime() + 1L)) == DOWN);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
            avail = new Availability(this.theResource, new Date(now - 700000L), UP);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            assert (this.getPointInTime(new Date(avail.getStartTime().getTime() - 1L)) == DOWN);
            assert (this.getPointInTime(avail.getStartTime()) == UP);
            assert (this.getPointInTime(new Date(avail.getStartTime().getTime() + 1L)) == UP);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (em != null) {
                this.getTransactionManager().rollback();
                em.close();
            }
        }
    }

    @Test(enabled=true)
    public void testAgentOldReport2() throws Exception {
        EntityManager em = this.beginTx();
        try {
            this.setupResource(em);
            this.commitAndClose(em);
            em = null;
            long now = System.currentTimeMillis();
            this.persistAvailability(new Availability(this.theResource, new Date(now - 1000000L), UP));
            this.persistAvailability(new Availability(this.theResource, new Date(now - 900000L), DOWN));
            this.persistAvailability(new Availability(this.theResource, new Date(now - 800000L), UP));
            this.persistAvailability(new Availability(this.theResource, new Date(now - 50000L), DOWN));
            this.persistAvailability(new Availability(this.theResource, new Date(now - 30000L), UP));
            this.persistAvailability(new Availability(this.theResource, new Date(now), DOWN));
            this.persistAvailability(new Availability(this.theResource, new Date(now - 600000L), UP));
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
            this.persistAvailability(new Availability(this.theResource, new Date(now - 300000L), UP));
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
            this.persistAvailability(new Availability(this.theResource, new Date(now - 100000L), DOWN));
            this.persistAvailability(new Availability(this.theResource, new Date(now - 450000L), DOWN));
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
            this.persistAvailability(new Availability(this.theResource, new Date(now - 700000L), UP));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (em != null) {
                this.getTransactionManager().rollback();
                em.close();
            }
        }
    }

    @Test(enabled=true)
    public void testGetAvailabilities2() throws Exception {
        EntityManager em = this.beginTx();
        try {
            this.setupResource(em);
            this.commitAndClose(em);
            em = null;
            Calendar cal = Calendar.getInstance();
            cal.set(1, 2000);
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(10, 1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date date1 = cal.getTime();
            cal.set(10, 1);
            cal.set(12, 30);
            Date date2 = cal.getTime();
            cal.set(10, 2);
            cal.set(12, 0);
            Date date3 = cal.getTime();
            cal.set(10, 2);
            cal.set(12, 30);
            Date date4 = cal.getTime();
            cal.set(10, 3);
            cal.set(12, 0);
            Date date5 = cal.getTime();
            cal.set(10, 3);
            cal.set(12, 30);
            Date date6 = cal.getTime();
            Availability avail = new Availability(this.theResource, date1, AvailabilityType.UP);
            avail.setEndTime(date2);
            this.persistAvailability(avail);
            avail = new Availability(this.theResource, date2, AvailabilityType.DOWN);
            avail.setEndTime(date3);
            this.persistAvailability(avail);
            avail = new Availability(this.theResource, date3, AvailabilityType.UP);
            avail.setEndTime(date4);
            this.persistAvailability(avail);
            avail = new Availability(this.theResource, date4, AvailabilityType.DOWN);
            avail.setEndTime(date5);
            this.persistAvailability(avail);
            avail = new Availability(this.theResource, date5, AvailabilityType.UP);
            avail.setEndTime(date6);
            this.persistAvailability(avail);
            avail = new Availability(this.theResource, date6, AvailabilityType.DOWN);
            this.persistAvailability(avail);
            List points = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), date1.getTime(), date6.getTime(), 5, false);
            assert (points.size() == 5);
            assert (((AvailabilityPoint)points.get(0)).getValue() == 1);
            assert (((AvailabilityPoint)points.get(1)).getValue() == 0);
            assert (((AvailabilityPoint)points.get(2)).getValue() == 1);
            assert (((AvailabilityPoint)points.get(3)).getValue() == 0);
            assert (((AvailabilityPoint)points.get(4)).getValue() == 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (em != null) {
                this.getTransactionManager().rollback();
                em.close();
            }
        }
    }

    @Test(enabled=true)
    public void testMergeReport() throws Exception {
        EntityManager em = this.beginTx();
        try {
            this.setupResource(em);
            this.commitAndClose(em);
            em = null;
            long allAvailCount = this.setUpAvailabilities(em);
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            Availability avail = this.availabilityManager.getCurrentAvailabilityForResource(overlord, this.theResource.getId());
            assert (avail.getAvailabilityType() == UP);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(overlord, this.theResource.getId()) == UP);
            Date currentStartTime = avail.getStartTime();
            avail = new Availability(this.theResource, new Date(currentStartTime.getTime() + 3600000L), UP);
            AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            Thread.sleep(1000L);
            this.availabilityManager.mergeAvailabilityReport(report);
            Agent agent = LookupUtil.getAgentManager().getAgentByName(this.theAgent.getName());
            Date lastReport = new Date(agent.getLastAvailabilityReport());
            assert (lastReport != null);
            assert (this.countAvailabilitiesInDB(null) == allAvailCount);
            avail = this.availabilityManager.getCurrentAvailabilityForResource(overlord, this.theResource.getId());
            assert (avail.getStartTime().equals(this.availability3.getStartTime()));
            assert (avail.getAvailabilityType() == this.availability3.getAvailabilityType());
            assert (Math.abs(avail.getStartTime().getTime() - this.availability3.getStartTime().getTime()) < 1000L);
            assert (avail.getEndTime() == null);
            assert (avail.getEndTime() == this.availability3.getEndTime());
            avail = new Availability(this.theResource, new Date(currentStartTime.getTime() + 0x6DDD00L), DOWN);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            Thread.sleep(1000L);
            this.availabilityManager.mergeAvailabilityReport(report);
            agent = LookupUtil.getAgentManager().getAgentByName(this.theAgent.getName());
            assert (new Date(agent.getLastAvailabilityReport()).after(lastReport));
            assert (this.countAvailabilitiesInDB(null) == allAvailCount + 1L);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(overlord, this.theResource.getId()) == DOWN);
            Availability queriedAvail = this.availabilityManager.getCurrentAvailabilityForResource(overlord, this.theResource.getId());
            assert (queriedAvail.getId() > 0);
            assert (queriedAvail.getAvailabilityType() == avail.getAvailabilityType());
            assert (Math.abs(queriedAvail.getStartTime().getTime() - avail.getStartTime().getTime()) < 1000L);
            assert (queriedAvail.getEndTime() == null);
            assert (queriedAvail.getEndTime() == avail.getEndTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (em != null) {
                this.getTransactionManager().rollback();
                em.close();
            }
        }
    }

    @Test(enabled=true)
    public void testMergeReportPerformance() throws Exception {
        EntityManager em = this.beginTx();
        ArrayList<Resource> allResources = new ArrayList<Resource>();
        try {
            Availability avail;
            AvailabilityType curAvail;
            this.setupResource(em);
            allResources.add(this.theResource);
            for (int i = 0; i < 100; ++i) {
                allResources.add(this.setupAnotherResource(em, i, this.theResource));
            }
            em.flush();
            this.commitAndClose(em);
            em = null;
            AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
            for (Resource resource : allResources) {
                Availability avail2 = new Availability(resource, new Date(), UP);
                report.addAvailability(avail2);
            }
            long start = System.currentTimeMillis();
            this.availabilityManager.mergeAvailabilityReport(report);
            System.out.println("testMergeReportPerformance: mergeAvailabilityReport run 1 took " + (System.currentTimeMillis() - start) + "ms");
            start = System.currentTimeMillis();
            for (Resource resource : allResources) {
                curAvail = this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, resource.getId());
                assert (curAvail == UP) : curAvail;
            }
            System.out.println("testMergeReportPerformance: checking validity of data 1 took " + (System.currentTimeMillis() - start) + "ms");
            report = new AvailabilityReport(false, this.theAgent.getName());
            for (Resource resource : allResources) {
                avail = new Availability(resource, new Date(), DOWN);
                report.addAvailability(avail);
            }
            start = System.currentTimeMillis();
            this.availabilityManager.mergeAvailabilityReport(report);
            System.out.println("testMergeReportPerformance: mergeAvailabilityReport run 2 took " + (System.currentTimeMillis() - start) + "ms");
            start = System.currentTimeMillis();
            for (Resource resource : allResources) {
                curAvail = this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, resource.getId());
                assert (curAvail == DOWN) : curAvail;
            }
            System.out.println("testMergeReportPerformance: checking validity of data 2 took " + (System.currentTimeMillis() - start) + "ms");
            report = new AvailabilityReport(false, this.theAgent.getName());
            for (Resource resource : allResources) {
                avail = new Availability(resource, new Date(), null);
                report.addAvailability(avail);
            }
            start = System.currentTimeMillis();
            this.availabilityManager.mergeAvailabilityReport(report);
            System.out.println("testMergeReportPerformance: mergeAvailabilityReport run 3 took " + (System.currentTimeMillis() - start) + "ms");
            start = System.currentTimeMillis();
            for (Resource resource : allResources) {
                curAvail = this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, resource.getId());
                assert (curAvail == null) : curAvail;
            }
            System.out.println("testMergeReportPerformance: checking validity of data 3 took " + (System.currentTimeMillis() - start) + "ms");
            em = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (em != null) {
                this.getTransactionManager().rollback();
                em.close();
            }
        }
    }

    private EntityManager beginTx() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = AvailabilityManagerTest.getEntityManager();
        return em;
    }

    private void commitAndClose(EntityManager em) throws Exception {
        this.getTransactionManager().commit();
        em.close();
    }

    private AvailabilityType getPointInTime(Date time) {
        List list = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), time.getTime(), time.getTime() + 1L, 1, false);
        assert (list != null);
        assert (list.size() == 1) : "Should have returned a single point";
        int typeOrdinal = ((AvailabilityPoint)list.get(0)).getValue();
        if (UP.ordinal() == typeOrdinal) {
            return UP;
        }
        if (DOWN.ordinal() == typeOrdinal) {
            return DOWN;
        }
        assert (false) : "AvailabilityType enum has some additional values not known to this test: " + typeOrdinal;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long countAvailabilitiesInDB(EntityManager em) throws Exception {
        TransactionManager tx = null;
        if (em == null) {
            tx = this.getTransactionManager();
            tx.begin();
            em = AvailabilityManagerTest.getEntityManager();
        }
        try {
            long count;
            Query q = em.createQuery("SELECT count(a) FROM Availability a");
            long l = count = ((Long)q.getSingleResult()).longValue();
            return l;
        }
        finally {
            if (tx != null) {
                tx.rollback();
                em.close();
            }
        }
    }

    private Resource setupResource(EntityManager em) {
        this.theAgent = new Agent("testagent", "localhost", 1234, "", "randomToken");
        em.persist((Object)this.theAgent);
        this.theResourceType = new ResourceType("test-plat", "test-plugin", ResourceCategory.PLATFORM, null);
        em.persist((Object)this.theResourceType);
        this.theResource = new Resource("test-platform-key", "test-platform-name", this.theResourceType);
        this.theResource.setUuid("" + new Random().nextInt());
        this.theResource.setAgent(this.theAgent);
        em.persist((Object)this.theResource);
        em.flush();
        return this.theResource;
    }

    private Resource setupAnotherResource(EntityManager em, int uniqueNumber, Resource parentResource) {
        Resource newResource = new Resource("test-platform-key-" + uniqueNumber, "test-platform-name-" + uniqueNumber, this.theResourceType);
        newResource.setUuid("" + new Random().nextInt());
        newResource.setAgent(this.theAgent);
        parentResource.addChildResource(newResource);
        em.persist((Object)newResource);
        this.additionalResources.add(newResource);
        return newResource;
    }

    private long setUpAvailabilities(EntityManager em) throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(10, 1);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date start = cal.getTime();
        cal.set(10, 1);
        cal.set(12, 20);
        Date splitStart = cal.getTime();
        cal.set(12, 40);
        Date splitEnd = cal.getTime();
        long count = this.countAvailabilitiesInDB(em);
        this.availability1 = new Availability(this.theResource, start, AvailabilityType.UP);
        this.availability1.setEndTime(splitStart);
        this.persistAvailability(this.availability1);
        this.availability2 = new Availability(this.theResource, splitStart, AvailabilityType.DOWN);
        this.availability2.setEndTime(splitEnd);
        this.persistAvailability(this.availability2);
        this.availability3 = new Availability(this.theResource, splitEnd, AvailabilityType.UP);
        this.persistAvailability(this.availability3);
        long countNow = this.countAvailabilitiesInDB(em);
        assert (countNow == count + 3L) : "Did not find three availabilities - instead found: " + countNow;
        return countNow;
    }

    private void persistAvailability(Availability ... availabilities) {
        AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
        for (Availability avail : availabilities) {
            report.addAvailability(avail);
        }
        this.availabilityManager.mergeAvailabilityReport(report);
    }
}

