/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.test;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementBaseline;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementOOB;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementOOBManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class MeasurementBaselineManagerTest
extends AbstractEJB3Test {
    private Agent agent;
    private ResourceType platformType;
    private Resource platform;
    private Resource platform2;
    private MeasurementDefinition measDef;
    private MeasurementSchedule measSched;
    private MeasurementSchedule measSched2;
    private EntityManager entityManager;
    private ResourceManagerLocal resourceManager;
    private MeasurementBaselineManagerLocal baselineManager;
    private MeasurementOOBManagerLocal oobManager;
    private Subject overlord;
    private List<Resource> allResources;
    private List<MeasurementDefinition> allDefs;
    private List<MeasurementSchedule> allScheds;

    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.prepareScheduler();
        this.resourceManager = LookupUtil.getResourceManager();
        this.baselineManager = LookupUtil.getMeasurementBaselineManager();
        this.oobManager = LookupUtil.getOOBManager();
        this.overlord = LookupUtil.getSubjectManager().getOverlord();
    }

    @AfterMethod
    public void afterMethod() throws Exception {
        this.unprepareScheduler();
    }

    public void testAutoBaselineCalculationsWithLargeInventory() throws Throwable {
        this.begin();
        try {
            this.setupManyResources(this.entityManager, 20, 10);
            long now = System.currentTimeMillis();
            long eldest = now - 180000L;
            long elder = now - 120000L;
            long young = now - 60000L;
            long youngest = now;
            int dataCount = this.allScheds.size();
            for (MeasurementSchedule sched : this.allScheds) {
                this.insertMeasurementDataNumeric1H(eldest, sched, 30.0, 20.0, 40.0);
                this.insertMeasurementDataNumeric1H(elder, sched, 5.0, 2.0, 8.0);
                this.insertMeasurementDataNumeric1H(young, sched, 6.0, 3.0, 9.0);
                this.insertMeasurementDataNumeric1H(youngest, sched, 40.0, 30.0, 50.0);
                if (--dataCount % 500 != 0) continue;
                System.out.println(String.valueOf(dataCount) + " more test measurement data left to insert");
                this.commitAndBegin();
            }
            this.commit();
            long startingTime = System.currentTimeMillis();
            long computeTime = this.baselineManager.calculateAutoBaselines(90000L, System.currentTimeMillis());
            assert (computeTime > 0L);
            System.out.println(">>>>>>> a) [" + this.allScheds.size() + "] baselines calculated in [" + (System.currentTimeMillis() - startingTime) + "] ms");
            startingTime = System.currentTimeMillis();
            computeTime = this.baselineManager.calculateAutoBaselines(90000L, System.currentTimeMillis());
            assert (computeTime > 0L);
            System.out.println(">>>>>>> b) [" + this.allScheds.size() + "] baselines calculated in [" + (System.currentTimeMillis() - startingTime) + "] ms");
            this.deleteManyResources();
        }
        catch (Throwable t) {
            System.out.println("TEST FAILURE STACK TRACE FOLLOWS:");
            t.printStackTrace();
            throw t;
        }
        finally {
            try {
                this.getTransactionManager().rollback();
            }
            catch (Exception e) {}
            this.allScheds.clear();
            this.allDefs.clear();
            this.allResources.clear();
            this.allScheds = null;
            this.allDefs = null;
            this.allResources = null;
        }
    }

    public void testAutoBaselineCalculations() throws Throwable {
        this.begin();
        try {
            this.setupResources(this.entityManager);
            assert (this.entityManager.find(Resource.class, (Object)this.platform.getId()) != null) : "Did not setup platform - cannot test";
            long now = System.currentTimeMillis();
            long eldest = now - 180000L;
            long elder = now - 120000L;
            long young = now - 60000L;
            long youngest = now;
            this.insertMeasurementDataNumeric1H(0L, this.measSched, 0.0, 0.0, 0.0);
            this.insertMeasurementDataNumeric1H(eldest, this.measSched, 30.0, 20.0, 40.0);
            this.insertMeasurementDataNumeric1H(elder, this.measSched, 5.0, 2.0, 8.0);
            this.insertMeasurementDataNumeric1H(young, this.measSched, 6.0, 3.0, 9.0);
            this.insertMeasurementDataNumeric1H(youngest, this.measSched, 40.0, 30.0, 50.0);
            this.insertMeasurementDataNumeric1H(0L, this.measSched2, 0.0, 0.0, 0.0);
            this.insertMeasurementDataNumeric1H(eldest, this.measSched2, 5000.0, 3500.0, 6500.0);
            this.insertMeasurementDataNumeric1H(elder, this.measSched2, 5000.0, 3000.0, 7000.0);
            this.insertMeasurementDataNumeric1H(young, this.measSched2, 2000.0, 1000.0, 3000.0);
            this.insertMeasurementDataNumeric1H(youngest, this.measSched2, 1500.0, 500.0, 2500.0);
            this.commit();
            long computeTime = this.baselineManager.calculateAutoBaselines(30000L, System.currentTimeMillis());
            assert (computeTime > 0L);
            this.begin();
            MeasurementBaseline bl1 = ((MeasurementSchedule)this.entityManager.find(MeasurementSchedule.class, (Object)this.measSched.getId())).getBaseline();
            assert (bl1 != null) : "Baseline for measSched should have been inserted";
            assert (bl1.getSchedule().getId() == this.measSched.getId());
            assert (!bl1.isUserEntered());
            MeasurementBaselineManagerTest.assertEquals((Object)30.0, (Object)bl1.getMin());
            MeasurementBaselineManagerTest.assertEquals((Object)50.0, (Object)bl1.getMax());
            MeasurementBaselineManagerTest.assertEquals((Object)40.0, (Object)bl1.getMean());
            MeasurementBaseline bl2 = ((MeasurementSchedule)this.entityManager.find(MeasurementSchedule.class, (Object)this.measSched2.getId())).getBaseline();
            assert (bl2 != null) : "Baseline for measSched2 should have been inserted";
            assert (bl2.getSchedule().getId() == this.measSched2.getId());
            assert (!bl2.isUserEntered());
            MeasurementBaselineManagerTest.assertEquals((Object)500.0, (Object)bl2.getMin());
            MeasurementBaselineManagerTest.assertEquals((Object)2500.0, (Object)bl2.getMax());
            MeasurementBaselineManagerTest.assertEquals((Object)1500.0, (Object)bl2.getMean());
            int bl1Id = bl1.getId();
            int bl2Id = bl2.getId();
            Date bl1ComputeTime = bl1.getComputeTime();
            Date bl2ComputeTime = bl2.getComputeTime();
            this.commit();
            Thread.sleep(1000L);
            computeTime = this.baselineManager.calculateAutoBaselines(30000L, System.currentTimeMillis());
            assert (computeTime > 0L);
            this.begin();
            bl1 = ((MeasurementSchedule)this.entityManager.find(MeasurementSchedule.class, (Object)this.measSched.getId())).getBaseline();
            assert (bl1 != null) : "Baseline for measSched should have been inserted";
            assert (bl1.getSchedule().getId() == this.measSched.getId());
            assert (!bl1.isUserEntered());
            MeasurementBaselineManagerTest.assertEquals((Object)30.0, (Object)bl1.getMin());
            MeasurementBaselineManagerTest.assertEquals((Object)50.0, (Object)bl1.getMax());
            MeasurementBaselineManagerTest.assertEquals((Object)40.0, (Object)bl1.getMean());
            bl2 = ((MeasurementSchedule)this.entityManager.find(MeasurementSchedule.class, (Object)this.measSched2.getId())).getBaseline();
            assert (bl2 != null) : "Baseline for measSched2 should have been inserted";
            assert (bl2.getSchedule().getId() == this.measSched2.getId());
            assert (!bl2.isUserEntered());
            MeasurementBaselineManagerTest.assertEquals((Object)500.0, (Object)bl2.getMin());
            MeasurementBaselineManagerTest.assertEquals((Object)2500.0, (Object)bl2.getMax());
            MeasurementBaselineManagerTest.assertEquals((Object)1500.0, (Object)bl2.getMean());
            assert (bl1.getId() != bl1Id) : "bl1.getId() was " + bl1.getId() + ", bl1Id was " + bl1Id;
            assert (bl2.getId() != bl2Id) : "bl2.getId() was " + bl2.getId() + ", bl2Id was " + bl2Id;
            assert (bl1.getComputeTime().after(bl1ComputeTime));
            assert (bl2.getComputeTime().after(bl2ComputeTime));
            this.commit();
            Thread.sleep(1000L);
            computeTime = this.baselineManager.calculateAutoBaselines(240000L, System.currentTimeMillis());
            assert (computeTime > 0L);
            this.begin();
            bl1 = ((MeasurementSchedule)this.entityManager.find(MeasurementSchedule.class, (Object)this.measSched.getId())).getBaseline();
            assert (bl1 != null) : "Baseline for measSched should have been inserted";
            assert (bl1.getSchedule().getId() == this.measSched.getId());
            assert (!bl1.isUserEntered());
            MeasurementBaselineManagerTest.assertEquals((Object)2.0, (Object)bl1.getMin());
            MeasurementBaselineManagerTest.assertEquals((Object)50.0, (Object)bl1.getMax());
            MeasurementBaselineManagerTest.assertEquals((Object)20.25, (Object)bl1.getMean());
            bl2 = ((MeasurementSchedule)this.entityManager.find(MeasurementSchedule.class, (Object)this.measSched2.getId())).getBaseline();
            assert (bl2 != null) : "Baseline for measSched2 should have been inserted";
            assert (bl2.getSchedule().getId() == this.measSched2.getId());
            assert (!bl2.isUserEntered());
            MeasurementBaselineManagerTest.assertEquals((Object)500.0, (Object)bl2.getMin());
            MeasurementBaselineManagerTest.assertEquals((Object)7000.0, (Object)bl2.getMax());
            MeasurementBaselineManagerTest.assertEquals((Object)3375.0, (Object)bl2.getMean());
            assert (bl1.getId() != bl1Id);
            assert (bl2.getId() != bl2Id);
            assert (bl1.getComputeTime().after(bl1ComputeTime));
            assert (bl2.getComputeTime().after(bl2ComputeTime));
            this.commit();
            this.deleteResources();
        }
        catch (Throwable t) {
            System.out.println("TEST FAILURE STACK TRACE FOLLOWS:");
            t.printStackTrace();
            throw t;
        }
        finally {
            try {
                this.getTransactionManager().rollback();
            }
            catch (Exception e) {}
        }
    }

    public void testCalculateOOB() throws Throwable {
        this.begin();
        try {
            this.setupResources(this.entityManager);
            assert (this.entityManager.find(Resource.class, (Object)this.platform.getId()) != null) : "Did not setup platform - cannot test";
            long now = System.currentTimeMillis();
            long eldest = now - 180000L;
            long elder = now - 120000L;
            long young = now - 60000L;
            long youngest = now;
            this.insertMeasurementDataNumeric1H(0L, this.measSched, 0.0, 0.0, 0.0);
            this.insertMeasurementDataNumeric1H(eldest, this.measSched, 30.0, 20.0, 40.0);
            this.insertMeasurementDataNumeric1H(elder, this.measSched, 5.0, 2.0, 8.0);
            this.insertMeasurementDataNumeric1H(young, this.measSched, 6.0, 3.0, 9.0);
            this.insertMeasurementDataNumeric1H(youngest, this.measSched, 40.0, 30.0, 50.0);
            this.insertMeasurementDataNumeric1H(0L, this.measSched2, 0.0, 0.0, 0.0);
            this.insertMeasurementDataNumeric1H(eldest, this.measSched2, 5000.0, 3500.0, 6500.0);
            this.insertMeasurementDataNumeric1H(elder, this.measSched2, 5000.0, 3000.0, 7000.0);
            this.insertMeasurementDataNumeric1H(young, this.measSched2, 2000.0, 1000.0, 3000.0);
            this.insertMeasurementDataNumeric1H(youngest, this.measSched2, 1500.0, 500.0, 2500.0);
            this.commit();
            long computeTime = this.baselineManager.calculateAutoBaselines(30000L, System.currentTimeMillis());
            assert (computeTime > 0L);
            this.begin();
            this.oobManager.computeOOBsFromHourBeginingAt(this.overlord, eldest);
            Query q = this.entityManager.createQuery("SELECT oo FROM MeasurementOOB oo");
            List oobs = q.getResultList();
            System.out.println("OOBs calculated: \n" + oobs);
            for (MeasurementOOB oob : oobs) {
                if (oob.getScheduleId() == this.measSched.getId()) {
                    assert (oob.getOobFactor() == 50) : "Expected: 50, was " + oob.getOobFactor();
                    continue;
                }
                assert (oob.getOobFactor() == 200) : "Expected: 200, was " + oob.getOobFactor();
            }
            PageControl pc = PageControl.getUnlimitedInstance();
            PageList comps = this.oobManager.getSchedulesWithOOBs(this.overlord, null, null, null, pc);
            assert (comps.size() == 2) : "Expected 2 composites, but got " + comps.size();
            comps = this.oobManager.getHighestNOOBsForResource(this.overlord, this.platform.getId(), 2);
            assert (comps.size() == 1) : "Expected 1 composite, but got " + comps.size();
            this.oobManager.computeOOBsFromHourBeginingAt(this.overlord, elder);
            q = this.entityManager.createQuery("SELECT oo FROM MeasurementOOB oo");
            oobs = q.getResultList();
            comps = this.oobManager.getSchedulesWithOOBs(this.overlord, null, null, null, pc);
            assert (comps.size() == 2) : "Expected 2, but was " + comps.size();
            this.commit();
            this.begin();
            q = this.entityManager.createQuery("DELETE FROM MeasurementOOB oo WHERE  oo.id = :sched1 OR oo.id = :sched2");
            q.setParameter("sched1", (Object)this.measSched.getId());
            q.setParameter("sched2", (Object)this.measSched2.getId());
            q.executeUpdate();
            this.commit();
            this.deleteResources();
        }
        catch (Throwable t) {
            System.out.println("TEST FAILURE STACK TRACE FOLLOWS:");
            t.printStackTrace();
            throw t;
        }
        finally {
            try {
                this.getTransactionManager().rollback();
            }
            catch (Exception e) {}
        }
    }

    private void setupResources(EntityManager em) {
        this.agent = new Agent("test-agent", "localhost", 1234, "", "randomToken");
        em.persist((Object)this.agent);
        this.platformType = new ResourceType("testplatAB", "p", ResourceCategory.PLATFORM, null);
        em.persist((Object)this.platformType);
        this.platform = new Resource("platform1", "testAutoBaseline Platform One", this.platformType);
        this.platform.setUuid("" + new Random().nextInt());
        em.persist((Object)this.platform);
        this.platform.setAgent(this.agent);
        this.platform2 = new Resource("platform2", "testAutoBaseline Platform Two", this.platformType);
        this.platform2.setUuid("" + new Random().nextInt());
        this.platform.addChildResource(this.platform2);
        em.persist((Object)this.platform2);
        this.platform2.setAgent(this.agent);
        this.measDef = new MeasurementDefinition(this.platformType, "testAutoBaseline");
        this.measDef.setDefaultOn(true);
        this.measDef.setDisplayName("testAutoBaseline Measurement Display Name");
        this.measDef.setMeasurementType(NumericType.DYNAMIC);
        em.persist((Object)this.measDef);
        this.measSched = new MeasurementSchedule(this.measDef, this.platform);
        this.measSched.setEnabled(true);
        this.platform.addSchedule(this.measSched);
        this.measDef.addSchedule(this.measSched);
        em.persist((Object)this.measSched);
        this.measSched2 = new MeasurementSchedule(this.measDef, this.platform2);
        this.measSched2.setEnabled(true);
        this.platform2.addSchedule(this.measSched2);
        this.measDef.addSchedule(this.measSched2);
        em.persist((Object)this.measSched2);
    }

    private void deleteResources() {
        try {
            List deletedIds = this.resourceManager.uninventoryResource(this.overlord, this.platform.getId());
            for (Integer deletedResourceId : deletedIds) {
                this.resourceManager.uninventoryResourceAsyncWork(this.overlord, deletedResourceId.intValue());
            }
            this.begin();
            this.deleteMeasurementDataNumeric1H(this.measSched);
            this.deleteMeasurementDataNumeric1H(this.measSched2);
            Object doomed = this.entityManager.find(MeasurementSchedule.class, (Object)this.measSched.getId());
            if (doomed != null) {
                this.entityManager.remove(doomed);
            }
            if ((doomed = this.entityManager.find(MeasurementSchedule.class, (Object)this.measSched2.getId())) != null) {
                this.entityManager.remove(doomed);
            }
            if ((doomed = this.entityManager.find(MeasurementDefinition.class, (Object)this.measDef.getId())) != null) {
                this.entityManager.remove(doomed);
            }
            if ((doomed = this.entityManager.find(ResourceType.class, (Object)this.platformType.getId())) != null) {
                this.entityManager.remove(doomed);
            }
            this.commit();
        }
        catch (Exception e) {
            System.out.println("Cannot delete test resources, database still has test data in it");
            e.printStackTrace();
        }
    }

    private void setupManyResources(EntityManager em, int resourceCount, int measurementCount) {
        this.allResources = new ArrayList<Resource>(resourceCount);
        this.allDefs = new ArrayList<MeasurementDefinition>(measurementCount);
        this.allScheds = new ArrayList<MeasurementSchedule>(resourceCount * measurementCount);
        this.platformType = new ResourceType("testplatAB", "p", ResourceCategory.PLATFORM, null);
        em.persist((Object)this.platformType);
        for (int m = 0; m < measurementCount; ++m) {
            MeasurementDefinition def = new MeasurementDefinition(this.platformType, "testAutoBaselineMeasDef" + m);
            def.setDefaultOn(true);
            def.setDisplayName("testAutoBaseline Measurement Display Name" + m);
            def.setMeasurementType(NumericType.DYNAMIC);
            em.persist((Object)def);
            this.allDefs.add(def);
        }
        em.flush();
        em.clear();
        System.out.println("Populating test inventory with [" + resourceCount + "] resources.");
        this.agent = new Agent("test-agent", "localhost", 1234, "", "randomToken");
        em.persist((Object)this.agent);
        Resource root = null;
        for (int r = 0; r < resourceCount; ++r) {
            Resource resource = new Resource(String.valueOf(r), "testAutoBaselineResource" + r, this.platformType);
            resource.setUuid("" + new Random().nextInt());
            if (root == null) {
                root = resource;
            } else {
                root.addChildResource(resource);
            }
            em.persist((Object)resource);
            this.allResources.add(resource);
            resource.setAgent(this.agent);
            for (MeasurementDefinition def : this.allDefs) {
                MeasurementSchedule sched = new MeasurementSchedule(def, resource);
                sched.setEnabled(true);
                resource.addSchedule(sched);
                def.addSchedule(sched);
                em.persist((Object)sched);
                this.allScheds.add(sched);
            }
            if (r % 50 != 0) continue;
            System.out.println("..." + r);
            em.flush();
            em.clear();
        }
        em.flush();
        em.clear();
        System.out.println("Test inventory now has [" + resourceCount + "] resources.");
    }

    private void deleteManyResources() {
        try {
            Object doomed;
            int dataCount = this.allScheds.size();
            this.begin();
            for (MeasurementSchedule doomedSched : this.allScheds) {
                this.deleteMeasurementDataNumeric1H(doomedSched);
                if (--dataCount % 1000 != 0) continue;
                System.out.println(String.valueOf(dataCount) + " more test measurement data left to delete");
                this.commitAndBegin();
            }
            this.commit();
            Resource root = this.allResources.get(0);
            List deletedIds = this.resourceManager.uninventoryResource(this.overlord, root.getId());
            for (Integer deletedResourceId : deletedIds) {
                this.resourceManager.uninventoryResourceAsyncWork(this.overlord, deletedResourceId.intValue());
            }
            this.begin();
            for (MeasurementDefinition doomedDef : this.allDefs) {
                doomed = this.entityManager.find(MeasurementDefinition.class, (Object)doomedDef.getId());
                if (doomed == null) continue;
                this.entityManager.remove(doomed);
            }
            doomed = this.entityManager.find(ResourceType.class, (Object)this.platformType.getId());
            if (doomed != null) {
                this.entityManager.remove(doomed);
            }
            this.commit();
        }
        catch (Exception e) {
            System.out.println("Cannot delete test resources, database still has test data in it");
            e.printStackTrace();
        }
    }

    private void commitAndBegin() throws Exception {
        this.commit();
        this.begin();
    }

    private void commit() throws Exception {
        this.entityManager.flush();
        this.getTransactionManager().commit();
        this.entityManager.close();
    }

    private void begin() throws Exception {
        this.getTransactionManager().begin();
        this.entityManager = MeasurementBaselineManagerTest.getEntityManager();
    }

    private void insertMeasurementDataNumeric1H(long timeStamp, MeasurementSchedule schedule, double value, double min, double max) {
        String sql = "INSERT INTO RHQ_measurement_data_num_1h (time_stamp, schedule_id, value, minvalue, maxvalue) VALUES (" + timeStamp + "," + schedule.getId() + "," + value + "," + min + "," + max + ")";
        Query q = this.entityManager.createNativeQuery(sql);
        assert (q.executeUpdate() == 1);
    }

    private void deleteMeasurementDataNumeric1H(MeasurementSchedule schedule) {
        String sql = "DELETE FROM RHQ_measurement_data_num_1h WHERE schedule_id = " + schedule.getId();
        Query q = this.entityManager.createNativeQuery(sql);
        q.executeUpdate();
    }
}

