/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.test;

import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementCategory;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MeasurementDataManagerTest
extends AbstractEJB3Test {
    private static final int DELTA = 20;
    private MeasurementDataManagerLocal measurementDataManager;
    private CallTimeDataManagerLocal callTimeDataManager;
    private Subject overlord;
    private Resource resource1;
    private Resource resource2;
    private MeasurementDefinition definitionCt1;
    private MeasurementDefinition definitionCt2;
    private ResourceType theResourceType;
    private Agent theAgent;

    @BeforeMethod
    public void beforeMethod() {
        try {
            this.measurementDataManager = LookupUtil.getMeasurementDataManager();
            this.callTimeDataManager = LookupUtil.getCallTimeDataManager();
            this.overlord = LookupUtil.getSubjectManager().getOverlord();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    @AfterMethod
    public void afterMethod() {
        try {
            this.callTimeDataManager.purgeCallTimeData(new Date());
            EntityManager em = this.beginTx();
            ArrayList<Integer> resourceIds = new ArrayList<Integer>();
            resourceIds.add(this.resource1.getId());
            resourceIds.add(this.resource2.getId());
            Query q = em.createNamedQuery("CallTimeDataKey.deleteByResources");
            q.setParameter("resourceIds", resourceIds);
            q.executeUpdate();
            this.resource1 = (Resource)em.merge((Object)this.resource1);
            for (MeasurementSchedule sched : this.resource1.getSchedules()) {
                em.remove((Object)sched);
            }
            em.remove((Object)this.resource1);
            this.resource2 = (Resource)em.merge((Object)this.resource2);
            for (MeasurementSchedule sched : this.resource2.getSchedules()) {
                em.remove((Object)sched);
            }
            em.remove((Object)this.resource2);
            this.definitionCt1 = (MeasurementDefinition)em.merge((Object)this.definitionCt1);
            em.remove((Object)this.definitionCt1);
            this.definitionCt2 = (MeasurementDefinition)em.merge((Object)this.definitionCt2);
            em.remove((Object)this.definitionCt2);
            this.theResourceType = (ResourceType)em.merge((Object)this.theResourceType);
            em.remove((Object)this.theResourceType);
            this.theAgent = (Agent)em.merge((Object)this.theAgent);
            em.remove((Object)this.theAgent);
            this.commitAndClose(em);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Test
    public void bz658491() throws Exception {
        try {
            EntityManager em = this.beginTx();
            this.setupResources(em);
            MeasurementSchedule schedule1 = new MeasurementSchedule(this.definitionCt1, this.resource1);
            em.persist((Object)schedule1);
            this.definitionCt1.addSchedule(schedule1);
            this.resource1.addSchedule(schedule1);
            MeasurementSchedule schedule2 = new MeasurementSchedule(this.definitionCt1, this.resource2);
            em.persist((Object)schedule2);
            this.definitionCt1.addSchedule(schedule2);
            this.resource2.addSchedule(schedule2);
            em.flush();
            long now = System.currentTimeMillis();
            MeasurementScheduleRequest request1 = new MeasurementScheduleRequest(schedule1);
            MeasurementScheduleRequest request2 = new MeasurementScheduleRequest(schedule2);
            CallTimeData data1 = new CallTimeData(request1);
            CallTimeData data2 = new CallTimeData(request2);
            data1.addCallData("/foo", new Date(), 100L);
            data2.addCallData("/bar", new Date(), 200L);
            MeasurementReport report = new MeasurementReport();
            report.addData(data1);
            report.addData(data2);
            this.commitAndClose(em);
            this.measurementDataManager.mergeMeasurementReport(report);
            Thread.sleep(10000L);
            PageList list1 = this.callTimeDataManager.findCallTimeDataForResource(this.overlord, schedule1.getId(), now - 20L, System.currentTimeMillis() + 20L, new PageControl());
            PageList list2 = this.callTimeDataManager.findCallTimeDataForResource(this.overlord, schedule2.getId(), now - 20L, System.currentTimeMillis() + 20L, new PageControl());
            assert (list1 != null);
            assert (list2 != null);
            assert (list1.size() == 1) : "List 1 returned " + list1.size() + " entries, expected was 1";
            assert (list2.size() == 1) : "List 2 returned " + list2.size() + " entries, expected was 1";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Test
    public void bz658491OneResource() throws Exception {
        try {
            EntityManager em = this.beginTx();
            this.setupResources(em);
            MeasurementSchedule schedule1 = new MeasurementSchedule(this.definitionCt1, this.resource1);
            em.persist((Object)schedule1);
            this.definitionCt1.addSchedule(schedule1);
            this.resource1.addSchedule(schedule1);
            MeasurementSchedule schedule2 = new MeasurementSchedule(this.definitionCt2, this.resource1);
            em.persist((Object)schedule2);
            this.definitionCt1.addSchedule(schedule2);
            this.resource2.addSchedule(schedule2);
            em.flush();
            long now = System.currentTimeMillis();
            MeasurementScheduleRequest request1 = new MeasurementScheduleRequest(schedule1);
            MeasurementScheduleRequest request2 = new MeasurementScheduleRequest(schedule2);
            CallTimeData data1 = new CallTimeData(request1);
            CallTimeData data2 = new CallTimeData(request2);
            data1.addCallData("/foo", new Date(), 100L);
            data2.addCallData("/bar", new Date(), 200L);
            MeasurementReport report = new MeasurementReport();
            report.addData(data1);
            report.addData(data2);
            this.commitAndClose(em);
            this.measurementDataManager.mergeMeasurementReport(report);
            Thread.sleep(10000L);
            PageList list1 = this.callTimeDataManager.findCallTimeDataForResource(this.overlord, schedule1.getId(), now - 20L, System.currentTimeMillis() + 20L, new PageControl());
            PageList list2 = this.callTimeDataManager.findCallTimeDataForResource(this.overlord, schedule2.getId(), now - 20L, System.currentTimeMillis() + 20L, new PageControl());
            assert (list1 != null);
            assert (list2 != null);
            assert (list1.size() == 1) : "List 1 returned " + list1.size() + " entries, expected was 1";
            assert (list2.size() == 1) : "List 2 returned " + list2.size() + " entries, expected was 1";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void setupResources(EntityManager em) {
        this.theAgent = new Agent("testagent", "localhost", 1234, "", "randomToken");
        em.persist((Object)this.theAgent);
        this.theResourceType = new ResourceType("test-plat", "test-plugin", ResourceCategory.PLATFORM, null);
        em.persist((Object)this.theResourceType);
        this.definitionCt1 = new MeasurementDefinition("CT-Def1", MeasurementCategory.PERFORMANCE, MeasurementUnits.MILLISECONDS, DataType.CALLTIME, true, 60000L, DisplayType.SUMMARY);
        this.definitionCt1.setResourceType(this.theResourceType);
        em.persist((Object)this.definitionCt1);
        this.definitionCt2 = new MeasurementDefinition("CT-Def2", MeasurementCategory.PERFORMANCE, MeasurementUnits.MILLISECONDS, DataType.CALLTIME, true, 60000L, DisplayType.SUMMARY);
        this.definitionCt2.setResourceType(this.theResourceType);
        em.persist((Object)this.definitionCt2);
        this.resource1 = new Resource("test-platform-key1", "test-platform-name", this.theResourceType);
        this.resource1.setUuid("" + new Random().nextInt());
        this.resource1.setAgent(this.theAgent);
        em.persist((Object)this.resource1);
        this.resource2 = new Resource("test-platform-key2", "test-platform-name", this.theResourceType);
        this.resource2.setUuid("" + new Random().nextInt());
        this.resource2.setAgent(this.theAgent);
        em.persist((Object)this.resource2);
    }

    private EntityManager beginTx() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = MeasurementDataManagerTest.getEntityManager();
        return em;
    }

    private void commitAndClose(EntityManager em) throws Exception {
        em.flush();
        this.getTransactionManager().commit();
        em.close();
    }
}

