/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.test;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementViewManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MeasurementViewManagerTest
extends AbstractEJB3Test {
    private MeasurementViewManagerLocal viewManager;
    private SubjectManagerLocal subjectManager;
    private static final int SIZE = 5;
    private ResourceType type;
    private List<Resource> resources;
    private List<MeasurementDefinition> definitions;
    private List<MeasurementSchedule> schedules;
    private Subject overlord;

    @Test
    public void testAll() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeMethod
    public void init() throws Exception {
        this.viewManager = LookupUtil.getMeasurementViewManager();
        this.subjectManager = LookupUtil.getSubjectManager();
        this.overlord = this.subjectManager.getOverlord();
        this.getTransactionManager().begin();
        try {
            int i;
            EntityManager em = MeasurementViewManagerTest.getEntityManager();
            String prefix = MeasurementViewManagerTest.class.getSimpleName();
            this.type = new ResourceType(prefix + "type", prefix + "plugin", ResourceCategory.PLATFORM, null);
            em.persist((Object)this.type);
            this.resources = new ArrayList<Resource>();
            for (i = 0; i < 5; ++i) {
                Resource resource = new Resource(prefix + "key " + i, prefix + "key " + i, this.type);
                resource.setUuid(resource.getResourceKey());
                this.resources.add(resource);
                em.persist((Object)resource);
            }
            this.definitions = new ArrayList<MeasurementDefinition>();
            for (i = 0; i < 5; ++i) {
                MeasurementDefinition definition = new MeasurementDefinition(this.type, prefix + "definition " + i);
                this.definitions.add(definition);
                this.type.addMetricDefinition(definition);
                em.persist((Object)definition);
            }
            this.type = (ResourceType)em.merge((Object)this.type);
            this.schedules = new ArrayList<MeasurementSchedule>();
            for (i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    MeasurementDefinition definition = this.definitions.get(i);
                    Resource resource = this.resources.get(j);
                    MeasurementSchedule schedule = new MeasurementSchedule(definition, resource);
                    this.schedules.add(schedule);
                    definition.addSchedule(schedule);
                    resource.addSchedule(schedule);
                    em.persist((Object)schedule);
                }
            }
            for (i = 0; i < 5; ++i) {
                MeasurementDefinition definition = this.definitions.get(i);
                this.definitions.set(i, (MeasurementDefinition)em.merge((Object)definition));
            }
            for (int j = 0; j < 5; ++j) {
                Resource resource = this.resources.get(j);
                this.resources.set(j, (Resource)em.merge((Object)resource));
            }
        }
        finally {
            this.getTransactionManager().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod
    public void afterTest() throws Exception {
        this.getTransactionManager().begin();
        try {
            EntityManager em = MeasurementViewManagerTest.getEntityManager();
            ArrayList<Integer> measurementDefinitionIds = new ArrayList<Integer>();
            for (int i = 0; i < this.definitions.size(); ++i) {
                measurementDefinitionIds.add(this.definitions.get(i).getId());
            }
            Query removeSchedules = em.createQuery("delete from MeasurementSchedule ms where ms.definition.id IN ( :ids ) ");
            removeSchedules.setParameter("ids", measurementDefinitionIds);
            removeSchedules.executeUpdate();
            ArrayList<Integer> resourceIds = new ArrayList<Integer>();
            for (int i = 0; i < this.resources.size(); ++i) {
                resourceIds.add(this.resources.get(i).getId());
            }
            if (this.type != null) {
                Query removeDefinitions = em.createQuery("delete from MeasurementDefinition md where md.resourceType.id = :resourceTypeId ");
                removeDefinitions.setParameter("resourceTypeId", (Object)this.type.getId());
                removeDefinitions.executeUpdate();
            }
            Query removeResources = em.createQuery("delete from Resource res where res.id IN ( :ids ) ");
            removeResources.setParameter("ids", resourceIds);
            removeResources.executeUpdate();
            if (this.type != null) {
                this.type = (ResourceType)em.find(ResourceType.class, (Object)this.type.getId());
                em.remove((Object)this.type);
            }
        }
        finally {
            this.getTransactionManager().commit();
        }
    }
}

