/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.performance.test;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.event.EventSource;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3PerformanceTest;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.helpers.perftest.support.reporting.ExcelExporter;
import org.rhq.helpers.perftest.support.testng.DatabaseSetupInterceptor;
import org.rhq.helpers.perftest.support.testng.DatabaseState;
import org.rhq.helpers.perftest.support.testng.PerformanceReporting;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Test(groups={"PERF"})
@Listeners(value={DatabaseSetupInterceptor.class})
@PerformanceReporting(exporter=ExcelExporter.class)
@DatabaseState(url="perftest/AvailabilityInsertPurgeTest-testOne-data.xml.zip", dbVersion="2.101")
public class EventsInsertPurgeTest
extends AbstractEJB3PerformanceTest {
    private static final int ROUNDS = 20000;
    private static final int NUM_SOURCES = 10;
    private static final int LINES_PER_REPORT = 50;
    ResourceManagerLocal resourceManager;
    AvailabilityManagerLocal availabilityManager;
    AgentManagerLocal agentManager;
    SystemManagerLocal systemManager;
    AlertDefinitionManagerLocal alertDefinitionManager;
    EventManagerLocal eventManager;
    private static final int MILLIS_APART = 2000;
    private static final String ROUND__FORMAT = "Round %6d";
    private static final String PURGE__FORMAT = "Purge %6d";

    @BeforeMethod
    public void beforeMethod(Method method) {
        super.setupTimings(method);
        try {
            this.availabilityManager = LookupUtil.getAvailabilityManager();
            this.resourceManager = LookupUtil.getResourceManager();
            this.agentManager = LookupUtil.getAgentManager();
            this.systemManager = LookupUtil.getSystemManager();
            this.alertDefinitionManager = LookupUtil.getAlertDefinitionManager();
            this.eventManager = LookupUtil.getEventManager();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    public void testSimpleInserts() throws Exception {
        ResourceType type;
        Set eventDefs;
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        EntityManager em = EventsInsertPurgeTest.getEntityManager();
        Query q = em.createQuery("SELECT r FROM Resource r");
        List resources = q.getResultList();
        Resource res = (Resource)resources.get(0);
        if (res.getResourceType().getCategory() != ResourceCategory.PLATFORM) {
            res = this.resourceManager.getPlaformOfResource(overlord, res.getId());
        }
        if ((eventDefs = (type = res.getResourceType()).getEventDefinitions()) == null || eventDefs.isEmpty()) {
            throw new RuntimeException("No event definition found, should not happen");
        }
        EventDefinition def = (EventDefinition)eventDefs.iterator().next();
        EventSource[] evSrc = new EventSource[10];
        for (int i = 0; i < 10; ++i) {
            evSrc[i] = new EventSource("ESource1", def, res);
        }
        long now = new Date().getTime() - 1000000L;
        for (int round = 1; round < 20000; ++round) {
            HashMap events = new HashMap();
            for (int sourceNum = 0; sourceNum < 10; ++sourceNum) {
                HashSet<Event> eventSet = new HashSet<Event>();
                for (int i = 0; i < 50; ++i) {
                    Event ev = new Event("EType", "ESource" + sourceNum, now + (long)(round * i), EventSeverity.INFO, "This is a 2nd test", evSrc[sourceNum]);
                    eventSet.add(ev);
                }
                events.put(evSrc[sourceNum], eventSet);
            }
            this.startTiming("add");
            this.eventManager.addEventData(events);
            this.endTiming("add");
        }
        try {
            this.startTiming("purge_half");
            this.eventManager.purgeEventData(new Date(now + 500000L));
            this.endTiming("purge_half");
            this.startTiming("purge_final");
            this.eventManager.purgeEventData(new Date());
            this.endTiming("purge_final");
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

