/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.hibernate.LazyInitializationException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.plugin.PluginDeploymentType;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.core.domain.plugin.PluginStatusType;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.enterprise.server.plugin.ServerPluginsLocal;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.plugin.pc.generic.TestGenericServerPluginService;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.generic.GenericPluginDescriptorType;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class ServerPluginsBeanTest
extends AbstractEJB3Test {
    private static final String TEST_PLUGIN_NAME_PREFIX = "serverplugintest";
    private ServerPluginsLocal serverPluginsBean;

    @BeforeMethod
    public void beforeMethod() {
        TestGenericServerPluginService pluginService = new TestGenericServerPluginService();
        this.prepareCustomServerPluginService(pluginService);
        this.serverPluginsBean = LookupUtil.getServerPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod(alwaysRun=true)
    public void afterMethod() {
        EntityManager em = null;
        try {
            this.unprepareServerPluginService();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getTransactionManager().begin();
            em = ServerPluginsBeanTest.getEntityManager();
            Query q = em.createQuery("SELECT p FROM ServerPlugin p LEFT JOIN FETCH p.pluginConfiguration LEFT JOIN FETCH p.scheduledJobsConfiguration WHERE p.name LIKE 'serverplugintest%'");
            List doomed = q.getResultList();
            for (ServerPlugin plugin : doomed) {
                em.remove(em.getReference(ServerPlugin.class, (Object)plugin.getId()));
            }
            this.getTransactionManager().commit();
            em.close();
            em = null;
        }
        catch (Exception e) {
            try {
                System.out.println("CANNOT CLEAN UP TEST: Cause: " + e);
                this.getTransactionManager().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (null != em) {
                em.close();
            }
        }
    }

    public void testGetPlugins() throws Exception {
        ServerPlugin p1 = this.registerPlugin(1);
        ServerPlugin p2 = this.registerPlugin(2);
        PluginKey p1key = new PluginKey(p1);
        PluginKey p2key = new PluginKey(p2);
        List pluginKeys = this.serverPluginsBean.getServerPluginKeysByEnabled(true);
        assert (pluginKeys.contains(p1key)) : pluginKeys;
        assert (pluginKeys.contains(p2key)) : pluginKeys;
        pluginKeys = this.serverPluginsBean.getServerPluginKeysByEnabled(false);
        assert (!pluginKeys.contains(p1key)) : pluginKeys;
        assert (!pluginKeys.contains(p2key)) : pluginKeys;
        ServerPlugin plugin = this.serverPluginsBean.getServerPlugin(p1key);
        assert (plugin.getId() == p1.getId()) : plugin;
        assert (plugin.getName().equals(p1.getName())) : plugin;
        this.assetLazyInitializationException(plugin);
        plugin = this.serverPluginsBean.getServerPluginRelationships(plugin);
        assert (plugin.getPluginConfiguration() != null);
        assert (plugin.getScheduledJobsConfiguration() != null);
        assert (plugin.getPluginConfiguration().equals((Object)p1.getPluginConfiguration()));
        assert (plugin.getScheduledJobsConfiguration().equals((Object)p1.getScheduledJobsConfiguration()));
        List plugins = this.serverPluginsBean.getServerPlugins();
        assert (plugins.contains(p1)) : plugins;
        assert (plugins.contains(p2)) : plugins;
        this.assetLazyInitializationException((ServerPlugin)plugins.get(plugins.indexOf(p1)));
        this.assetLazyInitializationException((ServerPlugin)plugins.get(plugins.indexOf(p2)));
        plugins = this.serverPluginsBean.getAllServerPlugins();
        assert (plugins.contains(p1)) : plugins;
        assert (plugins.contains(p2)) : plugins;
        this.assetLazyInitializationException((ServerPlugin)plugins.get(plugins.indexOf(p1)));
        this.assetLazyInitializationException((ServerPlugin)plugins.get(plugins.indexOf(p2)));
        ArrayList<Integer> ids = new ArrayList<Integer>(2);
        ids.add(p1.getId());
        ids.add(p2.getId());
        plugins = this.serverPluginsBean.getServerPluginsById(ids);
        assert (plugins.size() == 2) : plugins;
        assert (plugins.contains(p1)) : plugins;
        assert (plugins.contains(p2)) : plugins;
        this.assetLazyInitializationException((ServerPlugin)plugins.get(plugins.indexOf(p1)));
        this.assetLazyInitializationException((ServerPlugin)plugins.get(plugins.indexOf(p2)));
        long lastTimestamp = this.serverPluginsBean.getLastConfigurationChangeTimestamp(p1.getId());
        assert (lastTimestamp == this.getConfigurationLastModifiedTimestamp(p1));
        lastTimestamp = this.serverPluginsBean.getLastConfigurationChangeTimestamp(p2.getId());
        assert (lastTimestamp == this.getConfigurationLastModifiedTimestamp(p2));
    }

    public void testUpdatePlugins() throws Exception {
        ServerPlugin p1 = this.registerPlugin(1);
        PluginKey p1key = new PluginKey(p1);
        p1 = this.serverPluginsBean.getServerPlugin(p1key);
        p1 = this.serverPluginsBean.getServerPluginRelationships(p1);
        ServerPlugin p1update = this.serverPluginsBean.updateServerPluginExceptContent(this.getOverlord(), p1);
        p1update = this.serverPluginsBean.getServerPluginRelationships(p1update);
        assert (p1update.getId() == p1.getId()) : p1update;
        assert (p1update.getId() == p1.getId()) : p1update;
        assert (p1update.getName().equals(p1.getName())) : p1update;
        assert (p1update.getName().equals(p1.getName())) : p1update;
        assert (p1update.getPluginConfiguration().equals((Object)p1.getPluginConfiguration())) : p1update;
        assert (p1update.getScheduledJobsConfiguration().equals((Object)p1.getScheduledJobsConfiguration())) : p1update;
        p1update.getPluginConfiguration().equals((Object)p1.getPluginConfiguration());
        p1update.getScheduledJobsConfiguration().equals((Object)p1.getScheduledJobsConfiguration());
    }

    public void testDisableEnablePlugins() throws Exception {
        ServerPlugin p1 = this.registerPlugin(1);
        ServerPlugin p2 = this.registerPlugin(2);
        PluginKey p1key = new PluginKey(p1);
        PluginKey p2key = new PluginKey(p2);
        ArrayList<Integer> ids = new ArrayList<Integer>(2);
        ids.add(p1.getId());
        ids.add(p2.getId());
        List disabled = this.serverPluginsBean.disableServerPlugins(this.getOverlord(), ids);
        assert (disabled.size() == 2) : disabled;
        assert (disabled.contains(p1key)) : disabled;
        assert (disabled.contains(p2key)) : disabled;
        assert (this.serverPluginsBean.getServerPlugin(p1key).getStatus() == PluginStatusType.INSTALLED);
        assert (this.serverPluginsBean.getServerPlugin(p2key).getStatus() == PluginStatusType.INSTALLED);
        List pluginKeys = this.serverPluginsBean.getServerPluginKeysByEnabled(false);
        assert (pluginKeys.contains(p1key)) : pluginKeys;
        assert (pluginKeys.contains(p2key)) : pluginKeys;
        pluginKeys = this.serverPluginsBean.getServerPluginKeysByEnabled(true);
        assert (!pluginKeys.contains(p1key)) : pluginKeys;
        assert (!pluginKeys.contains(p2key)) : pluginKeys;
        this.serverPluginsBean.enableServerPlugins(this.getOverlord(), ids);
        pluginKeys = this.serverPluginsBean.getServerPluginKeysByEnabled(true);
        assert (pluginKeys.contains(p1key)) : pluginKeys;
        assert (pluginKeys.contains(p2key)) : pluginKeys;
        pluginKeys = this.serverPluginsBean.getServerPluginKeysByEnabled(false);
        assert (!pluginKeys.contains(p1key)) : pluginKeys;
        assert (!pluginKeys.contains(p2key)) : pluginKeys;
        ServerPlugin plugin = this.serverPluginsBean.getServerPlugin(p1key);
        plugin = this.serverPluginsBean.getServerPluginRelationships(plugin);
        assert (plugin.getPluginConfiguration() != null);
        assert (plugin.getPluginConfiguration().equals((Object)p1.getPluginConfiguration()));
        plugin = this.serverPluginsBean.getServerPlugin(p2key);
        plugin = this.serverPluginsBean.getServerPluginRelationships(plugin);
        assert (plugin.getPluginConfiguration() != null);
        assert (plugin.getPluginConfiguration().equals((Object)p1.getPluginConfiguration()));
    }

    public void testUndeployPlugins() throws Exception {
        int originalSize = this.serverPluginsBean.getAllServerPlugins().size();
        PluginKey missingKey = new PluginKey(PluginDeploymentType.SERVER, new ServerPluginType(GenericPluginDescriptorType.class).stringify(), "serverplugintest1");
        PluginStatusType status = this.serverPluginsBean.getServerPluginStatus(missingKey);
        assert (status == null);
        missingKey = new PluginKey(PluginDeploymentType.SERVER, new ServerPluginType(GenericPluginDescriptorType.class).stringify(), "serverplugintest2");
        status = this.serverPluginsBean.getServerPluginStatus(missingKey);
        assert (status == null);
        ServerPlugin p1 = this.registerPlugin(1);
        ServerPlugin p2 = this.registerPlugin(2);
        PluginKey p1key = new PluginKey(p1);
        PluginKey p2key = new PluginKey(p2);
        status = this.serverPluginsBean.getServerPluginStatus(p1key);
        assert (status == PluginStatusType.INSTALLED);
        status = this.serverPluginsBean.getServerPluginStatus(p2key);
        assert (status == PluginStatusType.INSTALLED);
        assert (this.serverPluginsBean.getServerPlugins().size() == originalSize + 2);
        assert (this.serverPluginsBean.getAllServerPlugins().size() == originalSize + 2);
        ArrayList<Integer> ids = new ArrayList<Integer>(2);
        ids.add(p1.getId());
        ids.add(p2.getId());
        List undeployed = this.serverPluginsBean.undeployServerPlugins(this.getOverlord(), ids);
        assert (undeployed.size() == 2) : undeployed;
        assert (undeployed.contains(p1key)) : undeployed;
        assert (undeployed.contains(p2key)) : undeployed;
        ServerPlugin p1deleted = this.getDeletedPluginInTx(p1.getName());
        ServerPlugin p2deleted = this.getDeletedPluginInTx(p2.getName());
        assert (p1deleted.getStatus() == PluginStatusType.DELETED);
        assert (p2deleted.getStatus() == PluginStatusType.DELETED);
        List pluginKeys = this.serverPluginsBean.getServerPluginKeysByEnabled(false);
        assert (!pluginKeys.contains(p1key)) : "deleted plugins should not be returned even here" + pluginKeys;
        assert (!pluginKeys.contains(p2key)) : "deleted plugins should not be returned even here" + pluginKeys;
        pluginKeys = this.serverPluginsBean.getServerPluginKeysByEnabled(true);
        assert (!pluginKeys.contains(p1.getName())) : pluginKeys;
        assert (!pluginKeys.contains(p2.getName())) : pluginKeys;
        assert (this.serverPluginsBean.getServerPlugins().size() == originalSize);
        assert (this.serverPluginsBean.getAllServerPlugins().size() == originalSize + 2);
    }

    public void testReRegisterPlugins() throws Exception {
        PluginKey missingKey = new PluginKey(PluginDeploymentType.SERVER, new ServerPluginType(GenericPluginDescriptorType.class).stringify(), "serverplugintest1");
        PluginStatusType status = this.serverPluginsBean.getServerPluginStatus(missingKey);
        assert (status == null);
        missingKey = new PluginKey(PluginDeploymentType.SERVER, new ServerPluginType(GenericPluginDescriptorType.class).stringify(), "serverplugintest2");
        status = this.serverPluginsBean.getServerPluginStatus(missingKey);
        assert (status == null);
        ServerPlugin p1 = this.registerPlugin(1);
        ServerPlugin p2 = this.registerPlugin(2);
        PluginKey p1key = new PluginKey(p1);
        PluginKey p2key = new PluginKey(p2);
        status = this.serverPluginsBean.getServerPluginStatus(p1key);
        assert (status == PluginStatusType.INSTALLED);
        status = this.serverPluginsBean.getServerPluginStatus(p2key);
        assert (status == PluginStatusType.INSTALLED);
        ArrayList<Integer> ids = new ArrayList<Integer>(2);
        ids.add(p1.getId());
        ids.add(p2.getId());
        List undeployed = this.serverPluginsBean.undeployServerPlugins(this.getOverlord(), ids);
        assert (undeployed.size() == 2) : undeployed;
        assert (undeployed.contains(p1key)) : undeployed;
        assert (undeployed.contains(p2key)) : undeployed;
        ServerPlugin p1deleted = this.getDeletedPluginInTx(p1.getName());
        assert (p1deleted.getStatus() == PluginStatusType.DELETED);
        assert (p1deleted.getPluginConfiguration() == null);
        assert (p1deleted.getScheduledJobsConfiguration() == null);
        ServerPlugin p2deleted = this.getDeletedPluginInTx(p1.getName());
        assert (p2deleted.getStatus() == PluginStatusType.DELETED);
        assert (p2deleted.getPluginConfiguration() == null);
        assert (p2deleted.getScheduledJobsConfiguration() == null);
        List pluginKeys = this.serverPluginsBean.getServerPluginKeysByEnabled(false);
        assert (!pluginKeys.contains(p1key)) : "deleted plugins should not be returned even here" + pluginKeys;
        assert (!pluginKeys.contains(p2key)) : "deleted plugins should not be returned even here" + pluginKeys;
        pluginKeys = this.serverPluginsBean.getServerPluginKeysByEnabled(true);
        assert (!pluginKeys.contains(p1key)) : pluginKeys;
        assert (!pluginKeys.contains(p2key)) : pluginKeys;
        this.serverPluginsBean.purgeServerPlugin(this.getOverlord(), p1key);
        this.serverPluginsBean.purgeServerPlugin(this.getOverlord(), p2key);
        p1.setId(0);
        p2.setId(0);
        p1.setPluginConfiguration(p1.getPluginConfiguration().deepCopy(false));
        p2.setPluginConfiguration(p2.getPluginConfiguration().deepCopy(false));
        p1.setScheduledJobsConfiguration(p1.getScheduledJobsConfiguration().deepCopy(false));
        p2.setScheduledJobsConfiguration(p2.getScheduledJobsConfiguration().deepCopy(false));
        ServerPlugin p1again = this.serverPluginsBean.registerServerPlugin(this.getOverlord(), p1, null);
        ServerPlugin p2again = this.serverPluginsBean.registerServerPlugin(this.getOverlord(), p2, null);
        pluginKeys = this.serverPluginsBean.getServerPluginKeysByEnabled(true);
        assert (pluginKeys.contains(p1key)) : pluginKeys;
        assert (pluginKeys.contains(p2key)) : pluginKeys;
        assert (p1again.getStatus() == PluginStatusType.INSTALLED);
        assert (p2again.getStatus() == PluginStatusType.INSTALLED);
        pluginKeys = this.serverPluginsBean.getServerPluginKeysByEnabled(false);
        assert (!pluginKeys.contains(p1key)) : pluginKeys;
        assert (!pluginKeys.contains(p2key)) : pluginKeys;
    }

    private ServerPlugin registerPlugin(int index) throws Exception {
        ServerPlugin plugin = new ServerPlugin(0, TEST_PLUGIN_NAME_PREFIX + index, "path", "displayName", true, PluginStatusType.INSTALLED, "description", "help", "md5", "version", "ampsVersion", this.createPluginConfiguration(), this.createScheduledJobsConfiguration(), new ServerPluginType(GenericPluginDescriptorType.class).stringify(), System.currentTimeMillis(), System.currentTimeMillis());
        plugin = this.serverPluginsBean.registerServerPlugin(this.getOverlord(), plugin, null);
        assert (plugin.getId() > 0);
        assert (plugin.isEnabled());
        assert (plugin.getDeployment() == PluginDeploymentType.SERVER);
        assert (plugin.getStatus() == PluginStatusType.INSTALLED);
        assert (plugin.getPluginConfiguration() != null);
        assert (plugin.getScheduledJobsConfiguration() != null);
        assert (plugin.getType().equals(new ServerPluginType(GenericPluginDescriptorType.class).stringify()));
        return plugin;
    }

    private void assetLazyInitializationException(ServerPlugin plugin) {
        try {
            plugin.getPluginConfiguration().toString();
            assert (false) : "Should have thrown a lazy-initialization exception - we didn't load config";
        }
        catch (LazyInitializationException ok) {
            // empty catch block
        }
        try {
            plugin.getScheduledJobsConfiguration().toString();
            assert (false) : "Should have thrown a lazy-initialization exception - we didn't load config";
        }
        catch (LazyInitializationException lazyInitializationException) {
            // empty catch block
        }
    }

    private Configuration createPluginConfiguration() {
        Configuration config = new Configuration();
        config.put((Property)new PropertySimple("simpleprop1", (Object)"simpleprop1value"));
        return config;
    }

    private Configuration createScheduledJobsConfiguration() {
        Configuration config = new Configuration();
        PropertyMap map = new PropertyMap("jobname");
        config.put((Property)map);
        map.put((Property)new PropertySimple("methodName", (Object)"methodNameValue"));
        return config;
    }

    private Subject getOverlord() {
        return LookupUtil.getSubjectManager().getOverlord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerPlugin getDeletedPluginInTx(String pluginName) throws Exception {
        EntityManager em = ServerPluginsBeanTest.getEntityManager();
        this.getTransactionManager().begin();
        try {
            Query q = em.createNamedQuery("ServerPlugin.findAnyByName");
            q.setParameter("name", (Object)pluginName);
            ServerPlugin serverPlugin = (ServerPlugin)q.getSingleResult();
            return serverPlugin;
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    private long getConfigurationLastModifiedTimestamp(ServerPlugin plugin) {
        long timestamp = 0L;
        Configuration config = plugin.getPluginConfiguration();
        if (config != null) {
            timestamp = config.getModifiedTime();
        }
        if ((config = plugin.getScheduledJobsConfiguration()) != null && config.getModifiedTime() > timestamp) {
            timestamp = config.getModifiedTime();
        }
        return timestamp;
    }
}

