/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoGroup;
import org.rhq.core.domain.content.RepoRepoGroup;
import org.rhq.core.domain.criteria.RepoCriteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.plugin.pc.content.TestContentServerPluginService;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ContentProviderManagerSyncContentProviderTest
extends AbstractEJB3Test {
    private static final String CUSTOM_IMPORTED_REPO_NAME = "customImportedRepo";
    private static final String PREVIOUS_CANDIDATE_REPO_NAME = "testPreviousCandidate";
    private TestContentServerPluginService pluginService;
    private ContentSourceType testSourceType;
    private ContentSource syncSource;
    private ContentSource nonSyncSource;
    private Repo nonCandidateOnOtherSource;
    private List<Integer> reposToDelete = new ArrayList<Integer>();
    private List<Integer> repoGroupsToDelete = new ArrayList<Integer>();
    private Integer repoId;
    private Integer relatedRepoId;

    @BeforeMethod
    public void setupBeforeMethod() throws Exception {
        this.prepareScheduler();
        this.pluginService = new TestContentServerPluginService(this);
        TransactionManager tx = this.getTransactionManager();
        tx.begin();
        EntityManager entityManager = ContentProviderManagerSyncContentProviderTest.getEntityManager();
        ContentSourceManagerLocal contentManager = LookupUtil.getContentSourceManager();
        RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        Subject overlord = subjectManager.getOverlord();
        this.testSourceType = new ContentSourceType("testType");
        entityManager.persist((Object)this.testSourceType);
        this.syncSource = new ContentSource("testSource1", this.testSourceType);
        contentManager.simpleCreateContentSource(overlord, this.syncSource);
        entityManager.flush();
        this.nonSyncSource = new ContentSource("testSource2", this.testSourceType);
        contentManager.simpleCreateContentSource(overlord, this.nonSyncSource);
        entityManager.flush();
        this.nonCandidateOnOtherSource = new Repo("nonCandidateOnOtherSource");
        this.nonCandidateOnOtherSource.setCandidate(false);
        this.nonCandidateOnOtherSource.addContentSource(this.nonSyncSource);
        repoManager.createRepo(overlord, this.nonCandidateOnOtherSource);
        tx.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod
    public void tearDownAfterMethod() throws Exception {
        try {
            TransactionManager tx = this.getTransactionManager();
            tx.begin();
            EntityManager entityManager = ContentProviderManagerSyncContentProviderTest.getEntityManager();
            RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            Subject overlord = subjectManager.getOverlord();
            entityManager.createNamedQuery("RepoRepoRelationship.deleteByRepoId").setParameter("repoId", (Object)this.repoId).executeUpdate();
            entityManager.createNamedQuery("RepoRelationship.deleteByRelatedRepoId").setParameter("relatedRepoId", (Object)this.relatedRepoId).executeUpdate();
            for (Integer repoId : this.reposToDelete) {
                repoManager.deleteRepo(overlord, repoId.intValue());
            }
            this.reposToDelete.clear();
            for (Integer repoGroupId : this.repoGroupsToDelete) {
                repoManager.deleteRepoGroup(overlord, repoGroupId.intValue());
            }
            this.repoGroupsToDelete.clear();
            entityManager.createNamedQuery("PackageVersionContentSource.deleteByContentSourceId").setParameter("contentSourceId", (Object)this.syncSource.getId()).executeUpdate();
            this.nonCandidateOnOtherSource = (Repo)entityManager.find(Repo.class, (Object)this.nonCandidateOnOtherSource.getId());
            entityManager.remove((Object)this.nonCandidateOnOtherSource);
            this.syncSource = (ContentSource)entityManager.find(ContentSource.class, (Object)this.syncSource.getId());
            entityManager.remove((Object)this.syncSource);
            this.nonSyncSource = (ContentSource)entityManager.find(ContentSource.class, (Object)this.nonSyncSource.getId());
            entityManager.remove((Object)this.nonSyncSource);
            this.testSourceType = (ContentSourceType)entityManager.find(ContentSourceType.class, (Object)this.testSourceType.getId());
            entityManager.remove((Object)this.testSourceType);
            tx.commit();
        }
        finally {
            this.unprepareServerPluginService();
            this.unprepareScheduler();
        }
    }

    @Test
    public void synchronizeContentSource() throws Exception {
        try {
            this.getTransactionManager().begin();
            RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            Subject overlord = subjectManager.getOverlord();
            Repo existingImportedRepo = new Repo("testRepoImportedExisting");
            existingImportedRepo.setCandidate(false);
            repoManager.createRepo(overlord, existingImportedRepo);
            Repo customImportedRepo = new Repo(CUSTOM_IMPORTED_REPO_NAME);
            customImportedRepo.setCandidate(false);
            customImportedRepo.addContentSource(this.syncSource);
            repoManager.createRepo(overlord, customImportedRepo);
            Repo existingCandidateRepo = new Repo("testRepoCandidateExisting");
            existingCandidateRepo.setCandidate(true);
            repoManager.createRepo(overlord, existingCandidateRepo);
            Repo previousRepo = new Repo(PREVIOUS_CANDIDATE_REPO_NAME);
            previousRepo.setCandidate(true);
            previousRepo.addContentSource(this.syncSource);
            repoManager.createRepo(overlord, previousRepo);
            this.pluginService.getContentProviderManager().testConnection(this.syncSource.getId());
            boolean completed = this.pluginService.getContentProviderManager().synchronizeContentProvider(this.syncSource.getId());
            assert (completed);
            RepoGroup repoGroup = repoManager.getRepoGroupByName("testRepoGroup");
            assert (repoGroup != null);
            this.repoGroupsToDelete.add(repoGroup.getId());
            List retrievedRepos = repoManager.getRepoByName("testRepo1");
            assert (retrievedRepos.size() == 1);
            assert (((Repo)retrievedRepos.get(0)).isCandidate());
            this.reposToDelete.add(((Repo)retrievedRepos.get(0)).getId());
            retrievedRepos = repoManager.getRepoByName("testRepo2");
            assert (retrievedRepos.size() == 1);
            assert (((Repo)retrievedRepos.get(0)).isCandidate());
            this.reposToDelete.add(((Repo)retrievedRepos.get(0)).getId());
            Repo repoInGroup = (Repo)retrievedRepos.get(0);
            RepoCriteria findWithRepoGroup = new RepoCriteria();
            findWithRepoGroup.fetchRepoRepoGroups(true);
            findWithRepoGroup.addFilterId(Integer.valueOf(repoInGroup.getId()));
            PageList repoPageList = repoManager.findReposByCriteria(overlord, findWithRepoGroup);
            repoInGroup = (Repo)repoPageList.get(0);
            Set repoGroups = repoInGroup.getRepoRepoGroups();
            assert (repoGroups.size() == 1);
            RepoRepoGroup repoRepoGroup = (RepoRepoGroup)repoGroups.iterator().next();
            assert (repoRepoGroup.getRepoRepoGroupPK().getRepoGroup().getName().equals("testRepoGroup"));
            assert (repoRepoGroup.getRepoRepoGroupPK().getRepo().getName().equals("testRepo2"));
            retrievedRepos = repoManager.getRepoByName("testRepo3");
            assert (retrievedRepos.size() == 1);
            assert (((Repo)retrievedRepos.get(0)).isCandidate());
            this.reposToDelete.add(((Repo)retrievedRepos.get(0)).getId());
            this.relatedRepoId = ((Repo)retrievedRepos.get(0)).getId();
            retrievedRepos = repoManager.getRepoByName("testRepo4");
            assert (retrievedRepos.size() == 1);
            assert (((Repo)retrievedRepos.get(0)).isCandidate());
            this.reposToDelete.add(((Repo)retrievedRepos.get(0)).getId());
            this.repoId = ((Repo)retrievedRepos.get(0)).getId();
            RepoCriteria findWithRelationships = new RepoCriteria();
            findWithRelationships.addFilterName("testRepo4");
            findWithRelationships.fetchRepoRepoRelationships(true);
            PageList childRepoList = repoManager.findReposByCriteria(overlord, findWithRelationships);
            assert (childRepoList.size() == 1);
            Repo childRepo = (Repo)childRepoList.get(0);
            Set childRepoRepoRelationship = childRepo.getRepoRepoRelationships();
            assert (childRepoRepoRelationship.size() == 1);
            retrievedRepos = repoManager.getRepoByName("testRepoImportedExisting");
            assert (retrievedRepos.size() == 1);
            this.reposToDelete.add(((Repo)retrievedRepos.get(0)).getId());
            retrievedRepos = repoManager.getRepoByName(CUSTOM_IMPORTED_REPO_NAME);
            assert (retrievedRepos.size() == 1);
            this.reposToDelete.add(((Repo)retrievedRepos.get(0)).getId());
            retrievedRepos = repoManager.getRepoByName("testRepoCandidateExisting");
            assert (retrievedRepos.size() == 1);
            this.reposToDelete.add(((Repo)retrievedRepos.get(0)).getId());
            retrievedRepos = repoManager.getRepoByName(PREVIOUS_CANDIDATE_REPO_NAME);
            assert (retrievedRepos.size() == 0);
            retrievedRepos = repoManager.getRepoByName("testRepoFoo");
            assert (retrievedRepos.size() == 0);
            this.getTransactionManager().commit();
        }
        catch (Throwable t) {
            this.getTransactionManager().rollback();
        }
    }
}

