/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetailsKey;
import org.rhq.enterprise.server.plugin.pc.content.DistributionDetails;
import org.rhq.enterprise.server.plugin.pc.content.DistributionFileDetails;
import org.rhq.enterprise.server.plugin.pc.content.DistributionSource;
import org.rhq.enterprise.server.plugin.pc.content.DistributionSyncReport;
import org.rhq.enterprise.server.plugin.pc.content.PackageSource;
import org.rhq.enterprise.server.plugin.pc.content.PackageSyncReport;
import org.rhq.enterprise.server.plugin.pc.content.RepoDetails;
import org.rhq.enterprise.server.plugin.pc.content.RepoGroupDetails;
import org.rhq.enterprise.server.plugin.pc.content.RepoImportReport;
import org.rhq.enterprise.server.plugin.pc.content.RepoSource;
import org.rhq.enterprise.server.plugin.pc.content.SyncException;
import org.rhq.enterprise.server.plugin.pc.content.SyncProgressWeight;

public class TestContentProvider
implements ContentProvider,
PackageSource,
RepoSource,
DistributionSource {
    public static final String PACKAGE_TYPE_NAME = "testContentProviderFakePackage";
    public static final String RESOURCE_TYPE_NAME = "testContentProviderFakeResourceType";
    public static final String RESOURCE_TYPE_PLUGIN_NAME = "testContentProviderFakeResourceTypePlugin";
    public static final String EXISTING_IMPORTED_REPO_NAME = "testRepoImportedExisting";
    public static final String EXISTING_CANDIDATE_REPO_NAME = "testRepoCandidateExisting";
    public static final String REPO_WITH_PACKAGES = "testRepoImportedExisting";
    public static final String REPO_WITH_DISTRIBUTIONS = "testRepoImportedExisting";
    public static final Map<ContentProviderPackageDetailsKey, ContentProviderPackageDetails> PACKAGES = new HashMap<ContentProviderPackageDetailsKey, ContentProviderPackageDetails>(2);
    public static final String DISTRIBUTION_1_LABEL = "distribution1";
    public static final String DISTRIBUTION_2_LABEL = "distribution2";
    public static final Map<String, DistributionDetails> DISTRIBUTIONS;
    public static final int PACKAGE_COUNT_FOR_BITS;
    private boolean failTest = false;
    private int longRunningSynchSleep = 0;
    private List<String> logSynchronizePackagesRepos = new ArrayList<String>();
    private List<String> logGetInputStreamLocations = new ArrayList<String>();
    private List<String> logSynchronizeDistroRepos = new ArrayList<String>();

    public void initialize(Configuration configuration) throws Exception {
    }

    public void shutdown() {
    }

    public void testConnection() throws Exception {
        if (this.failTest) {
            throw new Exception("Mock content source configured to fail the connection test");
        }
        System.out.println("Connection tested.");
    }

    public RepoImportReport importRepos() throws Exception {
        RepoImportReport report = new RepoImportReport();
        RepoGroupDetails group1 = new RepoGroupDetails("testRepoGroup", "family");
        report.addRepoGroup(group1);
        RepoDetails repo1 = new RepoDetails("testRepo1");
        repo1.setDescription("First test repo");
        report.addRepo(repo1);
        RepoDetails repo2 = new RepoDetails("testRepo2");
        repo2.setRepoGroup("testRepoGroup");
        report.addRepo(repo2);
        RepoDetails repo3 = new RepoDetails("testRepo3");
        report.addRepo(repo3);
        RepoDetails repo4 = new RepoDetails("testRepo4");
        repo4.setParentRepoName("testRepo3");
        report.addRepo(repo4);
        RepoDetails repo5 = new RepoDetails("testRepoImportedExisting");
        report.addRepo(repo5);
        RepoDetails repo6 = new RepoDetails(EXISTING_CANDIDATE_REPO_NAME);
        report.addRepo(repo6);
        return report;
    }

    public void synchronizePackages(String repoName, PackageSyncReport report, Collection<ContentProviderPackageDetails> existingPackages) throws SyncException, InterruptedException {
        this.logSynchronizePackagesRepos.add(repoName);
        if (!"testRepoImportedExisting".equals(repoName)) {
            return;
        }
        for (ContentProviderPackageDetails pkg : PACKAGES.values()) {
            ContentProviderPackageDetails existingPackage = this.findDetailsByKey(pkg.getContentProviderPackageDetailsKey(), existingPackages);
            if (existingPackage != null) continue;
            report.addNewPackage(pkg);
        }
        System.out.println(this.getClass().getSimpleName() + ".synchronizePackages sleeping for " + this.longRunningSynchSleep + " seconds");
        Thread.sleep(this.longRunningSynchSleep);
    }

    public InputStream getInputStream(String location) throws Exception {
        this.logGetInputStreamLocations.add(location);
        String seed = "Test Bits " + System.currentTimeMillis();
        ByteArrayInputStream bais = new ByteArrayInputStream(seed.getBytes());
        BufferedInputStream bis = new BufferedInputStream(bais);
        return bis;
    }

    public void synchronizeDistribution(String repoName, DistributionSyncReport report, Collection<DistributionDetails> existingDistros) throws SyncException, InterruptedException {
        this.logSynchronizeDistroRepos.add(repoName);
        if (!"testRepoImportedExisting".equals(repoName)) {
            return;
        }
        for (DistributionDetails distro : DISTRIBUTIONS.values()) {
            boolean existing = false;
            for (DistributionDetails existingDistro : existingDistros) {
                if (!distro.getLabel().equals(existingDistro.getLabel())) continue;
                existing = true;
                break;
            }
            if (existing) continue;
            report.addDistro(distro);
        }
        System.out.println(this.getClass().getSimpleName() + ".synchronizeDistribution sleeping for " + this.longRunningSynchSleep + " seconds");
        Thread.sleep(this.longRunningSynchSleep);
    }

    public String getDistFileRemoteLocation(String repoName, String label, String relativeFilename) {
        return "foo";
    }

    public List<String> getLogSynchronizePackagesRepos() {
        return this.logSynchronizePackagesRepos;
    }

    public List<String> getLogGetInputStreamLocations() {
        return this.logGetInputStreamLocations;
    }

    public void setLongRunningSynchSleep(int longRunningSynchSleep) {
        this.longRunningSynchSleep = longRunningSynchSleep;
    }

    public void reset() {
        this.logGetInputStreamLocations.clear();
        this.logSynchronizePackagesRepos.clear();
        this.logSynchronizeDistroRepos.clear();
    }

    private ContentProviderPackageDetails findDetailsByKey(ContentProviderPackageDetailsKey key, Collection<ContentProviderPackageDetails> packages) {
        for (ContentProviderPackageDetails pkg : packages) {
            if (!pkg.getContentProviderPackageDetailsKey().equals((Object)key)) continue;
            return pkg;
        }
        return null;
    }

    public SyncProgressWeight getSyncProgressWeight() {
        return SyncProgressWeight.DEFAULT_WEIGHTS;
    }

    static {
        ContentProviderPackageDetailsKey key1 = new ContentProviderPackageDetailsKey("package1", "version1", PACKAGE_TYPE_NAME, "noarch", RESOURCE_TYPE_NAME, RESOURCE_TYPE_PLUGIN_NAME);
        ContentProviderPackageDetails details1 = new ContentProviderPackageDetails(key1);
        details1.setFileName("filename1");
        details1.setFileSize(Long.valueOf(4L));
        details1.setLocation("foo1");
        PACKAGES.put(key1, details1);
        ContentProviderPackageDetailsKey key2 = new ContentProviderPackageDetailsKey("package2", "version2", PACKAGE_TYPE_NAME, "noarch", RESOURCE_TYPE_NAME, RESOURCE_TYPE_PLUGIN_NAME);
        ContentProviderPackageDetails details2 = new ContentProviderPackageDetails(key2);
        details2.setFileName("filename2");
        details2.setFileSize(Long.valueOf(4L));
        details2.setLocation("foo2");
        PACKAGES.put(key2, details2);
        DISTRIBUTIONS = new HashMap<String, DistributionDetails>(2);
        DistributionDetails dis1 = new DistributionDetails(DISTRIBUTION_1_LABEL, "kickstart");
        dis1.setDistributionPath("/kstrees");
        DistributionFileDetails file11 = new DistributionFileDetails("dist1file1", System.currentTimeMillis(), "zzz");
        DistributionFileDetails file12 = new DistributionFileDetails("dist1file2", System.currentTimeMillis(), "zzz");
        dis1.addFile(file11);
        dis1.addFile(file12);
        DISTRIBUTIONS.put(dis1.getLabel(), dis1);
        DistributionDetails dis2 = new DistributionDetails(DISTRIBUTION_2_LABEL, "kickstart");
        dis2.setDistributionPath("/kstrees");
        DistributionFileDetails file21 = new DistributionFileDetails("dist2file1", System.currentTimeMillis(), "zzz");
        dis2.addFile(file21);
        DISTRIBUTIONS.put(dis2.getLabel(), dis2);
        PACKAGE_COUNT_FOR_BITS = PACKAGES.size() + 3;
    }
}

