/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.generic;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.core.domain.plugin.PluginStatusType;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.enterprise.server.plugin.pc.AbstractTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainerConfiguration;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.ServerPluginService;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.plugin.pc.generic.GenericServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.generic.TestGenericServerPluginServiceMBean;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorMetadataParser;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

public class TestGenericServerPluginService
extends ServerPluginService
implements TestGenericServerPluginServiceMBean {
    public TestMasterServerPluginContainer master;
    public TestGenericServerPluginContainer genericPC;
    public MasterServerPluginContainerConfiguration masterConfig;

    public TestGenericServerPluginService() {
        File dir = new File(System.getProperty("java.io.tmpdir"), "test-server-plugins");
        this.masterConfig = new MasterServerPluginContainerConfiguration(dir, dir, dir, null);
    }

    public MasterServerPluginContainer createMasterPluginContainer() {
        this.master = new TestMasterServerPluginContainer();
        this.master.initialize(this.masterConfig);
        return this.master;
    }

    class TestGenericPluginManager
    extends ServerPluginManager {
        public final Map<String, ServerPluginComponent> components;

        public TestGenericPluginManager(TestGenericServerPluginContainer pc) {
            super((AbstractTypeServerPluginContainer)pc);
            this.components = new HashMap<String, ServerPluginComponent>();
        }

        protected ServerPlugin getPlugin(ServerPluginEnvironment env) {
            try {
                Configuration pluginConfig = null;
                Configuration scheduledJobsConfig = null;
                ServerPluginDescriptorType pluginDescriptor = env.getPluginDescriptor();
                ConfigurationDefinition configDef = ServerPluginDescriptorMetadataParser.getPluginConfigurationDefinition((ServerPluginDescriptorType)pluginDescriptor);
                if (configDef != null) {
                    pluginConfig = configDef.getDefaultTemplate().createConfiguration();
                }
                if ((configDef = ServerPluginDescriptorMetadataParser.getScheduledJobsDefinition((ServerPluginDescriptorType)pluginDescriptor)) != null) {
                    scheduledJobsConfig = configDef.getDefaultTemplate().createConfiguration();
                }
                File pluginFile = new File(env.getPluginUrl().toURI());
                ServerPlugin plugin = new ServerPlugin(0, env.getPluginKey().getPluginName(), pluginFile.getName(), pluginDescriptor.getDisplayName(), true, PluginStatusType.INSTALLED, pluginDescriptor.getDescription(), "", MessageDigestGenerator.getDigestString((File)pluginFile), pluginDescriptor.getVersion(), pluginDescriptor.getVersion(), pluginConfig, scheduledJobsConfig, new ServerPluginType(pluginDescriptor).stringify(), System.currentTimeMillis(), System.currentTimeMillis());
                return plugin;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected ServerPluginComponent createServerPluginComponent(ServerPluginEnvironment environment) throws Exception {
            ServerPluginComponent component = super.createServerPluginComponent(environment);
            this.components.put(environment.getPluginKey().getPluginName(), component);
            return component;
        }
    }

    class TestGenericServerPluginContainer
    extends GenericServerPluginContainer {
        public State state;

        public TestGenericServerPluginContainer(MasterServerPluginContainer master) {
            super(master);
            this.state = State.UNINITIALIZED;
        }

        protected ServerPluginManager createPluginManager() {
            TestGenericPluginManager pm = new TestGenericPluginManager(this);
            return pm;
        }

        public synchronized void initialize() throws Exception {
            if (this.state != State.UNINITIALIZED) {
                System.out.println("!!! PC LIFECYCLE WAS BAD - THIS IS A BUG !!!");
                throw new IllegalStateException("not uninitialized: " + (Object)((Object)this.state));
            }
            this.state = State.INITIALIZED;
            super.initialize();
        }

        public synchronized void start() {
            if (this.state != State.INITIALIZED) {
                System.out.println("!!! PC LIFECYCLE WAS BAD - THIS IS A BUG !!!");
                throw new IllegalStateException("not initialized: " + (Object)((Object)this.state));
            }
            this.state = State.STARTED;
            super.start();
        }

        public synchronized void stop() {
            if (this.state != State.STARTED) {
                System.out.println("!!! PC LIFECYCLE WAS BAD - THIS IS A BUG !!!");
                throw new IllegalStateException("not started: " + (Object)((Object)this.state));
            }
            this.state = State.STOPPED;
            super.stop();
        }

        public synchronized void shutdown() {
            if (this.state != State.STOPPED) {
                System.out.println("!!! PC LIFECYCLE WAS BAD - THIS IS A BUG !!!");
                throw new IllegalStateException("not stopped: " + (Object)((Object)this.state));
            }
            this.state = State.UNINITIALIZED;
            super.shutdown();
        }
    }

    class TestMasterServerPluginContainer
    extends MasterServerPluginContainer {
        TestMasterServerPluginContainer() {
        }

        protected List<AbstractTypeServerPluginContainer> createPluginContainers() {
            ArrayList<AbstractTypeServerPluginContainer> pcs = new ArrayList<AbstractTypeServerPluginContainer>(1);
            TestGenericServerPluginService.this.genericPC = new TestGenericServerPluginContainer(this);
            pcs.add((AbstractTypeServerPluginContainer)TestGenericServerPluginService.this.genericPC);
            return pcs;
        }

        protected ClassLoader createRootServerPluginClassLoader() {
            return ((Object)((Object)this)).getClass().getClassLoader();
        }

        protected Map<URL, ? extends ServerPluginDescriptorType> preloadAllPlugins() throws Exception {
            File pluginDir = this.getConfiguration().getPluginDirectory();
            if (pluginDir == null || pluginDir.listFiles() == null || pluginDir.listFiles().length == 0) {
                return new HashMap();
            }
            return super.preloadAllPlugins();
        }

        protected List<PluginKey> getDisabledPluginKeys() {
            return new ArrayList<PluginKey>();
        }
    }

    public static enum State {
        INITIALIZED,
        STARTED,
        STOPPED,
        UNINITIALIZED;

    }
}

