/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.generic;

import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;

public class TestLifecycleListener
implements ServerPluginComponent {
    public ServerPluginContext context;
    public LifecycleState state = LifecycleState.UNINITIALIZED;

    public void initialize(ServerPluginContext context) throws Exception {
        this.context = context;
        if (this.state == LifecycleState.UNINITIALIZED) {
            this.state = LifecycleState.INITIALIZED;
        } else {
            this.println("!!! lifecycle listener is in a bad state - this is a BUG !!!: " + (Object)((Object)this.state));
        }
        this.println("test server plugin has been initialized");
    }

    public void start() {
        if (this.state == LifecycleState.INITIALIZED) {
            this.state = LifecycleState.STARTED;
        } else {
            this.println("!!! lifecycle listener is in a bad state - this is a BUG !!!: " + (Object)((Object)this.state));
        }
        this.println("test server plugin has started");
    }

    public void stop() {
        if (this.state == LifecycleState.STARTED) {
            this.state = LifecycleState.STOPPED;
        } else {
            this.println("!!! lifecycle listener is in a bad state - this is a BUG !!!: " + (Object)((Object)this.state));
        }
        this.println("test server plugin has stopped");
    }

    public void shutdown() {
        if (this.state == LifecycleState.STOPPED) {
            this.state = LifecycleState.UNINITIALIZED;
        } else {
            this.println("!!! lifecycle listener is in a bad state - this is a BUG !!!: " + (Object)((Object)this.state));
        }
        this.println("test server plugin has been shut down");
    }

    private void println(String msg) {
        System.out.println(msg + "!!! : " + this);
    }

    public String toString() {
        if (this.context == null) {
            return "<no context>";
        }
        StringBuilder str = new StringBuilder();
        str.append("plugin-key=").append(this.context.getPluginEnvironment().getPluginKey()).append(",");
        str.append("plugin-url=").append(this.context.getPluginEnvironment().getPluginUrl()).append(",");
        str.append("data-dir=").append(this.context.getDataDirectory()).append(",");
        str.append("tmp-dir=").append(this.context.getTemporaryDirectory());
        return str.toString();
    }

    public static enum LifecycleState {
        UNINITIALIZED,
        INITIALIZED,
        STARTED,
        STOPPED;

    }
}

