/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.cluster;

import java.util.List;
import javax.persistence.EntityManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.group.ClusterKey;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.cluster.ClusterManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"resource-manager"})
public class ClusterManagerBeanTest
extends AbstractEJB3Test {
    private static final boolean TESTS_ENABLED = true;
    private ClusterManagerLocal clusterManager;
    private ResourceGroupManagerLocal resourceGroupManager;
    private ResourceManagerLocal resourceManager;

    @BeforeMethod
    private void init() {
        this.clusterManager = LookupUtil.getClusterManager();
        this.resourceGroupManager = LookupUtil.getResourceGroupManager();
        this.resourceManager = LookupUtil.getResourceManager();
    }

    @Test(enabled=true)
    public void testClusterKey() throws Throwable {
        this.getTransactionManager().begin();
        try {
            EntityManager em = ClusterManagerBeanTest.getEntityManager();
            Subject subject = SessionTestHelper.createNewSubject(em, "subject-ClusterManagerBeanTest");
            Role role = SessionTestHelper.createNewRoleForSubject(em, subject, "role-ClusterManagerBeanTest", Permission.MANAGE_INVENTORY);
            ResourceGroup clusterGroup = SessionTestHelper.createNewCompatibleGroupForRole(em, role, "clusterGroup-ClusterManagerBeanTest");
            List<Resource> treeA = ResourceTreeHelper.createTree(em, "A=d1c1,d1c2; d1c1=d2c1,d2c2; d2c1=d3c1,d3c2; d2c2=d3c3,d3c4");
            List<Resource> treeB = ResourceTreeHelper.createTree(em, "B=d1c1,d1c2; d1c1=d2c1,d2c2; d2c1=d3c1,d3c2; d2c2=d3c3,d3c4");
            Resource nodeA = ResourceTreeHelper.findNode(treeA, "A");
            Resource nodeB = ResourceTreeHelper.findNode(treeB, "B");
            this.resourceGroupManager.addResourcesToGroup(subject, clusterGroup.getId(), new int[]{nodeA.getId(), nodeB.getId()});
            PageList AChildren = this.resourceManager.findChildResources(subject, nodeA.getId(), PageControl.getUnlimitedInstance());
            assert (!AChildren.isEmpty()) : "Expected Children for Node A";
            int AChildResourceTypeId = ((Resource)AChildren.get(0)).getResourceType().getId();
            String AChildResourceKey = ((Resource)AChildren.get(0)).getResourceKey();
            ClusterKey clusterKey = new ClusterKey(clusterGroup.getId(), AChildResourceTypeId, AChildResourceKey);
            assert (clusterKey.getClusterGroupId() == clusterGroup.getId());
            assert (clusterKey.getDepth() == 1);
            assert (AChildResourceKey.equals(((ClusterKey.Node)clusterKey.getHierarchy().get(0)).getResourceKey()));
            assert (AChildResourceTypeId == ((ClusterKey.Node)clusterKey.getHierarchy().get(0)).getResourceTypeId());
            assert (AChildResourceTypeId == ClusterKey.getResourceType((ClusterKey)clusterKey));
            assert (ClusterKey.valueOf((String)clusterKey.toString()) != null);
            List resources = this.clusterManager.getAutoClusterResources(subject, clusterKey);
            assert (resources.size() == 2);
            assert (((Resource)resources.get(0)).getId() != ((Resource)resources.get(1)).getId());
            assert (((Resource)resources.get(0)).getParentResource().getId() != ((Resource)resources.get(1)).getParentResource().getId());
            assert (((Resource)resources.get(0)).getParentResource().getId() == nodeA.getId() || ((Resource)resources.get(0)).getParentResource().getId() == nodeB.getId());
            assert (((Resource)resources.get(1)).getParentResource().getId() == nodeA.getId() || ((Resource)resources.get(1)).getParentResource().getId() == nodeB.getId());
            ClusterManagerBeanTest.assertNull((Object)this.clusterManager.getAutoClusterBackingGroup(subject, clusterKey));
            ResourceGroup backingGroup = this.clusterManager.createAutoClusterBackingGroup(subject, clusterKey, true);
            ClusterManagerBeanTest.assertNotNull((Object)backingGroup);
            ClusterManagerBeanTest.assertEquals((String)backingGroup.getClusterKey(), (String)clusterKey.toString());
            ClusterManagerBeanTest.assertEquals((Object)backingGroup.getClusterResourceGroup(), (Object)clusterGroup);
            PageList backingGroupResources = this.resourceManager.findExplicitResourcesByResourceGroup(subject, backingGroup, PageControl.getUnlimitedInstance());
            ClusterManagerBeanTest.assertEquals((int)backingGroupResources.size(), (int)resources.size());
            for (Resource resource : backingGroupResources) {
                assert (resources.contains(resource));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    @Test(enabled=true)
    public void testClusterKeyDepth2() throws Throwable {
        this.getTransactionManager().begin();
        try {
            EntityManager em = ClusterManagerBeanTest.getEntityManager();
            Subject subject = SessionTestHelper.createNewSubject(em, "subject-ClusterManagerBeanTest");
            Role role = SessionTestHelper.createNewRoleForSubject(em, subject, "role-ClusterManagerBeanTest", Permission.MANAGE_INVENTORY);
            ResourceGroup clusterGroup = SessionTestHelper.createNewCompatibleGroupForRole(em, role, "clusterGroup-ClusterManagerBeanTest");
            List<Resource> treeA = ResourceTreeHelper.createTree(em, "A=d1c1,d1c2; d1c1=d2c1,d2c2; d2c1=d3c1,d3c2; d2c2=d3c3,d3c4");
            List<Resource> treeB = ResourceTreeHelper.createTree(em, "B=d1c1,d1c2; d1c1=d2c1,d2c2; d2c1=d3c1,d3c2; d2c2=d3c3,d3c4");
            Resource nodeA = ResourceTreeHelper.findNode(treeA, "A");
            Resource nodeB = ResourceTreeHelper.findNode(treeB, "B");
            this.resourceGroupManager.addResourcesToGroup(subject, clusterGroup.getId(), new int[]{nodeA.getId(), nodeB.getId()});
            PageList AChildren = this.resourceManager.findChildResources(subject, nodeA.getId(), PageControl.getUnlimitedInstance());
            assert (!AChildren.isEmpty()) : "Expected Children for Node A";
            Resource AChild = (Resource)AChildren.get(0);
            int AChildResourceTypeId = AChild.getResourceType().getId();
            String AChildResourceKey = AChild.getResourceKey();
            PageList AGrandChildren = this.resourceManager.findChildResources(subject, AChild.getId(), PageControl.getUnlimitedInstance());
            Resource AGrandChild = (Resource)AGrandChildren.get(0);
            int AGrandChildResourceTypeId = AGrandChild.getResourceType().getId();
            String AGrandChildResourceKey = AGrandChild.getResourceKey();
            ClusterKey clusterKey = new ClusterKey(clusterGroup.getId(), AChildResourceTypeId, AChildResourceKey);
            clusterKey.addChildToHierarchy(AGrandChildResourceTypeId, AGrandChildResourceKey);
            assert (clusterKey.getClusterGroupId() == clusterGroup.getId());
            assert (clusterKey.getDepth() == 2);
            assert (AChildResourceKey.equals(((ClusterKey.Node)clusterKey.getHierarchy().get(0)).getResourceKey()));
            assert (AChildResourceTypeId == ((ClusterKey.Node)clusterKey.getHierarchy().get(0)).getResourceTypeId());
            assert (AGrandChildResourceKey.equals(((ClusterKey.Node)clusterKey.getHierarchy().get(1)).getResourceKey()));
            assert (AGrandChildResourceTypeId == ((ClusterKey.Node)clusterKey.getHierarchy().get(1)).getResourceTypeId());
            assert (AGrandChildResourceTypeId == ClusterKey.getResourceType((ClusterKey)clusterKey));
            assert (ClusterKey.valueOf((String)clusterKey.toString()) != null);
            List resources = this.clusterManager.getAutoClusterResources(subject, clusterKey);
            assert (resources.size() == 2);
            assert (((Resource)resources.get(0)).getId() != ((Resource)resources.get(1)).getId());
            assert (((Resource)resources.get(0)).getParentResource().getId() != ((Resource)resources.get(1)).getParentResource().getId());
            assert (((Resource)resources.get(0)).getParentResource().getParentResource().getId() == nodeA.getId() || ((Resource)resources.get(0)).getParentResource().getParentResource().getId() == nodeB.getId());
            assert (((Resource)resources.get(1)).getParentResource().getParentResource().getId() == nodeA.getId() || ((Resource)resources.get(1)).getParentResource().getParentResource().getId() == nodeB.getId());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }
}

