/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group.test;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import javax.persistence.Query;
import org.rhq.core.domain.common.SystemConfiguration;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.enterprise.server.RHQConstants;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerPluginService;
import org.rhq.enterprise.server.test.ldap.FakeLdapCtxFactory;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.test.TransactionCallback;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LdapGroupManagerBeanTest
extends AbstractEJB3Test {
    public static String RHQ_TEST_LDAP_URL_PROPERTY = "rhq.test.ldap.url";
    public static String RHQ_TEST_LDAP_LDAPFACTORY_PROPERTY = "rhq.test.ldap.LDAPFactory";
    public static String RHQ_TEST_LDAP_DEFAULT_CONTEXT_FACTORY = FakeLdapCtxFactory.class.getCanonicalName();
    public static String RHQ_TEST_LDAP_DEFAULT_URL = "ldap://localhost:389";
    private LdapGroupManagerLocal ldapGroupManager = null;
    private SystemManagerLocal systemManager = null;
    private TestServerPluginService testServerPluginService = null;

    @BeforeClass
    private void init() throws Throwable {
        this.systemManager = LookupUtil.getSystemManager();
        this.ldapGroupManager = LookupUtil.getLdapGroupManager();
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.testServerPluginService = new TestServerPluginService();
        this.prepareCustomServerPluginService(this.testServerPluginService);
        this.testServerPluginService.startMasterPluginContainer();
        URL url = LdapGroupManagerBeanTest.class.getClassLoader().getResource("test-ldap.properties");
        Properties mvnProps = new Properties();
        try {
            if (url == null) {
                throw new IOException("Unable to find test-ldap.properties in test envrionment's class loader");
            }
            mvnProps.load(url.openStream());
        }
        catch (IOException e) {
            System.err.println(" !!! Unable to load test-ldap.properties - All defaults are in place !!! ");
            e.printStackTrace();
        }
        String LDAPFactory = mvnProps.getProperty(RHQ_TEST_LDAP_LDAPFACTORY_PROPERTY);
        if (LDAPFactory == null || ("${" + RHQ_TEST_LDAP_LDAPFACTORY_PROPERTY + "}").equals(LDAPFactory)) {
            LDAPFactory = RHQ_TEST_LDAP_DEFAULT_CONTEXT_FACTORY;
        }
        this.setLdapCtxFactory(LDAPFactory);
        System.out.println("!! Initial LDAP Context Factory is " + LDAPFactory + " !!");
        String ldapUrl = mvnProps.getProperty(RHQ_TEST_LDAP_URL_PROPERTY);
        if (ldapUrl == null || ("${" + RHQ_TEST_LDAP_URL_PROPERTY + "}").equals(ldapUrl)) {
            ldapUrl = RHQ_TEST_LDAP_DEFAULT_URL;
        }
        this.setLdapUrl(ldapUrl);
        this.setLdapBaseDN("dc=test,dc=rhq,dc=redhat,dc=com");
        this.setLdapBindDN("uid=admin,ou=system");
        this.setLdapBindPassword("secret");
        this.setLdapUserFilter("objectClass=person");
        this.setLdapLoginAttribute("uid");
        this.setLdapGroupFilter("objectClass=groupOfNames");
        this.setLdapGroupMemberAttribute("member");
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws Exception {
        this.unprepareServerPluginService();
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForNonUser() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet(), (Object)this.ldapGroupManager.findAvailableGroupsFor("gsmith"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserSimpleUseCase() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("rjosmith"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("jsmith"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("ssmith"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserCommaChar() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("bcannon"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("ghause"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("bwalsh"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserBackslashChar() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("csamlin"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("cgroober"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("jkirk"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserHashChar() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("csellers"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("brogers"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("sphillips"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserPlusChar() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("bbalanger"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("sreed"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("woverture"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserGTLTChar() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("bwallace"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("ltoller"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("callen"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserSemiColonChar() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("zbalanger"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("hsimpsonite"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("wfredrick"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserQuoteChar() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("acallen"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("jmathers"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("smein"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserEqualChar() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("ssmitherson"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("hrein"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("nsadler"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserLTSpaceChar() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("bkiddough"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("sferguson"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("ssmiley"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserSlashChar() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("sysapi"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("pscarlson"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("sysapi2"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserHyphenChar() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("lecroutche"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("samathers"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("sajeopardy"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserAsteriskChar() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("sjeopardy"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("lcroutche"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("smathers"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserParenthesisChar() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("bstrafford"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("kkrawford"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("jwilbright"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUser8BitAsciiChar() throws Throwable {
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("mmechura"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("wsequerl"));
        LdapGroupManagerBeanTest.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), (Object)this.ldapGroupManager.findAvailableGroupsFor("pbrady"));
    }

    private void setSystemConfigProperty(String name, String value) throws Exception {
        Properties sysConfig = this.systemManager.getSystemConfiguration(LookupUtil.getSubjectManager().getOverlord());
        sysConfig.setProperty(name, value);
        this.systemManager.setSystemConfiguration(LookupUtil.getSubjectManager().getOverlord(), sysConfig, true);
    }

    private void setLdapGroupFilter(String filter) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPGroupFilter, filter);
    }

    private void setLdapGroupMemberAttribute(String attributeName) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPGroupMember, attributeName);
    }

    private void setLdapBaseDN(String dn) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPBaseDN, dn);
    }

    private void setLdapLoginAttribute(String attributeName) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPLoginProperty, attributeName);
    }

    private void setLdapBindDN(String dn) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPBindDN, dn);
    }

    private void setLdapBindPassword(String password) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPBindPW, password);
    }

    private void setLdapUserFilter(String filter) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPFilter, filter);
    }

    private void setLdapUrl(String url) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPUrl, url);
    }

    private void setLdapCtxFactory(final String name) throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            public void execute() throws Exception {
                Query q = AbstractEJB3Test.getEntityManager().createNamedQuery("SystemConfiguration.FIND_PROPERTY_BY_KEY");
                q.setParameter("key", (Object)SystemSetting.LDAP_NAMING_FACTORY.getInternalName());
                SystemConfiguration config = (SystemConfiguration)q.getSingleResult();
                config.setPropertyValue(name);
                AbstractEJB3Test.getEntityManager().merge((Object)config);
                AbstractEJB3Test.getEntityManager().flush();
            }
        });
        this.systemManager.loadSystemConfigurationCache();
    }
}

