/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.Arrays;
import java.util.Collections;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.resource.metadata.MetadataBeanTest;
import org.testng.annotations.Test;

public class ContentMetadataManagerBeanTest
extends MetadataBeanTest {
    @Test(groups={"plugin.metadata", "Content.NewPlugin"})
    public void registerContentPlugin() throws Exception {
        this.createPlugin("content-test-plugin", "1.0", "plugin_v1.xml");
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnGroups={"Content.NewPlugin"})
    public void upgradeContentPlugin() throws Exception {
        this.createPlugin("content-test-plugin", "2.0", "plugin_v2.xml");
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void addPackageTypes() throws Exception {
        this.assertResourceTypeAssociationEquals("ContentServer1", "ContentMetadataManagerBeanTestPlugin", "packageTypes", Arrays.asList("ContentServer1.Content.1", "ContentServer1.Content.2"));
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void deletePackageTypes() throws Exception {
        this.assertResourceTypeAssociationEquals("ContentServer2", "ContentMetadataManagerBeanTestPlugin", "packageTypes", Collections.EMPTY_LIST);
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void deletePackageTypesThatExistsInOldResourceTypeButNotInNewResourceType() throws Exception {
        this.assertResourceTypeAssociationEquals("ContentServer3", "ContentMetadataManagerBeanTestPlugin", "packageTypes", Arrays.asList("ContentServer3.Content.2", "ContentServer3.Content.3"));
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void addPackageThatAreAddedInNewResourceType() throws Exception {
        this.assertResourceTypeAssociationEquals("ContentServer4", "ContentMetadataManagerBeanTestPlugin", "packageTypes", Arrays.asList("ContentServer4.Content.1", "ContentServer4.Content.2"));
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void addNewDeploymentConfigurationDefinition() throws Exception {
        PackageType packageType = this.loadPackageType("ContentServer", "ContentMetadataManagerBeanTestPlugin", "ContentServer.Content.1");
        ConfigurationDefinition deploymentConfigDef = packageType.getDeploymentConfigurationDefinition();
        ContentMetadataManagerBeanTest.assertNotNull((String)"Failed to create new deployment configuration definition for package type that previously did not have one", (Object)deploymentConfigDef);
        ContentMetadataManagerBeanTest.assertEquals((String)"Expected to find 1 property definition in new deployment configuration definition", (int)1, (int)deploymentConfigDef.getPropertyDefinitions().size());
        ContentMetadataManagerBeanTest.assertNotNull((String)"Expected to find 1 property definition, <version>, in new deployment configuration definition", (Object)deploymentConfigDef.get("version"));
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void updateDeploymentConfigDefThatExistsInOldAndNewResourceType() throws Exception {
        PackageType packageType = this.loadPackageType("ContentServer5", "ContentMetadataManagerBeanTestPlugin", "ContentServer5.Content.1");
        ConfigurationDefinition deploymentConfigDef = packageType.getDeploymentConfigurationDefinition();
        ContentMetadataManagerBeanTest.assertNotNull((String)"Failed to update deployment configuration definition for package type", (Object)deploymentConfigDef);
        ContentMetadataManagerBeanTest.assertEquals((String)"Expected to find 2 property definitions in updated deployment configuration definition", (int)2, (int)deploymentConfigDef.getPropertyDefinitions().size());
        ContentMetadataManagerBeanTest.assertNotNull((String)"Expected existing property definition to be retained across update", (Object)deploymentConfigDef.get("x"));
        ContentMetadataManagerBeanTest.assertNotNull((String)"Expected new property definition to be added during update", (Object)deploymentConfigDef.get("y"));
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void deleteDeploymentConfigDefThatIsRemovedInNewResourceType() {
        PackageType packageType = this.loadPackageType("ContentServer5", "ContentMetadataManagerBeanTestPlugin", "ContentServer5.Content.2");
        ContentMetadataManagerBeanTest.assertNull((String)"Expected deployment configuration definition to be removed since it was removed from new resource type", (Object)packageType.getDeploymentConfigurationDefinition());
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void updateBundleType() {
        ResourceType resourceType = this.loadResourceTypeWithBundleType("ContentServer7", "ContentMetadataManagerBeanTestPlugin");
        BundleType bundleType = resourceType.getBundleType();
        ContentMetadataManagerBeanTest.assertNotNull((String)"Failed to upgrade bundle type", (Object)bundleType);
        ContentMetadataManagerBeanTest.assertEquals((String)"Failed to upgrade bundle type correctly. The bundle type name is wrong", (String)"ContentServer.Bundle.2", (String)bundleType.getName());
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void addBundleTypeThatOnlyExistsInNewResourceType() {
        ResourceType resourceType = this.loadResourceTypeWithBundleType("ContentServer6", "ContentMetadataManagerBeanTestPlugin");
        BundleType bundleType = resourceType.getBundleType();
        ContentMetadataManagerBeanTest.assertNotNull((String)"Expected to find bundle type added during upgrade", (Object)bundleType);
        ContentMetadataManagerBeanTest.assertEquals((String)"Failed to correctly add bundle type during upgrade", (String)"ContentServer6.Bundle.1", (String)bundleType.getName());
    }

    PackageType loadPackageType(String resourceType, String plugin, String packageType) {
        return (PackageType)ContentMetadataManagerBeanTest.getEntityManager().createQuery("from PackageType p left join fetch p.deploymentConfigurationDefinition where p.name = :packageType and p.resourceType.name = :resourceType and p.resourceType.plugin = :plugin").setParameter("packageType", (Object)packageType).setParameter("plugin", (Object)plugin).setParameter("resourceType", (Object)resourceType).getSingleResult();
    }

    ResourceType loadResourceTypeWithBundleType(String resourceType, String plugin) {
        return (ResourceType)ContentMetadataManagerBeanTest.getEntityManager().createQuery("from  ResourceType t left join fetch t.bundleType where t.name = :resourceType and t.plugin = :plugin").setParameter("resourceType", (Object)resourceType).setParameter("plugin", (Object)plugin).getSingleResult();
    }
}

