/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementCategory;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.enterprise.server.resource.metadata.MetadataBeanTest;
import org.rhq.test.AssertUtils;
import org.testng.annotations.Test;

public class MeasurementMetadataManagerBeanTest
extends MetadataBeanTest {
    @Test(groups={"plugin.metadata", "Metrics.NewPlugin"})
    void registerMetricsPlugin() throws Exception {
        this.createPlugin("metric-test-plugin", "1.0", "plugin_v1.xml");
    }

    @Test(groups={"plugin.metadata", "Metrics.NewPlugin"}, dependsOnMethods={"registerMetricsPlugin"})
    public void persistNewMetrics() throws Exception {
        this.assertResourceTypeAssociationEquals("MetricServer1", "MeasurementMetadataManagerBeanTestPlugin", "metricDefinitions", Arrays.asList("metric1", "metric2", "metric3"));
    }

    @Test(groups={"plugin.metadata", "Metrics.NewPlugin"}, dependsOnMethods={"persistNewMetrics"})
    public void persistNewTraitDefinitionProperties() {
        MeasurementDefinition traitDef = this.loadMeasurementDef("metric1", "MetricServer1");
        MeasurementDefinition expected = new MeasurementDefinition("metric1", MeasurementCategory.AVAILABILITY, MeasurementUnits.MILLISECONDS, DataType.TRAIT, NumericType.DYNAMIC, true, 30000L, DisplayType.SUMMARY);
        expected.setDescription("Metric 1");
        expected.setDisplayName("metric1");
        expected.setDisplayOrder(1);
        AssertUtils.assertPropertiesMatch((String)"Failed to persist properties for a trait metric definition", (Object)expected, (Object)traitDef, Arrays.asList("id", "resourceType"));
    }

    @Test(groups={"plugin.metadata", "Metrics.NewPlugin"}, dependsOnMethods={"persistNewMetrics"})
    public void persistNewNumericMeasurementDef() {
        MeasurementDefinition measurementDef = this.loadMeasurementDef("metric2", "MetricServer1");
        MeasurementDefinition expected = new MeasurementDefinition("metric2", MeasurementCategory.PERFORMANCE, MeasurementUnits.MEGABYTES, NumericType.TRENDSUP, false, 30000L, DisplayType.DETAIL);
        expected.setRawNumericType(null);
        expected.setDescription("Metric 2");
        expected.setDisplayName("metric2");
        expected.setDisplayOrder(2);
        AssertUtils.assertPropertiesMatch((String)"Failed to persist properties for numeric metric definition", (Object)expected, (Object)measurementDef, Arrays.asList("id", "resourceType"));
        MeasurementDefinition perMinuteDef = this.loadMeasurementDef("metric2", "MetricServer1", "metric2 per Minute");
        expected = new MeasurementDefinition(measurementDef);
        expected.setDisplayName("metric2 per Minute");
        expected.setDisplayOrder(3);
        expected.setDefaultOn(true);
        expected.setNumericType(NumericType.DYNAMIC);
        expected.setRawNumericType(measurementDef.getNumericType());
        AssertUtils.assertPropertiesMatch((String)"Failed to create and persist per minute metric definition for numeric metric definition", (Object)expected, (Object)perMinuteDef, Arrays.asList("id", "resourceType"));
    }

    @Test(groups={"plugin.metadata", "Metrics.NewPlugin"}, dependsOnMethods={"persistNewMetrics"})
    public void persistNewCallTimeDef() {
        MeasurementDefinition calltimeDef = this.loadMeasurementDef("metric3", "MetricServer1");
        MeasurementDefinition expected = new MeasurementDefinition("metric3", MeasurementCategory.THROUGHPUT, MeasurementUnits.MILLISECONDS, DataType.CALLTIME, true, 30000L, DisplayType.DETAIL);
        expected.setNumericType(NumericType.DYNAMIC);
        expected.setDestinationType("myMethod");
        expected.setDescription("Metric 3");
        expected.setDisplayName("metric3");
        expected.setDisplayOrder(4);
        AssertUtils.assertPropertiesMatch((String)"Failed to create calltime metric definition", (Object)expected, (Object)calltimeDef, Arrays.asList("id", "resourceType"));
    }

    @Test(groups={"plugin.metadata", "Metrics.UpgradePlugin"}, dependsOnGroups={"Metrics.NewPlugin"})
    public void upgradeMetricsPlugin() throws Exception {
        this.createPlugin("metric-test-plugin", "2.0", "plugin_v2.xml");
    }

    @Test(groups={"plugin.metadata", "Metrics.UpradePlugin"}, dependsOnMethods={"upgradeMetricsPlugin"})
    public void addNewMetricDef() throws Exception {
        this.assertResourceTypeAssociationEquals("MetricServer2", "MeasurementMetadataManagerBeanTestPlugin", "metricDefinitions", Arrays.asList("metric1"));
    }

    @Test(groups={"plugin.metadata", "Metrics.UpradePlugin"}, dependsOnMethods={"upgradeMetricsPlugin"})
    public void changeTraitDefToMeasurementDef() {
        MeasurementDefinition measurementDef = this.loadMeasurementDef("metric1", "MetricServer3");
        MeasurementDefinition expected = new MeasurementDefinition("metric1", MeasurementCategory.PERFORMANCE, MeasurementUnits.MILLISECONDS, DataType.MEASUREMENT, NumericType.TRENDSUP, false, 30000L, DisplayType.DETAIL);
        expected.setRawNumericType(null);
        expected.setDefaultInterval(30000L);
        expected.setDescription("Metric One");
        expected.setDisplayName("metric1");
        expected.setDisplayOrder(1);
        AssertUtils.assertPropertiesMatch((String)"Failed to change trait definition to a measurement defintion", (Object)expected, (Object)measurementDef, Arrays.asList("id", "resourceType"));
        MeasurementDefinition perMinuteDef = this.loadMeasurementDef("metric1", "MetricServer3", "metric1 per Minute");
        expected.setDisplayName("metric1 per Minute");
        expected.setDisplayOrder(2);
        expected.setDefaultInterval(60000L);
        expected.setDefaultOn(false);
        expected.setNumericType(NumericType.DYNAMIC);
        expected.setRawNumericType(measurementDef.getNumericType());
        AssertUtils.assertPropertiesMatch((String)"Failed to create and persist per minute metric definition for updated metric definition", (Object)expected, (Object)perMinuteDef, Arrays.asList("id", "resourceType"));
    }

    @Test(groups={"plugin.metadata", "Metrics.UpradePlugin"}, dependsOnMethods={"upgradeMetricsPlugin"})
    public void deleteMetricDefThatHasBeenRemovedFromResourceType() throws Exception {
        this.assertResourceTypeAssociationEquals("MetricServer4", "MeasurementMetadataManagerBeanTestPlugin", "metricDefinitions", Collections.EMPTY_LIST);
    }

    @Test(groups={"plugin.metadata", "Metrics.UpradePlugin"}, dependsOnMethods={"upgradeMetricsPlugin"})
    public void deleteMetricDefsForResourceTypeThatIsRemoved() {
        List metricDefs = MeasurementMetadataManagerBeanTest.getEntityManager().createQuery("from  MeasurementDefinition m where m.name = :metric1Name or name = :metric2Name").setParameter("metric1Name", (Object)"MetricServer5.metric1").setParameter("metric2Name", (Object)"MetricServer5.metric3").getResultList();
        MeasurementMetadataManagerBeanTest.assertEquals((String)"Failed to delete metric definitions", (int)0, (int)metricDefs.size());
    }

    MeasurementDefinition loadMeasurementDef(String name, String resourceType) {
        return this.loadMeasurementDef(name, resourceType, name);
    }

    MeasurementDefinition loadMeasurementDef(String name, String resourceType, String displayName) {
        return (MeasurementDefinition)MeasurementMetadataManagerBeanTest.getEntityManager().createQuery("from  MeasurementDefinition m where m.name = :name and m.displayName = :displayName and m.resourceType.name = :resourceType").setParameter("name", (Object)name).setParameter("displayName", (Object)displayName).setParameter("resourceType", (Object)resourceType).getSingleResult();
    }
}

