/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlProducer;
import org.dbunit.ext.oracle.Oracle10DataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;
import org.dbunit.operation.DatabaseOperation;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.clientapi.shared.PluginDescriptorUtil;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.bundle.TestBundleServerPluginService;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.scheduler.jobs.PurgePluginsJob;
import org.rhq.enterprise.server.scheduler.jobs.PurgeResourceTypesJob;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.xml.sax.InputSource;

public class MetadataBeanTest
extends AbstractEJB3Test {
    private List<Integer> pluginIds = new ArrayList<Integer>();

    @Override
    protected boolean isDBResetNeeded() {
        return false;
    }

    @BeforeGroups(groups={"plugin.metadata"}, dependsOnGroups={"integration.ejb3"})
    public void beforeGroups() throws Exception {
        this.setupDB();
    }

    @AfterClass(alwaysRun=true, groups={"plugin.metadata"})
    void afterClass() throws Exception {
        PluginManagerLocal pluginMgr = LookupUtil.getPluginManager();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        pluginMgr.deletePlugins(overlord, this.pluginIds);
        pluginMgr.markPluginsForPurge(overlord, this.pluginIds);
        new PurgePluginsJob().executeJobCode(null);
        new PurgeResourceTypesJob().executeJobCode(null);
    }

    @BeforeMethod(groups={"plugin.metadata"}, dependsOnGroups={"integration.ejb3"})
    public void beforeMethod() throws Exception {
        TestBundleServerPluginService bundleService = new TestBundleServerPluginService();
        this.prepareCustomServerPluginService(bundleService);
        bundleService.startMasterPluginContainerWithoutSchedulingJobs();
        this.prepareScheduler();
    }

    @AfterMethod(alwaysRun=true, groups={"plugin.metadata"})
    void afterMethod() throws Exception {
        this.unprepareServerPluginService();
        this.unprepareScheduler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupDB() throws Exception {
        Connection connection = null;
        try {
            connection = MetadataBeanTest.getConnection();
            DatabaseConnection dbunitConnection = new DatabaseConnection(connection);
            this.setDbType((IDatabaseConnection)dbunitConnection);
            DatabaseOperation.REFRESH.execute((IDatabaseConnection)dbunitConnection, this.getDataSet());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private void setDbType(IDatabaseConnection connection) throws Exception {
        DatabaseConfig config = connection.getConfig();
        String name = connection.getConnection().getMetaData().getDatabaseProductName().toLowerCase();
        int major = connection.getConnection().getMetaData().getDatabaseMajorVersion();
        Object type = null;
        if (name.contains("postgres")) {
            type = new PostgresqlDataTypeFactory();
        } else if (name.contains("oracle")) {
            type = major >= 10 ? new Oracle10DataTypeFactory() : new OracleDataTypeFactory();
        }
        if (type != null) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", type);
        }
    }

    private IDataSet getDataSet() throws DataSetException {
        FlatXmlProducer xmlProducer = new FlatXmlProducer(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream(this.getDataSetFile())));
        xmlProducer.setColumnSensing(true);
        return new FlatXmlDataSet(xmlProducer);
    }

    protected String getDataSetFile() {
        return "MetadataTest.xml";
    }

    protected void createPlugin(String pluginFileName, String version, String descriptorFileName) throws Exception {
        URL descriptorURL = this.getDescriptorURL(descriptorFileName);
        PluginDescriptor pluginDescriptor = PluginDescriptorUtil.loadPluginDescriptor((URL)descriptorURL);
        String pluginFilePath = this.getCurrentWorkingDir() + "/" + pluginFileName + ".jar";
        File pluginFile = new File(pluginFilePath);
        Plugin plugin = new Plugin(pluginDescriptor.getName(), pluginFilePath);
        plugin.setDisplayName(pluginDescriptor.getName());
        plugin.setEnabled(true);
        plugin.setDescription(pluginDescriptor.getDescription());
        plugin.setAmpsVersion(this.getAmpsVersion(pluginDescriptor));
        plugin.setVersion(pluginDescriptor.getVersion());
        plugin.setMD5(MessageDigestGenerator.getDigestString((URL)descriptorURL));
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        PluginManagerLocal pluginMgr = LookupUtil.getPluginManager();
        pluginMgr.registerPlugin(subjectMgr.getOverlord(), plugin, pluginDescriptor, null, true);
        this.pluginIds.add(plugin.getId());
    }

    private URL getDescriptorURL(String descriptor) {
        String dir = ((Object)((Object)this)).getClass().getSimpleName();
        return ((Object)((Object)this)).getClass().getResource(dir + "/" + descriptor);
    }

    private String getPluginWorkDir() throws Exception {
        return this.getCurrentWorkingDir() + "/work";
    }

    private String getCurrentWorkingDir() throws Exception {
        return ((Object)((Object)this)).getClass().getResource(".").toURI().getPath();
    }

    String getAmpsVersion(PluginDescriptor pluginDescriptor) {
        ComparableVersion version2;
        if (pluginDescriptor.getAmpsVersion() == null) {
            return "2.0";
        }
        ComparableVersion version = new ComparableVersion(pluginDescriptor.getAmpsVersion());
        if (version.compareTo((Object)(version2 = new ComparableVersion("2.0"))) <= 0) {
            return "2.0";
        }
        return pluginDescriptor.getAmpsVersion();
    }

    protected ResourceType assertResourceTypeAssociationEquals(String resourceTypeName, String plugin, String propertyName, List<String> expected) throws Exception {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        String fetch = "fetch" + WordUtils.capitalize((String)propertyName);
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.addFilterName(resourceTypeName);
        criteria.addFilterPluginName(plugin);
        criteria.setStrict(true);
        MethodUtils.invokeMethod((Object)criteria, (String)fetch, (Object)true);
        PageList resourceTypes = resourceTypeMgr.findResourceTypesByCriteria(subjectMgr.getOverlord(), criteria);
        ResourceType resourceType = (ResourceType)resourceTypes.get(0);
        HashSet<String> expectedSet = new HashSet<String>(expected);
        ArrayList<String> missing = new ArrayList<String>();
        ArrayList<String> unexpected = new ArrayList<String>();
        for (String expectedProperty : expectedSet) {
            if (this.contains(resourceType, propertyName, expectedProperty)) continue;
            missing.add(expectedProperty);
        }
        Collection actualPropertyValues = (Collection)PropertyUtils.getProperty((Object)resourceType, (String)propertyName);
        for (Object actualPropertyValue : actualPropertyValues) {
            String actualName = (String)PropertyUtils.getProperty(actualPropertyValue, (String)"name");
            if (expectedSet.contains(actualName)) continue;
            unexpected.add(actualName);
        }
        String errors = "";
        if (!missing.isEmpty()) {
            errors = "Failed to find the following " + propertyName + "(s) for type " + resourceTypeName + ": " + missing;
        }
        if (unexpected.size() > 0) {
            errors = errors + "\nFound unexpected " + propertyName + "(s) for type " + resourceTypeName + ": " + unexpected;
        }
        assert (errors.isEmpty()) : errors;
        return resourceType;
    }

    private boolean contains(ResourceType type, String propertyName, String expected) throws Exception {
        Collection actualPropertyValues = (Collection)PropertyUtils.getProperty((Object)type, (String)propertyName);
        for (Object actualPropertyValue : actualPropertyValues) {
            String actualName = (String)PropertyUtils.getProperty(actualPropertyValue, (String)"name");
            if (!actualName.equals(expected)) continue;
            return true;
        }
        return false;
    }
}

