/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.Arrays;
import java.util.List;
import javax.ejb.EJBException;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.plugin.PluginStatusType;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.resource.metadata.MetadataBeanTest;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class PluginManagerBeanTest
extends MetadataBeanTest {
    SubjectManagerLocal subjectMgr;
    PluginManagerLocal pluginMgr;

    @Test(groups={"plugin.metadata", "PluginManagerBean"})
    public void registerPlugins() throws Exception {
        this.subjectMgr = LookupUtil.getSubjectManager();
        this.pluginMgr = LookupUtil.getPluginManager();
        this.createPlugin("test-plugin1", "1.0", "plugin_1.xml");
        this.createPlugin("test-plugin2", "1.0", "plugin_2.xml");
        this.createPlugin("test-plugin3", "1.0", "plugin_3.xml");
    }

    @Test(groups={"plugin.metadata", "PluginManagerBean"}, dependsOnMethods={"registerPlugins"})
    public void disablePlugin() throws Exception {
        Plugin plugin = this.getPlugin("PluginManagerBeanTestPlugin3");
        this.pluginMgr.disablePlugins(this.subjectMgr.getOverlord(), Arrays.asList(plugin.getId()));
        plugin = this.pluginMgr.getPlugin("PluginManagerBeanTestPlugin3");
        PluginManagerBeanTest.assertFalse((String)"Failed to disable plugin", (boolean)plugin.isEnabled());
    }

    @Test(groups={"plugin.metadata", "PluginManagerBean"}, dependsOnMethods={"registerPlugins"})
    public void doNotDisablePluginIfDependentPluginsAreNotAlsoDisabled() throws Exception {
        Plugin plugin = this.getPlugin("PluginManagerBeanTestPlugin1");
        EJBException exception = null;
        try {
            this.pluginMgr.disablePlugins(this.subjectMgr.getOverlord(), Arrays.asList(plugin.getId()));
        }
        catch (EJBException e) {
            exception = e;
        }
        PluginManagerBeanTest.assertNotNull((String)"Expected exception to be thrown when trying to disable a plugin that has dependent plugins", (Object)((Object)exception));
        PluginManagerBeanTest.assertTrue((String)"Expected an IllegalArgumentException when trying to disable a plugin with dependent plugins", (boolean)(exception.getCausedByException() instanceof IllegalArgumentException));
    }

    @Test(groups={"plugin.metadata", "PluginManagerBean"}, dependsOnMethods={"doNotDisablePluginIfDependentPluginsAreNotAlsoDisabled"})
    public void disablePluginAndDependentPlugins() throws Exception {
        Plugin plugin1 = this.getPlugin("PluginManagerBeanTestPlugin1");
        Plugin plugin2 = this.getPlugin("PluginManagerBeanTestPlugin2");
        this.pluginMgr.disablePlugins(this.subjectMgr.getOverlord(), Arrays.asList(plugin1.getId(), plugin2.getId()));
        plugin1 = this.getPlugin("PluginManagerBeanTestPlugin1");
        plugin2 = this.getPlugin("PluginManagerBeanTestPlugin2");
        PluginManagerBeanTest.assertFalse((String)"Failed to disable plugin", (boolean)plugin1.isEnabled());
        PluginManagerBeanTest.assertFalse((String)"Failed to disable plugin", (boolean)plugin2.isEnabled());
    }

    @Test(groups={"plugin.metadata", "PluginManagerBean"}, dependsOnMethods={"disablePluginAndDependentPlugins"})
    public void enablePlugins() throws Exception {
        Plugin plugin1 = this.getPlugin("PluginManagerBeanTestPlugin1");
        Plugin plugin2 = this.getPlugin("PluginManagerBeanTestPlugin2");
        this.pluginMgr.enablePlugins(this.subjectMgr.getOverlord(), Arrays.asList(plugin1.getId(), plugin2.getId()));
        plugin1 = this.getPlugin("PluginManagerBeanTestPlugin1");
        plugin2 = this.getPlugin("PluginManagerBeanTestPlugin2");
        PluginManagerBeanTest.assertTrue((String)"Failed to enable plugin", (boolean)plugin1.isEnabled());
        PluginManagerBeanTest.assertTrue((String)"Failed to enable plugin", (boolean)plugin2.isEnabled());
    }

    @Test(groups={"plugin.metadata", "PluginManagerBean"}, dependsOnMethods={"enablePlugins"})
    public void doNotDeletePluginIfDependentPluginIsNotAlsoDeleted() throws Exception {
        Plugin plugin = this.getPlugin("PluginManagerBeanTestPlugin1");
        EJBException exception = null;
        try {
            this.pluginMgr.deletePlugins(this.subjectMgr.getOverlord(), Arrays.asList(plugin.getId()));
        }
        catch (EJBException e) {
            exception = e;
        }
        PluginManagerBeanTest.assertNotNull((String)"Expected exception to be thrown when trying to delete a plugin that has dependent plugins", (Object)((Object)exception));
        PluginManagerBeanTest.assertTrue((String)"Expected an IllegalArgumentException when trying to delete a plugin with dependent plugins", (boolean)(exception.getCausedByException() instanceof IllegalArgumentException));
    }

    @Test(groups={"plugin.metadata", "PluginManagerBean"}, dependsOnMethods={"doNotDeletePluginIfDependentPluginIsNotAlsoDeleted"})
    public void deletePlugins() throws Exception {
        Plugin plugin1 = this.getPlugin("PluginManagerBeanTestPlugin1");
        Plugin plugin2 = this.getPlugin("PluginManagerBeanTestPlugin2");
        this.pluginMgr.deletePlugins(this.subjectMgr.getOverlord(), Arrays.asList(plugin1.getId(), plugin2.getId()));
        plugin1 = this.getPlugin("PluginManagerBeanTestPlugin1", "Deleting a plugin should not remove it from the database");
        plugin2 = this.getPlugin("PluginManagerBeanTestPlugin2", "Deleting a plugin should not remove it from the database");
        PluginManagerBeanTest.assertTrue((String)"Expected plugin status to be set to DELETED", (plugin1.getStatus() == PluginStatusType.DELETED ? 1 : 0) != 0);
        PluginManagerBeanTest.assertTrue((String)"Expected plugin status to be set to DELETED", (plugin2.getStatus() == PluginStatusType.DELETED ? 1 : 0) != 0);
    }

    @Test(enabled=false, groups={"plugin.metadata", "PluginManagerBean"}, dependsOnMethods={"deletePlugins"})
    public void purgePlugins() throws Exception {
        Plugin plugin1 = this.getPlugin("PluginManagerBeanTestPlugin1", "Deleting a plugin should not remove it from the database");
        Plugin plugin2 = this.getPlugin("PluginManagerBeanTestPlugin2", "Deleting a plugin should not remove it from the database");
        this.pluginMgr.markPluginsForPurge(this.subjectMgr.getOverlord(), Arrays.asList(plugin1.getId(), plugin2.getId()));
        PluginManagerBeanTest.assertEquals((String)"Failed to purge plugins from the database", (int)1, (int)this.pluginMgr.getPlugins().size());
    }

    Plugin getPlugin(String name) {
        Plugin plugin = this.pluginMgr.getPlugin(name);
        PluginManagerBeanTest.assertNotNull((String)"Failed to find plugin <$name>", (Object)plugin);
        return plugin;
    }

    Plugin getPlugin(String name, String msg) {
        List plugins = PluginManagerBeanTest.getEntityManager().createQuery("from Plugin where name = :name").setParameter("name", (Object)name).getResultList();
        PluginManagerBeanTest.assertTrue((String)"Failed to find plugin <$name>: $msg", (plugins.size() == 1 ? 1 : 0) != 0);
        return (Plugin)plugins.get(0);
    }
}

