/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.WordUtils;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.bundle.Bundle;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.bundle.ResourceTypeBundleConfiguration;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.criteria.OperationDefinitionCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionTemplate;
import org.rhq.core.domain.drift.Filter;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.shared.ResourceBuilder;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.bundle.BundleManagerLocal;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.metadata.MetadataBeanTest;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class ResourceMetadataManagerBeanTest
extends MetadataBeanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"plugin.metadata", "NewPlugin"})
    public void testRemovalOfObsoleteBundleAndDriftConfig() throws Exception {
        Query qConfig;
        Query qTemplate;
        this.createPlugin("test-plugin.jar", "1.0", "remove_bundle_drift_config_v1.xml");
        ResourceType type1 = this.assertResourceTypeAssociationEquals("ServerWithBundleAndDriftConfig", "TestPlugin", "driftDefinitionTemplates", Arrays.asList("drift1"));
        String qTemplateString = "from DriftDefinitionTemplate where id = :id";
        String qConfigString = "from Configuration c where id = :id";
        DriftDefinitionTemplate driftTemplate = (DriftDefinitionTemplate)type1.getDriftDefinitionTemplates().iterator().next();
        Configuration bundleConfig = type1.getResourceTypeBundleConfiguration().getBundleConfiguration();
        Configuration driftDefConfig = driftTemplate.getConfiguration();
        this.getTransactionManager().begin();
        try {
            qTemplate = ResourceMetadataManagerBeanTest.getEntityManager().createQuery(qTemplateString).setParameter("id", (Object)driftTemplate.getId());
            qConfig = ResourceMetadataManagerBeanTest.getEntityManager().createQuery(qConfigString).setParameter("id", (Object)driftDefConfig.getId());
            ResourceMetadataManagerBeanTest.assertEquals((String)"drift template didn't get persisted", (int)1, (int)qTemplate.getResultList().size());
            ResourceMetadataManagerBeanTest.assertEquals((String)"drift template config didn't get persisted", (int)1, (int)qConfig.getResultList().size());
            qConfig.setParameter("id", (Object)bundleConfig.getId());
            ResourceMetadataManagerBeanTest.assertEquals((String)"bundle config didn't get persisted", (int)1, (int)qConfig.getResultList().size());
        }
        finally {
            this.getTransactionManager().commit();
        }
        ResourceMetadataManagerBeanTest.assertNotNull((Object)type1.getResourceTypeBundleConfiguration());
        ResourceMetadataManagerBeanTest.assertEquals((String)"destdir1", (String)((ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory)type1.getResourceTypeBundleConfiguration().getBundleDestinationBaseDirectories().iterator().next()).getName());
        this.createPlugin("test-plugin.jar", "2.0", "remove_bundle_drift_config_v2.xml");
        this.getTransactionManager().begin();
        try {
            qTemplate = ResourceMetadataManagerBeanTest.getEntityManager().createQuery(qTemplateString).setParameter("id", (Object)driftTemplate.getId());
            qConfig = ResourceMetadataManagerBeanTest.getEntityManager().createQuery(qConfigString).setParameter("id", (Object)driftDefConfig.getId());
            ResourceMetadataManagerBeanTest.assertEquals((String)"drift template didn't get purged", (int)0, (int)qTemplate.getResultList().size());
            ResourceMetadataManagerBeanTest.assertEquals((String)"drift template config didn't get purged", (int)0, (int)qConfig.getResultList().size());
            qConfig.setParameter("id", (Object)bundleConfig.getId());
            ResourceMetadataManagerBeanTest.assertEquals((String)"bundle config didn't get purged", (int)0, (int)qConfig.getResultList().size());
        }
        finally {
            this.getTransactionManager().commit();
        }
    }

    @Test(groups={"plugin.metadata", "NewPlugin"})
    public void registerPluginWithDuplicateDriftDefinitions() {
        try {
            this.createPlugin("test-plugin.jar", "1.0", "dup_drift.xml");
            ResourceMetadataManagerBeanTest.fail((String)"should not have succeeded - the drift definition had duplicate names");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(dependsOnMethods={"registerPluginWithDuplicateDriftDefinitions"}, groups={"plugin.metadata", "NewPlugin"})
    public void registerPlugin() throws Exception {
        this.createPlugin("test-plugin.jar", "1.0", "plugin_v1.xml");
    }

    @Test(dependsOnMethods={"registerPlugin"}, groups={"plugin.metadata", "NewPlugin"})
    public void persistNewTypes() {
        List<String> newTypes = Arrays.asList("ServerA", "ServerB");
        this.assertTypesPersisted("Failed to persist new types", newTypes, "TestPlugin");
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.metadata", "NewPlugin"})
    public void persistMeasurementDefinitions() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", "TestPlugin", "metricDefinitions", Arrays.asList("metric1", "metric2"));
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.metadata", "NewPlugin"})
    public void persistEventDefinitions() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", "TestPlugin", "eventDefinitions", Arrays.asList("logAEntry", "logBEntry"));
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.metadata", "NewPlugin"})
    public void persistOperationDefinitions() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", "TestPlugin", "operationDefinitions", Arrays.asList("start", "stop"));
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.metadata", "NewPlugin"})
    public void persistProcessScans() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", "TestPlugin", "processScans", Arrays.asList("serverA"));
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.metadata", "NewPlugin"})
    public void persistDriftDefinitionTemplates() throws Exception {
        ResourceType type = this.assertResourceTypeAssociationEquals("ServerA", "TestPlugin", "driftDefinitionTemplates", Arrays.asList("drift-pc", "drift-fs"));
        DriftDefinition driftDef = null;
        Set drifts = type.getDriftDefinitionTemplates();
        for (DriftDefinitionTemplate drift : drifts) {
            if (drift.getName().equals("drift-pc")) {
                driftDef = new DriftDefinition(drift.getConfiguration());
                ResourceMetadataManagerBeanTest.assertTrue((boolean)driftDef.isEnabled());
                ResourceMetadataManagerBeanTest.assertEquals((Object)DriftConfigurationDefinition.BaseDirValueContext.pluginConfiguration, (Object)driftDef.getBasedir().getValueContext());
                ResourceMetadataManagerBeanTest.assertEquals((String)"connectionPropertyX", (String)driftDef.getBasedir().getValueName());
                ResourceMetadataManagerBeanTest.assertEquals((long)123456L, (long)driftDef.getInterval());
                ResourceMetadataManagerBeanTest.assertEquals((int)1, (int)driftDef.getIncludes().size());
                ResourceMetadataManagerBeanTest.assertEquals((int)2, (int)driftDef.getExcludes().size());
                Filter filter = (Filter)driftDef.getIncludes().get(0);
                ResourceMetadataManagerBeanTest.assertEquals((String)"foo/bar", (String)filter.getPath());
                ResourceMetadataManagerBeanTest.assertEquals((String)"**/*.blech", (String)filter.getPattern());
                filter = (Filter)driftDef.getExcludes().get(0);
                ResourceMetadataManagerBeanTest.assertEquals((String)"/wot/gorilla", (String)filter.getPath());
                ResourceMetadataManagerBeanTest.assertEquals((String)"*.xml", (String)filter.getPattern());
                filter = (Filter)driftDef.getExcludes().get(1);
                ResourceMetadataManagerBeanTest.assertEquals((String)"/hello", (String)filter.getPath());
                ResourceMetadataManagerBeanTest.assertEquals((String)"", (String)filter.getPattern());
                continue;
            }
            if (drift.getName().equals("drift-fs")) {
                driftDef = new DriftDefinition(drift.getConfiguration());
                ResourceMetadataManagerBeanTest.assertTrue((boolean)driftDef.isEnabled());
                ResourceMetadataManagerBeanTest.assertEquals((Object)DriftConfigurationDefinition.BaseDirValueContext.fileSystem, (Object)driftDef.getBasedir().getValueContext());
                ResourceMetadataManagerBeanTest.assertEquals((String)"/", (String)driftDef.getBasedir().getValueName());
                ResourceMetadataManagerBeanTest.assertEquals((long)1800L, (long)driftDef.getInterval());
                ResourceMetadataManagerBeanTest.assertEquals((int)0, (int)driftDef.getIncludes().size());
                ResourceMetadataManagerBeanTest.assertEquals((int)0, (int)driftDef.getExcludes().size());
                continue;
            }
            ResourceMetadataManagerBeanTest.fail((String)("got an unexpected drift definition: " + driftDef));
        }
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.metadata", "NewPlugin"})
    public void persistBundleTargetConfigurations() throws Exception {
        String resourceTypeName = "ServerA";
        String plugin = "TestPlugin";
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.addFilterName(resourceTypeName);
        criteria.addFilterPluginName(plugin);
        criteria.fetchBundleConfiguration(true);
        PageList resourceTypes = resourceTypeMgr.findResourceTypesByCriteria(subjectMgr.getOverlord(), criteria);
        ResourceType resourceType = (ResourceType)resourceTypes.get(0);
        ResourceTypeBundleConfiguration rtbc = resourceType.getResourceTypeBundleConfiguration();
        ResourceMetadataManagerBeanTest.assertNotNull((String)"missing bundle configuration", (Object)rtbc);
        Set dirs = rtbc.getBundleDestinationBaseDirectories();
        ResourceMetadataManagerBeanTest.assertEquals((String)"Should have persisted 2 bundle dest dirs", (int)2, (int)dirs.size());
        for (ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory dir : dirs) {
            if (dir.getName().equals("bundleTarget-pc")) {
                ResourceMetadataManagerBeanTest.assertEquals((Object)ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.pluginConfiguration, (Object)dir.getValueContext());
                ResourceMetadataManagerBeanTest.assertEquals((String)"connectionPropertyY", (String)dir.getValueName());
                ResourceMetadataManagerBeanTest.assertEquals((String)"pc-description", (String)dir.getDescription());
                continue;
            }
            if (dir.getName().equals("bundleTarget-fs")) {
                ResourceMetadataManagerBeanTest.assertEquals((Object)ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.fileSystem, (Object)dir.getValueContext());
                ResourceMetadataManagerBeanTest.assertEquals((String)"/wot/gorilla", (String)dir.getValueName());
                ResourceMetadataManagerBeanTest.assertNull((Object)dir.getDescription());
                continue;
            }
            ResourceMetadataManagerBeanTest.fail((String)("got an unexpected bundle target dest dir: " + dir));
        }
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.metadata", "NewPlugin"})
    public void persistChildTypes() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", "TestPlugin", "childResourceTypes", Arrays.asList("Child1", "Child2"));
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.metadata", "NewPlugin"})
    public void persistPluginConfigurationDefinition() throws Exception {
        this.assertAssociationExists("ServerA", "pluginConfigurationDefinition");
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.metadata", "NewPlugin"})
    public void persistPackageTypes() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", "TestPlugin", "packageTypes", Arrays.asList("ServerA.Content.1", "ServerA.Content.2"));
    }

    @Test(groups={"plugin.metadata", "UpgradePlugin"}, dependsOnGroups={"NewPlugin"})
    public void upgradePlugin() throws Exception {
        this.createPlugin("test-plugin.jar", "2.0", "plugin_v2.xml");
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.metadata", "UpgradePlugin"})
    public void upgradeOperationDefinitions() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", "TestPlugin", "operationDefinitions", Arrays.asList("start", "shutdown", "restart"));
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.metadata", "UpgradePlugin"})
    public void upgradeChildResources() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", "TestPlugin", "childResourceTypes", Arrays.asList("Child1", "Child3"));
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.metadata", "UpgradePlugin"})
    public void upgradeParentTypeOfChild() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerB", "TestPlugin", "childResourceTypes", Arrays.asList("Child2"));
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.metadata", "UpgradePlugin"})
    public void upgradeEventDefinitions() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", "TestPlugin", "eventDefinitions", Arrays.asList("logAEntry", "logCEntry"));
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.metadata", "UpgradePlugin"})
    public void upgradeProcessScans() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", "TestPlugin", "processScans", Arrays.asList("processA", "processB"));
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.metadata", "UpgradePlugin"})
    public void upgradeDriftDefinitionTemplates() throws Exception {
        ResourceType type = this.assertResourceTypeAssociationEquals("ServerA", "TestPlugin", "driftDefinitionTemplates", Arrays.asList("drift-rc", "drift-mt"));
        DriftDefinition driftDef = null;
        Set drifts = type.getDriftDefinitionTemplates();
        for (DriftDefinitionTemplate drift : drifts) {
            if (drift.getName().equals("drift-rc")) {
                driftDef = new DriftDefinition(drift.getConfiguration());
                ResourceMetadataManagerBeanTest.assertTrue((boolean)driftDef.isEnabled());
                ResourceMetadataManagerBeanTest.assertEquals((Object)DriftConfigurationDefinition.BaseDirValueContext.resourceConfiguration, (Object)driftDef.getBasedir().getValueContext());
                ResourceMetadataManagerBeanTest.assertEquals((String)"resourceConfig1", (String)driftDef.getBasedir().getValueName());
                ResourceMetadataManagerBeanTest.assertEquals((long)1800L, (long)driftDef.getInterval());
                ResourceMetadataManagerBeanTest.assertEquals((int)0, (int)driftDef.getIncludes().size());
                ResourceMetadataManagerBeanTest.assertEquals((int)0, (int)driftDef.getExcludes().size());
                continue;
            }
            if (drift.getName().equals("drift-mt")) {
                driftDef = new DriftDefinition(drift.getConfiguration());
                ResourceMetadataManagerBeanTest.assertTrue((boolean)driftDef.isEnabled());
                ResourceMetadataManagerBeanTest.assertEquals((Object)DriftConfigurationDefinition.BaseDirValueContext.measurementTrait, (Object)driftDef.getBasedir().getValueContext());
                ResourceMetadataManagerBeanTest.assertEquals((String)"trait1", (String)driftDef.getBasedir().getValueName());
                ResourceMetadataManagerBeanTest.assertEquals((long)1800L, (long)driftDef.getInterval());
                ResourceMetadataManagerBeanTest.assertEquals((int)0, (int)driftDef.getIncludes().size());
                ResourceMetadataManagerBeanTest.assertEquals((int)0, (int)driftDef.getExcludes().size());
                continue;
            }
            ResourceMetadataManagerBeanTest.fail((String)("got an unexpected drift definition: " + driftDef));
        }
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.metadata", "UpgradePlugin"})
    public void upgradeBundleTargetConfigurations() throws Exception {
        String resourceTypeName = "ServerA";
        String plugin = "TestPlugin";
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.addFilterName(resourceTypeName);
        criteria.addFilterPluginName(plugin);
        criteria.fetchBundleConfiguration(true);
        PageList resourceTypes = resourceTypeMgr.findResourceTypesByCriteria(subjectMgr.getOverlord(), criteria);
        ResourceType resourceType = (ResourceType)resourceTypes.get(0);
        ResourceTypeBundleConfiguration rtbc = resourceType.getResourceTypeBundleConfiguration();
        ResourceMetadataManagerBeanTest.assertNotNull((String)"missing bundle configuration", (Object)rtbc);
        Set dirs = rtbc.getBundleDestinationBaseDirectories();
        ResourceMetadataManagerBeanTest.assertEquals((String)"Should have persisted 2 bundle dest dirs", (int)2, (int)dirs.size());
        for (ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory dir : dirs) {
            if (dir.getName().equals("bundleTarget-rc")) {
                ResourceMetadataManagerBeanTest.assertEquals((Object)ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.resourceConfiguration, (Object)dir.getValueContext());
                ResourceMetadataManagerBeanTest.assertEquals((String)"resourceConfig1", (String)dir.getValueName());
                ResourceMetadataManagerBeanTest.assertEquals((String)"rc-description", (String)dir.getDescription());
                continue;
            }
            if (dir.getName().equals("bundleTarget-mt")) {
                ResourceMetadataManagerBeanTest.assertEquals((Object)ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.measurementTrait, (Object)dir.getValueContext());
                ResourceMetadataManagerBeanTest.assertEquals((String)"trait1", (String)dir.getValueName());
                ResourceMetadataManagerBeanTest.assertEquals((String)"mt-description", (String)dir.getDescription());
                continue;
            }
            ResourceMetadataManagerBeanTest.assertTrue((String)("got an unexpected bundle target dest dir: " + dir), (boolean)false);
        }
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.metadata", "UpgradePlugin"})
    public void upgradePackageTypes() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", "TestPlugin", "packageTypes", Arrays.asList("ServerA.Content.1", "ServerA.Content.3"));
    }

    @Test(groups={"RemoveTypes"}, dependsOnGroups={"UpgradePlugin"})
    public void upgradePluginWithTypesRemoved() throws Exception {
        this.createPlugin("remove-types-plugin", "1.0", "remove_types_v1.xml");
        this.createResources(3, "RemoveTypesPlugin", "ServerC");
        this.createBundle("test-bundle-1", "Test Bundle", "ServerC", "RemoveTypesPlugin");
        this.createPackage("ServerC::test-package", "ServerC", "RemoveTypesPlugin");
        this.createResourceGroup("ServerC Group", "ServerC", "RemoveTypesPlugin");
        this.createAlertTemplate("ServerC Alert Template", "ServerC", "RemoveTypesPlugin");
        this.createPlugin("remove-types-plugin", "2.0", "remove_types_v2.xml");
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.metadata", "RemoveTypes"})
    public void deleteOperationDefsForRemovedType() throws Exception {
        OperationManagerLocal operationMgr = LookupUtil.getOperationManager();
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        OperationDefinitionCriteria criteria = new OperationDefinitionCriteria();
        criteria.addFilterResourceTypeName("ServerC");
        criteria.addFilterName("run");
        List operationDefs = operationMgr.findOperationDefinitionsByCriteria(subjectMgr.getOverlord(), criteria);
        ResourceMetadataManagerBeanTest.assertEquals((String)"The operation definition should have been deleted", (int)0, (int)operationDefs.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.metadata", "RemoveTypes"})
    public void deleteEventDefsForRemovedType() throws Exception {
        List results = ResourceMetadataManagerBeanTest.getEntityManager().createQuery("from EventDefinition e where e.name = :ename and e.resourceType.name = :rname").setParameter("ename", (Object)"serverCEvent").setParameter("rname", (Object)"ServerC").getResultList();
        ResourceMetadataManagerBeanTest.assertEquals((String)"The event definition(s) should have been deleted", (int)0, (int)results.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.metadata", "RemoveTypes"})
    public void deleteParent() throws Exception {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.addFilterName("ServerD.GrandChild1");
        criteria.addFilterPluginName("RemoveTypesPlugin");
        criteria.fetchParentResourceTypes(true);
        PageList types = resourceTypeMgr.findResourceTypesByCriteria(subjectMgr.getOverlord(), criteria);
        ResourceMetadataManagerBeanTest.assertEquals((String)"Expected to get back one resource type", (int)1, (int)types.size());
        ResourceType type = (ResourceType)types.get(0);
        ResourceMetadataManagerBeanTest.assertEquals((String)"Expected to find one parent type", (int)1, (int)type.getParentResourceTypes().size());
        ResourceType parentType = this.findByName(type.getParentResourceTypes(), "ServerD");
        ResourceMetadataManagerBeanTest.assertNotNull((String)("Expected to find 'ServerD' as the parent, but found, " + type.getParentResourceTypes()), (Object)parentType);
    }

    private ResourceType findByName(Collection<ResourceType> types, String name) {
        for (ResourceType type : types) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.metadata", "RemoveTypes"})
    public void deleteTypeAndAllItsDescedantTypes() throws Exception {
        List typesNotRemoved = ResourceMetadataManagerBeanTest.getEntityManager().createQuery("from ResourceType t where t.plugin = :plugin and t.name in (:resourceTypes)").setParameter("plugin", (Object)"RemoveTypesPlugin").setParameter("resourceTypes", Arrays.asList("ServerE", "ServerE1", "ServerE2", "ServerE3", "ServerE4")).getResultList();
        ResourceMetadataManagerBeanTest.assertEquals((String)"Failed to delete resource type or one or more of its descendant types", (int)0, (int)typesNotRemoved.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.metadata", "RemoveTypes"})
    public void deleteProcessScans() {
        List processScans = ResourceMetadataManagerBeanTest.getEntityManager().createQuery("from ProcessScan p where p.name = :name1 or p.name = :name2").setParameter("name1", (Object)"scan1").setParameter("name2", (Object)"scan2").getResultList();
        ResourceMetadataManagerBeanTest.assertEquals((String)"The process scans should have been deleted", (int)0, (int)processScans.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.metadata", "RemoveTypes"})
    public void deleteSubcategories() {
        List subcategories = ResourceMetadataManagerBeanTest.getEntityManager().createQuery("from ResourceSubCategory r where r.name = :name1 or r.name = :name2 or r.name = :name3").setParameter("name1", (Object)"ServerC.Category1").setParameter("name2", (Object)"ServerC.Category2").setParameter("name3", (Object)"ServerC.NestedCategory1").getResultList();
        ResourceMetadataManagerBeanTest.assertEquals((String)"The subcategories should have been deleted", (int)0, (int)subcategories.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.metadata", "RemoveTypes"})
    public void deleteResources() {
        ResourceManagerLocal resourceMgr = LookupUtil.getResourceManager();
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterResourceTypeName("ServerC");
        criteria.addFilterPluginName("RemoveTypesPlugin");
        PageList resources = resourceMgr.findResourcesByCriteria(subjectMgr.getOverlord(), criteria);
        ResourceMetadataManagerBeanTest.assertTrue((String)"Did not expect to find any more that three resources. Database might need to be reset", (resources.size() < 4 ? 1 : 0) != 0);
        for (Resource resource : resources) {
            ResourceMetadataManagerBeanTest.assertEquals((Object)"The resource should have been marked for deletion", (Object)(InventoryStatus.UNINVENTORIED == resource.getInventoryStatus() ? 1 : 0));
        }
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.metadata", "RemoveTypes"})
    public void deleteBundles() {
        List bundles = ResourceMetadataManagerBeanTest.getEntityManager().createQuery("from Bundle b where b.bundleType.name = :name").setParameter("name", (Object)"Test Bundle").getResultList();
        ResourceMetadataManagerBeanTest.assertEquals((String)"Failed to delete the bundles", (int)0, (int)bundles.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.metadata", "RemoveTypes"})
    public void deleteBundleTypes() {
        List bundleTypes = ResourceMetadataManagerBeanTest.getEntityManager().createQuery("from BundleType b where b.name = :name").setParameter("name", (Object)"Test Bundle").getResultList();
        ResourceMetadataManagerBeanTest.assertEquals((String)"The bundle type should have been deleted", (int)0, (int)bundleTypes.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.metadata", "RemoveTypes"})
    public void deletePackages() {
        List packages = ResourceMetadataManagerBeanTest.getEntityManager().createQuery("from Package p where p.name = :name").setParameter("name", (Object)"ServerC::test-package").getResultList();
        ResourceMetadataManagerBeanTest.assertEquals((String)"All packages should have been deleted", (int)0, (int)packages.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.metadata", "RemoveTypes"})
    public void deletePackageTypes() {
        List packageTypes = ResourceMetadataManagerBeanTest.getEntityManager().createQuery("from PackageType p where p.name = :name").setParameter("name", (Object)"ServerC.Content").getResultList();
        ResourceMetadataManagerBeanTest.assertEquals((String)"All package types should have been deleted", (int)0, (int)packageTypes.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.metadata", "RemoveTypes"})
    public void deleteResourceGroups() {
        List groups = ResourceMetadataManagerBeanTest.getEntityManager().createQuery("from ResourceGroup g where g.name = :name and g.resourceType.name = :typeName").setParameter("name", (Object)"ServerC Group").setParameter("typeName", (Object)"ServerC").getResultList();
        ResourceMetadataManagerBeanTest.assertEquals((String)"All resource groups should have been deleted", (int)0, (int)groups.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.metadata", "RemoveTypes"})
    public void deleteAlertTemplates() {
        List templates = ResourceMetadataManagerBeanTest.getEntityManager().createQuery("from AlertDefinition a where a.name = :name and a.resourceType.name = :typeName").setParameter("name", (Object)"ServerC Alert Template").setParameter("typeName", (Object)"ServerC").getResultList();
        ResourceMetadataManagerBeanTest.assertEquals((String)"Alert templates should have been deleted.", (int)0, (int)templates.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.metadata", "RemoveTypes"})
    public void deleteMeasurementDefinitions() {
        List measurementDefs = ResourceMetadataManagerBeanTest.getEntityManager().createQuery("from MeasurementDefinition m where m.name = :name").setParameter("name", (Object)"ServerC::metric1").getResultList();
        ResourceMetadataManagerBeanTest.assertEquals((String)"Measurement definitions should have been deleted", (int)0, (int)measurementDefs.size());
    }

    void assertTypesPersisted(String msg, List<String> types, String plugin) {
        ArrayList<String> typesNotFound = new ArrayList<String>();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        for (String type : types) {
            if (resourceTypeMgr.getResourceTypeByNameAndPlugin(type, plugin) != null) continue;
            typesNotFound.add(type);
        }
        if (!typesNotFound.isEmpty()) {
            ResourceMetadataManagerBeanTest.fail((String)(msg + ": The following types were not found: " + typesNotFound));
        }
    }

    void assertAssociationExists(String resourceTypeName, String propertyName) throws Exception {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        String fetch = "fetch" + WordUtils.capitalize((String)propertyName);
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.addFilterName(resourceTypeName);
        criteria.addFilterPluginName("TestPlugin");
        MethodUtils.invokeMethod((Object)criteria, (String)fetch, (Object)true);
        PageList resourceTypes = resourceTypeMgr.findResourceTypesByCriteria(subjectMgr.getOverlord(), criteria);
        ResourceType resourceType = (ResourceType)resourceTypes.get(0);
        Object property = PropertyUtils.getProperty((Object)resourceType, (String)propertyName);
        ResourceMetadataManagerBeanTest.assertNotNull((String)"Failed to find $propertyName for type '$resourceTypeName'", (Object)property);
    }

    void createResources(int count, String pluginName, String resourceTypeName) throws Exception {
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        ResourceType resourceType = resourceTypeMgr.getResourceTypeByNameAndPlugin(resourceTypeName, pluginName);
        ResourceMetadataManagerBeanTest.assertNotNull((String)("Cannot create resources. Unable to find resource type for [name: " + resourceTypeName + ", plugin: " + pluginName + "]"), (Object)resourceType);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (int i = 0; i < count; ++i) {
            resources.add(new ResourceBuilder().createServer().withResourceType(resourceType).withName(resourceType.getName() + "--" + i).withUuid(resourceType.getName()).withRandomResourceKey(resourceType.getName() + "--" + i).build());
        }
        this.getTransactionManager().begin();
        for (Resource resource : resources) {
            ResourceMetadataManagerBeanTest.getEntityManager().persist((Object)resource);
        }
        this.getTransactionManager().commit();
    }

    void createBundle(String bundleName, String bundleTypeName, String resourceTypeName, String pluginName) throws Exception {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        BundleManagerLocal bundleMgr = LookupUtil.getBundleManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        ResourceType resourceType = resourceTypeMgr.getResourceTypeByNameAndPlugin(resourceTypeName, pluginName);
        ResourceMetadataManagerBeanTest.assertNotNull((String)("Cannot create bundle. Unable to find resource type for [name: " + resourceTypeName + ", plugin: " + pluginName + "]"), (Object)resourceType);
        BundleType bundleType = bundleMgr.getBundleType(subjectMgr.getOverlord(), bundleTypeName);
        ResourceMetadataManagerBeanTest.assertNotNull((String)("Cannot create bundle. Unable to find bundle type for [name: " + bundleTypeName + "]"), (Object)bundleType);
        Bundle bundle = bundleMgr.createBundle(subjectMgr.getOverlord(), bundleName, "test bundle: " + bundleName, bundleType.getId());
        ResourceMetadataManagerBeanTest.assertNotNull((String)("Failed create bundle for [name: " + bundleName + "]"), (Object)bundle);
    }

    void createPackage(String packageName, String resourceTypeName, String pluginName) throws Exception {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ContentManagerLocal contentMgr = LookupUtil.getContentManager();
        List packageTypes = contentMgr.findPackageTypes(subjectMgr.getOverlord(), resourceTypeName, pluginName);
        Package pkg = new Package(packageName, (PackageType)packageTypes.get(0));
        contentMgr.persistPackage(pkg);
    }

    void createResourceGroup(String groupName, String resourceTypeName, String pluginName) throws Exception {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        ResourceGroupManagerLocal resourceGroupMgr = LookupUtil.getResourceGroupManager();
        ResourceType resourceType = resourceTypeMgr.getResourceTypeByNameAndPlugin(resourceTypeName, pluginName);
        ResourceMetadataManagerBeanTest.assertNotNull((String)("Cannot create resource group. Unable to find resource type for [name: " + resourceTypeName + ", plugin: " + pluginName + "]"), (Object)resourceType);
        ResourceGroup resourceGroup = new ResourceGroup(groupName, resourceType);
        resourceGroupMgr.createResourceGroup(subjectMgr.getOverlord(), resourceGroup);
    }

    void createAlertTemplate(String name, String resourceTypeName, String pluginName) throws Exception {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        AlertTemplateManagerLocal alertTemplateMgr = LookupUtil.getAlertTemplateManager();
        ResourceType resourceType = resourceTypeMgr.getResourceTypeByNameAndPlugin(resourceTypeName, pluginName);
        ResourceMetadataManagerBeanTest.assertNotNull((String)("Cannot create alert template. Unable to find resource type for [name: " + resourceTypeName + ", plugin: " + pluginName + "]"), (Object)resourceType);
        AlertDefinition alertDef = new AlertDefinition();
        alertDef.setName(name);
        alertDef.setPriority(AlertPriority.MEDIUM);
        alertDef.setResourceType(resourceType);
        alertDef.setConditionExpression(BooleanExpression.ALL);
        alertDef.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDef.setRecoveryId(Integer.valueOf(0));
        alertTemplateMgr.createAlertTemplate(subjectMgr.getOverlord(), alertDef, Integer.valueOf(resourceType.getId()));
    }
}

