/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata.test;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.persistence.EntityManager;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionEnumeration;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertyGroupDefinition;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.configuration.definition.constraint.Constraint;
import org.rhq.core.domain.configuration.definition.constraint.FloatRangeConstraint;
import org.rhq.core.domain.configuration.definition.constraint.IntegerRangeConstraint;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.resource.metadata.test.UpdatePluginMetadataTestBase;
import org.testng.annotations.Test;

public class UpdateConfigurationSubsystemTest
extends UpdatePluginMetadataTestBase {
    private static final boolean ENABLED = true;

    @Override
    protected String getSubsystemDirectory() {
        return "configuration";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testUpdatePluginConfig() throws Exception {
        try {
            this.registerPlugin("update5-v1_0.xml", null);
            ResourceType platform1 = this.getResourceType("myPlatform5");
            this.getTransactionManager().begin();
            EntityManager em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform1 = (ResourceType)em.find(ResourceType.class, (Object)platform1.getId());
            Set servers = platform1.getChildResourceTypes();
            assert (servers.size() == 1) : "Expected to find 1 server in v1, but got " + servers.size();
            ResourceType server1 = (ResourceType)servers.iterator().next();
            ConfigurationDefinition cDef = server1.getPluginConfigurationDefinition();
            assert (cDef != null) : "Expected to find a PluginConfigurationDefinition in v1";
            List groups1 = cDef.getGroupDefinitions();
            assert (groups1.size() == 3) : "Expected to find 3 groups in v1, but got " + groups1.size();
            int found = 0;
            for (PropertyGroupDefinition pgd : groups1) {
                if (this.containedIn(pgd.getName(), new String[]{"connection", "tuning", "control"})) {
                    ++found;
                }
                if (!pgd.getName().equals("tuning")) continue;
                List pdl = cDef.getPropertiesInGroup("tuning");
                for (PropertyDefinition pd : pdl) {
                    if (!pd.getName().equals("rampDownTime")) continue;
                    assert (!pd.isRequired()) : "rampDownTime is not required in 'tuning' in v1";
                    assert (pd.isReadOnly()) : "rampDownTime should be r/o in v1";
                    assert (!pd.isSummary()) : "rampDownTime should not be summary in v1";
                }
            }
            assert (found == 3) : "Expected to find 3 specially named control groups in v1, but only found " + found;
            this.getTransactionManager().rollback();
            System.out.println("-------- done with v1");
            this.registerPlugin("update5-v2_0.xml", null);
            ResourceType platform2 = this.getResourceType("myPlatform5");
            this.getTransactionManager().begin();
            em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform2 = (ResourceType)em.find(ResourceType.class, (Object)platform2.getId());
            Set servers2 = platform2.getChildResourceTypes();
            assert (servers2.size() == 1) : "Expected to find 1 server in v2, but got " + servers2.size();
            ResourceType server2 = (ResourceType)servers2.iterator().next();
            ConfigurationDefinition cDef2 = server2.getPluginConfigurationDefinition();
            assert (cDef2 != null) : "Expected to find a PluginConfigurationDefinition in v2";
            List groups2 = cDef2.getGroupDefinitions();
            assert (groups2.size() == 3) : "Expected to find 3 groups in v2, but got " + groups2.size();
            found = 0;
            for (PropertyGroupDefinition pgd : groups2) {
                List pdl;
                if (pgd.getName().equals("fun")) {
                    ++found;
                    pdl = cDef2.getPropertiesInGroup("fun");
                    assert (pdl.size() == 1) : "Expected to find 1 property for group 'fun' in v2, but got " + pdl.size();
                    PropertyDefinition pd = (PropertyDefinition)pdl.get(0);
                    assert (pd.getName().equals("funRampUpTime")) : "Expected to find the property 'rampUpTime', but got " + pd.getName();
                    continue;
                }
                if (pgd.getName().equals("tuning")) {
                    ++found;
                    pdl = cDef2.getPropertiesInGroup("tuning");
                    assert (pdl.size() == 3) : "Expected 3 properties in group 'tuning' in v2, but got " + pdl.size();
                    for (PropertyDefinition pd : pdl) {
                        if (!pd.getName().equals("rampDownTime")) continue;
                        assert (pd.isRequired()) : "rampDownTime is now required in 'tuning' in v2";
                        assert (!pd.isReadOnly()) : "rampDownTime should be r/w in v2";
                        assert (pd.isSummary()) : "rampDownTime should  be summary in v2";
                    }
                    continue;
                }
                if (pgd.getName().equals("control")) {
                    ++found;
                    continue;
                }
                System.out.println("Unknown definition in v2: " + pgd.getName());
            }
            assert (found == 3) : "Expected to find 3 specially named control groups in v2, but only found " + found;
            this.getTransactionManager().rollback();
            System.out.println("-------- done with v2");
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testAddDeleteDefaultTemplate");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false)
    public void testBZ_573034() throws Exception {
        try {
            String version1 = "1.0";
            String version2 = "2.0";
            this.registerPlugin("BZ_573034_v1.xml", version1);
            ResourceType testServerResourceType = this.getResourceType("TestServer");
            this.getTransactionManager().begin();
            EntityManager em = UpdateConfigurationSubsystemTest.getEntityManager();
            testServerResourceType = (ResourceType)em.find(ResourceType.class, (Object)testServerResourceType.getId());
            ConfigurationDefinition pluginConfigurationDef = testServerResourceType.getPluginConfigurationDefinition();
            PropertyDefinitionSimple testPropertyDef = pluginConfigurationDef.getPropertyDefinitionSimple("testProperty");
            Configuration pluginConfiguration = null;
            int pluginConfigurationId = 0;
            try {
                UpdateConfigurationSubsystemTest.assertNotNull((String)"Expected plugin configuration definition to have a property definition for 'testProperty'", (Object)testPropertyDef);
                String resourceKey = testServerResourceType.getName() + System.currentTimeMillis();
                Resource testResource = new Resource(resourceKey, resourceKey, testServerResourceType);
                testResource.setUuid("" + new Random().nextInt());
                em.persist((Object)testResource);
                em.flush();
                this.setUpAgent(em, testResource);
                testResource = (Resource)em.find(Resource.class, (Object)testResource.getId());
                pluginConfigurationId = testResource.getPluginConfiguration().getId();
                pluginConfiguration = (Configuration)em.find(Configuration.class, (Object)pluginConfigurationId);
                PropertySimple testProperty = pluginConfiguration.getSimple("testProperty");
                UpdateConfigurationSubsystemTest.assertNull((String)"Did not expect to find a value for 'testProperty' since a value has not been supplied for it yet", (Object)testProperty);
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                this.getTransactionManager().rollback();
                UpdateConfigurationSubsystemTest.fail((String)("testBZ_573034:" + e));
            }
            this.registerPlugin("BZ_573034_v2.xml", version2);
            testServerResourceType = this.getResourceType("TestServer");
            this.getTransactionManager().begin();
            em = UpdateConfigurationSubsystemTest.getEntityManager();
            testServerResourceType = (ResourceType)em.find(ResourceType.class, (Object)testServerResourceType.getId());
            pluginConfigurationDef = testServerResourceType.getPluginConfigurationDefinition();
            PropertyDefinitionSimple testPropertyWithDefaultDef = pluginConfigurationDef.getPropertyDefinitionSimple("testPropertyWithDefault");
            UpdateConfigurationSubsystemTest.assertNotNull((String)"Expected updated plugin configuration definition to define the property 'testPropertyWithDefault'", (Object)testPropertyWithDefaultDef);
            pluginConfiguration = (Configuration)em.find(Configuration.class, (Object)pluginConfigurationId);
            PropertySimple testPropertyWithDefault = pluginConfiguration.getSimple("testPropertyWithDefault");
            UpdateConfigurationSubsystemTest.assertNotNull((String)"Expected to find the property 'testPropertyWithDefault' in the updated plugin configuration", (Object)testPropertyWithDefault);
            UpdateConfigurationSubsystemTest.assertEquals((String)"Expected default value to be set", (String)"default", (String)testPropertyWithDefault.getStringValue());
            this.getTransactionManager().rollback();
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testResourceConfiguration");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testResourceConfiguration() throws Exception {
        try {
            this.registerPlugin("update5-v1_0.xml", "1");
            ResourceType platform1 = this.getResourceType("myPlatform5");
            this.getTransactionManager().begin();
            EntityManager em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform1 = (ResourceType)em.find(ResourceType.class, (Object)platform1.getId());
            Set servers = platform1.getChildResourceTypes();
            assert (servers.size() == 1) : "Expected to find 1 server in v1, but got " + servers.size();
            ResourceType server1 = (ResourceType)servers.iterator().next();
            ConfigurationDefinition def1 = server1.getResourceConfigurationDefinition();
            List cpdl = def1.getNonGroupedProperties();
            assert (cpdl.size() == 3) : "Did not find 3 properties in <resource-configuration> in v1 but " + cpdl.size();
            for (PropertyDefinition pd : cpdl) {
                PropertyDefinitionSimple pds;
                if (pd.getName().equals("jnpPort")) {
                    assert (pd instanceof PropertyDefinitionSimple) : "jnpPort is no simple-property in v1";
                    pds = (PropertyDefinitionSimple)pd;
                    List pdel = pds.getEnumeratedValues();
                    assert (pdel.size() == 3) : "jnpPort did not have 3 options in v1, but " + pdel.size();
                    int found = 0;
                    for (PropertyDefinitionEnumeration pde : pdel) {
                        if (!this.containedIn(pde.getName(), new String[]{"option1", "option2", "option3"})) continue;
                        ++found;
                    }
                    assert (found == 3) : "Did not find the three expected options in v1";
                    continue;
                }
                if (!pd.getName().equals("secureJnpPort")) continue;
                assert (pd instanceof PropertyDefinitionSimple) : "secureJnpPort is no simple-property in v1";
                pds = (PropertyDefinitionSimple)pd;
                assert (pds.getType() == PropertySimpleType.INTEGER) : "Type of secureJnpPort is not integer in v1";
                Set constraints = pds.getConstraints();
                assert (constraints.size() == 4) : "Did not find 4 constraints for secureJnpPort in v1, but " + constraints.size();
            }
            this.getTransactionManager().rollback();
            this.registerPlugin("update5-v2_0.xml", "2");
            ResourceType platform2 = this.getResourceType("myPlatform5");
            this.getTransactionManager().begin();
            em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform2 = (ResourceType)em.find(ResourceType.class, (Object)platform2.getId());
            Set servers2 = platform2.getChildResourceTypes();
            assert (servers2.size() == 1) : "Expected to find 1 server in v2, but got " + servers2.size();
            ResourceType server2 = (ResourceType)servers2.iterator().next();
            ConfigurationDefinition def2 = server2.getResourceConfigurationDefinition();
            def2 = (ConfigurationDefinition)UpdateConfigurationSubsystemTest.getEntityManager().find(ConfigurationDefinition.class, (Object)def2.getId());
            List cpdl2 = def2.getNonGroupedProperties();
            assert (cpdl2.size() == 3) : "Did not find 3 properties in <resource-configuration> in v2 but " + cpdl2.size();
            int found = 0;
            for (PropertyDefinition pd : cpdl2) {
                if (!this.containedIn(pd.getName(), new String[]{"jnpPort", "secureJnpPort", "memorySize"})) continue;
                ++found;
            }
            assert (found == 3) : "Did not find the 3 specific properties in v2";
            for (PropertyDefinition pd : cpdl2) {
                PropertyDefinitionSimple pds;
                if (pd.getName().equals("jnpPort")) {
                    if (!(pd instanceof PropertyDefinitionSimple)) continue;
                    pds = (PropertyDefinitionSimple)pd;
                    List pdel = pds.getEnumeratedValues();
                    for (int i = pdel.size() - 1; i >= 0; --i) {
                        if (pdel.get(i) != null) continue;
                        pdel.remove(i);
                    }
                    assert (pdel.size() == 4) : "jnpPort did not have 4 options in v2, but " + pdel.size();
                    found = 0;
                    for (PropertyDefinitionEnumeration pde : pdel) {
                        if (this.containedIn(pde.getName(), new String[]{"option2", "option3", "newOption4", "newOption5"})) {
                            ++found;
                        }
                        if (pde.getName().equals("option3")) assert (pde.getValue().equals("changed")) : "Value for option 'option3' did not change in v2";
                    }
                    assert (found == 4) : "Did not find the four expected options in v2 ";
                    continue;
                }
                if (!pd.getName().equals("secureJnpPort")) continue;
                assert (pd instanceof PropertyDefinitionSimple) : "secureJnpPort is no simple-property in v2";
                pds = (PropertyDefinitionSimple)pd;
                Set constraints = pds.getConstraints();
                assert (constraints.size() == 3) : "Did not find 3 constraints for secureJnpPort in v2, but " + constraints.size();
            }
            this.getTransactionManager().rollback();
            this.registerPlugin("update5-v1_0.xml", "3");
            platform1 = this.getResourceType("myPlatform5");
            this.getTransactionManager().begin();
            em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform1 = (ResourceType)em.find(ResourceType.class, (Object)platform1.getId());
            servers = platform1.getChildResourceTypes();
            assert (servers.size() == 1) : "Expected to find 1 server in v1, but got " + servers.size();
            ResourceType server3 = (ResourceType)servers.iterator().next();
            ConfigurationDefinition def3 = server3.getResourceConfigurationDefinition();
            List cpdl3 = def3.getNonGroupedProperties();
            assert (cpdl3.size() == 3) : "Did not find 3 properties in <resource-configuration> in v3 again but " + cpdl3.size();
            for (PropertyDefinition pd : cpdl3) {
                if (!pd.getName().equals("jnpPort") || !(pd instanceof PropertyDefinitionSimple)) continue;
                PropertyDefinitionSimple pds = (PropertyDefinitionSimple)pd;
                List pdel = pds.getEnumeratedValues();
                for (int i = pdel.size() - 1; i >= 0; --i) {
                    if (pdel.get(i) != null) continue;
                    pdel.remove(i);
                }
                assert (pdel.size() == 3) : "jnpPort did not have 3 options in v3, but " + pdel.size();
                found = 0;
                for (PropertyDefinitionEnumeration pde : pdel) {
                    if (!this.containedIn(pde.getName(), new String[]{"option1", "option2", "option3"})) continue;
                    ++found;
                }
                assert (found == 3) : "Did not find the three expected options in v3";
            }
            this.getTransactionManager().rollback();
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testResourceConfiguration");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testConstraint() throws Exception {
        try {
            this.registerPlugin("constraint.xml");
            ResourceType platform = this.getResourceType("constraintPlatform");
            this.getTransactionManager().begin();
            EntityManager em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            ConfigurationDefinition config = platform.getResourceConfigurationDefinition();
            PropertyDefinitionSimple propDef = config.getPropertyDefinitionSimple("secureJnpPort");
            Set constraints = propDef.getConstraints();
            assert (constraints.size() == 4) : "Expected to get 4 constraints, but got " + constraints.size();
            assert (propDef.getDefaultValue().equals("1234"));
            this.getTransactionManager().rollback();
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testConstraint");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testConstraint2() throws Exception {
        try {
            this.registerPlugin("constraint.xml");
            ResourceType platform = this.getResourceType("constraintPlatform");
            this.getTransactionManager().begin();
            EntityManager em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            ConfigurationDefinition config = platform.getResourceConfigurationDefinition();
            Map propDefMap = config.getPropertyDefinitions();
            PropertyDefinitionSimple propDef = (PropertyDefinitionSimple)propDefMap.get("secureJnpPort");
            Set constraints = propDef.getConstraints();
            assert (constraints.size() == 4) : "Expected to get 4 constraints, but got " + constraints.size();
            assert (propDef.getDefaultValue().equals("1234"));
            this.getTransactionManager().rollback();
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testConstraint2");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testConstraintMinMax() throws Exception {
        try {
            this.registerPlugin("constraintMinMax.xml");
            ResourceType platform = this.getResourceType("constraintPlatform");
            this.getTransactionManager().begin();
            EntityManager em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            ConfigurationDefinition config = platform.getResourceConfigurationDefinition();
            PropertyDefinitionSimple propDef = config.getPropertyDefinitionSimple("secureJnpPort");
            Set constraints = propDef.getConstraints();
            assert (constraints.size() == 2) : "Expected to get 2 constraints, but got " + constraints.size();
            for (Constraint co : constraints) {
                if (co instanceof IntegerRangeConstraint) {
                    IntegerRangeConstraint irc = (IntegerRangeConstraint)co;
                    assert (irc.getMinimum() == 5L);
                    assert (irc.getMaximum() == 0L);
                    continue;
                }
                if (!(co instanceof FloatRangeConstraint)) continue;
                FloatRangeConstraint frc = (FloatRangeConstraint)co;
                assert (frc != null);
                assert (frc.getMaximum() == 0.0);
                assert (frc.getMinimum() == 5.0);
            }
            this.getTransactionManager().rollback();
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testConstraint2");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testListOfLists() throws Exception {
        try {
            Set constraints;
            String[] optionVals;
            int found;
            List options;
            PropertyDefinitionSimple pds;
            PropertyDefinitionList pdl2;
            PropertyDefinitionSimple pds2;
            PropertyDefinition member;
            PropertyDefinitionList pdl;
            this.registerPlugin("propertyList-v1.xml");
            ResourceType platform = this.getResourceType("myPlatform6");
            this.getTransactionManager().begin();
            EntityManager em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            ConfigurationDefinition cd = platform.getResourceConfigurationDefinition();
            Map propDefs = cd.getPropertyDefinitions();
            assert (propDefs.size() == 4) : "Expected to see 4 <list-property>s in v1, but got " + propDefs.size();
            for (PropertyDefinition def : propDefs.values()) {
                assert (def instanceof PropertyDefinitionList) : "PropertyDefinition " + def.getName() + " is no list-property in v1";
                pdl = (PropertyDefinitionList)def;
                member = pdl.getMemberDefinition();
                if (pdl.getName().equals("myList1")) {
                    assert (pdl.getDescription().equals("Just a simple list"));
                    assert (member instanceof PropertyDefinitionSimple) : "Expected the member of myList1 to be a simple property in v1";
                    pds2 = (PropertyDefinitionSimple)member;
                    assert (pds2.getName().equals("foo"));
                    continue;
                }
                if (pdl.getName().equals("myList2")) {
                    assert (member instanceof PropertyDefinitionList) : "Expected the member of myList2 to be a list property in v1";
                    continue;
                }
                if (pdl.getName().equals("myList3")) {
                    assert (member instanceof PropertyDefinitionSimple) : "Expected the member of myList3 to be a simple property in v1";
                    pds2 = (PropertyDefinitionSimple)member;
                    assert (pds2.getName().equals("baz"));
                    continue;
                }
                if (pdl.getName().equals("rec1")) {
                    assert (member instanceof PropertyDefinitionList) : "Expected the member of rc1 to be a list property in v1";
                    pdl2 = (PropertyDefinitionList)member;
                    assert (pdl2.getName().equals("rec2"));
                    pdl2 = (PropertyDefinitionList)pdl2.getMemberDefinition();
                    assert (pdl2.getName().equals("rec3"));
                    pdl2 = (PropertyDefinitionList)pdl2.getMemberDefinition();
                    assert (pdl2.getName().equals("rec4"));
                    assert (pdl2.getMemberDefinition() instanceof PropertyDefinitionSimple);
                    pds = (PropertyDefinitionSimple)pdl2.getMemberDefinition();
                    assert (pds.getName().equals("rec5"));
                    assert (pds.getDescription().equals("Deeply nested"));
                    options = pds.getEnumeratedValues();
                    assert (options.size() == 4);
                    found = 0;
                    optionVals = new String[]{"a", "b", "c", "d"};
                    for (PropertyDefinitionEnumeration option : options) {
                        if (!this.containedIn(option.getValue(), optionVals)) continue;
                        ++found;
                    }
                    assert (found == 4);
                    constraints = pds.getConstraints();
                    assert (constraints.size() == 1);
                    continue;
                }
                assert (false) : "Unknown list-definition in v1: " + pdl.getName();
            }
            this.getTransactionManager().rollback();
            this.registerPlugin("propertyList-v2.xml");
            platform = this.getResourceType("myPlatform6");
            this.getTransactionManager().begin();
            em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            cd = platform.getResourceConfigurationDefinition();
            propDefs = cd.getPropertyDefinitions();
            assert (propDefs.size() == 4) : "Expected to see 4 <list-property>s in v2, but got " + propDefs.size();
            for (PropertyDefinition def : propDefs.values()) {
                assert (def instanceof PropertyDefinitionList) : "PropertyDefinition " + def.getName() + " is no list-property in v2";
                pdl = (PropertyDefinitionList)def;
                member = pdl.getMemberDefinition();
                if (pdl.getName().equals("myList2")) {
                    assert (member instanceof PropertyDefinitionList) : "Expected the member of myList2 to be a list property in v2";
                    continue;
                }
                if (pdl.getName().equals("myList3")) {
                    assert (member instanceof PropertyDefinitionList) : "Expected the member of myList3 to be a list property in v2";
                    pds2 = (PropertyDefinitionList)member;
                    assert (pds2.getName().equals("baz"));
                    assert (pds2.getDescription().equals("myList3:baz"));
                    assert (pds2.getMemberDefinition() instanceof PropertyDefinitionSimple) : "Expected the member of list3:baz to be a simple property in v2";
                    continue;
                }
                if (pdl.getName().equals("myList4")) {
                    assert (pdl.getDescription().equals("Just a simple list"));
                    assert (member instanceof PropertyDefinitionSimple) : "Expected the member of myList4 to be a simple property in v2";
                    pds2 = (PropertyDefinitionSimple)member;
                    assert (pds2.getName().equals("foo"));
                    continue;
                }
                if (pdl.getName().equals("rec1")) {
                    assert (member instanceof PropertyDefinitionList) : "Expected the member of rec1 to be a list property in v2";
                    pdl2 = (PropertyDefinitionList)member;
                    assert (pdl2.getName().equals("rec2"));
                    pdl2 = (PropertyDefinitionList)pdl2.getMemberDefinition();
                    assert (pdl2.getName().equals("rec3+"));
                    pdl2 = (PropertyDefinitionList)pdl2.getMemberDefinition();
                    assert (pdl2.getName().equals("rec4"));
                    assert (pdl2.getMemberDefinition() instanceof PropertyDefinitionSimple);
                    pds = (PropertyDefinitionSimple)pdl2.getMemberDefinition();
                    assert (pds.getName().equals("rec5"));
                    assert (pds.getDescription().equals("Nested deeply"));
                    options = pds.getEnumeratedValues();
                    assert (options.size() == 5);
                    found = 0;
                    optionVals = new String[]{"b", "c", "d", "x", "z"};
                    for (PropertyDefinitionEnumeration option : options) {
                        if (!this.containedIn(option.getValue(), optionVals)) continue;
                        ++found;
                    }
                    assert (found == optionVals.length);
                    constraints = pds.getConstraints();
                    assert (constraints.size() == 2);
                    for (Constraint constraint : constraints) {
                        if (constraint instanceof IntegerRangeConstraint) {
                            IntegerRangeConstraint irc = (IntegerRangeConstraint)constraint;
                            assert (irc != null) : "Integer-constraint was null, but should not be";
                            assert (irc.getDetails().equals("-2#10"));
                            irc.setDetails(irc.getDetails());
                            assert (irc.getMaximum() == 10L);
                            assert (irc.getMinimum() == -2L);
                            continue;
                        }
                        if (constraint instanceof FloatRangeConstraint) {
                            FloatRangeConstraint frc = (FloatRangeConstraint)constraint;
                            assert (frc != null) : "Float-constraint was null, but should not be";
                            assert (frc.getDetails().equals("10.0#5.0"));
                            frc.setDetails(frc.getDetails());
                            assert (frc.getMinimum() == 10.0);
                            assert (frc.getMaximum() == 5.0);
                            continue;
                        }
                        assert (false) : "Unknown constraint type encountered";
                    }
                    continue;
                }
                assert (false) : "Unknown list-definition in v2: " + pdl.getName();
            }
            this.getTransactionManager().rollback();
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testListOfLists");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testListPropertyMinMax() throws Exception {
        try {
            this.registerPlugin("propertyList-simple.xml");
            ResourceType platform = this.getResourceType("myPlatform");
            this.getTransactionManager().begin();
            EntityManager em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            ConfigurationDefinition cd = platform.getResourceConfigurationDefinition();
            Map properties = cd.getPropertyDefinitions();
            PropertyDefinitionList a = (PropertyDefinitionList)properties.get("a");
            assert (a.getDescription().equals("Yada !")) : "Expected the description to be 'Yada !', but it was " + a.getDescription();
            this.getTransactionManager().rollback();
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testListPropertyMinMax");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testMapProperty() throws Exception {
        try {
            PropertyDefinitionSimple simple;
            Map children;
            PropertyDefinitionMap map;
            this.registerPlugin("propertyMap-v1.xml");
            ResourceType platform = this.getResourceType("myPlatform7");
            this.getTransactionManager().begin();
            EntityManager em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            ConfigurationDefinition cd = platform.getResourceConfigurationDefinition();
            Map propDefs = cd.getPropertyDefinitions();
            assert (propDefs.size() == 5) : "Expected to find 5 properties in v1, but got " + propDefs.size();
            int found = 0;
            for (PropertyDefinition def : propDefs.values()) {
                if (this.containedIn(def.getName(), new String[]{"map1", "map2", "map3", "map4", "map5"})) {
                    ++found;
                }
                assert (def instanceof PropertyDefinitionMap) : "Not all properties are maps in v1";
                if (def.getName().equals("map4")) {
                    map = (PropertyDefinitionMap)def;
                    children = map.getPropertyDefinitions();
                    assert (children.size() == 1) : "Map4 should have 1 child";
                    children = map.getPropertyDefinitions();
                    map = (PropertyDefinitionMap)children.get("map4:2");
                    assert (map != null) : "Child map4:2 not found";
                    children = map.getPropertyDefinitions();
                    map = (PropertyDefinitionMap)children.get("map4:2:3");
                    assert (map != null) : "Child map4:2:3 not found";
                    children = map.getPropertyDefinitions();
                    simple = (PropertyDefinitionSimple)children.get("simple");
                    assert (simple != null) : "Child simple not found";
                }
                if (!def.getName().equals("map5")) continue;
                map = (PropertyDefinitionMap)def;
                children = map.getPropertyDefinitions();
                assert (children.size() == 1) : "Map4 should have 1 child";
                children = map.getPropertyDefinitions();
                simple = (PropertyDefinitionSimple)children.get("hugo");
                assert (simple.getDescription().equals("foo"));
            }
            assert (found == 5) : "Did not find the 5 desired maps in v1";
            this.getTransactionManager().rollback();
            System.out.println("Done with v1");
            this.registerPlugin("propertyMap-v2.xml");
            platform = this.getResourceType("myPlatform7");
            this.getTransactionManager().begin();
            em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            cd = platform.getResourceConfigurationDefinition();
            propDefs = cd.getPropertyDefinitions();
            assert (propDefs.size() == 5) : "Expected to find 5 properties in v2, but got " + propDefs.size();
            found = 0;
            for (PropertyDefinition def : propDefs.values()) {
                if (this.containedIn(def.getName(), new String[]{"map1", "map2", "map3", "map4", "map5"})) {
                    ++found;
                }
                if (def.getName().equals("map1")) {
                    assert (def instanceof PropertyDefinitionSimple) : "Map 1 should be a simple-property in v2";
                } else assert (def instanceof PropertyDefinitionMap) : "Not all properties are maps in v2";
                if (def.getName().equals("map3")) assert (!def.isRequired()) : "Map 3 should not be false in v2";
                if (def.getName().equals("map4")) {
                    map = (PropertyDefinitionMap)def;
                    children = map.getPropertyDefinitions();
                    assert (children.size() == 1) : "Map4 should have 1 child, but has " + children.size();
                    children = map.getPropertyDefinitions();
                    map = (PropertyDefinitionMap)children.get("map4:2+");
                    assert (map != null) : "Child map4:2 not found";
                    children = map.getPropertyDefinitions();
                    assert (children.size() == 1) : "Map4:2 should have 1 child, but has " + children.size();
                    map = (PropertyDefinitionMap)children.get("map4:2:3");
                    assert (map != null) : "Child map4:2:3 not found";
                    children = map.getPropertyDefinitions();
                    assert (children.size() == 2) : "Map4:2:3 should have 1 child, but has " + children.size();
                    PropertyDefinitionList list = (PropertyDefinitionList)children.get("list");
                    assert (list != null) : "Child list not found";
                    PropertyDefinitionSimple simple2 = (PropertyDefinitionSimple)children.get("simple2");
                    assert (simple2 != null) : "Child simple2 not found";
                }
                if (!def.getName().equals("map5")) continue;
                map = (PropertyDefinitionMap)def;
                children = map.getPropertyDefinitions();
                assert (children.size() == 1) : "Map5 should have 1 child";
                children = map.getPropertyDefinitions();
                simple = (PropertyDefinitionSimple)children.get("hugo");
                assert (simple.getDescription().equals("bar")) : "Map5:hugo should have 'bar' in v2";
            }
            assert (found == 5) : "Did not find the 5 desired properties in v2, instead found " + found;
            this.getTransactionManager().rollback();
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testMapProperty");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testChangePropertyType() throws Exception {
        try {
            this.registerPlugin("propertyChanging-v1.xml");
            ResourceType platform = this.getResourceType("myPlatform7");
            this.getTransactionManager().begin();
            EntityManager em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            ConfigurationDefinition cd = platform.getResourceConfigurationDefinition();
            Map propDefs = cd.getPropertyDefinitions();
            for (PropertyDefinition def : propDefs.values()) {
                if (def.getName().equals("one")) {
                    assert (def instanceof PropertyDefinitionMap);
                    continue;
                }
                if (def.getName().equals("two")) {
                    assert (def instanceof PropertyDefinitionMap);
                    continue;
                }
                if (def.getName().equals("three")) {
                    assert (def instanceof PropertyDefinitionList);
                    continue;
                }
                if (def.getName().equals("four")) {
                    assert (def instanceof PropertyDefinitionList);
                    continue;
                }
                if (def.getName().equals("five")) {
                    assert (def instanceof PropertyDefinitionSimple);
                    continue;
                }
                if (def.getName().equals("six")) {
                    assert (def instanceof PropertyDefinitionSimple);
                    continue;
                }
                assert (false) : "Unknown definition : " + def.getName() + " in v1";
            }
            this.getTransactionManager().rollback();
            this.registerPlugin("propertyChanging-v2.xml");
            platform = this.getResourceType("myPlatform7");
            this.getTransactionManager().begin();
            em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            cd = platform.getResourceConfigurationDefinition();
            propDefs = cd.getPropertyDefinitions();
            for (PropertyDefinition def : propDefs.values()) {
                if (def.getName().equals("one")) {
                    assert (def instanceof PropertyDefinitionList) : "Expected a list-property, but it was " + def.getClass().getCanonicalName();
                    continue;
                }
                if (def.getName().equals("two")) {
                    assert (def instanceof PropertyDefinitionSimple) : "Expected a simple-property, but it was " + def.getClass().getCanonicalName();
                    continue;
                }
                if (def.getName().equals("three")) {
                    assert (def instanceof PropertyDefinitionMap) : "Expected a map-property, but it was " + def.getClass().getCanonicalName();
                    continue;
                }
                if (def.getName().equals("four")) {
                    assert (def instanceof PropertyDefinitionSimple) : "Expected a simple-property, but it was " + def.getClass().getCanonicalName();
                    continue;
                }
                if (def.getName().equals("five")) {
                    assert (def instanceof PropertyDefinitionMap) : "Expected a map-property, but it was " + def.getClass().getCanonicalName();
                    continue;
                }
                if (def.getName().equals("six")) {
                    assert (def instanceof PropertyDefinitionList) : "Expected a list-property, but it was " + def.getClass().getCanonicalName();
                    continue;
                }
                assert (false) : "Unknown definition : " + def.getName() + " in v2";
            }
            this.getTransactionManager().rollback();
            this.registerPlugin("propertyChanging-v1.xml", "3.0");
            platform = this.getResourceType("myPlatform7");
            this.getTransactionManager().begin();
            em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            cd = platform.getResourceConfigurationDefinition();
            propDefs = cd.getPropertyDefinitions();
            for (PropertyDefinition def : propDefs.values()) {
                if (def.getName().equals("one")) {
                    assert (def instanceof PropertyDefinitionMap) : "Expected a map-property, but it was " + def.getClass().getCanonicalName();
                    continue;
                }
                if (def.getName().equals("two")) {
                    assert (def instanceof PropertyDefinitionMap) : "Expected a map-property, but it was " + def.getClass().getCanonicalName();
                    continue;
                }
                if (def.getName().equals("three")) {
                    assert (def instanceof PropertyDefinitionList) : "Expected a list-property, but it was " + def.getClass().getCanonicalName();
                    continue;
                }
                if (def.getName().equals("four")) {
                    assert (def instanceof PropertyDefinitionList) : "Expected a list-property, but it was " + def.getClass().getCanonicalName();
                    continue;
                }
                if (def.getName().equals("five") ? !$assertionsDisabled && !(def instanceof PropertyDefinitionSimple) : def.getName().equals("six") && !$assertionsDisabled && !(def instanceof PropertyDefinitionSimple)) {
                    throw new AssertionError((Object)("Expected a simple-property, but it was " + def.getClass().getCanonicalName()));
                }
            }
            this.getTransactionManager().rollback();
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testChangePropertyType");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testGroupDeleted() throws Exception {
        try {
            this.registerPlugin("groupDeleted-v1.xml");
            System.out.println("==> Done with v1");
            this.registerPlugin("groupDeleted-v2.xml");
            System.out.println("==> Done with v2");
            this.registerPlugin("groupDeleted-v1.xml", "3.0");
            System.out.println("==> Done with v1");
        }
        finally {
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testGroupDeleted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testGroupPropDeleted() throws Exception {
        try {
            this.registerPlugin("groupPropDeleted-v1.xml");
            System.out.println("==> Done with v1");
            this.registerPlugin("groupPropDeleted-v2.xml");
            System.out.println("==> Done with v2");
            this.registerPlugin("groupPropDeleted-v1.xml", "3.0");
            System.out.println("==> Done with v1");
        }
        finally {
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testGroupPropDeleted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testGroupPropDeletedExt() throws Exception {
        try {
            this.registerPlugin("groupPropDeleted-v3.xml");
            System.out.println("==> Done with v1");
            this.registerPlugin("groupPropDeleted-v4.xml");
            System.out.println("==> Done with v2");
            this.registerPlugin("groupPropDeleted-v3.xml", "5.0");
            System.out.println("==> Done with v1");
        }
        finally {
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testGroupPropDeletedExt");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testGroupPropMoved() throws Exception {
        try {
            this.registerPlugin("groupPropMoved-v1.xml");
            System.out.println("==> Done with v1");
            this.registerPlugin("groupPropMoved-v2.xml");
            System.out.println("==> Done with v2");
            this.registerPlugin("groupPropMoved-v1.xml", "3.0");
            System.out.println("==> Done with v1");
        }
        finally {
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testGroupPropMoved");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testUpdateDefaultTemplate() throws Exception {
        try {
            this.registerPlugin("updateDefaultTemplate1.xml");
            ResourceType platform = this.getResourceType("myPlatform7");
            this.getTransactionManager().begin();
            EntityManager em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            ConfigurationDefinition cd = platform.getResourceConfigurationDefinition();
            ConfigurationTemplate defaultTemplate = cd.getDefaultTemplate();
            assert (defaultTemplate != null);
            Configuration config = defaultTemplate.getConfiguration();
            PropertySimple ps = config.getSimple("six");
            assert ("foo".equals(ps.getStringValue())) : "Expected 'foo', but got " + ps.getStringValue();
            this.getTransactionManager().rollback();
            this.registerPlugin("updateDefaultTemplate2.xml");
            platform = this.getResourceType("myPlatform7");
            this.getTransactionManager().begin();
            em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            cd = platform.getResourceConfigurationDefinition();
            defaultTemplate = cd.getDefaultTemplate();
            assert (defaultTemplate != null);
            config = defaultTemplate.getConfiguration();
            ps = config.getSimple("six");
            assert ("bar".equals(ps.getStringValue())) : "Expected 'bar', but got " + ps.getStringValue();
            this.getTransactionManager().rollback();
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testUpdateDefaultTemplate");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testAddDeleteTemplate() throws Exception {
        try {
            this.registerPlugin("addDeleteTemplate1.xml");
            ResourceType platform = this.getResourceType("myPlatform7");
            this.getTransactionManager().begin();
            EntityManager em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            ConfigurationDefinition cd = platform.getResourceConfigurationDefinition();
            ConfigurationTemplate defaultTemplate = cd.getDefaultTemplate();
            assert (defaultTemplate != null);
            Map templateMap = cd.getTemplates();
            assert (templateMap.size() == 1) : "Expected only the 1 default template but got " + templateMap.size();
            this.getTransactionManager().rollback();
            System.out.println("Done with v1");
            this.registerPlugin("addDeleteTemplate2.xml");
            platform = this.getResourceType("myPlatform7");
            this.getTransactionManager().begin();
            em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            cd = platform.getResourceConfigurationDefinition();
            defaultTemplate = cd.getDefaultTemplate();
            templateMap = cd.getTemplates();
            assert (defaultTemplate != null);
            assert (templateMap.size() == 2) : "Expected 2 templates but got " + templateMap;
            ConfigurationTemplate template = (ConfigurationTemplate)templateMap.get("additional");
            assert (template != null);
            PropertySimple ps = template.getConfiguration().getSimple("second_one");
            assert (ps.getStringValue().equals("Bart")) : "Expected 'Bart', but got " + ps.getStringValue();
            this.getTransactionManager().rollback();
            System.out.println("Done with v2");
            this.registerPlugin("addDeleteTemplate3.xml");
            platform = this.getResourceType("myPlatform7");
            this.getTransactionManager().begin();
            em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            cd = platform.getResourceConfigurationDefinition();
            defaultTemplate = cd.getDefaultTemplate();
            templateMap = cd.getTemplates();
            assert (defaultTemplate != null);
            assert (templateMap.size() == 2) : "Expected 2 templates but got " + templateMap;
            template = (ConfigurationTemplate)templateMap.get("additional");
            assert (template != null);
            ps = template.getConfiguration().getSimple("second_one");
            assert (ps.getStringValue().equals("Bart Simpson")) : "Expected 'Bart Simpson', but got " + ps.getStringValue();
            this.getTransactionManager().rollback();
            System.out.println("Done with v3");
            this.registerPlugin("addDeleteTemplate1.xml", "4.0");
            platform = this.getResourceType("myPlatform7");
            this.getTransactionManager().begin();
            em = UpdateConfigurationSubsystemTest.getEntityManager();
            platform = (ResourceType)em.find(ResourceType.class, (Object)platform.getId());
            cd = platform.getResourceConfigurationDefinition();
            defaultTemplate = cd.getDefaultTemplate();
            templateMap = cd.getTemplates();
            assert (defaultTemplate != null);
            assert (templateMap.size() == 1) : "Expected only the 1 default template but got " + templateMap;
            this.getTransactionManager().rollback();
            System.out.println("Done with v1(2)");
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            try {
                this.cleanupTest();
            }
            catch (Exception e) {
                System.out.println("CANNNOT CLEAN UP TEST: " + ((Object)((Object)this)).getClass().getSimpleName() + ".testAddDeleteDefaultTemplate");
            }
        }
    }
}

