/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata.test;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.transaction.TransactionManager;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.rhq.core.clientapi.agent.measurement.MeasurementAgentService;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDataRequest;
import org.rhq.core.domain.measurement.ResourceMeasurementScheduleRequest;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.test.JPAUtils;
import org.rhq.test.TransactionCallbackWithContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class UpdatePluginMetadataTestBase
extends AbstractEJB3Test {
    protected TestServerCommunicationsService agentServiceContainer;
    protected static final String PLUGIN_NAME = "ResourceMetaDataManagerBeanTest";
    protected static final String AGENT_NAME = "-dummy agent-";
    protected static final String COMMON_PATH_PREFIX = "./test/metadata/";
    protected static PluginManagerLocal pluginMgr;
    protected static ResourceTypeManagerLocal resourceTypeManager;
    protected static ResourceManagerLocal resourceManager;

    @AfterClass
    public void afterClass() throws Exception {
        this.cleanupTest();
    }

    @BeforeMethod
    protected void init() {
        this.agentServiceContainer = this.prepareForTestAgents();
        this.prepareMockAgentServiceContainer();
        this.prepareScheduler();
        try {
            pluginMgr = LookupUtil.getPluginManager();
            resourceTypeManager = LookupUtil.getResourceTypeManager();
            resourceManager = LookupUtil.getResourceManager();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws Exception {
        this.unprepareForTestAgents();
        this.unprepareScheduler();
    }

    protected void prepareMockAgentServiceContainer() {
        this.agentServiceContainer.measurementService = new MockMeasurementAgentService();
    }

    protected ResourceType getResourceType(String typeName) {
        return this.getResourceType(typeName, PLUGIN_NAME);
    }

    protected ResourceType getResourceType(String typeName, String pluginName) {
        Subject overlord = this.getOverlord();
        ResourceTypeCriteria resourceTypeCriteria = new ResourceTypeCriteria();
        resourceTypeCriteria.setStrict(true);
        resourceTypeCriteria.addFilterName(typeName);
        resourceTypeCriteria.addFilterPluginName(pluginName);
        resourceTypeCriteria.fetchMetricDefinitions(true);
        resourceTypeCriteria.fetchSubCategory(true);
        PageList results = resourceTypeManager.findResourceTypesByCriteria(overlord, resourceTypeCriteria);
        if (results.size() == 0) {
            return null;
        }
        if (results.size() == 1) {
            return (ResourceType)results.get(0);
        }
        throw new IllegalStateException("Found more than one resourceType with name " + typeName + " from plugin " + pluginName + ".");
    }

    protected Resource createResource(String resourceKey, String name, ResourceType type) {
        Resource resource = new Resource(resourceKey, name, type);
        resource.setUuid(UUID.randomUUID().toString());
        resource.setInventoryStatus(InventoryStatus.COMMITTED);
        return resource;
    }

    protected Resource getResource(ResourceCriteria resourceCriteria) {
        Subject overlord = this.getOverlord();
        PageList results = resourceManager.findResourcesByCriteria(overlord, resourceCriteria);
        if (results.size() == 0) {
            return null;
        }
        if (results.size() == 1) {
            return (Resource)results.get(0);
        }
        throw new IllegalStateException("Found more than one Resource with criteria " + resourceCriteria + ".");
    }

    protected String getSubsystemDirectory() {
        return ".";
    }

    protected void registerPlugin(String pathToDescriptor, String versionOverride) throws Exception {
        pathToDescriptor = COMMON_PATH_PREFIX + this.getSubsystemDirectory() + "/" + pathToDescriptor;
        this.registerPluginInternal(pathToDescriptor, versionOverride);
    }

    private void registerPluginInternal(String pathToDescriptor, String versionOverride) throws Exception {
        System.out.println("Registering plugin with descriptor [" + pathToDescriptor + "]...");
        String md5 = MessageDigestGenerator.getDigestString((String)pathToDescriptor);
        Plugin testPlugin = new Plugin(PLUGIN_NAME, "foo.jar", md5);
        testPlugin.setDisplayName("ResourceMetaDataManagerBeanTest: " + pathToDescriptor);
        PluginDescriptor descriptor = this.loadPluginDescriptor(pathToDescriptor);
        if (versionOverride != null) {
            testPlugin.setVersion(versionOverride);
        } else {
            testPlugin.setVersion(descriptor.getVersion());
        }
        try {
            pluginMgr.registerPlugin(this.getOverlord(), testPlugin, descriptor, null, true);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    protected void registerPlugin(String pathToDescriptor) throws Exception {
        this.registerPlugin(pathToDescriptor, null);
    }

    public PluginDescriptor loadPluginDescriptor(String descriptorFile) throws Exception {
        URL descriptorUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(descriptorFile);
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.rhq.core.clientapi.descriptor.plugin");
        URL pluginSchemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("rhq-plugin.xsd");
        Schema pluginSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(pluginSchemaURL);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        ValidationEventCollector vec = new ValidationEventCollector();
        unmarshaller.setEventHandler((ValidationEventHandler)vec);
        unmarshaller.setSchema(pluginSchema);
        if (descriptorUrl == null) {
            throw new FileNotFoundException("File " + descriptorFile + " not found");
        }
        return (PluginDescriptor)unmarshaller.unmarshal(descriptorUrl.openStream());
    }

    protected boolean containedIn(String string, String[] references) {
        boolean found = false;
        for (String ref : references) {
            if (!string.equals(ref)) continue;
            found = true;
            break;
        }
        return found;
    }

    protected int getPluginId(EntityManager entityManager) throws NoResultException {
        Plugin existingPlugin = (Plugin)entityManager.createNamedQuery("Plugin.findByName").setParameter("name", (Object)PLUGIN_NAME).getSingleResult();
        int plugin1Id = existingPlugin.getId();
        return plugin1Id;
    }

    protected int getAgentId(EntityManager entityManager) throws NoResultException {
        Agent existingAgent = this.getAgent(entityManager);
        int agentId = existingAgent.getId();
        return agentId;
    }

    protected Agent getAgent(EntityManager entityManager) throws NoResultException {
        Agent existingAgent = (Agent)entityManager.createNamedQuery("Agent.findByName").setParameter("name", (Object)AGENT_NAME).getSingleResult();
        return existingAgent;
    }

    protected void setUpAgent(EntityManager entityManager, Resource testResource) {
        Agent agent;
        try {
            agent = this.getAgent(entityManager);
        }
        catch (NoResultException nre) {
            agent = new Agent(AGENT_NAME, "localhost", 12345, "http://localhost:12345/", "-dummy token-");
            entityManager.persist((Object)agent);
        }
        testResource.setAgent(agent);
        this.agentServiceContainer.addStartedAgent(agent);
    }

    protected void cleanupTest() throws Exception {
        this.cleanupMetadata();
        this.cleanupAgent();
        this.cleanupPlugin();
    }

    protected void cleanupMetadata() throws Exception {
        String pathToDescriptor = "./test/metadata//noTypes.xml";
        this.registerPluginInternal(pathToDescriptor, null);
    }

    protected void cleanupAgent() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = UpdatePluginMetadataTestBase.getEntityManager();
        try {
            try {
                int agentId = this.getAgentId(em);
                Agent agent = (Agent)em.getReference(Agent.class, (Object)agentId);
                if (null != agent) {
                    em.remove((Object)agent);
                }
            }
            catch (NoResultException nre) {
                // empty catch block
            }
        }
        catch (Exception e) {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            System.out.println("CANNOT CLEAN UP AGENT: " + e);
            throw e;
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().commit();
            }
        }
    }

    protected void cleanupPlugin() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = UpdatePluginMetadataTestBase.getEntityManager();
        try {
            try {
                int plugin1Id = this.getPluginId(em);
                Plugin plugin1 = (Plugin)em.getReference(Plugin.class, (Object)plugin1Id);
                if (null != plugin1) {
                    em.remove((Object)plugin1);
                }
            }
            catch (NoResultException nre) {
                // empty catch block
            }
        }
        catch (Exception e) {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            System.out.println("CANNOT CLEAN UP PLUGIN: " + e);
            throw e;
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().commit();
            }
        }
    }

    protected void cleanupResourceType(String rtName) throws Exception {
        try {
            ResourceType rt = this.getResourceType(rtName);
            if (null != rt) {
                Subject overlord = this.getOverlord();
                ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
                ResourceCriteria c = new ResourceCriteria();
                c.setStrict(true);
                c.addFilterResourceTypeId(Integer.valueOf(rt.getId()));
                c.addFilterInventoryStatus(InventoryStatus.NEW);
                PageList doomedResources = resourceManager.findResourcesByCriteria(overlord, c);
                c.addFilterInventoryStatus(InventoryStatus.DELETED);
                doomedResources.addAll(resourceManager.findResourcesByCriteria(overlord, c));
                c.addFilterInventoryStatus(InventoryStatus.UNINVENTORIED);
                doomedResources.addAll(resourceManager.findResourcesByCriteria(overlord, c));
                for (Resource doomed : doomedResources) {
                    List deletedIds = resourceManager.uninventoryResource(overlord, doomed.getId());
                    for (Integer deletedResourceId : deletedIds) {
                        resourceManager.uninventoryResourceAsyncWork(overlord, deletedResourceId.intValue());
                    }
                }
                this.getTransactionManager().begin();
                EntityManager em = UpdatePluginMetadataTestBase.getEntityManager();
                rt = (ResourceType)em.find(ResourceType.class, (Object)rt.getId());
                ResourceType parent = rt.getParentResourceTypes().isEmpty() ? null : (ResourceType)rt.getParentResourceTypes().iterator().next();
                em.remove((Object)rt);
                if (null != parent) {
                    em.remove((Object)parent);
                }
            }
        }
        catch (Exception e) {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            System.out.println("CANNOT CLEAN UP RESOURCE TYPE: " + rtName + ": " + e);
            throw e;
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().commit();
            }
        }
    }

    protected Subject getOverlord() {
        return LookupUtil.getSubjectManager().getOverlord();
    }

    protected Resource persistNewResource(final String resourceTypeName) throws Exception {
        return (Resource)JPAUtils.executeInTransaction((TransactionCallbackWithContext)new TransactionCallbackWithContext<Resource>(){

            public Resource execute(TransactionManager tm, EntityManager em) throws Exception {
                ResourceType resourceType = UpdatePluginMetadataTestBase.this.getResourceType(resourceTypeName);
                Resource resource = new Resource("reskey" + System.currentTimeMillis(), "resname", resourceType);
                resource.setUuid(UUID.randomUUID().toString());
                resource.setInventoryStatus(InventoryStatus.COMMITTED);
                UpdatePluginMetadataTestBase.this.setUpAgent(em, resource);
                em.persist((Object)resource);
                return resource;
            }
        });
    }

    protected void deleteNewResource(Resource resource) throws Exception {
        try {
            List deletedIds = resourceManager.uninventoryResource(this.getOverlord(), resource.getId());
            for (Integer deletedResourceId : deletedIds) {
                resourceManager.uninventoryResourceAsyncWork(this.getOverlord(), deletedResourceId.intValue());
            }
        }
        catch (Exception e) {
            System.out.println("CANNOT CLEAN UP RESOURCE: " + resource + ": " + e);
            throw e;
        }
    }

    public class MockMeasurementAgentService
    implements MeasurementAgentService {
        public Set<MeasurementData> getRealTimeMeasurementValue(int resourceId, List<MeasurementDataRequest> requests) {
            return null;
        }

        public void scheduleCollection(Set<ResourceMeasurementScheduleRequest> resourceSchedules) {
        }

        public void unscheduleCollection(Set<Integer> resourceIds) {
        }

        public void updateCollection(Set<ResourceMeasurementScheduleRequest> resourceSchedules) {
        }

        public Map<String, Object> getMeasurementScheduleInfoForResource(int resourceId) {
            return null;
        }
    }
}

