/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.test;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.persistence.EntityManager;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.inventory.CreateResourceRequest;
import org.rhq.core.clientapi.agent.inventory.CreateResourceResponse;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceRequest;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceResponse;
import org.rhq.core.clientapi.agent.inventory.ResourceFactoryAgentService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageCategory;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.resource.CreateResourceHistory;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.DeleteResourceHistory;
import org.rhq.core.domain.resource.DeleteResourceStatus;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.StandardServerPluginService;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ResourceFactoryManagerBeanTest
extends AbstractEJB3Test {
    private ResourceFactoryManagerLocal resourceFactoryManager;
    private ResourceManagerLocal resourceManager;
    private Subject overlord;
    private MockResourceFactoryAgentService mockAgentService = new MockResourceFactoryAgentService();
    private Resource parentResource;
    private ResourceType parentResourceType;
    private ResourceType childResourceType;
    private PackageType packageType;

    @BeforeClass
    public void setupBeforeClass() throws Exception {
        this.resourceFactoryManager = LookupUtil.getResourceFactoryManager();
        this.resourceManager = LookupUtil.getResourceManager();
        this.overlord = LookupUtil.getSubjectManager().getOverlord();
    }

    @BeforeMethod
    public void setupBeforeMethod() throws Exception {
        this.prepareScheduler();
        TestServerCommunicationsService agentServiceContainer = this.prepareForTestAgents();
        agentServiceContainer.resourceFactoryService = this.mockAgentService;
        StandardServerPluginService serverPluginService = new StandardServerPluginService();
        this.prepareCustomServerPluginService(serverPluginService);
        serverPluginService.startMasterPluginContainer();
        this.setupResourceEnvironment();
    }

    @AfterMethod(alwaysRun=true)
    public void teardownAfterMethod() throws Exception {
        this.unprepareForTestAgents();
        this.unprepareScheduler();
        this.unprepareServerPluginService();
        this.teardownResourceEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createResourceViaConfiguration() throws Exception {
        this.mockAgentService.setCreateReturnStatus(CreateResourceStatus.SUCCESS);
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration resourceConfiguration = new Configuration();
        resourceConfiguration.put((Property)new PropertySimple("property1", (Object)"value1"));
        this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.childResourceType.getId(), "newResource", null, resourceConfiguration);
        EntityManager entityManager = null;
        try {
            this.getTransactionManager().begin();
            entityManager = ResourceFactoryManagerBeanTest.getEntityManager();
            Resource parent = (Resource)entityManager.find(Resource.class, (Object)this.parentResource.getId());
            List historyList = parent.getCreateChildResourceRequests();
            assert (historyList.size() == 1) : "Incorrect number of children found. Expected: 1, Found: " + historyList.size();
            CreateResourceHistory historyItem = (CreateResourceHistory)historyList.get(0);
            assert (historyItem.getStatus() == CreateResourceStatus.SUCCESS) : "Incorrect status for history item. Expected: Success, Found: " + historyItem.getStatus();
            assert (historyItem.getNewResourceKey().equals("mockResourceKey")) : "Incorrect resource key for history item. Expected: mockResourceKey, Found: " + historyItem.getNewResourceKey();
            assert (historyItem.getErrorMessage() == null) : "Error message found for successful call";
            assert (historyItem.getConfiguration() != null) : "Null configuration found for history item";
        }
        finally {
            this.getTransactionManager().rollback();
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createResourceViaConfigurationFailure() throws Exception {
        this.mockAgentService.setCreateReturnStatus(CreateResourceStatus.FAILURE);
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration resourceConfiguration = new Configuration();
        resourceConfiguration.put((Property)new PropertySimple("property1", (Object)"value1"));
        this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.childResourceType.getId(), "newResource", null, resourceConfiguration);
        EntityManager entityManager = null;
        try {
            this.getTransactionManager().begin();
            entityManager = ResourceFactoryManagerBeanTest.getEntityManager();
            Resource parent = (Resource)entityManager.find(Resource.class, (Object)this.parentResource.getId());
            List historyList = parent.getCreateChildResourceRequests();
            assert (historyList.size() == 1) : "Incorrect number of children found. Expected: 1, Found: " + historyList.size();
            CreateResourceHistory historyItem = (CreateResourceHistory)historyList.get(0);
            assert (historyItem.getStatus() == CreateResourceStatus.FAILURE) : "Incorrect status for history item. Expected: Failure, Found: " + historyItem.getStatus();
            assert (historyItem.getErrorMessage().equals("errorMessage")) : "Incorrect error message for history item. Expected: errorMessage, Found: " + historyItem.getErrorMessage();
        }
        finally {
            this.getTransactionManager().rollback();
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createResourceViaPackage() throws Exception {
        this.mockAgentService.setCreateReturnStatus(CreateResourceStatus.SUCCESS);
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        String packageName = "testDataResourcePackage";
        String packageVersion = "1.0.0";
        int architectureId = 1;
        Configuration deploymentTimeConfiguration = new Configuration();
        deploymentTimeConfiguration.put((Property)new PropertySimple("testProperty", (Object)"testValue"));
        URL contentResource = ((Object)((Object)this)).getClass().getClassLoader().getResource("jndi.properties");
        assert (contentResource != null) : "Could not load jndi.properties as package content";
        InputStream packageInputStream = contentResource.openStream();
        this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.childResourceType.getId(), "newResource", null, packageName, packageVersion, Integer.valueOf(architectureId), deploymentTimeConfiguration, packageInputStream);
        EntityManager entityManager = null;
        try {
            this.getTransactionManager().begin();
            entityManager = ResourceFactoryManagerBeanTest.getEntityManager();
            Resource parent = (Resource)entityManager.find(Resource.class, (Object)this.parentResource.getId());
            List historyList = parent.getCreateChildResourceRequests();
            assert (historyList.size() == 1) : "Incorrect number of children found. Expected: 1, Found: " + historyList.size();
            CreateResourceHistory historyItem = (CreateResourceHistory)historyList.get(0);
            assert (historyItem.getStatus() == CreateResourceStatus.SUCCESS) : "Incorrect status for history item. Expected: Success, Found: " + historyItem.getStatus();
            assert (historyItem.getNewResourceKey().equals("mockResourceKey")) : "Incorrect resource key for history item. Expected: mockResourceKey, Found: " + historyItem.getNewResourceKey();
            assert (historyItem.getErrorMessage() == null) : "Error message found for successful call";
        }
        finally {
            this.getTransactionManager().rollback();
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteResource() throws Exception {
        this.mockAgentService.setDeleteReturnStatus(DeleteResourceStatus.SUCCESS);
        Resource deleteMe = this.addResourceToParent();
        assert (deleteMe != null) : "Child resource to be deleted was not correctly added in the first place";
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        this.resourceFactoryManager.deleteResource(overlord, deleteMe.getId());
        EntityManager entityManager = null;
        try {
            this.getTransactionManager().begin();
            entityManager = ResourceFactoryManagerBeanTest.getEntityManager();
            Resource parent = (Resource)entityManager.find(Resource.class, (Object)this.parentResource.getId());
            Set childResources = parent.getChildResources();
            assert (childResources.size() == 1) : "Child resource not found on the parent";
            Resource deletedResource = (Resource)childResources.iterator().next();
            assert (deletedResource.getInventoryStatus() == InventoryStatus.DELETED) : "Inventory status for deleted resource was incorrect. Expected: Deleted, Found: " + deletedResource.getInventoryStatus();
        }
        finally {
            this.getTransactionManager().rollback();
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteResourceFailure() throws Exception {
        this.mockAgentService.setDeleteReturnStatus(DeleteResourceStatus.FAILURE);
        Resource deleteMe = this.addResourceToParent();
        assert (deleteMe != null) : "Child resource to be deleted was not correctly added in the first place";
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        this.resourceFactoryManager.deleteResource(overlord, deleteMe.getId());
        EntityManager entityManager = null;
        try {
            this.getTransactionManager().begin();
            entityManager = ResourceFactoryManagerBeanTest.getEntityManager();
            Resource parent = (Resource)entityManager.find(Resource.class, (Object)this.parentResource.getId());
            Set childResources = parent.getChildResources();
            assert (childResources.size() == 1) : "Child resource not found on the parent";
            Resource deletedResource = (Resource)childResources.iterator().next();
            assert (deletedResource.getInventoryStatus() == InventoryStatus.COMMITTED) : "Inventory status for deleted resource was incorrect. Expected: Committed, Found: " + deletedResource.getInventoryStatus();
        }
        finally {
            this.getTransactionManager().rollback();
            entityManager.close();
        }
    }

    @Test
    public void createHistory() {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration resourceConfiguration = new Configuration();
        resourceConfiguration.getMap();
        this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.childResourceType.getId(), "resource1", (Configuration)null, resourceConfiguration);
        resourceConfiguration = new Configuration();
        resourceConfiguration.getMap();
        this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.childResourceType.getId(), "resource2", (Configuration)null, resourceConfiguration);
        resourceConfiguration = new Configuration();
        resourceConfiguration.getMap();
        this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.childResourceType.getId(), "resource3", (Configuration)null, resourceConfiguration);
        int numRequestsInHistory = this.resourceFactoryManager.getCreateChildResourceHistoryCount(this.parentResource.getId(), null, null);
        assert (numRequestsInHistory == 3) : "Incorrect history count. Expected: 3, Found: " + numRequestsInHistory;
        PageControl pageControl = new PageControl(0, 10000);
        pageControl.initDefaultOrderingField("createdResourceName");
        PageList historyList = this.resourceFactoryManager.findCreateChildResourceHistory(overlord, this.parentResource.getId(), null, null, pageControl);
        assert (historyList.getTotalSize() == 3) : "Incorrect number of entries in page list. Expected: 3, Found: " + historyList.getTotalSize();
        assert (((CreateResourceHistory)historyList.get(0)).getCreatedResourceName().equals("resource1")) : "History entry 1 is invalid";
        assert (((CreateResourceHistory)historyList.get(1)).getCreatedResourceName().equals("resource2")) : "History entry 2 is invalid";
        assert (((CreateResourceHistory)historyList.get(2)).getCreatedResourceName().equals("resource3")) : "History entry 3 is invalid";
    }

    @Test
    public void deleteHistory() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Resource resource1 = this.addResourceToParent();
        Resource resource2 = this.addResourceToParent();
        Resource resource3 = this.addResourceToParent();
        this.resourceFactoryManager.deleteResource(overlord, resource1.getId());
        this.resourceFactoryManager.deleteResource(overlord, resource2.getId());
        this.resourceFactoryManager.deleteResource(overlord, resource3.getId());
        int numRequestsInHistory = this.resourceFactoryManager.getDeleteChildResourceHistoryCount(this.parentResource.getId(), null, null);
        assert (numRequestsInHistory == 3) : "Incorrect history count. Expected: 3, Found: " + numRequestsInHistory;
        PageControl pageControl = new PageControl(0, 10000);
        pageControl.initDefaultOrderingField("drh.id");
        PageList historyList = this.resourceFactoryManager.findDeleteChildResourceHistory(overlord, this.parentResource.getId(), null, null, pageControl);
        assert (historyList.getTotalSize() == 3) : "Incorrect number of entries in page list. Expected: 3, Found: " + historyList.getTotalSize();
        assert (((DeleteResourceHistory)historyList.get(0)).getResource().getId() == resource1.getId()) : "History entry 1 is invalid";
        assert (((DeleteResourceHistory)historyList.get(1)).getResource().getId() == resource2.getId()) : "History entry 2 is invalid";
        assert (((DeleteResourceHistory)historyList.get(2)).getResource().getId() == resource3.getId()) : "History entry 3 is invalid";
    }

    @Test
    public void getHistoryItem() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration resourceConfiguration = new Configuration();
        resourceConfiguration.getMap();
        this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.childResourceType.getId(), "NewResource", null, resourceConfiguration);
        PageList historyList = this.resourceFactoryManager.findCreateChildResourceHistory(overlord, this.parentResource.getId(), null, null, new PageControl(0, 1000));
        int historyItemId = ((CreateResourceHistory)historyList.get(0)).getId();
        CreateResourceHistory historyItem = this.resourceFactoryManager.getCreateHistoryItem(historyItemId);
        assert (historyItem != null) : "Null history item returned from call";
        assert (historyItem.getCreatedResourceName().equals("NewResource"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupResourceEnvironment() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = ResourceFactoryManagerBeanTest.getEntityManager();
        try {
            try {
                this.parentResourceType = new ResourceType("platform-" + System.currentTimeMillis(), "TestPlugin", ResourceCategory.PLATFORM, null);
                em.persist((Object)this.parentResourceType);
                this.childResourceType = new ResourceType("server-" + System.currentTimeMillis(), "TestPlugin", ResourceCategory.SERVER, this.parentResourceType);
                em.persist((Object)this.childResourceType);
                this.packageType = new PackageType();
                this.packageType.setName("artifact-" + System.currentTimeMillis());
                this.packageType.setDescription("");
                this.packageType.setCategory(PackageCategory.DEPLOYABLE);
                this.packageType.setDisplayName("TestResourceArtifact");
                this.packageType.setCreationData(true);
                this.packageType.setResourceType(this.childResourceType);
                em.persist((Object)this.packageType);
                this.childResourceType.addPackageType(this.packageType);
                this.parentResource = new Resource("parent" + System.currentTimeMillis(), "name", this.parentResourceType);
                this.parentResource.setUuid("" + new Random().nextInt());
                em.persist((Object)this.parentResource);
            }
            catch (Exception e) {
                System.out.println(e);
                this.getTransactionManager().rollback();
                throw e;
            }
            this.getTransactionManager().commit();
        }
        finally {
            em.close();
        }
    }

    private void teardownResourceEnvironment() throws Exception {
        if (this.parentResource != null) {
            List deletedIds = this.resourceManager.uninventoryResource(this.overlord, this.parentResource.getId());
            for (Integer deletedResourceId : deletedIds) {
                this.resourceManager.uninventoryResourceAsyncWork(this.overlord, deletedResourceId.intValue());
            }
            this.getTransactionManager().begin();
            EntityManager em = ResourceFactoryManagerBeanTest.getEntityManager();
            try {
                ResourceType deleteMeType = (ResourceType)em.find(ResourceType.class, (Object)this.childResourceType.getId());
                em.remove((Object)deleteMeType);
                deleteMeType = (ResourceType)em.find(ResourceType.class, (Object)this.parentResourceType.getId());
                em.remove((Object)deleteMeType);
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                try {
                    System.out.println(e);
                    this.getTransactionManager().rollback();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource addResourceToParent() throws Exception {
        Resource resource = null;
        this.getTransactionManager().begin();
        EntityManager em = ResourceFactoryManagerBeanTest.getEntityManager();
        try {
            try {
                resource = new Resource("child" + System.currentTimeMillis(), "name", this.parentResourceType);
                resource.setUuid("" + new Random().nextInt());
                resource.setParentResource(this.parentResource);
                resource.setInventoryStatus(InventoryStatus.COMMITTED);
                em.persist((Object)resource);
            }
            catch (Exception e) {
                System.out.println(e);
                this.getTransactionManager().rollback();
            }
            this.getTransactionManager().commit();
        }
        finally {
            em.close();
        }
        return resource;
    }

    private class MockResourceFactoryAgentService
    implements ResourceFactoryAgentService {
        private CreateResourceStatus createReturnStatus = CreateResourceStatus.SUCCESS;
        private DeleteResourceStatus deleteReturnStatus = DeleteResourceStatus.SUCCESS;

        private MockResourceFactoryAgentService() {
        }

        public void setCreateReturnStatus(CreateResourceStatus createReturnStatus) {
            this.createReturnStatus = createReturnStatus;
        }

        public void setDeleteReturnStatus(DeleteResourceStatus deleteReturnStatus) {
            this.deleteReturnStatus = deleteReturnStatus;
        }

        public void createResource(CreateResourceRequest request) throws PluginContainerException {
            CreateResourceResponse response = null;
            switch (this.createReturnStatus) {
                case SUCCESS: {
                    response = new CreateResourceResponse(request.getRequestId(), "mockResourceName", "mockResourceKey", CreateResourceStatus.SUCCESS, null, request.getResourceConfiguration());
                    break;
                }
                case FAILURE: {
                    response = new CreateResourceResponse(request.getRequestId(), null, null, CreateResourceStatus.FAILURE, "errorMessage", request.getResourceConfiguration());
                }
            }
            ResourceFactoryManagerBeanTest.this.resourceFactoryManager.completeCreateResource(response);
        }

        public void deleteResource(DeleteResourceRequest request) throws PluginContainerException {
            DeleteResourceResponse response = null;
            switch (this.deleteReturnStatus) {
                case SUCCESS: {
                    response = new DeleteResourceResponse(request.getRequestId(), this.deleteReturnStatus, null);
                    break;
                }
                case FAILURE: {
                    response = new DeleteResourceResponse(request.getRequestId(), this.deleteReturnStatus, "errorMessage");
                }
            }
            ResourceFactoryManagerBeanTest.this.resourceFactoryManager.completeDeleteResourceRequest(response);
        }

        public CreateResourceResponse executeCreateResourceImmediately(CreateResourceRequest request) throws PluginContainerException {
            return null;
        }

        public DeleteResourceResponse executeDeleteResourceImmediately(DeleteResourceRequest request) throws PluginContainerException {
            return null;
        }
    }
}

