/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.test;

import javax.persistence.EntityManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.resource.group.ResourceGroupAlreadyExistsException;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupNotFoundException;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ResourceGroupManagerBeanTest
extends AbstractEJB3Test {
    private static ResourceGroupManagerLocal resourceGroupManager;

    @BeforeMethod
    private void init() {
        try {
            resourceGroupManager = LookupUtil.getResourceGroupManager();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.session"})
    public void testGetCompatibleGroupById() throws Exception {
        this.getTransactionManager().begin();
        try {
            EntityManager em = ResourceGroupManagerBeanTest.getEntityManager();
            ResourceType type = new ResourceType("type", "plugin", ResourceCategory.PLATFORM, null);
            Subject testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            Role testRole = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole");
            ResourceGroup compatGroup = new ResourceGroup("testCompatGroup", type);
            compatGroup.addRole(testRole);
            em.persist((Object)type);
            em.persist((Object)compatGroup);
            em.flush();
            testRole.addResourceGroup(compatGroup);
            em.merge((Object)testRole);
            em.flush();
            int id = compatGroup.getId();
            try {
                resourceGroupManager.getResourceGroupById(testSubject, id, null);
            }
            catch (ResourceGroupNotFoundException e) {
                assert (false) : "Could not find recently persisted compatible group by id";
            }
            catch (PermissionException se) {
                assert (false) : "Incorrect permissions when getting compatible group by id";
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.session"})
    public void testUpdateGroupDescription() throws Exception {
        this.getTransactionManager().begin();
        try {
            EntityManager em = ResourceGroupManagerBeanTest.getEntityManager();
            ResourceType type = new ResourceType("type", "plugin", ResourceCategory.PLATFORM, null);
            Subject testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            Role testRole = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole");
            testRole.addPermission(Permission.MANAGE_INVENTORY);
            ResourceGroup compatGroup = new ResourceGroup("group1", type);
            compatGroup.addRole(testRole);
            em.persist((Object)type);
            em.persist((Object)compatGroup);
            em.flush();
            testRole.addResourceGroup(compatGroup);
            em.merge((Object)testRole);
            em.flush();
            int id = compatGroup.getId();
            try {
                ResourceGroup oldGroup = resourceGroupManager.getResourceGroupById(testSubject, id, null);
                oldGroup.setDescription("new description goes here ");
                resourceGroupManager.updateResourceGroup(testSubject, oldGroup);
            }
            catch (ResourceGroupAlreadyExistsException rgaee) {
                ResourceGroupManagerBeanTest.fail((String)"ResourceGroupAlreadyExistsException should NOT have been thrown.");
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.session"})
    public void testUpdateGroupName() throws Exception {
        this.getTransactionManager().begin();
        try {
            EntityManager em = ResourceGroupManagerBeanTest.getEntityManager();
            ResourceType type = new ResourceType("type", "plugin", ResourceCategory.PLATFORM, null);
            Subject testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            Role testRole = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole");
            testRole.addPermission(Permission.MANAGE_INVENTORY);
            ResourceGroup compatGroup = new ResourceGroup("group1", type);
            compatGroup.addRole(testRole);
            em.persist((Object)type);
            em.persist((Object)compatGroup);
            em.flush();
            testRole.addResourceGroup(compatGroup);
            em.merge((Object)testRole);
            em.flush();
            int id = compatGroup.getId();
            try {
                ResourceGroup oldGroup = resourceGroupManager.getResourceGroupById(testSubject, id, null);
                oldGroup.setName("newGroup1");
                resourceGroupManager.updateResourceGroup(testSubject, oldGroup);
            }
            catch (ResourceGroupAlreadyExistsException rgaee) {
                ResourceGroupManagerBeanTest.fail((String)"ResourceGroupAlreadyExistsException should NOT have been thrown.");
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }
}

