/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.test;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceErrorType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.discovery.DiscoveryServerServiceImpl;
import org.rhq.enterprise.server.resource.metadata.test.UpdatePluginMetadataTestBase;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class ResourceManagerBeanTest
extends UpdatePluginMetadataTestBase {
    private Subject superuser;
    private Resource newResource;
    TestServerCommunicationsService agentServiceContainer;

    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.superuser = LookupUtil.getSubjectManager().getOverlord();
        this.newResource = this.createNewResourceWithNewType();
    }

    @Override
    @AfterMethod
    public void afterMethod() throws Exception {
        this.deleteNewResourceAgentResourceType(this.newResource);
    }

    public void testResourceErrors() {
        DiscoveryServerServiceImpl serverService = new DiscoveryServerServiceImpl();
        List errors = resourceManager.findResourceErrors(this.superuser, this.newResource.getId(), ResourceErrorType.INVALID_PLUGIN_CONFIGURATION);
        assert (errors.size() == 0);
        ResourceError error = new ResourceError(this.newResource, ResourceErrorType.INVALID_PLUGIN_CONFIGURATION, "test summary", "test detail", 12345L);
        serverService.setResourceError(error);
        errors = resourceManager.findResourceErrors(this.superuser, this.newResource.getId(), ResourceErrorType.INVALID_PLUGIN_CONFIGURATION);
        assert (errors.size() == 1);
        error = (ResourceError)errors.get(0);
        assert (error.getId() > 0);
        assert (error.getSummary().equals("test summary"));
        assert (error.getDetail().equals("test detail"));
        assert (error.getErrorType() == ResourceErrorType.INVALID_PLUGIN_CONFIGURATION);
        assert (error.getTimeOccurred() == 12345L);
        error.setId(0);
        error.setTimeOccurred(567890L);
        error.setSummary("another summary");
        error.setDetail("another detail");
        serverService.setResourceError(error);
        errors = resourceManager.findResourceErrors(this.superuser, this.newResource.getId(), ResourceErrorType.INVALID_PLUGIN_CONFIGURATION);
        assert (errors.size() == 1);
        error = (ResourceError)errors.get(0);
        assert (error.getId() > 0);
        assert (error.getSummary().equals("another summary"));
        assert (error.getDetail().equals("another detail"));
        assert (error.getErrorType() == ResourceErrorType.INVALID_PLUGIN_CONFIGURATION);
        assert (error.getTimeOccurred() == 567890L);
        resourceManager.deleteResourceError(this.superuser, error.getId());
        errors = resourceManager.findResourceErrors(this.superuser, this.newResource.getId(), ResourceErrorType.INVALID_PLUGIN_CONFIGURATION);
        assert (errors.size() == 0);
    }

    public void testResourceLineage() throws Exception {
        int leafResourceId = this.givenASampleResourceHierarchy();
        List resourceLineage = resourceManager.getResourceLineage(leafResourceId);
        ResourceManagerBeanTest.assertEquals((int)resourceLineage.size(), (int)4);
        StringBuilder stringBuilder = new StringBuilder();
        for (Resource resource : resourceLineage) {
            stringBuilder.append(resource.getName());
            if (resourceLineage.indexOf(resource) == resourceLineage.size() - 1) continue;
            stringBuilder.append("::");
        }
        System.err.println(stringBuilder.toString());
        for (int i = resourceLineage.size() - 1; i >= 0; --i) {
            this.deleteNewResourceAgentResourceType((Resource)resourceLineage.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int givenASampleResourceHierarchy() throws NotSupportedException, SystemException {
        this.getTransactionManager().begin();
        EntityManager em = ResourceManagerBeanTest.getEntityManager();
        int leafResourceId = 0;
        try {
            ResourceType platformType = this.createResourceType(em, "platform" + System.currentTimeMillis(), "test", null, ResourceCategory.PLATFORM);
            ResourceType appserverType = this.createResourceType(em, "jboss AS 5" + System.currentTimeMillis(), "jbossas5", platformType, ResourceCategory.SERVER);
            ResourceType jvmType = this.createResourceType(em, "JVM" + System.currentTimeMillis(), "jbossas5", appserverType, ResourceCategory.SERVICE);
            ResourceType memType = this.createResourceType(em, "Memory Subsystem" + System.currentTimeMillis(), "jbossas5", jvmType, ResourceCategory.SERVICE);
            Agent agent = new Agent("agent" + System.currentTimeMillis(), "host" + System.currentTimeMillis(), 1, "", "token" + System.currentTimeMillis());
            em.persist((Object)agent);
            em.flush();
            Resource platform = this.createResource(em, platformType, agent, "platformKey" + System.currentTimeMillis(), "host.dev.corp", null);
            Resource appserver = this.createResource(em, appserverType, agent, "JEAP" + System.currentTimeMillis(), "JBOSS EAP 5.1.1", platform);
            Resource jvm = this.createResource(em, jvmType, agent, "jvm" + System.currentTimeMillis(), "JBoss AS JVM", appserver);
            Resource memSubystem = this.createResource(em, memType, agent, "mem" + System.currentTimeMillis(), "Memory Subsystem", jvm);
            leafResourceId = memSubystem.getId();
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            try {
                System.out.println("CANNOT Prepare TEST: Cause: " + e);
                this.getTransactionManager().rollback();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        finally {
            em.close();
        }
        return leafResourceId;
    }

    private Resource createResource(EntityManager em, ResourceType platformType, Agent agent, String resourceKey, String resourceName, Resource parent) {
        Resource resource = new Resource(resourceKey, resourceName, platformType);
        resource.setUuid(UUID.randomUUID().toString());
        resource.setAgent(agent);
        resource.setParentResource(parent);
        em.persist((Object)resource);
        return resource;
    }

    private ResourceType createResourceType(EntityManager em, String name, String pluginName, ResourceType parentResourceType, ResourceCategory resourceCategory) {
        ResourceType platformType;
        ResourceType resourceType = platformType = new ResourceType(name, pluginName, resourceCategory, parentResourceType);
        em.persist((Object)resourceType);
        return resourceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource createNewResourceWithNewType() throws Exception {
        Resource resource;
        this.getTransactionManager().begin();
        EntityManager em = ResourceManagerBeanTest.getEntityManager();
        try {
            try {
                ResourceType resourceType = new ResourceType("plat" + System.currentTimeMillis(), "test", ResourceCategory.PLATFORM, null);
                em.persist((Object)resourceType);
                Agent agent = new Agent("testagent", "testaddress", 16163, "", "testtoken");
                em.persist((Object)agent);
                em.flush();
                resource = new Resource("reskey" + System.currentTimeMillis(), "resname", resourceType);
                resource.setUuid("" + new Random().nextInt());
                resource.setAgent(agent);
                em.persist((Object)resource);
            }
            catch (Exception e) {
                System.out.println("CANNOT PREPARE TEST: " + e);
                this.getTransactionManager().rollback();
                throw e;
            }
            this.getTransactionManager().commit();
        }
        finally {
            em.close();
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNewResourceAgentResourceType(Resource resource) throws Exception {
        if (resource != null) {
            this.getTransactionManager().begin();
            EntityManager em = ResourceManagerBeanTest.getEntityManager();
            try {
                Resource res = (Resource)em.find(Resource.class, (Object)resource.getId());
                System.out.println("Removing " + res + "...");
                List deletedIds = resourceManager.uninventoryResource(this.superuser, res.getId());
                for (Integer deletedResourceId : deletedIds) {
                    resourceManager.uninventoryResourceAsyncWork(this.superuser, deletedResourceId.intValue());
                }
                em.flush();
                ResourceType type = (ResourceType)em.find(ResourceType.class, (Object)resource.getResourceType().getId());
                System.out.println("Removing " + type + "...");
                em.remove((Object)type);
                em.flush();
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                try {
                    System.out.println("CANNOT CLEAN UP TEST: Cause: " + e);
                    this.getTransactionManager().rollback();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            finally {
                em.close();
            }
        }
    }
}

