/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.test;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceComposite;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.composite.ResourceGroupComposite;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerBean;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.resource.ResourceManagerBean;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.test.ResourceWithStatus;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class ResourceStorageTest
extends AbstractEJB3Test {
    private Log log = LogFactory.getLog(ResourceStorageTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindResourceComposite() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = ResourceStorageTest.getEntityManager();
        try {
            ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            PageControl pc = new PageControl(1, 5, new OrderingField[]{new OrderingField("res.name", PageOrdering.ASC)});
            Subject subject = subjectManager.loginUnauthenticated("ghinkle");
            subject = this.createSession(subject);
            ResourceType t = (ResourceType)em.getReference(ResourceType.class, (Object)new Integer(501064));
            String typeNameFilter = t == null ? null : t.getName();
            PageList resources = resourceManager.findResourceComposites(subject, ResourceCategory.SERVER, typeNameFilter, null, null, "g", false, pc);
            System.out.println("Found resource composites: " + resources.size());
            for (ResourceComposite resourceComposite : resources) {
                System.out.println("\t" + resourceComposite);
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBindOrderBy() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = ResourceStorageTest.getEntityManager();
        try {
            this.log.error((Object)"QUERY TEST!!");
            Query q = em.createQuery("SELECT r FROM Resource r ORDER BY :col");
            q.setParameter("col", (Object)"r.name desc");
            List resources = q.getResultList();
            System.out.println("Sorted resources: ");
            for (Resource r : resources) {
                System.out.println("\t" + r);
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.ejb3"})
    public void testMixedGroupCompositeQuery() throws Exception {
        this.getTransactionManager().begin();
        try {
            ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            PageControl pc = new PageControl(1, 5, new OrderingField[]{new OrderingField("rg.name", PageOrdering.ASC)});
            Subject subject = subjectManager.getOverlord();
            subject = this.createSession(subject);
            PageList groups = groupManager.findResourceGroupComposites(subject, GroupCategory.MIXED, null, null, null, null, null, null, pc);
            System.out.println("Found mixed groups: " + groups.size());
            for (ResourceGroupComposite group : groups) {
                System.out.println("\t" + group);
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.ejb3"})
    public void testCompatibleGroupCompositeQuery() throws Exception {
        this.getTransactionManager().begin();
        try {
            ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            PageControl pc = new PageControl(1, 5, new OrderingField[]{new OrderingField("rg.name", PageOrdering.ASC)});
            PageList groups = groupManager.findResourceGroupComposites(subjectManager.getOverlord(), GroupCategory.COMPATIBLE, null, null, null, null, null, null, pc);
            System.out.println("Found compatible groups: " + groups.getTotalSize());
            for (ResourceGroupComposite group : groups) {
                System.out.println("\t" + group);
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.ejb3"})
    public void testConstructorQuery() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = ResourceStorageTest.getEntityManager();
        try {
            Query q = em.createQuery("SELECT new org.rhq.enterprise.server.resource.test.ResourceWithStatus(a.availabilityType,r) FROM Resource r, Availability a WHERE r.id = a.resource.id AND  a.startTime = (SELECT MAX(aa.startTime) FROM Availability aa WHERE aa.resource.id = r.id)");
            List resourceWithStatuses = q.getResultList();
            for (ResourceWithStatus r : resourceWithStatuses) {
                System.out.println(r.getAvailabilityType() + " - " + r.getResource().getName());
                System.out.println("\tchildren: " + r.getResource().getChildResources().size());
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.ejb3"})
    public void getDeadResources() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = ResourceStorageTest.getEntityManager();
        try {
            Query q = em.createQuery("SELECT new org.rhq.enterprise.server.resource.test.ResourceWithStatus(a.availabilityType,r) FROM Resource r, Availability a WHERE r.id = a.resource.id AND a.availabilityType = 1 AND  a.startTime = (SELECT MAX(aa.startTime) FROM Availability aa WHERE aa.resource.id = r.id)");
            List resourceWithStatuses = q.getResultList();
            System.out.println("Resource currently down");
            for (ResourceWithStatus r : resourceWithStatuses) {
                System.out.println(r.getAvailabilityType() + " - " + r.getResource().getName());
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.ejb3"})
    public void discoveryQueueTest() throws Exception {
        this.getTransactionManager().begin();
        try {
            DiscoveryBossLocal discoveryBoss = LookupUtil.getDiscoveryBoss();
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            Subject rhqadmin = subjectManager.loginUnauthenticated("rhqadmin");
            rhqadmin = this.createSession(rhqadmin);
            Map queue = discoveryBoss.getQueuedPlatformsAndServers(rhqadmin, PageControl.getUnlimitedInstance());
            for (Resource root : queue.keySet()) {
                System.out.println("Queue root resource: " + root);
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    @Test(groups={"integration.ejb3"})
    public void resourceTest() throws Exception {
        System.out.println("foo");
        ResourceManagerLocal resourceManager = (ResourceManagerLocal)ResourceStorageTest.getInitialContext().lookup(ResourceManagerBean.class.getSimpleName() + "/local");
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        AuthorizationManagerLocal authorizationManager = (AuthorizationManagerLocal)ResourceStorageTest.getInitialContext().lookup(AuthorizationManagerBean.class.getSimpleName() + "/local");
        Subject rhqadmin = subjectManager.loginUnauthenticated("rhqadmin");
        System.out.println(rhqadmin);
    }
}

