/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.HashSet;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.rhq.core.domain.content.Repo;
import org.rhq.enterprise.server.scheduler.jobs.RepoSyncJob;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RepoSyncJobTest
extends AbstractEJB3Test {
    private static final boolean ENABLED = true;

    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.prepareScheduler();
        this.prepareForTestAgents();
    }

    @AfterMethod
    public void afterMethod() throws Exception {
        this.unprepareForTestAgents();
        this.unprepareScheduler();
    }

    @Test(enabled=true)
    public void createJobDataMap() throws Exception {
        String repoName = "testRepo";
        Repo repo = new Repo(repoName);
        JobDataMap existingMap = new JobDataMap();
        JobDetail detail = new JobDetail();
        detail.setJobDataMap(existingMap);
        JobDataMap nullDetailsMap = RepoSyncJob.createJobDataMap(null, (Repo)repo);
        JobDataMap existingDetailsMap = RepoSyncJob.createJobDataMap((JobDetail)detail, (Repo)repo);
        assert (nullDetailsMap.getString("repoName").equals(repoName));
        assert (existingDetailsMap.getString("repoName").equals(repoName));
        assert (existingDetailsMap == existingMap);
    }

    @Test(enabled=true)
    public void createJobName() throws Exception {
        Repo repo = new Repo("testRepo");
        HashSet<String> jobNames = new HashSet<String>(1);
        jobNames.add(RepoSyncJob.createJobName((Repo)repo));
        jobNames.add(RepoSyncJob.createJobName((Repo)repo));
        jobNames.add(RepoSyncJob.createJobName((Repo)repo));
        jobNames.add(RepoSyncJob.createJobName((Repo)repo));
        jobNames.add(RepoSyncJob.createJobName((Repo)repo));
        assert (jobNames.size() == 1) : "Number of jobs found: " + jobNames.size();
    }

    @Test(enabled=true)
    public void createUniqueJobName() throws Exception {
        Repo repo = new Repo("testRepo");
        HashSet<String> jobNames = new HashSet<String>(1);
        jobNames.add(RepoSyncJob.createUniqueJobName((Repo)repo));
        Thread.sleep(100L);
        jobNames.add(RepoSyncJob.createUniqueJobName((Repo)repo));
        Thread.sleep(100L);
        jobNames.add(RepoSyncJob.createUniqueJobName((Repo)repo));
        Thread.sleep(100L);
        jobNames.add(RepoSyncJob.createUniqueJobName((Repo)repo));
        Thread.sleep(100L);
        jobNames.add(RepoSyncJob.createUniqueJobName((Repo)repo));
        assert (jobNames.size() == 5) : "Number of jobs found: " + jobNames.size();
    }
}

