/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.core.domain.search.SearchSuggestion;
import org.rhq.enterprise.server.search.TestAutoCompletionManager;
import org.rhq.enterprise.server.search.execution.SearchAssistManager;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class GenericSearchAssistTest
extends AbstractEJB3Test {
    @Test
    public void testGenericAssist() throws Exception {
        BufferedReader reader = null;
        try {
            InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test-assist-color-number.txt");
            reader = new BufferedReader(new InputStreamReader(stream));
            String expression = null;
            String expected = null;
            int count = 0;
            while ((expression = reader.readLine()) != null && (expected = reader.readLine()) != null) {
                ++count;
                List results = new TestAutoCompletionManager().getAdvancedSuggestions(expression, expression.length(), null);
                List<String> expectedResults = Arrays.asList(expected.split(" "));
                System.out.println();
                System.out.println("Expression: " + expression);
                try {
                    this.compare(results, expectedResults);
                    System.out.println("Assist worked: " + this.parenthesize(expectedResults.toString()));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            System.out.println("Tested " + count + " expressions for assist");
        }
        catch (Exception e) {
            System.out.println("Error testing GenericSearchAssistTest: " + e);
            e.printStackTrace(System.out);
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    public void test2() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        SearchAssistManager mgr = new SearchAssistManager(overlord, SearchSubsystem.RESOURCE);
        List suggestions = mgr.getSuggestions("category=PLATFORM", 0);
        System.out.println("Number of suggestions: " + suggestions.size());
        for (SearchSuggestion s : suggestions) {
            System.out.println(s);
        }
    }

    private void compare(List<SearchSuggestion> results, List<String> expected) {
        ArrayList<String> rawResults = new ArrayList<String>();
        for (SearchSuggestion suggestion : results) {
            rawResults.add(suggestion.getValue());
        }
        Collections.sort(rawResults);
        Collections.sort(expected);
        assert (rawResults.size() == expected.size()) : this.print(expected, rawResults);
        for (int i = 0; i < rawResults.size(); ++i) {
            String nextRaw = (String)rawResults.get(i);
            String nextExpected = expected.get(i);
            assert (nextRaw.equals(nextExpected)) : this.print(expected, rawResults);
        }
    }

    private String print(List<String> expected, List<String> results) {
        return "expected" + this.parenthesize(expected.toString()) + ", results" + this.parenthesize(results.toString());
    }

    private String parenthesize(String data) {
        return "(" + data.substring(1, data.length() - 1) + ")";
    }

    public static void main(String[] args) throws Exception {
        new GenericSearchAssistTest().testGenericAssist();
    }
}

