/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jmock.Expectations;
import org.jmock.api.Action;
import org.jmock.internal.ExpectationBuilder;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.enterprise.server.sync.ExportReader;
import org.rhq.enterprise.server.sync.ExportWriter;
import org.rhq.enterprise.server.sync.ExportingInputStream;
import org.rhq.enterprise.server.sync.NoSingleEntity;
import org.rhq.enterprise.server.sync.Synchronizer;
import org.rhq.enterprise.server.sync.exporters.AbstractDelegatingExportingIterator;
import org.rhq.enterprise.server.sync.exporters.Exporter;
import org.rhq.enterprise.server.sync.exporters.ExportingIterator;
import org.rhq.enterprise.server.sync.importers.ExportedEntityMatcher;
import org.rhq.enterprise.server.sync.importers.Importer;
import org.rhq.enterprise.server.sync.validators.ConsistencyValidator;
import org.rhq.enterprise.server.sync.validators.EntityValidator;
import org.rhq.test.JMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Test
public class ExportingInputStreamTest
extends JMockTest {
    private static final Log LOG = LogFactory.getLog(ExportingInputStreamTest.class);

    public void testSucessfulExport() throws Exception {
        List<String> list1 = Arrays.asList("a", "b", "c");
        List<Integer> list2 = Arrays.asList(1, 2, 3);
        StringListSynchronizer ex1 = new StringListSynchronizer(list1);
        IntegerListSynchronizer ex2 = new IntegerListSynchronizer(list2);
        LinkedHashSet<Synchronizer> exporters = this.asSet(ex1, ex2);
        ExportingInputStream export = new ExportingInputStream(exporters, new HashMap(), 1024, false);
        DocumentBuilder bld = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = bld.parse((InputStream)export);
        Element root = doc.getDocumentElement();
        Assert.assertEquals((String)"configuration-export", (String)root.getNodeName());
        NodeList entities = root.getElementsByTagName("entities");
        Assert.assertEquals((int)entities.getLength(), (int)2, (String)"Unexpected number of entities elements");
        Element export1 = (Element)entities.item(0);
        Element export2 = (Element)entities.item(1);
        Assert.assertEquals((String)export1.getAttribute("id"), (String)StringListSynchronizer.class.getName());
        Assert.assertEquals((String)export2.getAttribute("id"), (String)IntegerListSynchronizer.class.getName());
        String[] expectedNotes = new String[]{list1.toString(), list2.toString()};
        int elementIndex = 0;
        for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
            Node node = root.getChildNodes().item(i);
            if (!(node instanceof Element)) continue;
            Element entitiesElement = (Element)node;
            Assert.assertEquals((String)entitiesElement.getNodeName(), (String)"entities");
            NodeList errorMessages = entitiesElement.getElementsByTagName("error-message");
            Assert.assertEquals((int)errorMessages.getLength(), (int)0, (String)"Unexpected number of error message elements in an entities export.");
            Node note = ExportingInputStreamTest.getDirectChildByTagName(entitiesElement, "notes");
            Assert.assertNotNull((Object)note, (String)"Couldn't find exporter notes.");
            String notesText = ((Element)note).getTextContent();
            Assert.assertEquals((String)notesText, (String)expectedNotes[elementIndex], (String)"Unexpected notes for entities.");
            NodeList entityElements = entitiesElement.getElementsByTagName("entity");
            Assert.assertEquals((int)entityElements.getLength(), (int)3, (String)"Unexpected number of exported entities.");
            for (int j = 0; j < entityElements.getLength(); ++j) {
                Element entityElement = (Element)entityElements.item(j);
                errorMessages = entityElement.getElementsByTagName("error-message");
                Assert.assertEquals((int)errorMessages.getLength(), (int)0, (String)"Unexpected number of error message elements in an entity.");
                note = ExportingInputStreamTest.getDirectChildByTagName(entityElement, "notes");
                Assert.assertNotNull((Object)note, (String)"Could not find notes for an exported entity.");
                Node data = ExportingInputStreamTest.getDirectChildByTagName(entityElement, "data");
                Assert.assertNotNull((Object)data, (String)"Could not find data element in the entity.");
                String dataText = ((Element)data).getTextContent();
                notesText = ((Element)note).getTextContent();
                Assert.assertEquals((String)notesText, (String)("Wow, I just exported an item from a list: " + dataText), (String)"Unexpected discrepancy between data and notes in the export.");
            }
            ++elementIndex;
        }
    }

    @Test(expectedExceptions={IOException.class})
    public void testExceptionHandling_Exporter_getExportingIterator() throws Exception {
        final Exporter failingExporter = (Exporter)this.context.mock(Exporter.class);
        final Synchronizer syncer = (Synchronizer)this.context.mock(Synchronizer.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                RuntimeException failure = new RuntimeException("Injected failure");
                ((Exporter)this.allowing(failingExporter)).getExportingIterator();
                this.will(1.throwException((Throwable)failure));
                ((Synchronizer)this.allowing(syncer)).getRequiredValidators();
                this.will(1.returnValue(Collections.emptySet()));
                ((Synchronizer)this.allowing(syncer)).getExporter();
                this.will(1.returnValue((Object)failingExporter));
            }
        });
        LinkedHashSet<Synchronizer> syncers = this.asSet(syncer);
        ExportingInputStream export = new ExportingInputStream(syncers, new HashMap(), 1024, false);
        ExportingInputStreamTest.readAll(new InputStreamReader((InputStream)export, "UTF-8"));
        Assert.fail((String)"Successfully read the export even though one of the exporters threw an exception when asked for the exported entity iterator.");
    }

    @Test(expectedExceptions={IOException.class})
    public void testExceptionHandling_ExportingIterator_next() throws Exception {
        final ExportingIterator iterator = (ExportingIterator)this.context.mock(ExportingIterator.class);
        final Exporter exporter = (Exporter)this.context.mock(Exporter.class);
        final Importer importer = (Importer)this.context.mock(Importer.class);
        final Synchronizer syncer = (Synchronizer)this.context.mock(Synchronizer.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                RuntimeException failure = new RuntimeException("Injected failure");
                ((ExportingIterator)this.allowing(iterator)).hasNext();
                this.will(2.returnValue((Object)true));
                ((ExportingIterator)this.allowing(iterator)).next();
                this.will(2.onConsecutiveCalls((Action[])new Action[]{2.returnValue((Object)"Success"), 2.throwException((Throwable)failure)}));
                ((ExportingIterator)this.allowing(iterator)).export((ExportWriter)this.with(2.any(ExportWriter.class)));
                ((ExportingIterator)this.allowing(iterator)).getNotes();
                ((Exporter)this.allowing(exporter)).getExportingIterator();
                this.will(2.returnValue((Object)iterator));
                ((Exporter)this.allowing(exporter)).getNotes();
                ((Synchronizer)this.allowing(syncer)).getRequiredValidators();
                this.will(2.returnValue(Collections.emptySet()));
                ((Synchronizer)this.allowing(syncer)).getExporter();
                this.will(2.returnValue((Object)exporter));
                ((Synchronizer)this.allowing(syncer)).getImporter();
                this.will(2.returnValue((Object)importer));
                ((Importer)this.allowing(importer)).getImportConfigurationDefinition();
            }
        });
        LinkedHashSet<Synchronizer> syncers = this.asSet(syncer);
        ExportingInputStream export = new ExportingInputStream(syncers, new HashMap(), 1024, false);
        ExportingInputStreamTest.readAll(new InputStreamReader((InputStream)export, "UTF-8"));
        Assert.fail((String)"Successfully read the export even though one of the exporters threw an exception when asked for the next exported entity.");
    }

    public void testExceptionHandling_ExportingIterator_export() throws Exception {
        final ExportingIterator iterator = (ExportingIterator)this.context.mock(ExportingIterator.class);
        final Exporter exporter = (Exporter)this.context.mock(Exporter.class);
        final Importer importer = (Importer)this.context.mock(Importer.class);
        final Synchronizer syncer = (Synchronizer)this.context.mock(Synchronizer.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                RuntimeException failure = new RuntimeException("Injected failure");
                ((ExportingIterator)this.allowing(iterator)).hasNext();
                this.will(3.onConsecutiveCalls((Action[])new Action[]{3.returnValue((Object)true), 3.returnValue((Object)true), 3.returnValue((Object)false)}));
                ((ExportingIterator)this.allowing(iterator)).next();
                ((ExportingIterator)this.allowing(iterator)).export((ExportWriter)this.with(3.any(ExportWriter.class)));
                this.will(3.onConsecutiveCalls((Action[])new Action[]{3.returnValue(null), 3.throwException((Throwable)failure)}));
                ((ExportingIterator)this.allowing(iterator)).getNotes();
                ((Exporter)this.allowing(exporter)).getExportingIterator();
                this.will(3.returnValue((Object)iterator));
                ((Exporter)this.allowing(exporter)).getNotes();
                ((Synchronizer)this.allowing(syncer)).getRequiredValidators();
                this.will(3.returnValue(Collections.emptySet()));
                ((Synchronizer)this.allowing(syncer)).getExporter();
                this.will(3.returnValue((Object)exporter));
                ((Synchronizer)this.allowing(syncer)).getImporter();
                this.will(3.returnValue((Object)importer));
                ((Importer)this.allowing(importer)).getImportConfigurationDefinition();
            }
        });
        LinkedHashSet<Synchronizer> syncers = this.asSet(syncer);
        Object export = new ExportingInputStream(syncers, new HashMap(), 1024, false);
        String exportContents = ExportingInputStreamTest.readAll(new InputStreamReader((InputStream)export, "UTF-8"));
        LOG.warn((Object)("Export contents:\n" + exportContents));
        export = new ByteArrayInputStream(exportContents.getBytes("UTF-8"));
        DocumentBuilder bld = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = bld.parse((InputStream)export);
        Element root = doc.getDocumentElement();
        NodeList entities = root.getElementsByTagName("entity");
        Assert.assertEquals((int)entities.getLength(), (int)2, (String)"Unexpected number of exported elements");
        Element failedEntity = (Element)entities.item(1);
        Node errorMessage = ExportingInputStreamTest.getDirectChildByTagName(failedEntity, "error-message");
        Assert.assertNotNull((Object)errorMessage, (String)"Could not find the error-message element at the entity that failed to export.");
    }

    private <T> LinkedHashSet<T> asSet(T ... ts) {
        LinkedHashSet<T> ret = new LinkedHashSet<T>();
        for (T t : ts) {
            ret.add(t);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readAll(Reader rdr) throws IOException {
        try {
            int c;
            StringBuilder bld = new StringBuilder();
            while ((c = rdr.read()) != -1) {
                bld.append((char)c);
            }
            String string = bld.toString();
            return string;
        }
        finally {
            rdr.close();
        }
    }

    private static Node getDirectChildByTagName(Node node, String tagName) {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node n = node.getChildNodes().item(i);
            if (!n.getNodeName().equals(tagName)) continue;
            return n;
        }
        return null;
    }

    private static class IntegerListSynchronizer
    extends ListToStringSynchronizer<Integer> {
        public IntegerListSynchronizer(List<Integer> list) {
            super(list);
        }
    }

    private static class StringListSynchronizer
    extends ListToStringSynchronizer<String> {
        public StringListSynchronizer(List<String> list) {
            super(list);
        }
    }

    private static class ListToStringSynchronizer<T>
    implements Synchronizer<NoSingleEntity, T> {
        private List<T> list;

        public ListToStringSynchronizer(List<T> list) {
            this.list = list;
        }

        public Exporter<NoSingleEntity, T> getExporter() {
            return new ListToStringExporter<T>(this.list);
        }

        public Importer<NoSingleEntity, T> getImporter() {
            return new DummyImporter();
        }

        public Set<ConsistencyValidator> getRequiredValidators() {
            return Collections.emptySet();
        }

        public void initialize(Subject subject, EntityManager entityManager) {
        }
    }

    private static class DummyImporter<T>
    implements Importer<NoSingleEntity, T> {
        private DummyImporter() {
        }

        public ConfigurationDefinition getImportConfigurationDefinition() {
            return null;
        }

        public void configure(Configuration importConfiguration) {
        }

        public ExportedEntityMatcher<NoSingleEntity, T> getExportedEntityMatcher() {
            return null;
        }

        public void update(NoSingleEntity entity, T exportedEntity) throws Exception {
        }

        public T unmarshallExportedEntity(ExportReader reader) throws XMLStreamException {
            return null;
        }

        public String finishImport() throws Exception {
            return null;
        }

        public Set<EntityValidator<T>> getEntityValidators() {
            return Collections.emptySet();
        }
    }

    private static class ListToStringExporter<T>
    implements Exporter<NoSingleEntity, T> {
        List<T> valuesToExport;
        public static final String NOTE_PREFIX = "Wow, I just exported an item from a list: ";

        public ListToStringExporter(List<T> valuesToExport) {
            this.valuesToExport = valuesToExport;
        }

        public ExportingIterator<T> getExportingIterator() {
            return new Iterator();
        }

        public String getNotes() {
            return this.valuesToExport.toString();
        }

        private class Iterator
        extends AbstractDelegatingExportingIterator<T, T> {
            public Iterator() {
                super(ListToStringExporter.this.valuesToExport.iterator());
            }

            public void export(ExportWriter output) throws XMLStreamException {
                output.writeCData(this.getCurrent().toString());
            }

            public String getNotes() {
                return ListToStringExporter.NOTE_PREFIX + this.getCurrent();
            }

            protected T convert(T object) {
                return object;
            }
        }
    }
}

