/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.sync.entity.MetricTemplate;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.sync.importers.ExportedEntityMatcher;
import org.rhq.enterprise.server.sync.importers.MetricTemplateImporter;
import org.rhq.test.JMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class MetricTemplateImporterTest
extends JMockTest {
    private static final ResourceType FAKE_RESOURCE_TYPE = new ResourceType("fake", "fake", ResourceCategory.PLATFORM, null);

    public void testNonMatchingMeasurementDefinitionsAreIgnored() {
        final TestPrerequisities prereqs = new TestPrerequisities(this.context);
        MeasurementDefinition def = new MeasurementDefinition(FAKE_RESOURCE_TYPE, "fake");
        def.setId(1);
        def.setDefaultOn(true);
        def.setDefaultInterval(1000L);
        prereqs.setMeasurementDefinitions(Collections.singletonList(def));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                prereqs.addExpectations(this);
                MeasurementScheduleManagerLocal msm = prereqs.getMeasurementScheduleManager();
                ((MeasurementScheduleManagerLocal)this.one(msm)).updateDefaultCollectionIntervalAndEnablementForMeasurementDefinitions((Subject)this.with(1.any(Subject.class)), (int[])this.with(new int[]{1}), this.with(1000L), this.with(true), this.with(false));
            }
        });
        MetricTemplateImporter importer = new MetricTemplateImporter(null, prereqs.getEntityManager(), prereqs.getMeasurementScheduleManager());
        MetricTemplate nonMatching = new MetricTemplate();
        nonMatching.setResourceTypeName("asf");
        nonMatching.setResourceTypePlugin("asfd");
        nonMatching.setMetricName("asf");
        MetricTemplate matching = new MetricTemplate(def);
        importer.configure(null);
        ExportedEntityMatcher matcher = importer.getExportedEntityMatcher();
        Assert.assertNull((Object)matcher.findMatch((Object)nonMatching), (String)"The non-matching metric template shouldn't have been matched.");
        Assert.assertSame((Object)matcher.findMatch((Object)matching), (Object)def, (String)"The matching metric template should have found the defined measurement definition");
        importer.update(null, nonMatching);
        importer.update(def, matching);
        importer.finishImport();
    }

    public void testCanUpdateEnablements() {
        MeasurementDefinition defToEnable = new MeasurementDefinition(FAKE_RESOURCE_TYPE, "enabled");
        MeasurementDefinition defToDisable = new MeasurementDefinition(FAKE_RESOURCE_TYPE, "disable");
        defToEnable.setId(1);
        defToEnable.setDefaultOn(true);
        defToEnable.setDefaultInterval(1000L);
        defToDisable.setId(2);
        defToDisable.setDefaultOn(false);
        defToDisable.setDefaultInterval(2000L);
        final TestPrerequisities prereqs = new TestPrerequisities(this.context);
        prereqs.setMeasurementDefinitions(Arrays.asList(defToEnable, defToDisable));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                prereqs.addExpectations(this);
                MeasurementScheduleManagerLocal msm = prereqs.getMeasurementScheduleManager();
                ((MeasurementScheduleManagerLocal)this.one(msm)).updateDefaultCollectionIntervalAndEnablementForMeasurementDefinitions((Subject)this.with(2.any(Subject.class)), (int[])this.with(new int[]{1}), this.with(1000L), this.with(true), this.with(false));
                ((MeasurementScheduleManagerLocal)this.one(msm)).updateDefaultCollectionIntervalAndEnablementForMeasurementDefinitions((Subject)this.with(2.any(Subject.class)), (int[])this.with(new int[]{2}), this.with(2000L), this.with(false), this.with(false));
            }
        });
        MetricTemplateImporter importer = new MetricTemplateImporter(null, prereqs.getEntityManager(), prereqs.getMeasurementScheduleManager());
        importer.configure(null);
        ExportedEntityMatcher matcher = importer.getExportedEntityMatcher();
        MetricTemplate match1 = new MetricTemplate(defToEnable);
        MetricTemplate match2 = new MetricTemplate(defToDisable);
        Assert.assertSame((Object)matcher.findMatch((Object)match1), (Object)defToEnable, (String)"The matching metric template should have found the defined measurement definition");
        Assert.assertSame((Object)matcher.findMatch((Object)match2), (Object)defToDisable, (String)"The matching metric template should have found the defined measurement definition");
        importer.update(defToEnable, match1);
        importer.update(defToDisable, match2);
        importer.finishImport();
    }

    public void testCanUpdateSchedules() {
        MeasurementDefinition def = new MeasurementDefinition(FAKE_RESOURCE_TYPE, "def");
        def.setId(1);
        def.setDefaultOn(true);
        def.setDefaultInterval(1000L);
        final TestPrerequisities prereqs = new TestPrerequisities(this.context);
        prereqs.setMeasurementDefinitions(Collections.singletonList(def));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                prereqs.addExpectations(this);
                MeasurementScheduleManagerLocal msm = prereqs.getMeasurementScheduleManager();
                ((MeasurementScheduleManagerLocal)this.one(msm)).updateDefaultCollectionIntervalAndEnablementForMeasurementDefinitions((Subject)this.with(3.any(Subject.class)), (int[])this.with(new int[]{1}), this.with(1000L), this.with(true), this.with(true));
            }
        });
        MetricTemplateImporter importer = new MetricTemplateImporter(null, prereqs.getEntityManager(), prereqs.getMeasurementScheduleManager());
        Configuration importConfig = new Configuration();
        importConfig.put((Property)new PropertySimple("updateAllSchedules", (Object)true));
        importer.configure(importConfig);
        ExportedEntityMatcher matcher = importer.getExportedEntityMatcher();
        MetricTemplate template = new MetricTemplate(def);
        Assert.assertSame((Object)matcher.findMatch((Object)template), (Object)def, (String)"The matching metric template should have found the defined measurement definition");
        importer.update(def, template);
        importer.finishImport();
    }

    public void testPerMetricUpdateScheduleOverrides() {
        MeasurementDefinition updatedDef = new MeasurementDefinition(FAKE_RESOURCE_TYPE, "def");
        updatedDef.setId(1);
        updatedDef.setDefaultOn(true);
        updatedDef.setDefaultInterval(1000L);
        MeasurementDefinition notUpdatedDef = new MeasurementDefinition(FAKE_RESOURCE_TYPE, "ndef");
        notUpdatedDef.setId(2);
        notUpdatedDef.setDefaultOn(true);
        notUpdatedDef.setDefaultInterval(2000L);
        final TestPrerequisities prereqs = new TestPrerequisities(this.context);
        prereqs.setMeasurementDefinitions(Arrays.asList(updatedDef, notUpdatedDef));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                prereqs.addExpectations(this);
                MeasurementScheduleManagerLocal msm = prereqs.getMeasurementScheduleManager();
                ((MeasurementScheduleManagerLocal)this.one(msm)).updateDefaultCollectionIntervalAndEnablementForMeasurementDefinitions((Subject)this.with(4.any(Subject.class)), (int[])this.with(new int[]{1}), this.with(1000L), this.with(true), this.with(true));
                ((MeasurementScheduleManagerLocal)this.one(msm)).updateDefaultCollectionIntervalAndEnablementForMeasurementDefinitions((Subject)this.with(4.any(Subject.class)), (int[])this.with(new int[]{2}), this.with(2000L), this.with(true), this.with(false));
            }
        });
        MetricTemplateImporter importer = new MetricTemplateImporter(null, prereqs.getEntityManager(), prereqs.getMeasurementScheduleManager());
        Configuration importConfig = new Configuration();
        importConfig.put((Property)new PropertySimple("updateAllSchedules", (Object)false));
        PropertyList list = new PropertyList("metricUpdateOverrides");
        importConfig.put((Property)list);
        PropertyMap map = new PropertyMap("metricUpdateOverride");
        list.add((Property)map);
        map.put((Property)new PropertySimple("metricName", (Object)"def"));
        map.put((Property)new PropertySimple("resourceTypeName", (Object)FAKE_RESOURCE_TYPE.getName()));
        map.put((Property)new PropertySimple("resourceTypePlugin", (Object)FAKE_RESOURCE_TYPE.getPlugin()));
        map.put((Property)new PropertySimple("updateSchedules", (Object)true));
        importer.configure(importConfig);
        ExportedEntityMatcher matcher = importer.getExportedEntityMatcher();
        MetricTemplate template1 = new MetricTemplate(updatedDef);
        MetricTemplate template2 = new MetricTemplate(notUpdatedDef);
        Assert.assertSame((Object)matcher.findMatch((Object)template1), (Object)updatedDef, (String)"The matching metric template should have found the defined measurement definition");
        Assert.assertSame((Object)matcher.findMatch((Object)template2), (Object)notUpdatedDef, (String)"The matching metric template should have found the defined measurement definition");
        importer.update(updatedDef, template1);
        importer.update(notUpdatedDef, template2);
        importer.finishImport();
    }

    public void testNullConfigurationInterpretedAsDefault() {
        this.testNonMatchingMeasurementDefinitionsAreIgnored();
    }

    public void testDistinguishingBetweenNormalAndPerMinuteTemplates() {
        MeasurementDefinition normalDef = new MeasurementDefinition(FAKE_RESOURCE_TYPE, "def");
        MeasurementDefinition perMinuteDef = new MeasurementDefinition(FAKE_RESOURCE_TYPE, "def");
        normalDef.setId(1);
        normalDef.setDefaultOn(true);
        normalDef.setDefaultInterval(1000L);
        perMinuteDef.setId(2);
        perMinuteDef.setDefaultOn(false);
        perMinuteDef.setDefaultInterval(2000L);
        perMinuteDef.setRawNumericType(NumericType.TRENDSUP);
        final TestPrerequisities prereqs = new TestPrerequisities(this.context);
        prereqs.setMeasurementDefinitions(Arrays.asList(normalDef, perMinuteDef));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                prereqs.addExpectations(this);
                MeasurementScheduleManagerLocal msm = prereqs.getMeasurementScheduleManager();
                ((MeasurementScheduleManagerLocal)this.one(msm)).updateDefaultCollectionIntervalAndEnablementForMeasurementDefinitions((Subject)this.with(5.any(Subject.class)), (int[])this.with(new int[]{1}), this.with(1000L), this.with(true), this.with(false));
                ((MeasurementScheduleManagerLocal)this.one(msm)).updateDefaultCollectionIntervalAndEnablementForMeasurementDefinitions((Subject)this.with(5.any(Subject.class)), (int[])this.with(new int[]{2}), this.with(2000L), this.with(false), this.with(false));
            }
        });
        MetricTemplateImporter importer = new MetricTemplateImporter(null, prereqs.getEntityManager(), prereqs.getMeasurementScheduleManager());
        importer.configure(null);
        ExportedEntityMatcher matcher = importer.getExportedEntityMatcher();
        MetricTemplate template1 = new MetricTemplate(normalDef);
        MetricTemplate template2 = new MetricTemplate(perMinuteDef);
        Assert.assertSame((Object)matcher.findMatch((Object)template1), (Object)normalDef, (String)"The matching metric template should have found the defined measurement definition");
        Assert.assertSame((Object)matcher.findMatch((Object)template2), (Object)perMinuteDef, (String)"The matching metric template should have found the defined measurement definition");
        importer.update(normalDef, template1);
        importer.update(perMinuteDef, template2);
        importer.finishImport();
    }

    public void testNotifiesAboutIgnoredMetricTemplates() throws Exception {
        final TestPrerequisities prereqs = new TestPrerequisities(this.context);
        prereqs.setMeasurementDefinitions(Collections.<MeasurementDefinition>emptyList());
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                prereqs.addExpectations(this);
            }
        });
        MetricTemplateImporter importer = new MetricTemplateImporter(null, prereqs.getEntityManager(), prereqs.getMeasurementScheduleManager());
        importer.configure(null);
        importer.configure(null);
        MetricTemplate unmatched = new MetricTemplate();
        unmatched.setMetricName("made-up");
        unmatched.setResourceTypeName("made-up");
        unmatched.setResourceTypePlugin("made-up");
        ExportedEntityMatcher matcher = importer.getExportedEntityMatcher();
        Assert.assertNull((Object)matcher.findMatch((Object)unmatched));
        importer.update(null, unmatched);
        String notes = importer.finishImport();
        String expectedNotes = MetricTemplateImporter.getUnmatchedMetricTemplatesReport(Collections.singleton(unmatched));
        Assert.assertEquals((String)notes, (String)expectedNotes);
    }

    private static class TestPrerequisities {
        private EntityManager em;
        private Query q;
        private MeasurementScheduleManagerLocal msm;
        private List<MeasurementDefinition> defs;

        public TestPrerequisities(Mockery context) {
            this.em = (EntityManager)context.mock(EntityManager.class);
            this.msm = (MeasurementScheduleManagerLocal)context.mock(MeasurementScheduleManagerLocal.class);
            this.q = (Query)context.mock(Query.class);
        }

        public Query getQuery() {
            return this.q;
        }

        public EntityManager getEntityManager() {
            return this.em;
        }

        public MeasurementScheduleManagerLocal getMeasurementScheduleManager() {
            return this.msm;
        }

        public void setMeasurementDefinitions(List<MeasurementDefinition> defs) {
            this.defs = defs;
        }

        public void addExpectations(Expectations expectations) {
            ((EntityManager)expectations.allowing((Object)this.em)).createQuery((String)expectations.with(Expectations.any(String.class)));
            expectations.will(Expectations.returnValue((Object)this.q));
            ((Query)expectations.allowing((Object)this.q)).getResultList();
            expectations.will(Expectations.returnValue(this.defs));
        }
    }
}

