/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.persistence.EntityManager;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.criteria.MeasurementDefinitionCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementCategory;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.sync.ExportReport;
import org.rhq.core.domain.sync.ImportConfiguration;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.sync.ExportReader;
import org.rhq.enterprise.server.sync.ExportWriter;
import org.rhq.enterprise.server.sync.MetricTemplateSynchronizer;
import org.rhq.enterprise.server.sync.NoSingleEntity;
import org.rhq.enterprise.server.sync.SynchronizationConstants;
import org.rhq.enterprise.server.sync.SynchronizationManagerLocal;
import org.rhq.enterprise.server.sync.Synchronizer;
import org.rhq.enterprise.server.sync.SynchronizerFactory;
import org.rhq.enterprise.server.sync.SystemSettingsSynchronizer;
import org.rhq.enterprise.server.sync.ValidationException;
import org.rhq.enterprise.server.sync.exporters.Exporter;
import org.rhq.enterprise.server.sync.exporters.ExportingIterator;
import org.rhq.enterprise.server.sync.importers.ExportedEntityMatcher;
import org.rhq.enterprise.server.sync.importers.Importer;
import org.rhq.enterprise.server.sync.validators.ConsistencyValidator;
import org.rhq.enterprise.server.sync.validators.EntityValidator;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerPluginService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@Test
public class SynchronizationManagerBeanTest
extends AbstractEJB3Test {
    private SynchronizationManagerLocal synchronizationManager;
    private Subject user;
    private ExportReport export;
    private static final String RESOURCE_TYPE_NAME = "SynchronizationManagerBeanTest";
    private static final String PLUGIN_NAME = "SynchronizationManagerBeanTest";
    private static final String METRIC_NAME = "SynchronizationManagerBeanTest";
    private TestData testData;

    private void setup(boolean createExport) throws Exception {
        this.testData = new TestData();
        this.getTransactionManager().begin();
        try {
            EntityManager em = SynchronizationManagerBeanTest.getEntityManager();
            this.testData.fakeType = new ResourceType("SynchronizationManagerBeanTest", "SynchronizationManagerBeanTest", ResourceCategory.PLATFORM, null);
            MeasurementDefinition mdef = new MeasurementDefinition("SynchronizationManagerBeanTest", MeasurementCategory.PERFORMANCE, MeasurementUnits.NONE, DataType.MEASUREMENT, true, 600000L, DisplayType.SUMMARY);
            this.testData.fakeType.addMetricDefinition(mdef);
            em.persist((Object)this.testData.fakeType);
            this.testData.fakePlatform = new Resource("SynchronizationManagerBeanTest", "SynchronizationManagerBeanTest", this.testData.fakeType);
            this.testData.fakePlatform.setUuid(UUID.randomUUID().toString());
            this.testData.fakePlatform.setInventoryStatus(InventoryStatus.COMMITTED);
            MeasurementSchedule sched = new MeasurementSchedule(mdef, this.testData.fakePlatform);
            sched.setInterval(600000L);
            this.testData.fakePlatform.addSchedule(sched);
            em.persist((Object)this.testData.fakePlatform);
            em.persist((Object)sched);
            em.flush();
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            this.getTransactionManager().rollback();
            throw e;
        }
        this.testData.testServerPluginService = new TestServerPluginService();
        this.prepareCustomServerPluginService(this.testData.testServerPluginService);
        this.testData.testServerPluginService.startMasterPluginContainer();
        this.synchronizationManager = LookupUtil.getSynchronizationManager();
        SystemManagerLocal systemManager = LookupUtil.getSystemManager();
        systemManager.loadSystemConfigurationCache();
        this.testData.systemSettings = systemManager.getSystemConfiguration(this.freshUser());
        if (createExport) {
            this.export = this.synchronizationManager.exportAllSubsystems(this.freshUser());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tearDown() throws Exception {
        try {
            this.getTransactionManager().begin();
            try {
                LookupUtil.getSystemManager().setSystemConfiguration(this.freshUser(), this.testData.systemSettings, true);
                EntityManager em = SynchronizationManagerBeanTest.getEntityManager();
                MeasurementSchedule sched = (MeasurementSchedule)em.find(MeasurementSchedule.class, (Object)((MeasurementSchedule)this.testData.fakePlatform.getSchedules().iterator().next()).getId());
                em.remove((Object)sched);
                Resource attachedPlatform = (Resource)em.find(Resource.class, (Object)this.testData.fakePlatform.getId());
                em.remove((Object)attachedPlatform);
                ResourceType attachedType = (ResourceType)em.find(ResourceType.class, (Object)this.testData.fakeType.getId());
                em.remove((Object)attachedType);
                em.flush();
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                this.getTransactionManager().rollback();
                throw e;
            }
        }
        finally {
            this.unprepareServerPluginService();
            this.export = null;
            this.testData = null;
            this.synchronizationManager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExport() throws Exception {
        this.setup(true);
        try {
            SynchronizationManagerBeanTest.assertNull((String)"Export shouldn't generate an error message.", (Object)this.export.getErrorMessage());
            SynchronizationManagerBeanTest.assertTrue((String)"The export should contain some data.", (this.export.getExportFile().length > 0 ? 1 : 0) != 0);
        }
        finally {
            this.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportWithDefaultConfiguration() throws Exception {
        this.setup(true);
        try {
            SystemManagerLocal systemManager = LookupUtil.getSystemManager();
            MeasurementDefinitionManagerLocal measurementDefinitionManager = LookupUtil.getMeasurementDefinitionManager();
            Properties beforeSystemSettings = systemManager.getSystemConfiguration(this.freshUser());
            MeasurementDefinitionCriteria criteria = new MeasurementDefinitionCriteria();
            criteria.setPageControl(PageControl.getUnlimitedInstance());
            criteria.fetchResourceType(true);
            PageList beforeMeasurementDefinitions = measurementDefinitionManager.findMeasurementDefinitionsByCriteria(this.freshUser(), criteria);
            this.synchronizationManager.importAllSubsystems(this.freshUser(), this.export.getExportFile(), null);
            systemManager.loadSystemConfigurationCache();
            Properties afterSystemSettings = systemManager.getSystemConfiguration(this.freshUser());
            PageList afterMeasurementDefinitions = measurementDefinitionManager.findMeasurementDefinitionsByCriteria(this.freshUser(), criteria);
            SynchronizationManagerBeanTest.assertEquals((String)"System settings unexpectedly differ", (Object)beforeSystemSettings, (Object)afterSystemSettings);
            HashSet beforeDefsToCheck = new HashSet(beforeMeasurementDefinitions);
            HashSet afterDefsToCheck = new HashSet(afterMeasurementDefinitions);
            SynchronizationManagerBeanTest.assertEquals((String)"Measurement definitions unexpectedly differ", beforeDefsToCheck, afterDefsToCheck);
        }
        finally {
            this.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportWithRedefinedConfigurationInExportFile() throws Exception {
        this.setup(true);
        try {
            String exportXML = this.getExportData();
            exportXML = this.updateSystemSettingsImportConfiguration(exportXML);
            exportXML = this.updateMetricTemplatesImportConfiguration(exportXML);
            InputStream exportData = this.createCompressedStream(exportXML);
            try {
                this.synchronizationManager.importAllSubsystems(this.freshUser(), exportData, null);
            }
            finally {
                exportData.close();
            }
            SystemManagerLocal systemManager = LookupUtil.getSystemManager();
            Properties settings = systemManager.getSystemConfiguration(this.freshUser());
            SynchronizationManagerBeanTest.assertEquals((String)settings.getProperty("CAM_BASE_URL"), (String)"http://testing.domain:7080");
            MeasurementDefinitionManagerLocal measurementDefinitionManager = LookupUtil.getMeasurementDefinitionManager();
            MeasurementDefinitionCriteria crit = new MeasurementDefinitionCriteria();
            crit.addFilterResourceTypeName("SynchronizationManagerBeanTest");
            crit.addFilterName("SynchronizationManagerBeanTest");
            MeasurementDefinition mdef = (MeasurementDefinition)measurementDefinitionManager.findMeasurementDefinitionsByCriteria(this.freshUser(), crit).get(0);
            SynchronizationManagerBeanTest.assertEquals((String)"The SynchronizationManagerBeanTest metric should have been updated with default interval of 30s", (Object)30000L, (Object)new Long(mdef.getDefaultInterval()));
            ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
            ResourceCriteria rcrit = new ResourceCriteria();
            rcrit.addFilterResourceTypeName("SynchronizationManagerBeanTest");
            PageList platforms = resourceManager.findResourcesByCriteria(this.freshUser(), rcrit);
            SynchronizationManagerBeanTest.assertEquals((String)"Unexpected number of platform resources found.", (int)1, (int)platforms.size());
            int platformResourceId = ((Resource)platforms.get(0)).getId();
            MeasurementScheduleManagerLocal measurementScheduleManager = LookupUtil.getMeasurementScheduleManager();
            List schedules = measurementScheduleManager.findSchedulesByResourceIdAndDefinitionIds(this.freshUser(), platformResourceId, new int[]{mdef.getId()});
            SynchronizationManagerBeanTest.assertEquals((String)"Unexpected number of 'SynchronizationManagerBeanTest' schedules found.", (int)1, (int)schedules.size());
            SynchronizationManagerBeanTest.assertEquals((String)"The schedule should have been updated along with the definition during the config sync", (long)30000L, (long)((MeasurementSchedule)schedules.get(0)).getInterval());
        }
        finally {
            this.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManuallyPassedImportConfigurationHasPrecendenceOverTheInlinedOne() throws Exception {
        this.setup(true);
        try {
            SystemManagerLocal systemManager = LookupUtil.getSystemManager();
            Properties settings = systemManager.getSystemConfiguration(this.freshUser());
            String originalBaseUrl = settings.getProperty("CAM_BASE_URL");
            MeasurementDefinitionManagerLocal measurementDefinitionManager = LookupUtil.getMeasurementDefinitionManager();
            MeasurementDefinitionCriteria crit = new MeasurementDefinitionCriteria();
            crit.addFilterResourceTypeName("SynchronizationManagerBeanTest");
            crit.addFilterName("SynchronizationManagerBeanTest");
            MeasurementDefinition distroNameDef = (MeasurementDefinition)measurementDefinitionManager.findMeasurementDefinitionsByCriteria(this.freshUser(), crit).get(0);
            long originalInterval = distroNameDef.getDefaultInterval();
            String exportXML = this.getExportData();
            exportXML = this.updateSystemSettingsImportConfiguration(exportXML);
            exportXML = this.updateMetricTemplatesImportConfiguration(exportXML);
            InputStream exportData = this.createCompressedStream(exportXML);
            ImportConfiguration systemSettingsConfiguration = new ImportConfiguration(SystemSettingsSynchronizer.class.getName(), new SystemSettingsSynchronizer().getImporter().getImportConfigurationDefinition().getDefaultTemplate().createConfiguration());
            ImportConfiguration metricTemplatesConfiguration = new ImportConfiguration(MetricTemplateSynchronizer.class.getName(), new MetricTemplateSynchronizer().getImporter().getImportConfigurationDefinition().getDefaultTemplate().createConfiguration());
            try {
                this.synchronizationManager.importAllSubsystems(this.freshUser(), exportData, Arrays.asList(systemSettingsConfiguration, metricTemplatesConfiguration));
            }
            finally {
                exportData.close();
            }
            settings = systemManager.getSystemConfiguration(this.freshUser());
            SynchronizationManagerBeanTest.assertEquals((String)settings.getProperty("CAM_BASE_URL"), (String)originalBaseUrl);
            measurementDefinitionManager = LookupUtil.getMeasurementDefinitionManager();
            distroNameDef = (MeasurementDefinition)measurementDefinitionManager.findMeasurementDefinitionsByCriteria(this.freshUser(), crit).get(0);
            SynchronizationManagerBeanTest.assertEquals((String)"The SynchronizationManagerBeanTest metric shouldn't have changed its default interval", (long)30000L, (long)distroNameDef.getDefaultInterval());
            ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
            ResourceCriteria rcrit = new ResourceCriteria();
            rcrit.addFilterResourceTypeName("SynchronizationManagerBeanTest");
            PageList platforms = resourceManager.findResourcesByCriteria(this.freshUser(), rcrit);
            SynchronizationManagerBeanTest.assertEquals((String)"Unexpected number of platform resources found.", (int)1, (int)platforms.size());
            int platformResourceId = ((Resource)platforms.get(0)).getId();
            MeasurementScheduleManagerLocal measurementScheduleManager = LookupUtil.getMeasurementScheduleManager();
            List schedules = measurementScheduleManager.findSchedulesByResourceIdAndDefinitionIds(this.freshUser(), platformResourceId, new int[]{distroNameDef.getId()});
            SynchronizationManagerBeanTest.assertEquals((String)"Unexpected number of 'SynchronizationManagerBeanTest' schedules found.", (int)1, (int)schedules.size());
            SynchronizationManagerBeanTest.assertEquals((String)"The schedule should have been updated along with the definition during the config sync", (long)originalInterval, (long)((MeasurementSchedule)schedules.get(0)).getInterval());
        }
        finally {
            this.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnknownValidatorsAreIgnored() throws Exception {
        this.setup(true);
        try {
            String export = this.getExportData();
            Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(export)));
            Element unknownValidator = xml.createElement("validator");
            unknownValidator.setAttribute("class", "org.nothing.UnknownValidator");
            xml.getDocumentElement().insertBefore(unknownValidator, xml.getDocumentElement().getFirstChild());
            export = SynchronizationManagerBeanTest.documentToString(xml);
            InputStream exportStream = this.createCompressedStream(export);
            this.synchronizationManager.importAllSubsystems(this.freshUser(), exportStream, null);
        }
        finally {
            this.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImporterConfiguredBeforeValidatorsObtained() throws Exception {
        this.setup(false);
        try {
            ImportConfigurationCheckingSynchronizer.reset();
            this.synchronizationManager.setSynchronizerFactory(new SynchronizerFactory(){

                public Set<Synchronizer<?, ?>> getAllSynchronizers() {
                    return Collections.singleton(new ImportConfigurationCheckingSynchronizer());
                }
            });
            this.export = this.synchronizationManager.exportAllSubsystems(this.freshUser());
            this.synchronizationManager.importAllSubsystems(this.freshUser(), this.export.getExportFile(), null);
            SynchronizationManagerBeanTest.assertTrue((boolean)ImportConfigurationCheckingSynchronizer.importerConfigured);
            SynchronizationManagerBeanTest.assertTrue((boolean)ImportConfigurationCheckingSynchronizer.importValidatorsObtainedAfterConfiguration);
        }
        finally {
            this.synchronizationManager.setSynchronizerFactory(new SynchronizerFactory());
            this.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExportData() throws IOException {
        InputStreamReader str = new InputStreamReader((InputStream)new GZIPInputStream(new ByteArrayInputStream(this.export.getExportFile())), "UTF-8");
        try {
            char[] buf = new char[32768];
            StringBuilder bld = new StringBuilder();
            int cnt = 0;
            while ((cnt = str.read(buf)) >= 0) {
                bld.append(buf, 0, cnt);
            }
            String string = bld.toString();
            return string;
        }
        finally {
            str.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String documentToString(Document document) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        StringWriter ret = new StringWriter();
        try {
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(ret);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            String string = ret.toString();
            return string;
        }
        finally {
            ret.close();
        }
    }

    private String updateSystemSettingsImportConfiguration(String exportXML) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(SynchronizationConstants.createConfigurationExportNamespaceContext());
        XPathExpression systemSettingsConfigurationPath = xpath.compile("/:configuration-export/:entities[@id='org.rhq.enterprise.server.sync.SystemSettingsSynchronizer']/:default-configuration/ci:simple-property[@name='propertiesToImport']");
        XPathExpression baseUrlSettingPath = xpath.compile("/:configuration-export/:entities[@id='org.rhq.enterprise.server.sync.SystemSettingsSynchronizer']/:entity/:data/systemSettings/entry[@key='CAM_BASE_URL']");
        Element systemSettingsConfiguration = (Element)systemSettingsConfigurationPath.evaluate(new InputSource(new StringReader(exportXML)), XPathConstants.NODE);
        String propsToImport = systemSettingsConfiguration.getAttribute("value");
        propsToImport = propsToImport + ", CAM_BASE_URL";
        systemSettingsConfiguration.setAttribute("value", propsToImport);
        exportXML = SynchronizationManagerBeanTest.documentToString(systemSettingsConfiguration.getOwnerDocument());
        Element baseUrlSetting = (Element)baseUrlSettingPath.evaluate(new InputSource(new StringReader(exportXML)), XPathConstants.NODE);
        baseUrlSetting.setTextContent("http://testing.domain:7080");
        return SynchronizationManagerBeanTest.documentToString(baseUrlSetting.getOwnerDocument());
    }

    private String updateMetricTemplatesImportConfiguration(String exportXML) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(SynchronizationConstants.createConfigurationExportNamespaceContext());
        XPathExpression overridesPath = xpath.compile("/:configuration-export/:entities[@id='org.rhq.enterprise.server.sync.MetricTemplateSynchronizer']/:default-configuration/ci:list-property[@name='metricUpdateOverrides']");
        Element overrides = (Element)overridesPath.evaluate(new InputSource(new StringReader(exportXML)), XPathConstants.NODE);
        Document doc = overrides.getOwnerDocument();
        String ns = "urn:xmlns:rhq-configuration-instance";
        String prefix = "ci";
        Element values = doc.createElementNS(ns, prefix + ":values");
        overrides.appendChild(values);
        Element mapValue = doc.createElementNS(ns, prefix + ":map-value");
        values.appendChild(mapValue);
        SynchronizationManagerBeanTest.addSimpleValue(mapValue, "metricName", "SynchronizationManagerBeanTest");
        SynchronizationManagerBeanTest.addSimpleValue(mapValue, "resourceTypeName", "SynchronizationManagerBeanTest");
        SynchronizationManagerBeanTest.addSimpleValue(mapValue, "resourceTypePlugin", "SynchronizationManagerBeanTest");
        SynchronizationManagerBeanTest.addSimpleValue(mapValue, "updateSchedules", "true");
        exportXML = SynchronizationManagerBeanTest.documentToString(doc);
        XPathExpression distroNameMetricPath = xpath.compile("/:configuration-export/:entities[@id='org.rhq.enterprise.server.sync.MetricTemplateSynchronizer']/:entity/:data/metricTemplate[@metricName='SynchronizationManagerBeanTest']");
        Element metric = (Element)distroNameMetricPath.evaluate(new InputSource(new StringReader(exportXML)), XPathConstants.NODE);
        doc = metric.getOwnerDocument();
        metric.setAttribute("defaultInterval", "30000");
        return SynchronizationManagerBeanTest.documentToString(doc);
    }

    private static void addSimpleValue(Element parent, String propertyName, String value) {
        String ns = "urn:xmlns:rhq-configuration-instance";
        String prefix = "ci";
        Element simpleValue = parent.getOwnerDocument().createElementNS(ns, prefix + ":simple-value");
        simpleValue.setAttribute("property-name", propertyName);
        simpleValue.setAttribute("value", value);
        parent.appendChild(simpleValue);
    }

    private Subject freshUser() {
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        if (this.user != null) {
            try {
                subjectManager.logout(this.user);
            }
            catch (PermissionException permissionException) {
                // empty catch block
            }
        }
        this.user = subjectManager.getOverlord();
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream createCompressedStream(String exportData) throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream compressed = new ByteArrayOutputStream();
        OutputStreamWriter wrt = new OutputStreamWriter((OutputStream)new GZIPOutputStream(compressed), "UTF-8");
        try {
            wrt.write(exportData);
        }
        finally {
            wrt.close();
        }
        return new ByteArrayInputStream(compressed.toByteArray());
    }

    public static class ImportConfigurationCheckingSynchronizer
    implements Synchronizer<NoSingleEntity, String> {
        public static boolean importerConfigured;
        public static boolean importValidatorsObtainedAfterConfiguration;

        public static void reset() {
            importerConfigured = false;
            importValidatorsObtainedAfterConfiguration = false;
        }

        public void initialize(Subject subject, EntityManager entityManager) {
        }

        public Exporter<NoSingleEntity, String> getExporter() {
            return new Exporter<NoSingleEntity, String>(){

                public ExportingIterator<String> getExportingIterator() {
                    return new ExportingIterator<String>(){
                        boolean ran = false;

                        public boolean hasNext() {
                            if (this.ran) {
                                return false;
                            }
                            this.ran = true;
                            return true;
                        }

                        public String next() {
                            return null;
                        }

                        public void remove() {
                        }

                        public void export(ExportWriter output) throws XMLStreamException {
                            output.writeStartElement("my-entity");
                            output.writeCharacters("value");
                            output.writeEndElement();
                        }

                        public String getNotes() {
                            return null;
                        }
                    };
                }

                public String getNotes() {
                    return null;
                }
            };
        }

        public Importer<NoSingleEntity, String> getImporter() {
            return new Importer<NoSingleEntity, String>(){

                public ConfigurationDefinition getImportConfigurationDefinition() {
                    return new ConfigurationDefinition("fake", null);
                }

                public void configure(Configuration importConfiguration) {
                    importerConfigured = true;
                }

                public ExportedEntityMatcher<NoSingleEntity, String> getExportedEntityMatcher() {
                    return null;
                }

                public Set<EntityValidator<String>> getEntityValidators() {
                    EntityValidator<String> v = new EntityValidator<String>(){

                        public void validateExportedEntity(String entity) throws ValidationException {
                        }

                        public void initialize(Subject subject, EntityManager entityManager) {
                        }
                    };
                    if (importerConfigured) {
                        importValidatorsObtainedAfterConfiguration = true;
                    }
                    return Collections.singleton(v);
                }

                public void update(NoSingleEntity entity, String exportedEntity) throws Exception {
                }

                public String unmarshallExportedEntity(ExportReader reader) throws XMLStreamException {
                    return reader.getElementText();
                }

                public String finishImport() throws Exception {
                    return null;
                }
            };
        }

        public Set<ConsistencyValidator> getRequiredValidators() {
            return Collections.emptySet();
        }
    }

    private static class TestData {
        public Properties systemSettings;
        public ResourceType fakeType;
        public Resource fakePlatform;
        public TestServerPluginService testServerPluginService;

        private TestData() {
        }
    }
}

