/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.rhq.core.clientapi.util.StringUtil;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.sync.entity.SystemSettings;
import org.rhq.enterprise.server.sync.importers.SystemSettingsImporter;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.test.JMockTest;
import org.testng.annotations.Test;

@Test
public class SystemSettingsImporterTest
extends JMockTest {
    public void testNullConfigurationUnderstoodAsDefault() throws Exception {
        String[] importableProps;
        final SystemManagerLocal systemManager = (SystemManagerLocal)this.context.mock(SystemManagerLocal.class);
        SystemSettingsImporter importer = new SystemSettingsImporter(null, systemManager);
        final HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("CAM_BASE_URL", "url");
        settings.put("SOME_UNKNOWN_PROPERTY", "asdf");
        for (String p : importableProps = "AGENT_MAX_QUIET_TIME_ALLOWED, ENABLE_AGENT_AUTO_UPDATE, ENABLE_DEBUG_MODE, ENABLE_EXPERIMENTAL_FEATURES, CAM_DATA_PURGE_1H, CAM_DATA_PURGE_6H, CAM_DATA_PURGE_1D, CAM_DATA_MAINTENANCE, DATA_REINDEX_NIGHTLY, RT_DATA_PURGE, ALERT_PURGE, EVENT_PURGE, TRAIT_PURGE, AVAILABILITY_PURGE, CAM_BASELINE_FREQUENCY, CAM_BASELINE_DATASET".split("\\s*,\\s*")) {
            settings.put(p, "value");
        }
        SystemSettings importedSettings = new SystemSettings(settings);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Properties expectedImport = new Properties();
                expectedImport.putAll((Map<?, ?>)settings);
                expectedImport.remove("CAM_BASE_URL");
                expectedImport.remove("SOME_UNKNOWN_PROPERTY");
                ((SystemManagerLocal)this.oneOf(systemManager)).setSystemConfiguration((Subject)this.with(1.any(Subject.class)), (Properties)this.with(expectedImport), this.with(true));
            }
        });
        importer.configure(null);
        importer.update(null, importedSettings);
        importer.finishImport();
    }

    public void testImportConfigurationHonored() throws Exception {
        final SystemManagerLocal systemManager = (SystemManagerLocal)this.context.mock(SystemManagerLocal.class);
        SystemSettingsImporter importer = new SystemSettingsImporter(null, systemManager);
        String[] importableProps = "AGENT_MAX_QUIET_TIME_ALLOWED, ENABLE_AGENT_AUTO_UPDATE, ENABLE_DEBUG_MODE, ENABLE_EXPERIMENTAL_FEATURES, CAM_DATA_PURGE_1H, CAM_DATA_PURGE_6H, CAM_DATA_PURGE_1D, CAM_DATA_MAINTENANCE, DATA_REINDEX_NIGHTLY, RT_DATA_PURGE, ALERT_PURGE, EVENT_PURGE, TRAIT_PURGE, AVAILABILITY_PURGE, CAM_BASELINE_FREQUENCY, CAM_BASELINE_DATASET".split("\\s*,\\s*");
        final HashMap<String, String> settings = new HashMap<String, String>();
        for (String p : importableProps) {
            settings.put(p, "value");
        }
        SystemSettings importedSettings = new SystemSettings(settings);
        final ArrayList<String> allowedSettings = new ArrayList<String>();
        for (int i = 0; i < importableProps.length; ++i) {
            if (i % 2 != 0) continue;
            allowedSettings.add(importableProps[i]);
        }
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Properties expectedImport = new Properties();
                for (String s : allowedSettings) {
                    expectedImport.put(s, settings.get(s));
                }
                ((SystemManagerLocal)this.oneOf(systemManager)).setSystemConfiguration((Subject)this.with(2.any(Subject.class)), (Properties)this.with(expectedImport), this.with(true));
            }
        });
        Configuration importConfig = new Configuration();
        importConfig.put((Property)new PropertySimple("propertiesToImport", (Object)StringUtil.collectionToString(allowedSettings, (String)", ")));
        importer.configure(importConfig);
        importer.update(null, importedSettings);
        importer.finishImport();
    }
}

