/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.system;

import java.util.Properties;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.core.domain.common.composite.SystemSettings;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerPluginService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class SystemManagerBeanTest
extends AbstractEJB3Test {
    private Subject overlord;
    private SystemManagerLocal systemManager;
    private TestServerPluginService testServerPluginService;

    @BeforeClass
    public void setupServer() {
        this.systemManager = LookupUtil.getSystemManager();
    }

    @BeforeMethod
    public void beforeMethod() {
        this.overlord = LookupUtil.getSubjectManager().getOverlord();
        this.testServerPluginService = new TestServerPluginService();
        this.prepareCustomServerPluginService(this.testServerPluginService);
        this.testServerPluginService.startMasterPluginContainer();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDownServer() throws Exception {
        this.unprepareServerPluginService();
    }

    public void testGetSystemConfiguration() {
        assert (null != this.systemManager.getSystemConfiguration(this.overlord));
    }

    public void testAnalyze() {
        this.systemManager.analyze(this.overlord);
    }

    public void testEnableHibernateStatistics() {
        this.systemManager.enableHibernateStatistics();
    }

    public void testGetDatabaseType() {
        assert (this.systemManager.getDatabaseType() instanceof DatabaseType);
    }

    public void testReindex() {
        this.systemManager.reindex(this.overlord);
    }

    public void testVacuum() {
        this.systemManager.vacuum(this.overlord);
    }

    public void testVacuumAppdef() {
        this.systemManager.vacuumAppdef(this.overlord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLegacySystemSettingsInCorrectFormat() throws Exception {
        SystemSettings settings = this.systemManager.getSystemSettings(this.overlord);
        Properties config = this.systemManager.getSystemConfiguration(this.overlord);
        SystemSettings origSettings = new SystemSettings(settings);
        try {
            this.checkFormats(settings, config);
            boolean currentJaasProvider = Boolean.valueOf((String)settings.get((Object)SystemSetting.LDAP_BASED_JAAS_PROVIDER));
            settings.put(SystemSetting.LDAP_BASED_JAAS_PROVIDER, Boolean.toString(!currentJaasProvider));
            boolean currentUseSslForLdap = Boolean.valueOf((String)settings.get((Object)SystemSetting.USE_SSL_FOR_LDAP));
            settings.put(SystemSetting.USE_SSL_FOR_LDAP, Boolean.toString(!currentUseSslForLdap));
            this.systemManager.setSystemSettings(this.overlord, settings);
            settings = this.systemManager.getSystemSettings(this.overlord);
            config = this.systemManager.getSystemConfiguration(this.overlord);
            this.checkFormats(settings, config);
        }
        finally {
            this.systemManager.setSystemSettings(this.overlord, origSettings);
        }
    }

    private void checkFormats(SystemSettings settings, Properties config) {
        assert (settings.size() == config.size()) : "The old and new style system settings differ in size";
        block4: for (String name : config.stringPropertyNames()) {
            SystemSetting setting = SystemSetting.getByInternalName((String)name);
            String oldStyleValue = config.getProperty(name);
            String newStyleValue = (String)settings.get((Object)setting);
            assert (setting != null) : "Could not find a system setting called '" + name + "'.";
            switch (setting) {
                case USE_SSL_FOR_LDAP: {
                    if ("ssl".equals(oldStyleValue)) {
                        assert (Boolean.valueOf(newStyleValue).booleanValue()) : "Secured LDAP protocol should be represented by a 'true' in new style settings.";
                        continue block4;
                    }
                    if ("".equals(oldStyleValue)) {
                        assert (!Boolean.valueOf(newStyleValue).booleanValue()) : "Unsecured LDAP protocol should be represented by a 'false' in the new style settings.";
                        continue block4;
                    }
                    assert (false) : "Unknown value for system setting '" + setting + "': [" + oldStyleValue + "].";
                    continue block4;
                }
                case LDAP_BASED_JAAS_PROVIDER: {
                    if ("LDAP".equals(oldStyleValue)) {
                        assert (Boolean.valueOf(newStyleValue).booleanValue()) : "LDAP JAAS provider should be represented by a 'true' in new style settings.";
                        continue block4;
                    }
                    if ("JDBC".equals(oldStyleValue)) {
                        assert (!Boolean.valueOf(newStyleValue).booleanValue()) : "JDBC JAAS provider should be represented by a 'false' in the new style settings.";
                        continue block4;
                    }
                    assert (false) : "Unknown value for system setting '" + setting + "': [" + oldStyleValue + "].";
                    continue block4;
                }
            }
            assert (oldStyleValue != null && newStyleValue != null && oldStyleValue.equals(newStyleValue)) : "Old and new style values unexpectedly differ for system setting '" + setting + "': old=[" + oldStyleValue + "], new=[" + newStyleValue + "].";
        }
    }
}

