/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.test;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.helpers.perftest.support.reporting.PerformanceReportExporter;
import org.rhq.helpers.perftest.support.testng.PerformanceReporting;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;

public class AbstractEJB3PerformanceTest
extends AbstractEJB3Test {
    private static final Log log = LogFactory.getLog((String)"TIMING_INFO");
    private static final String DEFAULT = "-default-";
    private Map<String, Long> timings;
    private Map<String, Long> startTime;

    protected void startTiming(String name) {
        if (this.startTime == null) {
            System.err.println("startTime is null, setupTimings was not called by TestNG!!");
            return;
        }
        long now = System.currentTimeMillis();
        this.startTime.put(name, now);
    }

    protected void endTiming(String name) {
        boolean found = this.startTime.containsKey(name);
        assert (found) : "No start time information for name [" + name + "] found - did you call startTiming()?";
        long now = System.currentTimeMillis();
        long start = this.startTime.get(name);
        long duration = now - start;
        if (this.timings.containsKey(name)) {
            long timing = this.timings.get(name);
            this.timings.put(name, timing += duration);
        } else {
            this.timings.put(name, duration);
        }
    }

    protected void startTiming() {
        this.startTiming(DEFAULT);
    }

    protected void endTiming() {
        this.endTiming(DEFAULT);
    }

    protected long getTiming(String name) {
        if (this.timings.containsKey(name)) {
            return this.timings.get(name);
        }
        return -1L;
    }

    protected long getTiming() {
        return this.getTiming(DEFAULT);
    }

    @AfterMethod
    protected void reportTimings(ITestResult result, Method meth) {
        this.printTimings(meth.getName());
        Class<?> clazz = meth.getDeclaringClass();
        PerformanceReporting pr = clazz.getAnnotation(PerformanceReporting.class);
        if (pr != null) {
            String file = pr.baseFilename();
            Class exporterClazz = pr.exporter();
            try {
                PerformanceReportExporter exporter = (PerformanceReportExporter)exporterClazz.newInstance();
                exporter.setBaseFile(file);
                exporter.setRolling(pr.rolling());
                exporter.export(this.timings, result);
            }
            catch (Throwable e) {
                System.err.println("Error writing to reporting file " + file + " : " + e.getMessage());
                e.printStackTrace();
            }
        }
        System.out.flush();
        System.err.flush();
        this.timings.clear();
        this.startTime.clear();
    }

    protected void setupTimings(Method meth) {
        this.timings = new HashMap<String, Long>();
        this.startTime = new HashMap<String, Long>();
    }

    protected void printTimings(String testName) {
        System.out.println("=== " + testName + " ===");
        Set<Map.Entry<String, Long>> data = this.timings.entrySet();
        TreeSet<Map.Entry<String, Long>> sorted = new TreeSet<Map.Entry<String, Long>>(new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> item1, Map.Entry<String, Long> item2) {
                return item1.getKey().compareTo(item2.getKey());
            }
        });
        sorted.addAll(data);
        long summaryTime = 0L;
        for (Map.Entry entry : sorted) {
            log.info((Object)(":| " + (String)entry.getKey() + " => " + entry.getValue()));
            System.out.println(":| " + (String)entry.getKey() + " => " + entry.getValue());
            summaryTime += ((Long)entry.getValue()).longValue();
        }
        System.out.println("Total: " + summaryTime + " ms");
    }

    protected void assertTiming(String name, long maxDuration) {
        boolean found = this.timings.containsKey(name);
        assert (found) : "No timing information for name [" + name + "] found";
        long duration = this.timings.get(name);
        assert (duration < maxDuration) : "Execution took longer than given max ( " + duration + " > " + maxDuration + ")";
    }

    protected void assertTiming(long maxDuration) {
        this.assertTiming(DEFAULT, maxDuration);
    }

    protected void assertLinear(long ref, long value, double multiplier, String text) {
        System.out.println(">>> assertLinear " + text + " " + ref + ", " + value + ", " + multiplier);
        long low = (long)((double)ref * multiplier * 0.8);
        long hi = (long)((double)ref * multiplier * 1.2);
    }
}

