/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.test;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;
import org.hibernate.SessionFactory;
import org.hibernate.stat.Statistics;
import org.jboss.ejb3.embedded.EJB3StandaloneBootstrap;
import org.jboss.ejb3.embedded.EJB3StandaloneDeployer;
import org.jboss.mx.util.MBeanServerLocator;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsServiceMBean;
import org.rhq.enterprise.server.plugin.pc.ServerPluginService;
import org.rhq.enterprise.server.plugin.pc.ServerPluginServiceManagement;
import org.rhq.enterprise.server.scheduler.SchedulerService;
import org.rhq.enterprise.server.scheduler.SchedulerServiceMBean;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.test.JPAUtils;
import org.rhq.test.TransactionCallback;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

public abstract class AbstractEJB3Test
extends AssertJUnit {
    private static EJB3StandaloneDeployer deployer;
    private static Statistics stats;
    private static long start;
    private SchedulerService schedulerService;
    private ServerPluginService serverPluginService;
    private MBeanServer dummyJBossMBeanServer;

    @BeforeClass
    public void resetDB() throws Exception {
        if (this.isDBResetNeeded()) {
            JPAUtils.clearDB();
        }
    }

    protected boolean isDBResetNeeded() {
        return true;
    }

    @BeforeSuite(alwaysRun=true)
    public static void startupEmbeddedJboss() throws Exception {
        System.setProperty("embeddedDeployment", "true");
        System.setProperty("rhq.server.content.filesystem", System.getProperty("java.io.tmpdir"));
        System.out.println("Starting JBoss EJB3 Embedded Container...");
        String deployDir = System.getProperty("deploymentDirectory", "target/classes");
        System.out.println("Loading EJB3 deployments from directory: " + deployDir);
        try {
            EJB3StandaloneBootstrap.boot(null);
            System.err.println("...... embedded container booted....");
            deployer = EJB3StandaloneBootstrap.createDeployer();
            deployer.setClassLoader(AbstractEJB3Test.class.getClassLoader());
            System.err.println("...... embedded container classloader set....");
            deployer.getArchivesByResource().add("META-INF/persistence.xml");
            System.err.println("...... embedded container persistence xml deployed....");
            deployer.getArchivesByResource().add("META-INF/ejb-jar.xml");
            System.err.println("...... embedded container ejb-jar xml deployed....");
            EJB3StandaloneBootstrap.deployXmlResource((String)"jboss-jms-beans.xml");
            System.err.println("...... embedded container jboss-jms-beans xml deployed....");
            EJB3StandaloneBootstrap.deployXmlResource((String)"rhq-mdb-beans.xml");
            System.err.println("...... embedded container rhq-mdb-beans xml deployed....");
            deployer.create();
            System.err.println("...... deployer created....");
            deployer.start();
            System.err.println("...... deployer started....");
            System.err.println("...... start statistics");
            SessionFactory sessionFactory = PersistenceUtility.getHibernateSession((EntityManager)AbstractEJB3Test.getEntityManager()).getSessionFactory();
            stats = sessionFactory.getStatistics();
            stats.setStatisticsEnabled(true);
            System.err.println("...... embedded container initialized and ready for testing....");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    @AfterSuite(alwaysRun=true)
    public static void shutdownEmbeddedJboss() {
        System.out.println("Stopping JBoss EJB3 Embedded Container...");
        System.err.println("!!! Any errors occurring after this point    !!!");
        System.err.println("!!! occurred during embedded server shutdown !!!");
        System.err.println("!!! and are probably not a real problem.     !!!");
        if (deployer != null) {
            try {
                deployer.stop();
                deployer.destroy();
                deployer = null;
            }
            catch (Throwable t) {
                System.err.println("Failed to stop embedded deployer");
                t.printStackTrace(System.err);
            }
        }
        EJB3StandaloneBootstrap.shutdown();
    }

    @BeforeMethod
    public static void startTest() {
        if (DatabaseTypeFactory.getDefaultDatabaseType() == null) {
            try {
                Connection conn = AbstractEJB3Test.getConnection();
                DatabaseTypeFactory.setDefaultDatabaseType((DatabaseType)DatabaseTypeFactory.getDatabaseType((Connection)conn));
            }
            catch (Exception e) {
                System.err.println("!!! WARNING !!! cannot set default database type, some tests may fail");
                e.printStackTrace();
            }
        }
        start = stats != null ? stats.getQueryExecutionCount() : 0L;
    }

    public static Connection getConnection() throws SQLException {
        return LookupUtil.getDataSource().getConnection();
    }

    @AfterMethod
    public static void endTest() {
    }

    public TransactionManager getTransactionManager() {
        return JPAUtils.lookupTransactionManager();
    }

    public static EntityManager getEntityManager() {
        return JPAUtils.lookupEntityManager();
    }

    public static InitialContext getInitialContext() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "org.jnp.interfaces.LocalOnlyContextFactory");
        env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        try {
            return new InitialContext(env);
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to load initial context", e);
        }
    }

    public boolean isPostgres() throws Exception {
        return DatabaseTypeFactory.getDatabaseType((Context)AbstractEJB3Test.getInitialContext(), (String)"java:/RHQDS") instanceof PostgresqlDatabaseType;
    }

    public Subject createSession(Subject subject) {
        return SessionManager.getInstance().put(subject);
    }

    public MBeanServer getJBossMBeanServer() {
        if (this.dummyJBossMBeanServer == null) {
            this.dummyJBossMBeanServer = MBeanServerFactory.createMBeanServer("jboss");
            MBeanServerLocator.setJBoss((MBeanServer)this.dummyJBossMBeanServer);
        }
        return this.dummyJBossMBeanServer;
    }

    public void releaseJBossMBeanServer() {
        if (this.dummyJBossMBeanServer != null) {
            MBeanServerFactory.releaseMBeanServer(this.dummyJBossMBeanServer);
            this.dummyJBossMBeanServer = null;
        }
    }

    public TestServerCommunicationsService prepareForTestAgents() {
        try {
            MBeanServer mbs = this.getJBossMBeanServer();
            if (mbs.isRegistered(ServerCommunicationsServiceMBean.OBJECT_NAME)) {
                mbs.unregisterMBean(ServerCommunicationsServiceMBean.OBJECT_NAME);
            }
            TestServerCommunicationsService testAgentContainer = new TestServerCommunicationsService();
            mbs.registerMBean(testAgentContainer, ServerCommunicationsServiceMBean.OBJECT_NAME);
            return testAgentContainer;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unprepareForTestAgents() {
        this.unprepareForTestAgents(false);
    }

    public void unprepareForTestAgents(boolean beanOnly) {
        try {
            if (beanOnly) {
                MBeanServer mbs = this.getJBossMBeanServer();
                if (mbs.isRegistered(ServerCommunicationsServiceMBean.OBJECT_NAME)) {
                    mbs.unregisterMBean(ServerCommunicationsServiceMBean.OBJECT_NAME);
                }
            } else {
                this.releaseJBossMBeanServer();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void prepareCustomServerPluginService(ServerPluginService testServiceMBean) {
        try {
            MBeanServer mbs = this.getJBossMBeanServer();
            testServiceMBean.start();
            mbs.registerMBean(testServiceMBean, ServerPluginServiceManagement.OBJECT_NAME);
            this.serverPluginService = testServiceMBean;
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unprepareServerPluginService() throws Exception {
        this.unprepareServerPluginService(false);
    }

    public void unprepareServerPluginService(boolean beanOnly) throws Exception {
        if (this.serverPluginService != null) {
            this.serverPluginService.stopMasterPluginContainer();
            this.serverPluginService.stop();
            if (beanOnly) {
                MBeanServer mbs = this.getJBossMBeanServer();
                if (mbs.isRegistered(ServerPluginService.OBJECT_NAME)) {
                    this.getJBossMBeanServer().unregisterMBean(ServerPluginService.OBJECT_NAME);
                }
                if (mbs.isRegistered(ServerPluginServiceManagement.OBJECT_NAME)) {
                    this.getJBossMBeanServer().unregisterMBean(ServerPluginServiceManagement.OBJECT_NAME);
                }
            } else {
                this.releaseJBossMBeanServer();
            }
            this.serverPluginService = null;
        }
    }

    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public void prepareScheduler() {
        try {
            if (this.schedulerService != null) {
                return;
            }
            Properties quartzProps = new Properties();
            quartzProps.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test-scheduler.properties"));
            this.schedulerService = new SchedulerService();
            this.schedulerService.setQuartzProperties(quartzProps);
            this.schedulerService.start();
            this.getJBossMBeanServer().registerMBean(this.schedulerService, SchedulerServiceMBean.SCHEDULER_MBEAN_NAME);
            this.schedulerService.startQuartzScheduler();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void unprepareScheduler() throws Exception {
        this.unprepareScheduler(false);
    }

    public void unprepareScheduler(boolean beanOnly) throws Exception {
        if (this.schedulerService != null) {
            this.schedulerService.stop();
            if (beanOnly) {
                MBeanServer mbs = this.getJBossMBeanServer();
                if (mbs.isRegistered(SchedulerServiceMBean.SCHEDULER_MBEAN_NAME)) {
                    this.getJBossMBeanServer().unregisterMBean(SchedulerServiceMBean.SCHEDULER_MBEAN_NAME);
                }
            } else {
                this.releaseJBossMBeanServer();
            }
            this.schedulerService = null;
        }
    }

    protected void executeInTransaction(TransactionCallback callback) {
        JPAUtils.executeInTransaction((TransactionCallback)callback);
    }
}

