/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.test;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.transaction.TransactionManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.configuration.group.GroupPluginConfigurationUpdate;
import org.rhq.core.domain.configuration.group.GroupResourceConfigurationUpdate;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.rhq.test.JPAUtils;
import org.rhq.test.TransactionCallbackWithContext;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class LargeGroupTestBase
extends AbstractEJB3Test {
    protected static final String PC_PROP1_NAME = "LargeGroupTest pc prop1";
    protected static final String PC_PROP1_VALUE = "LargeGroupTest pc property one";
    protected static final String PC_PROP2_NAME = "LargeGroupTest pc prop2";
    protected static final String RC_PROP1_NAME = "LargeGroupTest rc prop1";
    protected static final String RC_PROP1_VALUE = "LargeGroupTest rc property one";
    protected static final String RC_PROP2_NAME = "LargeGroupTest rc prop2";
    protected ConfigurationManagerLocal configurationManager;
    protected ResourceManagerLocal resourceManager;
    protected ResourceGroupManagerLocal resourceGroupManager;
    protected SubjectManagerLocal subjectManager;

    @BeforeClass
    public void beforeClassBase() {
        this.configurationManager = LookupUtil.getConfigurationManager();
        this.resourceManager = LookupUtil.getResourceManager();
        this.resourceGroupManager = LookupUtil.getResourceGroupManager();
        this.subjectManager = LookupUtil.getSubjectManager();
    }

    @BeforeMethod
    public void beforeMethodBase() throws Exception {
        TestServerCommunicationsService agentServiceContainer = this.prepareForTestAgents();
        this.setupMockAgentServices(agentServiceContainer);
        this.prepareScheduler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod(alwaysRun=true)
    public void afterMethodBase() throws Exception {
        try {
            this.unprepareForTestAgents();
        }
        finally {
            this.unprepareScheduler();
        }
    }

    protected abstract void setupMockAgentServices(TestServerCommunicationsService var1);

    protected LargeGroupEnvironment createLargeGroupWithNormalUserRoleAccess(final int groupSize, final Permission ... permissions) {
        System.out.println("=====Creating a group with [" + groupSize + "] members");
        final LargeGroupEnvironment lge = new LargeGroupEnvironment();
        JPAUtils.executeInTransaction((TransactionCallbackWithContext)new TransactionCallbackWithContext<Object>(){

            public Object execute(TransactionManager tm, EntityManager em) throws Exception {
                lge.agent = SessionTestHelper.createNewAgent(em, "LargeGroupTestAgent");
                lge.platformType = new ResourceType("LargeGroupTestPlatformType", "testPlugin", ResourceCategory.PLATFORM, null);
                em.persist((Object)lge.platformType);
                lge.serverType = new ResourceType("LargeGroupTestServerType", "testPlugin", ResourceCategory.SERVER, lge.platformType);
                lge.serverPluginConfiguration = new ConfigurationDefinition("LargeGroupTestPCDef", "pc desc");
                lge.serverPluginConfiguration.put((PropertyDefinition)new PropertyDefinitionSimple(LargeGroupTestBase.PC_PROP1_NAME, "pc prop1desc", false, PropertySimpleType.STRING));
                lge.serverPluginConfiguration.put((PropertyDefinition)new PropertyDefinitionSimple(LargeGroupTestBase.PC_PROP2_NAME, "pc prop2desc", false, PropertySimpleType.STRING));
                lge.serverType.setPluginConfigurationDefinition(lge.serverPluginConfiguration);
                lge.serverResourceConfiguration = new ConfigurationDefinition("LargeGroupTestRCDef", "rc desc");
                lge.serverResourceConfiguration.put((PropertyDefinition)new PropertyDefinitionSimple(LargeGroupTestBase.RC_PROP1_NAME, "rc prop1desc", false, PropertySimpleType.STRING));
                lge.serverResourceConfiguration.put((PropertyDefinition)new PropertyDefinitionSimple(LargeGroupTestBase.RC_PROP2_NAME, "rc prop2desc", false, PropertySimpleType.STRING));
                lge.serverType.setResourceConfigurationDefinition(lge.serverResourceConfiguration);
                em.persist((Object)lge.serverType);
                em.flush();
                lge.platformResource = SessionTestHelper.createNewResource(em, "LargeGroupTestPlatform", lge.platformType);
                lge.platformResource.setAgent(lge.agent);
                lge.normalSubject = new Subject("LargeGroupTestSubject", true, false);
                lge.normalRole = SessionTestHelper.createNewRoleForSubject(em, lge.normalSubject, "LargeGroupTestRole", permissions);
                lge.unauthzSubject = SessionTestHelper.createNewSubject(em, "LargeGroupTestSubjectUnauth");
                lge.compatibleGroup = SessionTestHelper.createNewCompatibleGroupForRole(em, lge.normalRole, "LargeGroupTestCompatGroup", lge.serverType);
                System.out.print("=====> Creating member Resources (this might take some time)...");
                for (int i = 1; i <= groupSize; ++i) {
                    Resource res = SessionTestHelper.createNewResourceForGroup(em, lge.compatibleGroup, "LargeGroupTestServer", lge.serverType, i % 100 == 0);
                    res.setAgent(lge.agent);
                    lge.platformResource.addChildResource(res);
                    Configuration pc = new Configuration();
                    pc.put((Property)new PropertySimple(LargeGroupTestBase.PC_PROP1_NAME, (Object)LargeGroupTestBase.PC_PROP1_VALUE));
                    pc.put((Property)new PropertySimple(LargeGroupTestBase.PC_PROP2_NAME, (Object)res.getId()));
                    em.persist((Object)pc);
                    res.setPluginConfiguration(pc);
                    if (i % 100 == 0) {
                        System.out.print(i);
                        continue;
                    }
                    if (i % 10 != 0) continue;
                    System.out.print('.');
                }
                System.out.println(" Done.");
                em.flush();
                return null;
            }
        });
        System.out.println("=====Created group [" + lge.compatibleGroup.getName() + "] with [" + lge.platformResource.getChildResources().size() + "] members");
        return lge;
    }

    protected void tearDownLargeGroupWithNormalUserRoleAccess(final LargeGroupEnvironment lge) throws Exception {
        System.out.println("=====Cleaning up test data from " + ((Object)((Object)this)).getClass().getSimpleName());
        this.resourceGroupManager.deleteResourceGroup(this.getOverlord(), lge.compatibleGroup.getId());
        System.out.print("=====> Removing member Resources (this might take some time)...");
        List deletedIds = this.resourceManager.uninventoryResource(this.getOverlord(), lge.platformResource.getId());
        int deletedIdsSize = deletedIds.size();
        for (int i = 1; i <= deletedIdsSize; ++i) {
            Integer deletedResourceId = (Integer)deletedIds.get(i - 1);
            this.resourceManager.uninventoryResourceAsyncWork(this.getOverlord(), deletedResourceId.intValue());
            if (i % 100 == 0) {
                System.out.print(i);
                continue;
            }
            if (i % 10 != 0) continue;
            System.out.print('.');
        }
        System.out.println(" Done.");
        JPAUtils.executeInTransaction((TransactionCallbackWithContext)new TransactionCallbackWithContext<Object>(){

            public Object execute(TransactionManager tm, EntityManager em) throws Exception {
                lge.normalRole = (Role)em.getReference(Role.class, (Object)lge.normalRole.getId());
                lge.normalSubject = (Subject)em.getReference(Subject.class, (Object)lge.normalSubject.getId());
                lge.unauthzSubject = (Subject)em.getReference(Subject.class, (Object)lge.unauthzSubject.getId());
                em.remove((Object)lge.normalRole);
                em.remove((Object)lge.normalSubject);
                em.remove((Object)lge.unauthzSubject);
                return null;
            }
        });
        JPAUtils.executeInTransaction((TransactionCallbackWithContext)new TransactionCallbackWithContext<Object>(){

            public Object execute(TransactionManager tm, EntityManager em) throws Exception {
                ResourceType pType = (ResourceType)em.getReference(ResourceType.class, (Object)lge.platformResource.getResourceType().getId());
                ResourceType sType = (ResourceType)em.getReference(ResourceType.class, (Object)lge.compatibleGroup.getResourceType().getId());
                em.remove((Object)sType);
                em.remove((Object)pType);
                return null;
            }
        });
        System.out.println("=====Cleaned up test data from " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    protected ConfigurationUpdateStatus getGroupPluginConfigurationStatus(final int groupId) {
        return (ConfigurationUpdateStatus)JPAUtils.executeInTransaction((TransactionCallbackWithContext)new TransactionCallbackWithContext<ConfigurationUpdateStatus>(){

            public ConfigurationUpdateStatus execute(TransactionManager tm, EntityManager em) throws Exception {
                try {
                    Query query = em.createNamedQuery("GroupPluginConfigurationUpdatee.findLatestByGroupId");
                    query.setParameter("groupId", (Object)groupId);
                    GroupPluginConfigurationUpdate latestConfigGroupUpdate = (GroupPluginConfigurationUpdate)query.getSingleResult();
                    return latestConfigGroupUpdate.getStatus();
                }
                catch (NoResultException nre) {
                    return null;
                }
            }
        });
    }

    protected ConfigurationUpdateStatus getGroupResourceConfigurationStatus(final int groupId) {
        return (ConfigurationUpdateStatus)JPAUtils.executeInTransaction((TransactionCallbackWithContext)new TransactionCallbackWithContext<ConfigurationUpdateStatus>(){

            public ConfigurationUpdateStatus execute(TransactionManager tm, EntityManager em) throws Exception {
                try {
                    Query query = em.createNamedQuery("GroupResourceConfigurationUpdate.findLatestByGroupId");
                    query.setParameter("groupId", (Object)groupId);
                    GroupResourceConfigurationUpdate latestConfigGroupUpdate = (GroupResourceConfigurationUpdate)query.getSingleResult();
                    return latestConfigGroupUpdate.getStatus();
                }
                catch (NoResultException nre) {
                    return null;
                }
            }
        });
    }

    protected Subject getOverlord() {
        return this.subjectManager.getOverlord();
    }

    protected class LargeGroupEnvironment {
        public Agent agent;
        public Resource platformResource;
        public ResourceType platformType;
        public ResourceType serverType;
        public ConfigurationDefinition serverPluginConfiguration;
        public ConfigurationDefinition serverResourceConfiguration;
        public ResourceGroup compatibleGroup;
        public Subject normalSubject;
        public Role normalRole;
        public Subject unauthzSubject;

        protected LargeGroupEnvironment() {
        }
    }
}

