/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.test;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.plugin.pc.AbstractTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainerConfiguration;
import org.rhq.enterprise.server.plugin.pc.ServerPluginService;
import org.rhq.enterprise.server.plugin.pc.alert.AlertServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.content.PackageTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.entitlement.EntitlementServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.generic.GenericServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.perspective.PerspectiveServerPluginContainer;
import org.rhq.enterprise.server.test.StandardServerPluginServiceMBean;

public class StandardServerPluginService
extends ServerPluginService
implements StandardServerPluginServiceMBean {
    private static final Log LOG = LogFactory.getLog(StandardServerPluginService.class);
    public TestMasterServerPluginContainer master;
    public MasterServerPluginContainerConfiguration masterConfig;
    public List<Class<? extends AbstractTypeServerPluginContainer>> pluginContainerClasses;

    public StandardServerPluginService() {
        File dir = new File(System.getProperty("java.io.tmpdir"), "test-server-plugins");
        this.masterConfig = new MasterServerPluginContainerConfiguration(dir, dir, dir, null);
        this.pluginContainerClasses = new ArrayList<Class<? extends AbstractTypeServerPluginContainer>>();
        this.pluginContainerClasses.add(AlertServerPluginContainer.class);
        this.pluginContainerClasses.add(BundleServerPluginContainer.class);
        this.pluginContainerClasses.add(ContentServerPluginContainer.class);
        this.pluginContainerClasses.add(EntitlementServerPluginContainer.class);
        this.pluginContainerClasses.add(GenericServerPluginContainer.class);
        this.pluginContainerClasses.add(PackageTypeServerPluginContainer.class);
        this.pluginContainerClasses.add(PerspectiveServerPluginContainer.class);
    }

    protected MasterServerPluginContainer createMasterPluginContainer() {
        this.master = new TestMasterServerPluginContainer(this.pluginContainerClasses);
        this.master.initialize(this.masterConfig);
        return this.master;
    }

    public static class TestMasterServerPluginContainer
    extends MasterServerPluginContainer {
        private List<AbstractTypeServerPluginContainer> serverPluginContainers = new ArrayList<AbstractTypeServerPluginContainer>();

        public TestMasterServerPluginContainer(List<Class<? extends AbstractTypeServerPluginContainer>> pluginContainerClasses) {
            for (Class<? extends AbstractTypeServerPluginContainer> cls : pluginContainerClasses) {
                try {
                    Constructor<? extends AbstractTypeServerPluginContainer> ctor = cls.getConstructor(MasterServerPluginContainer.class);
                    AbstractTypeServerPluginContainer container = ctor.newInstance(new Object[]{this});
                    this.serverPluginContainers.add(container);
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to instantiate server plugin container class: " + cls.getName()), (Throwable)e);
                }
            }
        }

        protected List<AbstractTypeServerPluginContainer> createPluginContainers() {
            return this.serverPluginContainers;
        }
    }
}

