/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.io.PrintWriter;
import java.util.Date;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class LoggerAntBuildListener
implements BuildListener {
    private PrintWriter output;

    public LoggerAntBuildListener(PrintWriter logFile) {
        this.output = logFile;
        this.output.println(new Date().toString());
    }

    public void buildFinished(BuildEvent event) {
        this.logEvent(event, "FINISHED!");
    }

    public void buildStarted(BuildEvent event) {
        this.logEvent(event, "STARTED!");
    }

    public void messageLogged(BuildEvent event) {
        this.logEvent(event, null);
    }

    public void targetFinished(BuildEvent event) {
        this.logEvent(event, null);
    }

    public void targetStarted(BuildEvent event) {
        this.logEvent(event, null);
    }

    public void taskFinished(BuildEvent event) {
        this.logEvent(event, null);
    }

    public void taskStarted(BuildEvent event) {
        this.logEvent(event, null);
    }

    private void logEvent(BuildEvent event, String additionalMessage) {
        String message = event.getMessage();
        Throwable exception = event.getException();
        Target target = event.getTarget();
        Task task = event.getTask();
        if (additionalMessage != null) {
            this.output.println(additionalMessage);
        }
        if (target != null) {
            this.output.print("[" + target.getName() + "] ");
        }
        if (task != null) {
            this.output.print("[" + task.getTaskName() + "] ");
        }
        if (message != null) {
            this.output.print(message);
        }
        if (exception != null) {
            this.output.println();
            exception.printStackTrace(this.output);
        }
        this.output.println();
    }
}

