/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.persistence.EntityManager;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;

public class ResourceTreeHelper {
    private static int fakeTypeId = 0;

    public static List<Resource> createTree(String flatStructure) {
        return ResourceTreeHelper.createTree(null, flatStructure);
    }

    public static synchronized List<Resource> createTree(EntityManager entityManager, String flatStructure) {
        flatStructure = flatStructure.replaceAll("\\s", "");
        ResourceType fakeType = null;
        if (null != entityManager) {
            fakeType = (ResourceType)entityManager.find(ResourceType.class, (Object)fakeTypeId);
            if (null == fakeType) {
                fakeType = new ResourceType("fakeType", "fakePlugin", ResourceCategory.PLATFORM, null);
                ResourceTreeHelper.persist(entityManager, fakeType);
                fakeTypeId = fakeType.getId();
            }
        } else {
            fakeType = new ResourceType("fakeType", "fakePlugin", ResourceCategory.PLATFORM, null);
        }
        HashMap<String, Resource> resources = new HashMap<String, Resource>();
        String[] relationships = flatStructure.split(";");
        for (int i = 0; i < relationships.length; ++i) {
            String relationship = relationships[i];
            int splitIndex = relationship.indexOf("=");
            String parent = relationship.substring(0, splitIndex);
            String[] children = relationship.substring(splitIndex + 1).split(",");
            Resource parentResource = null;
            if (resources.containsKey(parent)) {
                parentResource = (Resource)resources.get(parent);
            } else {
                parentResource = new Resource(parent, parent, fakeType);
                parentResource.setUuid("" + new Random().nextInt());
                resources.put(parent, parentResource);
            }
            for (String child : children) {
                Resource childResource = null;
                if (resources.containsKey(child)) {
                    childResource = (Resource)resources.get(child);
                } else {
                    childResource = new Resource(child, child, fakeType);
                    childResource.setUuid("" + new Random().nextInt());
                    resources.put(child, childResource);
                }
                childResource.setParentResource(parentResource);
                parentResource.addChildResource(childResource);
            }
        }
        ArrayList<Resource> roots = new ArrayList<Resource>();
        for (Resource potentialRoot : resources.values()) {
            potentialRoot.setInventoryStatus(InventoryStatus.COMMITTED);
            ResourceTreeHelper.persist(entityManager, potentialRoot);
            if (potentialRoot.getParentResource() != null) continue;
            roots.add(potentialRoot);
        }
        if (entityManager != null) {
            entityManager.flush();
        }
        return roots;
    }

    public static void deleteForest(EntityManager entityManager, List<Resource> roots) {
        for (Resource root : roots) {
            Resource doomedRoot = (Resource)entityManager.find(Resource.class, (Object)root.getId());
            if (null == doomedRoot) continue;
            ResourceType doomedResourceType = doomedRoot.getResourceType();
            ResourceTreeHelper.deleteTree(entityManager, root);
            if (null == doomedResourceType) continue;
            doomedResourceType = (ResourceType)entityManager.find(ResourceType.class, (Object)doomedResourceType.getId());
            entityManager.remove((Object)doomedResourceType);
        }
    }

    private static void deleteTree(EntityManager entityManager, Resource root) {
        for (Resource child : root.getChildResources()) {
            ResourceTreeHelper.deleteTree(entityManager, child);
        }
        Resource doomedResource = (Resource)entityManager.find(Resource.class, (Object)root.getId());
        entityManager.remove((Object)doomedResource);
    }

    public static Resource findNode(List<Resource> roots, String name) {
        Resource root;
        Resource node = null;
        Iterator<Resource> i$ = roots.iterator();
        while (i$.hasNext() && (node = ResourceTreeHelper.findNode(root = i$.next(), name)) == null) {
        }
        return node;
    }

    public static Resource findNode(Resource resource, String name) {
        Resource child;
        if (name.equals(resource.getName())) {
            return resource;
        }
        Resource result = null;
        Iterator i$ = resource.getChildResources().iterator();
        while (i$.hasNext() && (result = ResourceTreeHelper.findNode(child = (Resource)i$.next(), name)) == null) {
        }
        return result;
    }

    public static List<Resource> getSubtree(Resource resource) {
        ArrayList<Resource> subtree = new ArrayList<Resource>();
        LinkedList<Resource> toBeSearched = new LinkedList<Resource>();
        toBeSearched.add(resource);
        while (toBeSearched.size() > 0) {
            Resource next = (Resource)toBeSearched.remove(0);
            subtree.add(next);
            toBeSearched.addAll(next.getChildResources());
        }
        return subtree;
    }

    public static List<Resource> findSubtree(Resource resource, String name) {
        return ResourceTreeHelper.getSubtree(ResourceTreeHelper.findNode(resource, name));
    }

    private static void persist(EntityManager entityManager, Object object) {
        if (entityManager != null) {
            entityManager.persist(object);
        }
    }

    public static void printForest(List<Resource> resources) {
        for (Resource root : resources) {
            ResourceTreeHelper.printTree(root);
        }
    }

    public static void printTree(Resource resource) {
        ResourceTreeHelper.printTreeHelper(resource, 0, "");
    }

    private static void printTreeHelper(Resource resource, int level, String namePrefix) {
        for (int i = 0; i < level; ++i) {
            System.out.print("   ");
        }
        System.out.println("<resource id=\"" + resource.getId() + "\" " + "name=\"" + resource.getName() + "\" " + "path=\"" + namePrefix + resource.getName() + "\" />");
        for (Resource child : resource.getChildResources()) {
            ResourceTreeHelper.printTreeHelper(child, level + 1, namePrefix + resource.getName() + ".");
        }
    }

    public static void main(String[] args) {
        List<Resource> resourceRoots = ResourceTreeHelper.createTree("A=1,2; 1=a,b; a=i,ii; b=iii,iv; B=3");
        for (Resource root : resourceRoots) {
            ResourceTreeHelper.printTree(root);
        }
    }
}

