/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.test;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertConditionLog;
import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.alert.AlertManagerBean;
import org.rhq.enterprise.server.alert.i18n.AlertI18NFactory;
import org.testng.annotations.Test;

@Test
public class AlertManagerBeanTest {
    private static final String TEN_PERCENT = String.format("%2.1f%%", 10.0);
    private static final String TWELVE_DOT_5_B = String.format("%2.1fB", 12.5);
    private String pretty;

    public void testPrettyPrintAVAILABILITY() {
        AlertCondition condition = this.createCondition(AlertConditionCategory.AVAILABILITY, AlertConditionOperator.AVAIL_GOES_UP.name(), null, null, null, null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.availability.up");
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.availability.up.short");
        condition = this.createCondition(AlertConditionCategory.AVAILABILITY, AlertConditionOperator.AVAIL_GOES_DOWN.name(), null, null, null, null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.availability.down");
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.availability.down.short");
        condition = this.createCondition(AlertConditionCategory.AVAILABILITY, AlertConditionOperator.AVAIL_GOES_DISABLED.name(), null, null, null, null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.availability.disabled");
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.availability.disabled.short");
        condition = this.createCondition(AlertConditionCategory.AVAILABILITY, AlertConditionOperator.AVAIL_GOES_UNKNOWN.name(), null, null, null, null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.availability.unknown");
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.availability.unknown.short");
    }

    public void testPrettyPrintAVAILABILITY_DURATION() {
        AlertCondition condition = this.createCondition(AlertConditionCategory.AVAIL_DURATION, AlertConditionOperator.AVAIL_DURATION_DOWN.name(), null, null, "120", null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Availability stays DOWN [2m]".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Avail stays DOWN [2m]".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.AVAIL_DURATION, AlertConditionOperator.AVAIL_DURATION_NOT_UP.name(), null, null, "120", null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Availability stays NOT UP [2m]".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Avail stays NOT UP [2m]".equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintTHRESHOLD() {
        MeasurementDefinition md = this.createDynamicMeasurementDefinition();
        AlertCondition condition = this.createCondition(AlertConditionCategory.THRESHOLD, md.getDisplayName(), ">", 12.5, null, md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        String ref = String.format("Foo Prop > %2.1fB", 12.5);
        assert (ref.equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert (ref.equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintTHRESHOLD_Calltime() {
        MeasurementDefinition md = this.createCalltimeMeasurementDefinition();
        String regex = "some.*(reg)?ex$";
        AlertCondition condition = this.createCondition(AlertConditionCategory.THRESHOLD, regex, ">", 12.5, "MAX", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.calltime-threshold-with-expr", "CT Prop", "MAX", ">", TWELVE_DOT_5_B, regex);
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.calltime-threshold-with-expr.short", "CT Prop", "MAX", ">", TWELVE_DOT_5_B, regex);
        condition = this.createCondition(AlertConditionCategory.THRESHOLD, null, ">", 12.5, "MAX", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.calltime-threshold", "CT Prop", "MAX", ">", TWELVE_DOT_5_B);
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.calltime-threshold.short", "CT Prop", "MAX", ">", TWELVE_DOT_5_B);
    }

    public void testPrettyPrintBASELINE() {
        MeasurementDefinition md = this.createDynamicMeasurementDefinition();
        AlertCondition condition = this.createCondition(AlertConditionCategory.BASELINE, md.getDisplayName(), ">", 0.1, "mean", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.baseline.mean", "Foo Prop", ">", TEN_PERCENT);
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.baseline.mean.short", "Foo Prop", ">", TEN_PERCENT);
        condition = this.createCondition(AlertConditionCategory.BASELINE, md.getDisplayName(), ">", 0.1, "min", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.baseline.min", "Foo Prop", ">", TEN_PERCENT);
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.baseline.min.short", "Foo Prop", ">", TEN_PERCENT);
        condition = this.createCondition(AlertConditionCategory.BASELINE, md.getDisplayName(), ">", 0.1, "max", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.baseline.max", "Foo Prop", ">", TEN_PERCENT);
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.baseline.max.short", "Foo Prop", ">", TEN_PERCENT);
    }

    public void testPrettyPrintCHANGE() {
        MeasurementDefinition md = this.createDynamicMeasurementDefinition();
        AlertCondition condition = this.createCondition(AlertConditionCategory.CHANGE, md.getDisplayName(), null, null, null, md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.metric.changed", "Foo Prop");
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.metric.changed.short", "Foo Prop");
    }

    public void testPrettyPrintCHANGE_Calltime() {
        MeasurementDefinition md = this.createCalltimeMeasurementDefinition();
        String regex = "some.*(reg)?ex$";
        AlertCondition condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "LO", 0.1, "MIN", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        String msg = AlertI18NFactory.getMessage((String)"alert.condition.calltime-change.shrinks", (Object[])new Object[0]);
        String ref = "Calltime Metric CT Prop MIN %s by at least %2.1f%% with calltime destination matching \"some.*(reg)?ex$\"";
        String refs = "CT Prop MIN %s by %2.1f%% matching \"some.*(reg)?ex$\"";
        assert (String.format(ref, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert (String.format(refs, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty + " \n<=> " + String.format(refs, msg, Float.valueOf(10.0f));
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "CH", 0.1, "MIN", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        msg = AlertI18NFactory.getMessage((String)"alert.condition.calltime-change.changes", (Object[])new Object[0]);
        assert (String.format(ref, msg, Float.valueOf(10.0f)).equals(this.pretty));
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert (String.format(refs, msg, Float.valueOf(10.0f)).equals(this.pretty));
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "HI", 0.1, "MIN", md);
        msg = AlertI18NFactory.getMessage((String)"alert.condition.calltime-change.grows", (Object[])new Object[0]);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert (String.format(ref, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert (String.format(refs, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty + " \n<=> " + String.format(refs, msg, Float.valueOf(10.0f));
        ref = "Calltime Metric CT Prop MAX %s by at least %2.1f%% with calltime destination matching \"some.*(reg)?ex$\"";
        refs = "CT Prop MAX %s by %2.1f%% matching \"some.*(reg)?ex$\"";
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "LO", 0.1, "MAX", md);
        msg = AlertI18NFactory.getMessage((String)"alert.condition.calltime-change.shrinks", (Object[])new Object[0]);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert (String.format(ref, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert (String.format(refs, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty + " \n<=> " + String.format(refs, msg, Float.valueOf(10.0f));
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "CH", 0.1, "MAX", md);
        msg = AlertI18NFactory.getMessage((String)"alert.condition.calltime-change.changes", (Object[])new Object[0]);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert (String.format(ref, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert (String.format(refs, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty + " \n<=> " + String.format(refs, msg, Float.valueOf(10.0f));
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "HI", 0.1, "MAX", md);
        msg = AlertI18NFactory.getMessage((String)"alert.condition.calltime-change.grows", (Object[])new Object[0]);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert (String.format(ref, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert (String.format(refs, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty + " \n<=> " + String.format(refs, msg, Float.valueOf(10.0f));
        ref = "Calltime Metric CT Prop AVG %s by at least %2.1f%% with calltime destination matching \"some.*(reg)?ex$\"";
        refs = "CT Prop AVG %s by %2.1f%% matching \"some.*(reg)?ex$\"";
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "LO", 0.1, "AVG", md);
        msg = AlertI18NFactory.getMessage((String)"alert.condition.calltime-change.shrinks", (Object[])new Object[0]);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert (String.format(ref, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert (String.format(refs, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty + " \n<=> " + String.format(refs, msg, Float.valueOf(10.0f));
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "CH", 0.1, "AVG", md);
        msg = AlertI18NFactory.getMessage((String)"alert.condition.calltime-change.changes", (Object[])new Object[0]);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert (String.format(ref, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert (String.format(refs, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty + " \n<=> " + String.format(refs, msg, Float.valueOf(10.0f));
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "HI", 0.1, "AVG", md);
        msg = AlertI18NFactory.getMessage((String)"alert.condition.calltime-change.grows", (Object[])new Object[0]);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert (String.format(ref, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert (String.format(refs, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty + " \n<=> " + String.format(refs, msg, Float.valueOf(10.0f));
        ref = "Calltime Metric CT Prop AVG %s by at least %2.1f%%";
        refs = "CT Prop AVG %s by %2.1f%%";
        condition = this.createCondition(AlertConditionCategory.CHANGE, null, "LO", 0.1, "AVG", md);
        msg = AlertI18NFactory.getMessage((String)"alert.condition.calltime-change.shrinks", (Object[])new Object[0]);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert (String.format(ref, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert (String.format(refs, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty + " \n<=> " + String.format(refs, msg, Float.valueOf(10.0f));
        condition = this.createCondition(AlertConditionCategory.CHANGE, null, "CH", 0.1, "AVG", md);
        msg = AlertI18NFactory.getMessage((String)"alert.condition.calltime-change.changes", (Object[])new Object[0]);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert (String.format(ref, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert (String.format(refs, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty + " \n<=> " + String.format(refs, msg, Float.valueOf(10.0f));
        condition = this.createCondition(AlertConditionCategory.CHANGE, null, "HI", 0.1, "AVG", md);
        msg = AlertI18NFactory.getMessage((String)"alert.condition.calltime-change.grows", (Object[])new Object[0]);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert (String.format(ref, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert (String.format(refs, msg, Float.valueOf(10.0f)).equals(this.pretty)) : this.pretty + " \n<=> " + String.format(refs, msg, Float.valueOf(10.0f));
    }

    public void testPrettyPrintTRAIT() {
        MeasurementDefinition md = this.createTraitMeasurementDefinition();
        AlertCondition condition = this.createCondition(AlertConditionCategory.TRAIT, md.getDisplayName(), null, null, null, md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.metric.changed", "Blah Trait");
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.metric.changed.short", "Blah Trait");
    }

    public void testPrettyPrintCONTROL() {
        AlertCondition condition = this.createCondition(AlertConditionCategory.CONTROL, "opNameHere", null, null, OperationRequestStatus.FAILURE.name(), null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.op", "opNameHere", "FAILURE");
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.op.short", "opNameHere", "FAILURE");
        condition = this.createCondition(AlertConditionCategory.CONTROL, "opNameHere", null, null, OperationRequestStatus.SUCCESS.name(), null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.op", "opNameHere", "SUCCESS");
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.op.short", "opNameHere", "SUCCESS");
    }

    public void testPrettyPrintEVENT() {
        String regex = "some.*(reg)?ex$";
        AlertCondition condition = this.createCondition(AlertConditionCategory.EVENT, EventSeverity.WARN.name(), null, null, regex, null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert (("Event With Severity [WARN] Matching Expression \"" + regex + "\"").equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert (("[WARN] Event Matching \"" + regex + "\"").equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.EVENT, EventSeverity.WARN.name(), null, null, null, null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Event With Severity [WARN]".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("[WARN] Event".equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintRESOURCECONFIG() {
        AlertCondition condition = this.createCondition(AlertConditionCategory.RESOURCE_CONFIG, null, null, null, null, null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Resource Configuration Changed".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Res Config Chg".equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintDRIFT() {
        AlertCondition condition = this.createCondition(AlertConditionCategory.DRIFT, "?riftName", null, null, "fil.*", null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Drift detected for files that match \"fil.*\" and for drift definition [?riftName]".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Drift matching \"fil.*\", config=[?riftName]".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.DRIFT, null, null, null, "fil.*", null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Drift detected for files that match \"fil.*\"".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Drift matching \"fil.*\"".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.DRIFT, "?riftName", null, null, null, null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Drift detected for drift definition [?riftName]".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Drift! config=[?riftName]".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.DRIFT, null, null, null, null, null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Drift Detected".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Drift!".equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintRANGE() {
        MeasurementDefinition md = this.createDynamicMeasurementDefinition();
        AlertCondition condition = this.createCondition(AlertConditionCategory.RANGE, md.getDisplayName(), "<=", 1.0, "22.2", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.range.in.incl", "Foo Prop", String.format("%1.1fB", 1.0), String.format("%2.1fB", 22.2));
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.range.in.incl.short", "Foo Prop", String.format("%1.1fB", 1.0), String.format("%2.1fB", 22.2));
        condition = this.createCondition(AlertConditionCategory.RANGE, md.getDisplayName(), ">=", 1.0, "22.2", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.range.out.incl", "Foo Prop", String.format("%1.1fB", 1.0), String.format("%2.1fB", 22.2));
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.range.out.incl.short", "Foo Prop", String.format("%1.1fB", 1.0), String.format("%2.1fB", 22.2));
        condition = this.createCondition(AlertConditionCategory.RANGE, md.getDisplayName(), "<", 1.0, "22.2", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.range.in.excl", "Foo Prop", String.format("%1.1fB", 1.0), String.format("%2.1fB", 22.2));
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.range.in.excl.short", "Foo Prop", String.format("%1.1fB", 1.0), String.format("%2.1fB", 22.2));
        condition = this.createCondition(AlertConditionCategory.RANGE, md.getDisplayName(), ">", 1.0, "22.2", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        this.check("alert.condition.range.out.excl", "Foo Prop", String.format("%1.1fB", 1.0), String.format("%2.1fB", 22.2));
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        this.check("alert.condition.range.out.excl.short", "Foo Prop", String.format("%1.1fB", 1.0), String.format("%2.1fB", 22.2));
    }

    private String getPrettyAlertConditionString(AlertCondition condition) {
        AlertManagerBean pojo = new AlertManagerBean();
        String s = this.extractCondition(pojo.prettyPrintAlertConditions(this.createAlert(condition), false));
        System.out.println("long===>" + s);
        return s;
    }

    private String getShortPrettyAlertConditionString(AlertCondition condition) {
        AlertManagerBean pojo = new AlertManagerBean();
        String s = this.extractCondition(pojo.prettyPrintAlertConditions(this.createAlert(condition), true));
        System.out.println("short-->" + s);
        return s;
    }

    private MeasurementDefinition createDynamicMeasurementDefinition() {
        ResourceType resourceType = new ResourceType("testType", "testPlugin", ResourceCategory.PLATFORM, null);
        MeasurementDefinition md = new MeasurementDefinition(resourceType, "fooMetric");
        md.setDataType(DataType.MEASUREMENT);
        md.setDisplayName("Foo Prop");
        md.setMeasurementType(NumericType.DYNAMIC);
        md.setRawNumericType(NumericType.DYNAMIC);
        md.setUnits(MeasurementUnits.BYTES);
        return md;
    }

    private MeasurementDefinition createCalltimeMeasurementDefinition() {
        ResourceType resourceType = new ResourceType("testType", "testPlugin", ResourceCategory.PLATFORM, null);
        MeasurementDefinition md = new MeasurementDefinition(resourceType, "ctMetric");
        md.setDataType(DataType.CALLTIME);
        md.setDisplayName("CT Prop");
        md.setMeasurementType(NumericType.DYNAMIC);
        md.setRawNumericType(NumericType.DYNAMIC);
        md.setUnits(MeasurementUnits.BYTES);
        md.setDestinationType("/wot gorilla");
        return md;
    }

    private MeasurementDefinition createTraitMeasurementDefinition() {
        ResourceType resourceType = new ResourceType("testType", "testPlugin", ResourceCategory.PLATFORM, null);
        MeasurementDefinition md = new MeasurementDefinition(resourceType, "traitMetric");
        md.setDataType(DataType.TRAIT);
        md.setDisplayName("Blah Trait");
        md.setUnits(MeasurementUnits.BYTES);
        return md;
    }

    private Alert createAlert(AlertCondition condition) {
        Alert alert = new Alert();
        AlertConditionLog conditionLog = new AlertConditionLog(condition, System.currentTimeMillis());
        alert.addConditionLog(conditionLog);
        return alert;
    }

    private AlertCondition createCondition(AlertConditionCategory category, String name, String comparator, Double threshold, String option, MeasurementDefinition measDef) {
        AlertCondition condition = new AlertCondition();
        condition.setCategory(category);
        condition.setName(name);
        condition.setComparator(comparator);
        condition.setThreshold(threshold);
        condition.setOption(option);
        condition.setMeasurementDefinition(measDef);
        return condition;
    }

    private String extractCondition(String prettyString) {
        String cond = AlertI18NFactory.getMessage((String)"alert.condition.pattern", (Object[])new Object[0]);
        Pattern pattern = Pattern.compile("- " + cond + " 1: (.*)\n");
        Matcher matcher = pattern.matcher(prettyString);
        assert (matcher.find()) : "could not find the condition string";
        return matcher.group(1);
    }

    private void check(String msg) {
        String ref = AlertI18NFactory.getMessage((String)msg, (Object[])new Object[0]);
        assert (ref != null) : "Could not find reference message";
        assert (ref.equals(this.pretty)) : this.pretty;
    }

    private void check(String msg, Object ... args) {
        String ref = AlertI18NFactory.getMessage((String)msg, (Object[])args);
        assert (ref != null) : "Could not find reference message";
        assert (ref.equals(this.pretty)) : "Got : >>" + this.pretty + "<<   Expect: >>" + ref + "<<";
    }
}

