/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration;

import java.lang.reflect.Field;
import javax.persistence.EntityManager;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Sequence;
import org.jmock.internal.ExpectationBuilder;
import org.rhq.core.clientapi.agent.configuration.ConfigurationAgentService;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUpdateRequest;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.AbstractResourceConfigurationUpdate;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.RawConfiguration;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationFormat;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.configuration.ConfigurationManagerBean;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.configuration.ConfigurationUpdateNotSupportedException;
import org.rhq.enterprise.server.configuration.TranslationNotSupportedException;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.test.AssertUtils;
import org.rhq.test.JMockTest;
import org.rhq.test.jmock.PropertyMatcher;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ConfigurationManagerBeanUnitTest
extends JMockTest {
    static final boolean FROM_STRUCTURED = true;
    static final boolean FROM_RAW = false;
    static final Subject OVERLORD = new Subject("overlord", true, true);
    ConfigurationManagerLocal configurationMgrLocal;
    ResourceManagerLocal resourceMgr;
    SubjectManagerLocal subjectMgr;
    AgentManagerLocal agentMgr;
    AuthorizationManagerLocal authorizationMgr;
    EntityManager entityMgr;
    ConfigurationManagerBean configurationMgr;

    @BeforeMethod
    public void setup() throws Exception {
        this.configurationMgr = new ConfigurationManagerBean();
        this.configurationMgrLocal = (ConfigurationManagerLocal)this.context.mock(ConfigurationManagerLocal.class);
        ConfigurationManagerBeanUnitTest.setField(this.configurationMgr, "configurationManager", this.configurationMgrLocal);
        this.agentMgr = (AgentManagerLocal)this.context.mock(AgentManagerLocal.class);
        ConfigurationManagerBeanUnitTest.setField(this.configurationMgr, "agentManager", this.agentMgr);
        this.authorizationMgr = (AuthorizationManagerLocal)this.context.mock(AuthorizationManagerLocal.class);
        ConfigurationManagerBeanUnitTest.setField(this.configurationMgr, "authorizationManager", this.authorizationMgr);
        this.entityMgr = (EntityManager)this.context.mock(EntityManager.class);
        ConfigurationManagerBeanUnitTest.setField(this.configurationMgr, "entityManager", this.entityMgr);
        this.resourceMgr = (ResourceManagerLocal)this.context.mock(ResourceManagerLocal.class);
        ConfigurationManagerBeanUnitTest.setField(this.configurationMgr, "resourceManager", this.resourceMgr);
        this.subjectMgr = (SubjectManagerLocal)this.context.mock(SubjectManagerLocal.class);
        ConfigurationManagerBeanUnitTest.setField(this.configurationMgr, "subjectManager", this.subjectMgr);
    }

    static void setField(Object src, String fieldName, Object value) {
        try {
            Field field = src.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(src, value);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            String msg = "The field <" + fieldName + "> does not exist for " + src.getClass().getName();
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void updateStructuredResourceConfigShouldUpdateAuditTrailAndSendUpdateToAgent() throws Exception {
        final ResourceConfigUpdateFixture fixture = this.newStructuredResourceConfigUpdateFixture();
        final ResourceConfigurationUpdate expectedUpdate = new ResourceConfigurationUpdate(fixture.resource, fixture.configuration, fixture.subject.getName());
        final AgentClient agentClient = (AgentClient)this.context.mock(AgentClient.class);
        final ConfigurationAgentService configAgentService = (ConfigurationAgentService)this.context.mock(ConfigurationAgentService.class);
        final ConfigurationUpdateRequest expectedUpdateRequest = new ConfigurationUpdateRequest(expectedUpdate.getId(), expectedUpdate.getConfiguration(), expectedUpdate.getResource().getId());
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SubjectManagerLocal)this.allowing(ConfigurationManagerBeanUnitTest.this.subjectMgr)).getOverlord();
                this.will(1.returnValue((Object)OVERLORD));
                ((ResourceManagerLocal)this.allowing(ConfigurationManagerBeanUnitTest.this.resourceMgr)).getResource(OVERLORD, fixture.resourceId);
                this.will(1.returnValue((Object)fixture.resource));
                ((AuthorizationManagerLocal)this.oneOf(ConfigurationManagerBeanUnitTest.this.authorizationMgr)).hasResourcePermission(fixture.subject, Permission.CONFIGURE_WRITE, fixture.resourceId);
                this.will(1.returnValue((Object)true));
                ((EntityManager)this.allowing(ConfigurationManagerBeanUnitTest.this.entityMgr)).find(Resource.class, (Object)fixture.resourceId);
                this.will(1.returnValue((Object)fixture.resource));
                ((ConfigurationManagerLocal)this.oneOf(ConfigurationManagerBeanUnitTest.this.configurationMgrLocal)).persistResourceConfigurationUpdateInNewTransaction(fixture.subject, fixture.resourceId, fixture.configuration, ConfigurationUpdateStatus.INPROGRESS, fixture.subject.getName(), fixture.isPartOfGroupUpdate);
                this.will(1.returnValue((Object)expectedUpdate));
                ((AgentManagerLocal)this.allowing(ConfigurationManagerBeanUnitTest.this.agentMgr)).getAgentClient(expectedUpdate.getResource().getAgent());
                this.will(1.returnValue((Object)agentClient));
                ((AgentClient)this.allowing(agentClient)).getConfigurationAgentService();
                this.will(1.returnValue((Object)configAgentService));
                ((ConfigurationAgentService)this.oneOf(configAgentService)).updateResourceConfiguration((ConfigurationUpdateRequest)this.with(ConfigurationManagerBeanUnitTest.matchingUpdateRequest(expectedUpdateRequest)));
            }
        });
        ResourceConfigurationUpdate actualUpdate = this.configurationMgr.updateResourceConfiguration(fixture.subject, fixture.resourceId, fixture.configuration);
        Assert.assertSame((Object)actualUpdate, (Object)expectedUpdate, (String)"Expected to get back the persisted configuration update");
    }

    @Test
    public void updateRawResourceConfigShouldUpdateAuditTrailAndSendUpdateToAgent() throws Exception {
        final ResourceConfigUpdateFixture fixture = this.newRawResourceConfigUpdateFixture();
        final ResourceConfigurationUpdate expectedUpdate = new ResourceConfigurationUpdate(fixture.resource, fixture.configuration, fixture.subject.getName());
        final AgentClient agentClient = (AgentClient)this.context.mock(AgentClient.class);
        final ConfigurationAgentService configAgentService = (ConfigurationAgentService)this.context.mock(ConfigurationAgentService.class);
        final ConfigurationUpdateRequest expectedUpdateRequest = new ConfigurationUpdateRequest(expectedUpdate.getId(), expectedUpdate.getConfiguration(), expectedUpdate.getResource().getId());
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SubjectManagerLocal)this.allowing(ConfigurationManagerBeanUnitTest.this.subjectMgr)).getOverlord();
                this.will(2.returnValue((Object)OVERLORD));
                ((ResourceManagerLocal)this.allowing(ConfigurationManagerBeanUnitTest.this.resourceMgr)).getResource(OVERLORD, fixture.resourceId);
                this.will(2.returnValue((Object)fixture.resource));
                ((EntityManager)this.allowing(ConfigurationManagerBeanUnitTest.this.entityMgr)).find(Resource.class, (Object)fixture.resourceId);
                this.will(2.returnValue((Object)fixture.resource));
                ((AuthorizationManagerLocal)this.oneOf(ConfigurationManagerBeanUnitTest.this.authorizationMgr)).hasResourcePermission(fixture.subject, Permission.CONFIGURE_WRITE, fixture.resourceId);
                this.will(2.returnValue((Object)true));
                ((ConfigurationManagerLocal)this.oneOf(ConfigurationManagerBeanUnitTest.this.configurationMgrLocal)).persistResourceConfigurationUpdateInNewTransaction(fixture.subject, fixture.resourceId, fixture.configuration, ConfigurationUpdateStatus.INPROGRESS, fixture.subject.getName(), fixture.isPartOfGroupUpdate);
                this.will(2.returnValue((Object)expectedUpdate));
                ((AgentManagerLocal)this.allowing(ConfigurationManagerBeanUnitTest.this.agentMgr)).getAgentClient(expectedUpdate.getResource().getAgent());
                this.will(2.returnValue((Object)agentClient));
                ((AgentClient)this.allowing(agentClient)).getConfigurationAgentService();
                this.will(2.returnValue((Object)configAgentService));
                ((ConfigurationAgentService)this.oneOf(configAgentService)).updateResourceConfiguration((ConfigurationUpdateRequest)this.with(ConfigurationManagerBeanUnitTest.matchingUpdateRequest(expectedUpdateRequest)));
            }
        });
        ResourceConfigurationUpdate actualUpdate = this.configurationMgr.updateResourceConfiguration(fixture.subject, fixture.resourceId, fixture.configuration);
        Assert.assertSame((Object)actualUpdate, (Object)expectedUpdate, (String)"Expected to get back the persisted configuration update");
    }

    @Test(expectedExceptions={ConfigurationUpdateNotSupportedException.class})
    public void exceptionShouldBeThrownWhenCallingWrongMethodForConfigThatSupportsStructuredAndRaw() throws Exception {
        final ResourceConfigUpdateFixture fixture = this.newStructuredAndRawResourceConfigUpdateFixture();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((EntityManager)this.allowing(ConfigurationManagerBeanUnitTest.this.entityMgr)).find(Resource.class, (Object)fixture.resourceId);
                this.will(3.returnValue((Object)fixture.resource));
            }
        });
        this.configurationMgr.updateResourceConfiguration(fixture.subject, fixture.resourceId, fixture.configuration);
    }

    @Test
    public void updateResourceConfigShouldNotTranslateStructuredWhenRawNotSupported() throws Exception {
        final ResourceConfigUpdateFixture fixture = this.newStructuredResourceConfigUpdateFixture();
        final ResourceConfigurationUpdate expectedUpdate = new ResourceConfigurationUpdate(fixture.resource, fixture.configuration, fixture.subject.getName());
        expectedUpdate.setId(-1);
        final AgentClient agentClient = (AgentClient)this.context.mock(AgentClient.class);
        final ConfigurationAgentService configAgentService = (ConfigurationAgentService)this.context.mock(ConfigurationAgentService.class);
        final ConfigurationUpdateRequest expectedUpdateRequest = new ConfigurationUpdateRequest(expectedUpdate.getId(), expectedUpdate.getConfiguration(), expectedUpdate.getResource().getId());
        final Sequence configUdpate = this.context.sequence("structured-config-update");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((AuthorizationManagerLocal)this.oneOf(ConfigurationManagerBeanUnitTest.this.authorizationMgr)).canViewResource(fixture.subject, fixture.resourceId);
                this.will(4.returnValue((Object)true));
                ((AuthorizationManagerLocal)this.oneOf(ConfigurationManagerBeanUnitTest.this.authorizationMgr)).hasResourcePermission(fixture.subject, Permission.CONFIGURE_WRITE, fixture.resourceId);
                this.will(4.returnValue((Object)true));
                ((EntityManager)this.allowing(ConfigurationManagerBeanUnitTest.this.entityMgr)).find(Resource.class, (Object)fixture.resourceId);
                this.will(4.returnValue((Object)fixture.resource));
                ((AgentManagerLocal)this.allowing(ConfigurationManagerBeanUnitTest.this.agentMgr)).getAgentClient(expectedUpdate.getResource().getAgent());
                this.will(4.returnValue((Object)agentClient));
                ((AgentClient)this.allowing(agentClient)).getConfigurationAgentService();
                this.will(4.returnValue((Object)configAgentService));
                ((ConfigurationAgentService)this.oneOf(configAgentService)).validate(fixture.configuration, fixture.resourceId, true);
                this.inSequence(configUdpate);
                ((ConfigurationManagerLocal)this.oneOf(ConfigurationManagerBeanUnitTest.this.configurationMgrLocal)).persistResourceConfigurationUpdateInNewTransaction(fixture.subject, fixture.resourceId, fixture.configuration, ConfigurationUpdateStatus.INPROGRESS, fixture.subject.getName(), fixture.isPartOfGroupUpdate);
                this.will(4.returnValue((Object)expectedUpdate));
                this.inSequence(configUdpate);
                ((ConfigurationAgentService)this.oneOf(configAgentService)).updateResourceConfiguration((ConfigurationUpdateRequest)this.with(ConfigurationManagerBeanUnitTest.matchingUpdateRequest(expectedUpdateRequest)));
                this.inSequence(configUdpate);
            }
        });
        ResourceConfigurationUpdate actualUpdate = this.configurationMgr.updateStructuredOrRawConfiguration(fixture.subject, fixture.resourceId, fixture.configuration, true);
        Assert.assertSame((Object)actualUpdate, (Object)expectedUpdate, (String)"Expected to get back the persisted configuration update");
    }

    @Test
    public void updateResourceConfigShouldTranslateRawWhenRawConfigHasEdits() throws Exception {
        final ResourceConfigUpdateFixture fixture = this.newStructuredAndRawResourceConfigUpdateFixture();
        fixture.configuration.addRawConfiguration(new RawConfiguration());
        final Configuration translatedConfig = fixture.configuration.deepCopy();
        translatedConfig.put((Property)new PropertySimple("x", (Object)"y"));
        final ResourceConfigurationUpdate expectedUpdate = new ResourceConfigurationUpdate(fixture.resource, translatedConfig, fixture.subject.getName());
        expectedUpdate.setId(-1);
        final AgentClient agentClient = (AgentClient)this.context.mock(AgentClient.class);
        final ConfigurationAgentService configAgentService = (ConfigurationAgentService)this.context.mock(ConfigurationAgentService.class);
        final ConfigurationUpdateRequest expectedUpdateRequest = new ConfigurationUpdateRequest(expectedUpdate.getId(), expectedUpdate.getConfiguration(), expectedUpdate.getResource().getId());
        final Sequence configUdpate = this.context.sequence("raw-config-update");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((AuthorizationManagerLocal)this.oneOf(ConfigurationManagerBeanUnitTest.this.authorizationMgr)).hasResourcePermission(fixture.subject, Permission.CONFIGURE_READ, fixture.resourceId);
                this.will(5.returnValue((Object)true));
                ((AuthorizationManagerLocal)this.oneOf(ConfigurationManagerBeanUnitTest.this.authorizationMgr)).hasResourcePermission(fixture.subject, Permission.CONFIGURE_WRITE, fixture.resourceId);
                this.will(5.returnValue((Object)true));
                ((EntityManager)this.allowing(ConfigurationManagerBeanUnitTest.this.entityMgr)).find(Resource.class, (Object)fixture.resourceId);
                this.will(5.returnValue((Object)fixture.resource));
                ((AuthorizationManagerLocal)this.allowing(ConfigurationManagerBeanUnitTest.this.authorizationMgr)).canViewResource(fixture.subject, fixture.resourceId);
                this.will(5.returnValue((Object)true));
                ((ConfigurationAgentService)this.oneOf(configAgentService)).merge(fixture.configuration, fixture.resourceId, false);
                this.will(5.returnValue((Object)translatedConfig));
                this.inSequence(configUdpate);
                ((ConfigurationManagerLocal)this.oneOf(ConfigurationManagerBeanUnitTest.this.configurationMgrLocal)).persistResourceConfigurationUpdateInNewTransaction(fixture.subject, fixture.resourceId, translatedConfig, ConfigurationUpdateStatus.INPROGRESS, fixture.subject.getName(), fixture.isPartOfGroupUpdate);
                this.will(5.returnValue((Object)expectedUpdate));
                this.inSequence(configUdpate);
                ((AgentManagerLocal)this.allowing(ConfigurationManagerBeanUnitTest.this.agentMgr)).getAgentClient(expectedUpdate.getResource().getAgent());
                this.will(5.returnValue((Object)agentClient));
                ((AgentClient)this.allowing(agentClient)).getConfigurationAgentService();
                this.will(5.returnValue((Object)configAgentService));
                ((ConfigurationAgentService)this.oneOf(configAgentService)).validate(fixture.configuration, fixture.resourceId, false);
                ((ConfigurationAgentService)this.oneOf(configAgentService)).updateResourceConfiguration((ConfigurationUpdateRequest)this.with(ConfigurationManagerBeanUnitTest.matchingUpdateRequest(expectedUpdateRequest)));
                this.inSequence(configUdpate);
            }
        });
        ResourceConfigurationUpdate actualUpdate = this.configurationMgr.updateStructuredOrRawConfiguration(fixture.subject, fixture.resourceId, fixture.configuration, false);
        Assert.assertSame((Object)actualUpdate, (Object)expectedUpdate, (String)"Expected to get back the persisted configuration update");
    }

    @Test
    public void updateResourceConfigShouldMarkUpdateAsFailureWhenExceptionOccurs() throws Exception {
        final ResourceConfigUpdateFixture fixture = this.newStructuredResourceConfigUpdateFixture();
        final RuntimeException exception = new RuntimeException();
        final ResourceConfigurationUpdate expectedUpdate = new ResourceConfigurationUpdate(fixture.resource, fixture.configuration, fixture.subject.getName());
        expectedUpdate.setId(-1);
        expectedUpdate.setStatus(ConfigurationUpdateStatus.FAILURE);
        expectedUpdate.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)exception));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SubjectManagerLocal)this.allowing(ConfigurationManagerBeanUnitTest.this.subjectMgr)).getOverlord();
                this.will(6.returnValue((Object)OVERLORD));
                ((ResourceManagerLocal)this.allowing(ConfigurationManagerBeanUnitTest.this.resourceMgr)).getResource(OVERLORD, fixture.resourceId);
                this.will(6.returnValue((Object)fixture.resource));
                ((EntityManager)this.allowing(ConfigurationManagerBeanUnitTest.this.entityMgr)).find(Resource.class, (Object)fixture.resourceId);
                this.will(6.returnValue((Object)fixture.resource));
                ((EntityManager)this.allowing(ConfigurationManagerBeanUnitTest.this.entityMgr)).find(ResourceConfigurationUpdate.class, (Object)expectedUpdate.getId());
                this.will(6.returnValue((Object)expectedUpdate));
                ((AuthorizationManagerLocal)this.oneOf(ConfigurationManagerBeanUnitTest.this.authorizationMgr)).hasResourcePermission(fixture.subject, Permission.CONFIGURE_WRITE, fixture.resourceId);
                this.will(6.returnValue((Object)true));
                ((ConfigurationManagerLocal)this.oneOf(ConfigurationManagerBeanUnitTest.this.configurationMgrLocal)).persistResourceConfigurationUpdateInNewTransaction(fixture.subject, fixture.resourceId, fixture.configuration, ConfigurationUpdateStatus.INPROGRESS, fixture.subject.getName(), fixture.isPartOfGroupUpdate);
                this.will(6.returnValue((Object)expectedUpdate));
                ((ConfigurationManagerLocal)this.oneOf(ConfigurationManagerBeanUnitTest.this.configurationMgrLocal)).mergeConfigurationUpdate((AbstractResourceConfigurationUpdate)expectedUpdate);
                ((AgentManagerLocal)this.allowing(ConfigurationManagerBeanUnitTest.this.agentMgr)).getAgentClient(expectedUpdate.getResource().getAgent());
                this.will(6.throwException((Throwable)exception));
            }
        });
        ResourceConfigurationUpdate actualUpdate = this.configurationMgr.updateResourceConfiguration(fixture.subject, fixture.resourceId, fixture.configuration);
        AssertUtils.assertPropertiesMatch((Object)expectedUpdate, (Object)actualUpdate, (String)"Expected to get back a failure update");
    }

    @Test
    public void translatingFromStructuredToRawShouldReturnModifiedConfig() throws Exception {
        final ConfigTranslationFixture fixture = this.newStructuredAndRawTranslationFixture();
        final AgentClient agentClient = (AgentClient)this.context.mock(AgentClient.class);
        final ConfigurationAgentService configAgentService = (ConfigurationAgentService)this.context.mock(ConfigurationAgentService.class);
        final Configuration expectedConfig = new Configuration();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((EntityManager)this.allowing(ConfigurationManagerBeanUnitTest.this.entityMgr)).find(Resource.class, (Object)fixture.resourceId);
                this.will(7.returnValue((Object)fixture.resource));
                ((AgentManagerLocal)this.allowing(ConfigurationManagerBeanUnitTest.this.agentMgr)).getAgentClient(fixture.resource.getAgent());
                this.will(7.returnValue((Object)agentClient));
                ((AuthorizationManagerLocal)this.oneOf(ConfigurationManagerBeanUnitTest.this.authorizationMgr)).hasResourcePermission(fixture.subject, Permission.CONFIGURE_READ, fixture.resourceId);
                this.will(7.returnValue((Object)true));
                ((AgentClient)this.allowing(agentClient)).getConfigurationAgentService();
                this.will(7.returnValue((Object)configAgentService));
                ((ConfigurationAgentService)this.oneOf(configAgentService)).merge(fixture.configuration, fixture.resourceId, true);
                this.will(7.returnValue((Object)expectedConfig));
            }
        });
        Configuration translatedConfig = this.configurationMgr.translateResourceConfiguration(fixture.subject, fixture.resourceId, fixture.configuration, true);
        Assert.assertSame((Object)translatedConfig, (Object)expectedConfig, (String)("Expected to get back the configuration translated by the " + ConfigurationAgentService.class.getSimpleName()));
    }

    @Test
    public void translatingFromRawToStructuredShouldReturnModifiedConfig() throws Exception {
        final ConfigTranslationFixture fixture = this.newStructuredAndRawTranslationFixture();
        final AgentClient agentClient = (AgentClient)this.context.mock(AgentClient.class);
        final ConfigurationAgentService configAgentService = (ConfigurationAgentService)this.context.mock(ConfigurationAgentService.class);
        final Configuration expectedConfig = new Configuration();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((EntityManager)this.allowing(ConfigurationManagerBeanUnitTest.this.entityMgr)).find(Resource.class, (Object)fixture.resourceId);
                this.will(8.returnValue((Object)fixture.resource));
                ((AuthorizationManagerLocal)this.oneOf(ConfigurationManagerBeanUnitTest.this.authorizationMgr)).hasResourcePermission(fixture.subject, Permission.CONFIGURE_READ, fixture.resourceId);
                this.will(8.returnValue((Object)true));
                ((AgentManagerLocal)this.allowing(ConfigurationManagerBeanUnitTest.this.agentMgr)).getAgentClient(fixture.resource.getAgent());
                this.will(8.returnValue((Object)agentClient));
                ((AgentClient)this.allowing(agentClient)).getConfigurationAgentService();
                this.will(8.returnValue((Object)configAgentService));
                ((ConfigurationAgentService)this.oneOf(configAgentService)).merge(fixture.configuration, fixture.resourceId, false);
                this.will(8.returnValue((Object)expectedConfig));
            }
        });
        Configuration translatedConfig = this.configurationMgr.translateResourceConfiguration(fixture.subject, fixture.resourceId, fixture.configuration, false);
        Assert.assertSame((Object)translatedConfig, (Object)expectedConfig, (String)("Expected to get back the configuration translated by the " + ConfigurationAgentService.class.getSimpleName()));
    }

    @Test(expectedExceptions={TranslationNotSupportedException.class})
    public void exceptionShouldBeThrownWhenTryingToTranslateStructuredOnlyConfig() throws Exception {
        final ConfigTranslationFixture fixture = this.newStructuredTranslationFixture();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((EntityManager)this.allowing(ConfigurationManagerBeanUnitTest.this.entityMgr)).find(Resource.class, (Object)fixture.resourceId);
                this.will(9.returnValue((Object)fixture.resource));
            }
        });
        this.configurationMgr.translateResourceConfiguration(fixture.subject, fixture.resourceId, fixture.configuration, true);
    }

    @Test(expectedExceptions={TranslationNotSupportedException.class})
    public void exceptionShouldBeThrownWhenTryingToTranslateRawOnlyConfig() throws Exception {
        final ConfigTranslationFixture fixture = this.newRawTranslationFixture();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((EntityManager)this.allowing(ConfigurationManagerBeanUnitTest.this.entityMgr)).find(Resource.class, (Object)fixture.resourceId);
                this.will(10.returnValue((Object)fixture.resource));
            }
        });
        this.configurationMgr.translateResourceConfiguration(fixture.subject, fixture.resourceId, fixture.configuration, false);
    }

    public static Matcher<ConfigurationUpdateRequest> matchingUpdateRequest(ConfigurationUpdateRequest expected) {
        return new PropertyMatcher((Object)expected);
    }

    ResourceConfigUpdateFixture newStructuredResourceConfigUpdateFixture() {
        ResourceConfigUpdateFixture fixture = new ResourceConfigUpdateFixture();
        fixture.resource = this.createResourceWithStructuredConfig(fixture.resourceId);
        return fixture;
    }

    ResourceConfigUpdateFixture newRawResourceConfigUpdateFixture() {
        ResourceConfigUpdateFixture fixture = new ResourceConfigUpdateFixture();
        fixture.resource = this.createResourceWithRawConfig(fixture.resourceId);
        return fixture;
    }

    ResourceConfigUpdateFixture newStructuredAndRawResourceConfigUpdateFixture() {
        ResourceConfigUpdateFixture fixture = new ResourceConfigUpdateFixture();
        fixture.resource = this.createResourceWithStructuredAndRawConfig(fixture.resourceId);
        return fixture;
    }

    ConfigTranslationFixture newStructuredAndRawTranslationFixture() {
        ConfigTranslationFixture fixture = new ConfigTranslationFixture();
        fixture.resource = this.createResourceWithStructuredAndRawConfig(fixture.resourceId);
        return fixture;
    }

    ConfigTranslationFixture newStructuredTranslationFixture() {
        ConfigTranslationFixture fixture = new ConfigTranslationFixture();
        fixture.resource = this.createResourceWithStructuredConfig(fixture.resourceId);
        return fixture;
    }

    ConfigTranslationFixture newRawTranslationFixture() {
        ConfigTranslationFixture fixture = new ConfigTranslationFixture();
        fixture.resource = this.createResourceWithRawConfig(fixture.resourceId);
        return fixture;
    }

    Resource createResource(int resourceId) {
        Resource resource = new Resource(resourceId);
        resource.setAgent(new Agent("test-agent", "localhost", 7080, null, null));
        return resource;
    }

    Resource createResourceWithStructuredConfig(int resourceId) {
        Resource resource = this.createResource(resourceId);
        resource.setResourceType(this.createStructurerdOnlyResourceType());
        return resource;
    }

    Resource createResourceWithStructuredAndRawConfig(int resourceId) {
        Resource resource = this.createResource(resourceId);
        resource.setResourceType(this.createStructuredAndRawResourceType());
        return resource;
    }

    Resource createResourceWithRawConfig(int resourceId) {
        Resource resource = this.createResource(resourceId);
        resource.setResourceType(this.createRawResourceType());
        return resource;
    }

    ResourceType createStructuredAndRawResourceType() {
        ConfigurationDefinition configDef = new ConfigurationDefinition("structured-and-raw", "structured and raw");
        configDef.setConfigurationFormat(ConfigurationFormat.STRUCTURED_AND_RAW);
        ResourceType resourceType = new ResourceType();
        resourceType.setResourceConfigurationDefinition(configDef);
        return resourceType;
    }

    ResourceType createStructurerdOnlyResourceType() {
        ConfigurationDefinition configDef = new ConfigurationDefinition("structred-config-def", "structured config def");
        configDef.setConfigurationFormat(ConfigurationFormat.STRUCTURED);
        ResourceType resourceType = new ResourceType();
        resourceType.setResourceConfigurationDefinition(configDef);
        return resourceType;
    }

    ResourceType createRawResourceType() {
        ConfigurationDefinition configDef = new ConfigurationDefinition("raw-config-def", "raw config def");
        configDef.setConfigurationFormat(ConfigurationFormat.RAW);
        ResourceType resourceType = new ResourceType();
        resourceType.setResourceConfigurationDefinition(configDef);
        return resourceType;
    }

    static class ConfigTranslationFixture {
        Subject subject = new Subject("rhqadmin", true, true);
        int resourceId = -1;
        Configuration configuration = new Configuration();
        Resource resource;

        ConfigTranslationFixture() {
        }
    }

    static class ResourceConfigUpdateFixture {
        Subject subject = new Subject("rhqadmin", true, true);
        int resourceId = -1;
        Configuration configuration = new Configuration();
        boolean isPartOfGroupUpdate = false;
        Resource resource;

        ResourceConfigUpdateFixture() {
        }
    }
}

