/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.shared.ResourceBuilder;
import org.rhq.core.domain.shared.ResourceTypeBuilder;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.discovery.DeletedResourceTypeFilter;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.test.AssertUtils;
import org.rhq.test.JMockTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DeletedResourceTypeFilterTest
extends JMockTest {
    SubjectManagerLocal subjectMgr;
    ResourceTypeManagerLocal resourceTypeMgr;
    PluginManagerLocal pluginMgr;
    DeletedResourceTypeFilter filter;

    @BeforeMethod
    public void init() {
        this.subjectMgr = (SubjectManagerLocal)this.context.mock(SubjectManagerLocal.class);
        this.resourceTypeMgr = (ResourceTypeManagerLocal)this.context.mock(ResourceTypeManagerLocal.class);
        this.pluginMgr = (PluginManagerLocal)this.context.mock(PluginManagerLocal.class);
    }

    @Test
    public void acceptReportWithNoDeletedTypes() {
        InventoryReport report = this.createReport();
        report.addAddedRoot(new ResourceBuilder().createRandomServer().with(2).randomChildServices().build());
        report.addAddedRoot(new ResourceBuilder().createRandomService().with(2).randomChildServices().build());
        final ArrayList<Plugin> plugins = new ArrayList<Plugin>(this.getPluginsInReport(report.getAddedRoots()));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SubjectManagerLocal)this.allowing(DeletedResourceTypeFilterTest.this.subjectMgr)).getOverlord();
                this.will(1.returnValue((Object)new Subject("overlord", true, true)));
                ((ResourceTypeManagerLocal)this.allowing(DeletedResourceTypeFilterTest.this.resourceTypeMgr)).findResourceTypesByCriteria((Subject)this.with(1.aNonNull(Subject.class)), (ResourceTypeCriteria)this.with(1.aNonNull(ResourceTypeCriteria.class)));
                this.will(1.returnValue((Object)new PageList()));
                ((PluginManagerLocal)this.allowing(DeletedResourceTypeFilterTest.this.pluginMgr)).getInstalledPlugins();
                this.will(1.returnValue((Object)plugins));
            }
        });
        this.filter = new DeletedResourceTypeFilter(this.subjectMgr, this.resourceTypeMgr, this.pluginMgr);
        Set staleTypes = this.filter.apply(report);
        Assert.assertTrue((boolean)staleTypes.isEmpty(), (String)("Expected filter to return empty set when report does not contain any deleted resource types, but filter returned " + staleTypes));
    }

    @Test
    public void rejectReportWithDeletedTypes() {
        ResourceType deletedServiceType = new ResourceTypeBuilder().createServiceResourceType().withName("TestService").withPlugin("TestPlugin").thatIsDeleted().build();
        final PageList deletedTypes = new PageList();
        deletedTypes.add((Object)deletedServiceType);
        InventoryReport report = this.createReport();
        report.addAddedRoot(new ResourceBuilder().createRandomServer().withChildService().withName("ChildService").withUuid("c1").withResourceType(new ResourceTypeBuilder().createServiceResourceType().withName("TestService").withPlugin("TestPlugin").build()).included().build());
        final ArrayList<Plugin> plugins = new ArrayList<Plugin>(this.getPluginsInReport(report.getAddedRoots()));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SubjectManagerLocal)this.allowing(DeletedResourceTypeFilterTest.this.subjectMgr)).getOverlord();
                this.will(2.returnValue((Object)new Subject("overlord", true, true)));
                ((ResourceTypeManagerLocal)this.allowing(DeletedResourceTypeFilterTest.this.resourceTypeMgr)).findResourceTypesByCriteria((Subject)this.with(2.aNonNull(Subject.class)), (ResourceTypeCriteria)this.with(2.aNonNull(ResourceTypeCriteria.class)));
                this.will(2.returnValue((Object)deletedTypes));
                ((PluginManagerLocal)this.allowing(DeletedResourceTypeFilterTest.this.pluginMgr)).getInstalledPlugins();
                this.will(2.returnValue((Object)plugins));
            }
        });
        this.filter = new DeletedResourceTypeFilter(this.subjectMgr, this.resourceTypeMgr, this.pluginMgr);
        Set staleTypes = this.filter.apply(report);
        AssertUtils.assertCollectionEqualsNoOrder((Collection)staleTypes, (Collection)deletedTypes, (String)"Expected report to be rejected since it contains deleted resource types");
    }

    @Test
    public void rejectReportWithPluginThatIsNotInstalled() {
        InventoryReport report = this.createReport();
        report.addAddedRoot(new ResourceBuilder().createRandomServer().with(2).randomChildServices().build());
        report.addAddedRoot(new ResourceBuilder().createRandomService().withResourceType(new ResourceTypeBuilder().createServerResourceType().withName("StaleServer").withPlugin("DeletedPlugin").build()).with(2).randomChildServices().build());
        ArrayList<Plugin> plugins = new ArrayList<Plugin>(this.getPluginsInReport(report.getAddedRoots()));
        final List<Plugin> installedPlugins = this.removePlugins(plugins, "DeletedPlugin");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SubjectManagerLocal)this.allowing(DeletedResourceTypeFilterTest.this.subjectMgr)).getOverlord();
                this.will(3.returnValue((Object)new Subject("overlord", true, true)));
                ((ResourceTypeManagerLocal)this.allowing(DeletedResourceTypeFilterTest.this.resourceTypeMgr)).findResourceTypesByCriteria((Subject)this.with(3.aNonNull(Subject.class)), (ResourceTypeCriteria)this.with(3.aNonNull(ResourceTypeCriteria.class)));
                this.will(3.returnValue((Object)new PageList()));
                ((PluginManagerLocal)this.allowing(DeletedResourceTypeFilterTest.this.pluginMgr)).getInstalledPlugins();
                this.will(3.returnValue((Object)installedPlugins));
            }
        });
        this.filter = new DeletedResourceTypeFilter(this.subjectMgr, this.resourceTypeMgr, this.pluginMgr);
        Assert.assertFalse((boolean)this.filter.apply(report).isEmpty(), (String)"Expected filter to return non-empty since it contains a deleted plugin but empty set was returned");
    }

    InventoryReport createReport() {
        Agent agent = new Agent("localhost", "localhost", 1234, "1234", "test-token");
        return new InventoryReport(agent);
    }

    private Set<Plugin> getPluginsInReport(Set<Resource> resources) {
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        for (Resource resource : resources) {
            String name = resource.getResourceType().getPlugin();
            plugins.add(new Plugin(name, "/plugins/" + name));
            plugins.addAll(this.getPluginsInReport(resource.getChildResources()));
        }
        return plugins;
    }

    private List<Plugin> removePlugins(List<Plugin> plugins, String ... pluginsToRemove) {
        HashSet<String> removedPlugins = new HashSet<String>(Arrays.asList(pluginsToRemove));
        ArrayList<Plugin> filteredPlugins = new ArrayList<Plugin>();
        for (Plugin plugin : plugins) {
            if (removedPlugins.contains(plugin.getName())) continue;
            filteredPlugins.add(plugin);
        }
        return filteredPlugins;
    }
}

