/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.test;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.plugin.PluginStatusType;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.sync.ExportReader;
import org.rhq.enterprise.server.sync.ExportWriter;
import org.rhq.enterprise.server.sync.validators.DeployedAgentPluginsValidator;
import org.rhq.enterprise.server.sync.validators.InconsistentStateException;
import org.rhq.test.JMockTest;
import org.testng.Assert;

public class DeployedAgentPluginsValidatorTest
extends JMockTest {
    private static final Log LOG = LogFactory.getLog(DeployedAgentPluginsValidator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCanExportAndImportState() throws Exception {
        final PluginManagerLocal pluginManager = (PluginManagerLocal)this.context.mock(PluginManagerLocal.class);
        DeployedAgentPluginsValidator validator = new DeployedAgentPluginsValidator(pluginManager);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PluginManagerLocal)this.oneOf(pluginManager)).getInstalledPlugins();
                this.will(1.returnValue(new ArrayList(DeployedAgentPluginsValidatorTest.getDeployedPlugins())));
            }
        });
        validator.initialize(null, null);
        StringWriter output = new StringWriter();
        try {
            XMLOutputFactory ofactory = XMLOutputFactory.newInstance();
            XMLStreamWriter wrt = ofactory.createXMLStreamWriter(output);
            wrt.writeStartDocument();
            wrt.writeStartElement("root");
            validator.exportState(new ExportWriter(wrt));
            wrt.writeEndDocument();
            wrt.close();
            StringReader input = new StringReader(output.toString());
            try {
                XMLInputFactory ifactory = XMLInputFactory.newInstance();
                XMLStreamReader rdr = ifactory.createXMLStreamReader(input);
                rdr.nextTag();
                validator.initializeExportedStateValidation(new ExportReader(rdr));
                rdr.close();
                Assert.assertEquals((Set)validator.getPluginsToValidate(), DeployedAgentPluginsValidatorTest.getDeployedPlugins());
            }
            finally {
                input.close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Test failed. Output generated so far:\n" + output), (Throwable)e);
            throw e;
        }
        finally {
            output.close();
        }
    }

    public void testDetectsPluginDifferencies() {
        final PluginManagerLocal pluginManager = (PluginManagerLocal)this.context.mock(PluginManagerLocal.class);
        final ArrayList<DeployedAgentPluginsValidator.ConsistentPlugin> installedPlugins = new ArrayList<DeployedAgentPluginsValidator.ConsistentPlugin>(DeployedAgentPluginsValidatorTest.getDeployedPlugins());
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PluginManagerLocal)this.allowing(pluginManager)).getInstalledPlugins();
                this.will(2.returnValue((Object)installedPlugins));
            }
        });
        DeployedAgentPluginsValidator validator = new DeployedAgentPluginsValidator(pluginManager);
        Set<DeployedAgentPluginsValidator.ConsistentPlugin> pluginsToValidate = DeployedAgentPluginsValidatorTest.getDeployedPlugins();
        validator.initialize(null, null);
        validator.setPluginsToValidate(pluginsToValidate);
        validator.validateExportedState();
        DeployedAgentPluginsValidator.ConsistentPlugin newPlugin = DeployedAgentPluginsValidatorTest.createPlugin("superfluous", "1", "md5_4");
        pluginsToValidate.add(newPlugin);
        try {
            validator.validateExportedState();
            Assert.fail((String)"validation should have detected that the current installation has one plugin less.");
        }
        catch (InconsistentStateException e) {
            // empty catch block
        }
        pluginsToValidate.remove(newPlugin);
        installedPlugins.add(newPlugin);
        try {
            validator.validateExportedState();
            Assert.fail((String)"validation should have detected that the current installation has one plugin more.");
        }
        catch (InconsistentStateException e) {
            // empty catch block
        }
        DeployedAgentPluginsValidator.ConsistentPlugin newPluginCopy = new DeployedAgentPluginsValidator.ConsistentPlugin((Plugin)newPlugin);
        pluginsToValidate.add(newPluginCopy);
        newPlugin.setMd5("md5_different");
        try {
            validator.validateExportedState();
            Assert.fail((String)"validation should have failed because one of the plugins differs between current and exported states.");
        }
        catch (InconsistentStateException e) {
            // empty catch block
        }
        newPlugin.setMd5(newPluginCopy.getMd5());
        newPluginCopy.setMd5("md5_different");
        try {
            validator.validateExportedState();
            Assert.fail((String)"validation should have failed because one of the plugins differs between current and exported states.");
        }
        catch (InconsistentStateException e) {
            // empty catch block
        }
    }

    public void testAllValidatorsEqual() {
        PluginManagerLocal pluginManager = (PluginManagerLocal)this.context.mock(PluginManagerLocal.class);
        DeployedAgentPluginsValidator v1 = new DeployedAgentPluginsValidator(pluginManager);
        DeployedAgentPluginsValidator v2 = new DeployedAgentPluginsValidator(pluginManager);
        DeployedAgentPluginsValidator v3 = new DeployedAgentPluginsValidator(pluginManager);
        Object o = new Object();
        Assert.assertEquals((Object)v1, (Object)v2);
        Assert.assertEquals((Object)v1, (Object)v3);
        Assert.assertEquals((Object)v2, (Object)v3);
        Assert.assertFalse((boolean)v1.equals(o));
        Assert.assertFalse((boolean)v2.equals(o));
        Assert.assertFalse((boolean)v3.equals(o));
    }

    private static Set<DeployedAgentPluginsValidator.ConsistentPlugin> getDeployedPlugins() {
        HashSet<DeployedAgentPluginsValidator.ConsistentPlugin> ret = new HashSet<DeployedAgentPluginsValidator.ConsistentPlugin>();
        ret.add(DeployedAgentPluginsValidatorTest.createPlugin("p1", "1", "md5_1"));
        ret.add(DeployedAgentPluginsValidatorTest.createPlugin("p2", "1", "md5_2"));
        ret.add(DeployedAgentPluginsValidatorTest.createPlugin("p3", "1", "md5_3"));
        return ret;
    }

    private static DeployedAgentPluginsValidator.ConsistentPlugin createPlugin(String name, String version, String md5) {
        return new DeployedAgentPluginsValidator.ConsistentPlugin(new Plugin(0, name, null, null, true, PluginStatusType.INSTALLED, null, null, md5, version, null, 0L, 0L));
    }
}

