/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.MeasurementDefinitionCriteria;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.sync.ExportingInputStream;
import org.rhq.enterprise.server.sync.MetricTemplateSynchronizer;
import org.rhq.enterprise.server.sync.validators.ConsistencyValidator;
import org.rhq.test.JMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Test
public class MetricTemplateExporterTest
extends JMockTest {
    private static final Log LOG = LogFactory.getLog(MetricTemplateExporterTest.class);

    public void testCanExport() throws Exception {
        final MeasurementDefinitionManagerLocal measurementDefinitionManager = (MeasurementDefinitionManagerLocal)this.context.mock(MeasurementDefinitionManagerLocal.class);
        MeasurementScheduleManagerLocal measurementScheduleManager = (MeasurementScheduleManagerLocal)this.context.mock(MeasurementScheduleManagerLocal.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((MeasurementDefinitionManagerLocal)this.allowing(measurementDefinitionManager)).findMeasurementDefinitionsByCriteria((Subject)this.with(1.any(Subject.class)), (MeasurementDefinitionCriteria)this.with(1.any(MeasurementDefinitionCriteria.class)));
                this.will(1.returnValue((Object)MetricTemplateExporterTest.getFakeMeasurementDefinitions()));
            }
        });
        MetricTemplateSynchronizer exporter = new MetricTemplateSynchronizer(measurementDefinitionManager, measurementScheduleManager);
        HashSet<MetricTemplateSynchronizer> exporters = new HashSet<MetricTemplateSynchronizer>();
        exporters.add(exporter);
        ExportingInputStream eis = new ExportingInputStream(exporters, new HashMap(), 65536, false);
        DocumentBuilder bld = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = bld.parse((InputStream)eis);
        Element root = doc.getDocumentElement();
        List<Node> validators = MetricTemplateExporterTest.getDirectChildrenByTagName(root, "validator");
        Set declaredValidators = exporter.getRequiredValidators();
        Assert.assertEquals((int)validators.size(), (int)declaredValidators.size(), (String)"Unexpected number of validators in the export xml");
        for (Node v : validators) {
            Element validator = (Element)v;
            String cls = validator.getAttribute("class");
            boolean found = false;
            for (ConsistencyValidator dv : declaredValidators) {
                if (!cls.equals(dv.getClass().getName())) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found, (String)("The metric template exporter doesn't seem to declare a validator with class: " + cls + ", but one such appeared in the export"));
        }
        Element entities = (Element)MetricTemplateExporterTest.getFirstDirectChildByTagName(root, "entities");
        Assert.assertEquals((String)entities.getAttribute("id"), (String)MetricTemplateSynchronizer.class.getName(), (String)"Unexpected id of the entities element.");
        NodeList metricTemplates = entities.getElementsByTagName("metricTemplate");
        Assert.assertEquals((int)metricTemplates.getLength(), (int)3, (String)"Unexpected number of exported metric templates.");
        for (int i = 0; i < metricTemplates.getLength(); ++i) {
            Element m = (Element)metricTemplates.item(i);
            String index = Integer.toString(i + 1);
            String expectedName = "m" + index;
            Assert.assertEquals((String)m.getAttribute("referencedEntityId"), (String)index, (String)"Unexpected referencedEntityId value");
            Assert.assertEquals((String)m.getAttribute("enabled"), (String)"false", (String)"Unexpected enabled value");
            Assert.assertEquals((String)m.getAttribute("defaultInterval"), (String)"0", (String)"Unexpected defaultInterval value");
            Assert.assertEquals((String)m.getAttribute("metricName"), (String)expectedName, (String)"Unexpected metricName value");
            Assert.assertEquals((String)m.getAttribute("resourceTypePlugin"), (String)"fakePlugin", (String)"Unexpected resourceTypePlugin value");
            Assert.assertEquals((String)m.getAttribute("resourceTypeName"), (String)"fakeType", (String)"Unexpected resourceTypeName value");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readAll(Reader rdr) throws IOException {
        try {
            int c;
            StringBuilder bld = new StringBuilder();
            while ((c = rdr.read()) != -1) {
                bld.append((char)c);
            }
            String string = bld.toString();
            return string;
        }
        finally {
            rdr.close();
        }
    }

    private static Node getFirstDirectChildByTagName(Node node, String tagName) {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node n = node.getChildNodes().item(i);
            if (!n.getNodeName().equals(tagName)) continue;
            return n;
        }
        return null;
    }

    private static List<Node> getDirectChildrenByTagName(Node node, String tagName) {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node n = node.getChildNodes().item(i);
            if (!n.getNodeName().equals(tagName)) continue;
            ret.add(n);
        }
        return ret;
    }

    private static PageList<MeasurementDefinition> getFakeMeasurementDefinitions() {
        ArrayList<MeasurementDefinition> ret = new ArrayList<MeasurementDefinition>();
        ResourceType rt = new ResourceType("fakeType", "fakePlugin", ResourceCategory.PLATFORM, null);
        ret.add(new MeasurementDefinition(rt, "m1"));
        ret.add(new MeasurementDefinition(rt, "m2"));
        ret.add(new MeasurementDefinition(rt, "m3"));
        for (int i = 0; i < ret.size(); ++i) {
            ((MeasurementDefinition)ret.get(i)).setId(i + 1);
        }
        return new PageList(ret, PageControl.getUnlimitedInstance());
    }
}

