/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.rhq.core.domain.criteria.BaseCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CriteriaQueryTest {
    @Test
    public void executeQueryThatReturnsASinglePageOfResults() {
        List<FakeEntity> expected = Arrays.asList(new FakeEntity(1), new FakeEntity(2));
        FakeCriteriaQueryExecutor queryExecutor = new FakeCriteriaQueryExecutor(2, PageControl.getUnlimitedInstance());
        queryExecutor.addPage(expected);
        FakeEntityCriteria criteria = new FakeEntityCriteria();
        CriteriaQuery query = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)queryExecutor);
        ArrayList<FakeEntity> actual = new ArrayList<FakeEntity>();
        for (FakeEntity entity : query) {
            actual.add(entity);
        }
        Assert.assertEquals(actual, expected, (String)"Failed to iterate over query results with a single page");
    }

    @Test
    public void executeQueryThatReturnsMultiplePagesOfResults() {
        PageControl pc = new PageControl(0, 2);
        List<FakeEntity> expected = Arrays.asList(new FakeEntity(1), new FakeEntity(2), new FakeEntity(3), new FakeEntity(4));
        FakeCriteriaQueryExecutor queryExecutor = new FakeCriteriaQueryExecutor(4, pc);
        queryExecutor.addPage(expected.subList(0, 2));
        queryExecutor.addPage(expected.subList(2, 4));
        FakeEntityCriteria criteria = new FakeEntityCriteria();
        criteria.setPageControl(pc);
        CriteriaQuery query = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)queryExecutor);
        ArrayList<FakeEntity> actual = new ArrayList<FakeEntity>();
        for (FakeEntity entity : query) {
            actual.add(entity);
        }
        Assert.assertEquals(actual, expected);
    }

    @Test
    public void singleResultTest() {
        block15: {
            ArrayList<FakeEntity> result;
            block14: {
                block13: {
                    block12: {
                        result = null;
                        try {
                            FakeEntityCriteria.getSingleResult(result);
                            assert (false) : "Should have thrown Runtime Exception";
                        }
                        catch (RuntimeException e) {
                            if ($assertionsDisabled || e.getMessage().contains("NoResultException")) break block12;
                            throw new AssertionError();
                        }
                    }
                    result = new ArrayList<FakeEntity>(2);
                    try {
                        FakeEntityCriteria.getSingleResult(result);
                        assert (false) : "Should have thrown Runtime Exception";
                    }
                    catch (RuntimeException e) {
                        if ($assertionsDisabled || e.getMessage().contains("NoResultException")) break block13;
                        throw new AssertionError();
                    }
                }
                result.add(new FakeEntity(1));
                try {
                    FakeEntity r = (FakeEntity)FakeEntityCriteria.getSingleResult(result);
                    assert (r.getId() == 1) : "Should have retuned expected entity but returned: " + r;
                }
                catch (Throwable t) {
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError((Object)"Should have returned single result");
                }
            }
            result.add(new FakeEntity(2));
            try {
                FakeEntityCriteria.getSingleResult(result);
                assert (false) : "Should have thrown Runtime Exception";
            }
            catch (RuntimeException e) {
                if ($assertionsDisabled || e.getMessage().contains("NonUniqueResultException")) break block15;
                throw new AssertionError();
            }
        }
    }

    private static class FakeCriteriaQueryExecutor
    implements CriteriaQueryExecutor<FakeEntity, FakeEntityCriteria> {
        private List<PageList<FakeEntity>> pages = new ArrayList<PageList<FakeEntity>>();
        private int totalSize;
        private PageControl pc;

        public FakeCriteriaQueryExecutor(int totalSize, PageControl pc) {
            this.totalSize = totalSize;
            this.pc = pc;
        }

        public void addPage(List<FakeEntity> entities) {
            this.pages.add((PageList<FakeEntity>)new PageList(entities, this.totalSize, this.pc));
        }

        public PageList<FakeEntity> execute(FakeEntityCriteria criteria) {
            return this.pages.get(criteria.getPageNumber());
        }
    }

    private static class FakeEntityCriteria
    extends Criteria {
        private FakeEntityCriteria() {
        }

        public Class<?> getPersistentClass() {
            return FakeEntity.class;
        }
    }

    private static class FakeEntity {
        private int id;

        public FakeEntity(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

