/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class StopWatch {
    private long start;
    private long end;
    private Map<String, TimeSlice> markerMap;

    public StopWatch() {
        this.reset();
    }

    public void markTimeBegin(String marker) {
        if (this.markerMap.containsKey(marker)) {
            TimeSlice ts = this.markerMap.get(marker);
            ts.cont();
        } else {
            this.markerMap.put(marker, new TimeSlice(marker));
        }
    }

    public void markTimeEnd(String marker) {
        if (!this.markerMap.containsKey(marker)) {
            throw new IllegalArgumentException("Invalid marker");
        }
        TimeSlice ts = this.markerMap.get(marker);
        ts.setFinished();
    }

    public StopWatch(long start) {
        this.start = start;
        this.markerMap = new HashMap<String, TimeSlice>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reset() {
        try {
            long l = this.getElapsed();
            return l;
        }
        finally {
            this.start = System.currentTimeMillis();
            this.markerMap = new HashMap<String, TimeSlice>();
        }
    }

    public long getElapsed() {
        this.end = System.currentTimeMillis();
        return this.end - this.start;
    }

    public String toString() {
        long elap = this.getElapsed();
        StringBuffer buf = new StringBuffer(this.formatMillis(elap));
        if (this.markerMap.size() > 0) {
            buf.append(" {StopWatch Markers:\n");
            long totalMarked = 0L;
            TreeSet<String> keys = new TreeSet<String>(this.markerMap.keySet());
            for (String key : keys) {
                TimeSlice ts = this.markerMap.get(key);
                totalMarked += ts.end - ts.begin;
                ts.writeBuf(buf);
                buf.append('\n');
            }
            long unmarked = elap - totalMarked;
            if (unmarked > 99L) {
                buf.append(" [unmarked=").append(this.formatMillis(unmarked)).append("]\n");
            }
            buf.append("}");
        }
        return buf.toString();
    }

    private String formatMillis(long millis) {
        String fraction = String.valueOf(millis % 1000L);
        int pad = 3 - fraction.length();
        StringBuffer buf = new StringBuffer().append(millis / 1000L).append('.');
        while (pad-- > 0) {
            buf.append("0");
        }
        buf.append(fraction).append(" secs");
        return buf.toString();
    }

    class TimeSlice {
        String marker;
        long begin;
        long end;

        public TimeSlice(String marker) {
            this.marker = marker;
            this.begin = this.end = System.currentTimeMillis();
        }

        public void setFinished() {
            this.end = System.currentTimeMillis();
        }

        public void cont() {
            this.begin -= this.end - this.begin;
        }

        public void writeBuf(StringBuffer buf) {
            long elap = this.end - this.begin;
            buf.append(" [").append(this.marker).append("=").append(StopWatch.this.formatMillis(elap)).append("] ");
        }
    }
}

