/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.preferences.FilePreferencesFactory;

public class FilePreferences
extends AbstractPreferences {
    private final Log log = LogFactory.getLog(FilePreferences.class);
    private Map<String, String> root;
    private Map<String, FilePreferences> children;
    private boolean isRemoved = false;

    public FilePreferences(AbstractPreferences parent, String name) {
        super(parent, name);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Instantiating node " + name));
        }
        this.root = new TreeMap<String, String>();
        this.children = new TreeMap<String, FilePreferences>();
        try {
            this.sync();
        }
        catch (BackingStoreException e) {
            this.log.error((Object)("Unable to sync on creation of node " + name), (Throwable)e);
        }
    }

    @Override
    protected void putSpi(String key, String value) {
        this.root.put(key, value);
        try {
            this.flush();
        }
        catch (BackingStoreException e) {
            this.log.error((Object)("Unable to flush after putting " + key), (Throwable)e);
        }
    }

    @Override
    protected String getSpi(String key) {
        String val = this.root.get(key);
        return val;
    }

    @Override
    protected void removeSpi(String key) {
        this.root.remove(key);
        try {
            this.flush();
        }
        catch (BackingStoreException e) {
            this.log.error((Object)("Unable to flush after removing " + key), (Throwable)e);
        }
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        this.isRemoved = true;
        this.flush();
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        return this.root.keySet().toArray(new String[this.root.keySet().size()]);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        return this.children.keySet().toArray(new String[this.children.keySet().size()]);
    }

    @Override
    protected FilePreferences childSpi(String name) {
        FilePreferences child = this.children.get(name);
        if (null == child || child.isRemoved()) {
            child = new FilePreferences(this, name);
            this.children.put(name, child);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void syncSpi() throws BackingStoreException {
        if (this.isRemoved()) {
            return;
        }
        File file = FilePreferencesFactory.getPreferencesFile();
        if (!file.exists()) {
            return;
        }
        File file2 = file;
        synchronized (file2) {
            Properties p = new Properties();
            try {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(file);
                    p.load(fis);
                }
                finally {
                    if (null != fis) {
                        fis.close();
                    }
                }
                StringBuilder sb = new StringBuilder();
                this.getPath(sb);
                String path = sb.toString();
                Enumeration<?> pnen = p.propertyNames();
                while (pnen.hasMoreElements()) {
                    String subKey;
                    String propKey = (String)pnen.nextElement();
                    if (!propKey.startsWith(path) || (subKey = propKey.substring(path.length())).indexOf(47) != -1) continue;
                    this.root.put(subKey, p.getProperty(propKey));
                }
            }
            catch (IOException e) {
                throw new BackingStoreException(e);
            }
        }
    }

    private void getPath(StringBuilder sb) {
        FilePreferences parent = null;
        try {
            parent = (FilePreferences)this.parent();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (null == parent) {
            return;
        }
        parent.getPath(sb);
        sb.append(this.name()).append('/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushSpi() throws BackingStoreException {
        File file;
        File file2 = file = FilePreferencesFactory.getPreferencesFile();
        synchronized (file2) {
            Properties p = new Properties();
            try {
                StringBuilder sb = new StringBuilder();
                this.getPath(sb);
                String path = sb.toString();
                if (file.exists()) {
                    p.load(new FileInputStream(file));
                    ArrayList<String> toRemove = new ArrayList<String>();
                    Enumeration<?> pnen = p.propertyNames();
                    while (pnen.hasMoreElements()) {
                        String subKey;
                        String propKey = (String)pnen.nextElement();
                        if (!propKey.startsWith(path) || (subKey = propKey.substring(path.length())).indexOf(47) != -1) continue;
                        toRemove.add(propKey);
                    }
                    for (String propKey : toRemove) {
                        p.remove(propKey);
                    }
                }
                if (!this.isRemoved) {
                    for (String s : this.root.keySet()) {
                        p.setProperty(path + s, this.root.get(s));
                    }
                }
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(file);
                    p.store(fos, "RHQ FilePreferences. Do not edit this file manually.");
                }
                finally {
                    if (null != fos) {
                        fos.close();
                    }
                }
            }
            catch (IOException e) {
                throw new BackingStoreException(e);
            }
        }
    }
}

