/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.common.jbossas.client.controller;

import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.rhq.common.jbossas.client.controller.Address;
import org.rhq.common.jbossas.client.controller.FailureException;
import org.rhq.common.jbossas.client.controller.JBossASClient;

public class LoggingJBossASClient
extends JBossASClient {
    public static final String LOGGING = "logging";
    public static final String LOGGER = "logger";

    public LoggingJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public boolean isLogger(String loggerName) throws Exception {
        Address addr = Address.root().add("subsystem", LOGGING, LOGGER, loggerName);
        return null != this.readResource(addr);
    }

    public String getLoggerLevel(String loggerName) throws Exception {
        Address addr = Address.root().add("subsystem", LOGGING, LOGGER, loggerName);
        return this.getStringAttribute("level", addr);
    }

    public void setLoggerLevel(String loggerName, String level) throws Exception {
        ModelNode request;
        Address addr = Address.root().add("subsystem", LOGGING, LOGGER, loggerName);
        if (this.isLogger(loggerName)) {
            request = LoggingJBossASClient.createWriteAttributeRequest("level", level, addr);
        } else {
            String dmrTemplate = "{\"category\" => \"%s\" , \"level\" => \"%s\" , \"use-parent-handlers\" => \"true\" }";
            String dmr = String.format("{\"category\" => \"%s\" , \"level\" => \"%s\" , \"use-parent-handlers\" => \"true\" }", loggerName, level);
            request = ModelNode.fromString((String)dmr);
            request.get("operation").set("add");
            request.get("address").set(addr.getAddressNode());
        }
        ModelNode response = this.execute(request);
        if (!LoggingJBossASClient.isSuccess(response)) {
            throw new FailureException(response);
        }
    }
}

