/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.common.jbossas.client.controller;

import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.rhq.common.jbossas.client.controller.Address;
import org.rhq.common.jbossas.client.controller.FailureException;
import org.rhq.common.jbossas.client.controller.JBossASClient;

public class SocketBindingJBossASClient
extends JBossASClient {
    public static final String SOCKET_BINDING_GROUP = "socket-binding-group";
    public static final String SOCKET_BINDING = "socket-binding";
    public static final String PORT = "port";
    public static final String INTERFACE = "interface";
    public static final String PORT_OFFSET = "port-offset";
    public static final String STANDARD_SOCKETS = "standard-sockets";
    public static final String JBOSS_SYSPROP_PORT_OFFSET = "jboss.socket.binding.port-offset";
    public static final String DEFAULT_BINDING_MGMT_NATIVE = "management-native";
    public static final String DEFAULT_BINDING_MGMT_HTTP = "management-http";
    public static final String DEFAULT_BINDING_MGMT_HTTPS = "management-https";
    public static final String DEFAULT_BINDING_AJP = "ajp";
    public static final String DEFAULT_BINDING_HTTP = "http";
    public static final String DEFAULT_BINDING_HTTPS = "https";
    public static final String DEFAULT_BINDING_JACORB = "jacorb";
    public static final String DEFAULT_BINDING_JACORB_SSL = "jacorb-ssl";
    public static final String DEFAULT_BINDING_MESSAGING = "messaging";
    public static final String DEFAULT_BINDING_MESSAGING_THRUPUT = "messaging-throughput";
    public static final String DEFAULT_BINDING_OSGI_HTTP = "osgi-http";
    public static final String DEFAULT_BINDING_REMOTING = "remoting";
    public static final String DEFAULT_BINDING_TXN_RECOVERY_ENV = "txn-recovery-environment";
    public static final String DEFAULT_BINDING_TXN_STATUS_MGR = "txn-status-manager";

    public SocketBindingJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public void setStandardPortOffset(int offset) throws Exception {
        this.setPortOffset(STANDARD_SOCKETS, JBOSS_SYSPROP_PORT_OFFSET, offset);
    }

    public void setPortOffset(String socketBindingGroupName, String sysPropName, int offset) throws Exception {
        Address addr;
        String offsetValue = sysPropName != null ? "${" + sysPropName + ":" + offset + "}" : String.valueOf(offset);
        ModelNode request = SocketBindingJBossASClient.createWriteAttributeRequest(PORT_OFFSET, offsetValue, addr = Address.root().add(SOCKET_BINDING_GROUP, socketBindingGroupName));
        ModelNode results = this.execute(request);
        if (!SocketBindingJBossASClient.isSuccess(results)) {
            throw new FailureException(results);
        }
    }

    public void setStandardSocketBindingPort(String socketBindingName, int port) throws Exception {
        this.setStandardSocketBindingPortExpression(socketBindingName, null, port);
    }

    public void setStandardSocketBindingPortExpression(String socketBindingName, String sysPropName, int port) throws Exception {
        this.setSocketBindingPortExpression(STANDARD_SOCKETS, socketBindingName, sysPropName, port);
    }

    public void setSocketBindingPort(String socketBindingGroupName, String socketBindingName, int port) throws Exception {
        this.setSocketBindingPortExpression(socketBindingGroupName, socketBindingName, null, port);
    }

    public void setSocketBindingPortExpression(String socketBindingGroupName, String socketBindingName, String sysPropName, int port) throws Exception {
        Address addr;
        String portValue = sysPropName != null ? "${" + sysPropName + ":" + port + "}" : String.valueOf(port);
        ModelNode request = SocketBindingJBossASClient.createWriteAttributeRequest(PORT, portValue, addr = Address.root().add(SOCKET_BINDING_GROUP, socketBindingGroupName, SOCKET_BINDING, socketBindingName));
        ModelNode results = this.execute(request);
        if (!SocketBindingJBossASClient.isSuccess(results)) {
            throw new FailureException(results);
        }
    }

    public void setStandardSocketBindingInterface(String socketBindingName, String interfaceName) throws Exception {
        this.setStandardSocketBindingInterfaceExpression(socketBindingName, null, interfaceName);
    }

    public void setStandardSocketBindingInterfaceExpression(String socketBindingName, String sysPropName, String interfaceName) throws Exception {
        this.setSocketBindingInterfaceExpression(STANDARD_SOCKETS, socketBindingName, sysPropName, interfaceName);
    }

    public void setSocketBindingPort(String socketBindingGroupName, String socketBindingName, String interfaceName) throws Exception {
        this.setSocketBindingInterfaceExpression(socketBindingGroupName, socketBindingName, null, interfaceName);
    }

    public void setSocketBindingInterfaceExpression(String socketBindingGroupName, String socketBindingName, String sysPropName, String interfaceName) throws Exception {
        Address addr;
        String interfaceNameValue = sysPropName != null ? "${" + sysPropName + ":" + interfaceName + "}" : String.valueOf(interfaceName);
        ModelNode request = SocketBindingJBossASClient.createWriteAttributeRequest(INTERFACE, interfaceNameValue, addr = Address.root().add(SOCKET_BINDING_GROUP, socketBindingGroupName, SOCKET_BINDING, socketBindingName));
        ModelNode results = this.execute(request);
        if (!SocketBindingJBossASClient.isSuccess(results)) {
            throw new FailureException(results);
        }
    }
}

