/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.schema.AbstractManager;
import org.rhq.cassandra.schema.UpdateFile;

class TopologyManager
extends AbstractManager {
    private static final String TOPOLOGY_BASE_FOLDER = "topology";
    private final Log log = LogFactory.getLog(TopologyManager.class);

    public TopologyManager(String username, String password, String[] nodes, int cqlPort) {
        super(username, password, nodes, cqlPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTopology() {
        try {
            this.initClusterSession();
            if (this.schemaExists()) {
                this.log.info((Object)"Applying topology updates...");
                this.updateReplicationFactor();
                this.updateGCGrace();
            } else {
                this.log.info((Object)"Topology updates cannot be applied because the schema is not installed.");
            }
        }
        finally {
            this.shutdownClusterConnection();
        }
    }

    private void updateReplicationFactor() {
        this.log.info((Object)("Starting to execute " + (Object)((Object)Task.UpdateReplicationFactor) + " task."));
        int newReplicationFactor = this.calculateNewReplicationFactor();
        int existingReplicationFactor = this.queryReplicationFactor();
        if (existingReplicationFactor == newReplicationFactor) {
            this.log.info((Object)("No need to update replication factor. Replication factor already " + newReplicationFactor));
        } else {
            this.execute(new UpdateFile(Task.UpdateReplicationFactor.getFile()), "replication_factor", newReplicationFactor + "");
            this.log.info((Object)("Updated replication factor from " + existingReplicationFactor + " to  " + newReplicationFactor));
        }
        this.log.info((Object)("Successfully executed " + (Object)((Object)Task.UpdateReplicationFactor) + " task."));
    }

    private void updateGCGrace() {
        this.log.info((Object)("Starting to execute " + (Object)((Object)Task.UpdateGCGrace) + " task."));
        int gcGraceSeconds = 864000;
        gcGraceSeconds = this.getClusterSize() == 1 ? 0 : 691200;
        this.execute(new UpdateFile(Task.UpdateGCGrace.getFile()), "gc_grace_seconds", gcGraceSeconds + "");
        this.log.info((Object)("Updated gc_grace_seconds to " + gcGraceSeconds));
        this.log.info((Object)("Successfully executed " + (Object)((Object)Task.UpdateGCGrace) + " task."));
    }

    private static enum Task {
        UpdateReplicationFactor("0001.xml"),
        UpdateGCGrace("0002.xml");

        private final String file;

        private Task(String file) {
            this.file = file;
        }

        protected String getFile() {
            return "topology/" + this.file;
        }
    }
}

